/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.BEditPropertiesDialog;
import com.tridium.px.editor.property.PxPropertyComponentArray;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheetBindingLabel;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheetLabel;
import com.tridium.px.editor.sidebars.cellsheet.CellSheetContext;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BConverterCE;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BPxLayerCE;
import com.tridium.px.editor.util.LayerManager;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.event.PxCompoundWidgetEvent;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.shape.BShape;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.util.BConverter;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class EditPropertiesContext
extends Command
implements CellSheetContext {
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private BPxCellSheet sheet;
    private PxPropertyComponentArray oldGc;
    private PxPropertyComponentArray newGc;
    private BWidget[] oldWidgets;
    private BWidget[] newWidgets;

    public EditPropertiesContext(BPxEditor bPxEditor) {
        super((BWidget)bPxEditor, BPxEditorPane.lexicon(), "commands.editProperties");
        this.editor = bPxEditor;
        this.editorPane = (BPxEditorPane)bPxEditor.getContent();
    }

    public CommandArtifact doInvoke() throws Exception {
        SelectedWidgets selectedWidgets = this.editorPane.getSelectedWidgets();
        if (selectedWidgets.size() == 0) {
            throw new IllegalStateException();
        }
        this.oldWidgets = this.editorPane.getSelectedWidgets().getWidgets();
        for (int i = 0; i < this.oldWidgets.length; ++i) {
            if (!(this.oldWidgets[i] instanceof BNullWidget)) continue;
            return null;
        }
        this.newWidgets = this.editor.cloneWidgets(this.oldWidgets);
        this.oldGc = this.editorPane.getPxPropertyComponents();
        this.newGc = this.oldGc.deepClone();
        this.newGc.replaceWidgets(this.oldWidgets, this.newWidgets);
        this.sheet = new BPxCellSheet(this.editor, this);
        this.sheet.setReadonly(this.editor.isReadonly());
        this.sheet.editWidgets(this.newWidgets);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)this.sheet);
        bConstrainedPane.setMinWidth(500.0);
        String string = this.editorPane.getLexicon().getText("cellsheet.label");
        if (this.editor.isReadonly()) {
            BDialog.open((BWidget)this.editorPane, (String)string, (Object)bConstrainedPane, (int)1);
            return null;
        }
        if (BEditPropertiesDialog.open(this.sheet, (BWidget)this.editorPane, string, (BWidget)bConstrainedPane, 3) != 1) {
            return null;
        }
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    public boolean allowBindingDelete() {
        return true;
    }

    public boolean allowGotoOrd() {
        return false;
    }

    public boolean allowLayoutEdit(BWidget[] bWidgetArray) {
        for (int i = 0; i < this.oldWidgets.length; ++i) {
            if (this.oldWidgets[i] instanceof BShape) {
                return false;
            }
            if (this.oldWidgets[i].getParentWidget() instanceof BCanvasPane) continue;
            return false;
        }
        return true;
    }

    public BObject[] resolveBindingTarget(BBinding[] bBindingArray) {
        BObject[] bObjectArray = new BObject[bBindingArray.length];
        BObject bObject = this.editor.getWbShell().getActiveOrdTarget().get();
        for (int i = 0; i < bBindingArray.length; ++i) {
            try {
                bObjectArray[i] = bBindingArray[i].getOrd().get(bObject);
                continue;
            }
            catch (UnresolvedException unresolvedException) {
                bObjectArray[i] = null;
                continue;
            }
            catch (SyntaxException syntaxException) {
                bObjectArray[i] = null;
            }
        }
        return bObjectArray;
    }

    public void bindingAdded(BWidget bWidget, Property property, BBinding bBinding) {
        this.sheet.editWidgets(this.newWidgets);
    }

    public void bindingDeleted(BWidget bWidget, Property property, BBinding bBinding) {
        this.sheet.editWidgets(this.newWidgets);
    }

    public void converterAdded(BBinding bBinding, Property property, BConverter bConverter) {
        this.sheet.editWidgets(this.newWidgets);
    }

    public void converterDeleted(BBinding bBinding, Property property, BConverter bConverter) {
        this.sheet.editWidgets(this.newWidgets);
    }

    public int newBindingDragOver(BPxCellSheetLabel bPxCellSheetLabel, TransferContext transferContext) {
        return 0;
    }

    public CommandArtifact newBindingDrop(TransferContext transferContext) throws Exception {
        throw new IllegalStateException();
    }

    public int existingBindingDragOver(BPxCellSheetBindingLabel bPxCellSheetBindingLabel, TransferContext transferContext) {
        return 0;
    }

    public CommandArtifact existingBindingDrop(TransferContext transferContext, BWidget bWidget, BBinding bBinding) throws Exception {
        throw new IllegalStateException();
    }

    public void bindingPropertyChanged(BBinding bBinding, Property property, BValue bValue) {
        bBinding.set(property.getName(), bValue);
    }

    public void cellModified(BWbCellEditor bWbCellEditor) {
        try {
            bWbCellEditor.saveValue();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        if (bWbCellEditor instanceof BConverterCE) {
            BConverterCE bConverterCE = (BConverterCE)bWbCellEditor;
            BBinding bBinding = bConverterCE.binding();
            String string = bWbCellEditor.getPropertyName();
            BConverter bConverter = (BConverter)bConverterCE.getCurrentValue();
            bBinding.set(string, (BValue)bConverter);
        } else if (bWbCellEditor instanceof BPxLayerCE) {
            LayerManager layerManager = this.editorPane.getLayerManager();
            BPxLayerCE bPxLayerCE = (BPxLayerCE)bWbCellEditor;
            PxLayer pxLayer = layerManager.getLayerByName(bPxLayerCE.getListDropDown().getList().getSelectedItem().toString());
            for (int i = 0; i < this.newWidgets.length; ++i) {
                layerManager.removeTag(this.newWidgets[i]);
                if (pxLayer == null) continue;
                layerManager.addTag(this.newWidgets[i], pxLayer);
            }
        } else {
            String string = bWbCellEditor.getPropertyName();
            BValue bValue = (BValue)bWbCellEditor.getCurrentValue();
            for (int i = 0; i < this.newWidgets.length; ++i) {
                this.newWidgets[i].set(string, bValue);
                this.newWidgets[i].bindingsChanged();
            }
        }
    }

    public PxPropertyComponentArray getPxPropertyComponents() {
        return this.newGc;
    }

    public void pxPropertyLinked(PxProperty pxProperty, BComponent bComponent, String string) {
        this.newGc.addTarget(pxProperty, bComponent, string);
        this.sheet.editWidgets(this.newWidgets);
    }

    public void pxPropertyUnlinked(PxProperty pxProperty, BComponent bComponent, String string) {
        this.newGc.removeTarget(pxProperty, bComponent, string);
        this.sheet.editWidgets(this.newWidgets);
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            this.go(EditPropertiesContext.this.oldWidgets, EditPropertiesContext.this.newWidgets, EditPropertiesContext.this.newGc);
        }

        public void undo() throws Exception {
            this.go(EditPropertiesContext.this.newWidgets, EditPropertiesContext.this.oldWidgets, EditPropertiesContext.this.oldGc);
        }

        private void go(BWidget[] bWidgetArray, BWidget[] bWidgetArray2, PxPropertyComponentArray pxPropertyComponentArray) {
            PxWidgetEvent[] pxWidgetEventArray = new PxWidgetEvent[bWidgetArray.length];
            for (int i = 0; i < bWidgetArray.length; ++i) {
                BWidget bWidget = bWidgetArray[i].getParentWidget();
                Property property = bWidgetArray[i].getPropertyInParent();
                String string = property.getName();
                bWidget.set(property, (BValue)bWidgetArray2[i]);
                pxWidgetEventArray[i] = new PxWidgetEvent(2, bWidget, string, (BValue)bWidgetArray2[i]);
            }
            EditPropertiesContext.this.editorPane.setPxPropertyComponents(pxPropertyComponentArray);
            EditPropertiesContext.this.editorPane.getSelectedWidgets().setWidgets(bWidgetArray2);
            EditPropertiesContext.this.editor.firePxEvent(new PxCompoundWidgetEvent(2, pxWidgetEventArray));
        }
    }
}

