/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.px.editor.BPxEditorOptions;
import com.tridium.px.editor.RootShellManager;
import com.tridium.px.editor.property.PxPropertyComponent;
import com.tridium.px.editor.property.PxPropertyComponentArray;
import com.tridium.px.editor.sidebars.binding.BBoundOrds;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import com.tridium.px.editor.sidebars.layersheet.BPxLayerSheet;
import com.tridium.px.editor.sidebars.propsheet.BPxPropSheet;
import com.tridium.px.editor.sidebars.tree.BPxTreePane;
import com.tridium.px.editor.studio.BStudio;
import com.tridium.px.editor.studio.CommandStudio;
import com.tridium.px.editor.studio.PainterStudio;
import com.tridium.px.editor.studio.RootStudio;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.TreeStudio;
import com.tridium.px.editor.studio.commands.Align;
import com.tridium.px.editor.studio.commands.Reorg;
import com.tridium.px.editor.studio.painters.DefaultPainter;
import com.tridium.px.editor.studio.trackers.AddPathTracker;
import com.tridium.px.editor.studio.trackers.AddPointTracker;
import com.tridium.px.editor.studio.trackers.AddPolygonTracker;
import com.tridium.px.editor.studio.trackers.DeletePointTracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import com.tridium.px.editor.util.LayerManager;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import com.tridium.ui.BZoomPane;
import com.tridium.workbench.util.PropertyManager;
import com.tridium.workbench.util.TypeInfoSpec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.px.editor.BDrawingTool;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxSideBar;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.list.BList;
import javax.baja.ui.naming.BRootContainer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.shape.BShape;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BPxEditorPane
extends BEdgePane {
    public static final Action optionChanged = BPxEditorPane.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action zoomChanged = BPxEditorPane.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$BPxEditorPane == null ? (class$com$tridium$px$editor$BPxEditorPane = BPxEditorPane.class$("com.tridium.px.editor.BPxEditorPane")) : class$com$tridium$px$editor$BPxEditorPane));
    private static PropertyManager propMgr = new PropertyManager(new File(Sys.getUserHome(), "pxEditor.properties"), "PxEditor Properties");
    private static Lexicon lexicon = Lexicon.make((String)"pxEditor");
    private static Lexicon wbLexicon = Lexicon.make((String)"workbench");
    private BPxEditor editor;
    private BBoundOrds boundOrds;
    private BPxTreePane treePane;
    private BPxPropSheet propSheet;
    private BPxLayerSheet layerSheet;
    private BPxCellSheet cellSheet;
    private BSplitPane mainSplit;
    private BToolPane sideBarPane;
    private BTextField xyStatus;
    private BTextField zoomStatus;
    private DecimalFormat zoomStatusFormat = new DecimalFormat("0.0");
    private BGridPane statusPane;
    private PxPropertyComponentArray propComps;
    private LayerManager layerMgr;
    private SelectedWidgets selected;
    private BStudio studio;
    private BZoomPane zoomPane;
    private BScrollPane zoomScrollPane;
    private BRootContainer rootContainer;
    private RootShellManager rootShellMgr;
    private OptionToggle showGrid;
    private OptionToggle useSnap;
    private OptionToggle showHatch;
    private SetTargetMedia setTargetMedia;
    private BZoomPane.ZoomInCommand zoomIn;
    private BZoomPane.ZoomOutCommand zoomOut;
    private BZoomPane.ZoomResetCommand zoomReset;
    private Align alignCenter;
    private Align alignMiddle;
    private Align alignLft;
    private Align alignRgt;
    private Align alignTop;
    private Align alignBot;
    private Reorg bringToFront;
    private Reorg sendToBack;
    private NormalTool normalTool;
    private GeometryTool addPolygonTool;
    private GeometryTool addPathTool;
    private GeometryTool addPointTool;
    private GeometryTool deletePointTool;
    private BDrawingTool tool;
    private ToggleToolPane toggleToolPane;
    private BPxSideBar[] sideBars;
    private Map sideBarVisibility;
    private boolean loaded = false;
    private static final Map pxEditorStates = new HashMap();
    static /* synthetic */ Class class$com$tridium$px$editor$BPxEditorPane;
    static /* synthetic */ Class class$javax$baja$ui$pane$BLabelPane;

    public void optionChanged(BString bString) {
        this.invoke(optionChanged, (BValue)bString, null);
    }

    public void zoomChanged(BDouble bDouble) {
        this.invoke(zoomChanged, (BValue)bDouble, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPxEditorPane(BPxEditor bPxEditor) {
        this.editor = bPxEditor;
        this.selected = new SelectedWidgets(bPxEditor, this);
        this.setTargetMedia = new SetTargetMedia();
        this.studio = new BStudio(bPxEditor, this);
        this.zoomPane = new BZoomPane((BWidget)this.studio);
        this.zoomScrollPane = new BScrollPane((BWidget)this.zoomPane);
        this.rootContainer = new BRootContainer();
        this.rootShellMgr = new RootShellManager(this, this.studio);
        this.propComps = new PxPropertyComponentArray();
        this.layerMgr = new LayerManager(bPxEditor, this);
        BPxEditorOptions bPxEditorOptions = this.getOptions();
        this.showGrid = new OptionToggle(BPxEditorOptions.showGrid);
        this.useSnap = new OptionToggle(BPxEditorOptions.useSnap);
        this.showHatch = new OptionToggle(BPxEditorOptions.showHatch);
        this.zoomIn = new BZoomPane.ZoomInCommand((BWidget)this, this.zoomPane);
        this.zoomOut = new BZoomPane.ZoomOutCommand((BWidget)this, this.zoomPane);
        this.zoomReset = new BZoomPane.ZoomResetCommand((BWidget)this, this.zoomPane);
        this.alignLft = new Align(this, true, 0);
        this.alignCenter = new Align(this, true, 2);
        this.alignRgt = new Align(this, true, 1);
        this.alignTop = new Align(this, false, 0);
        this.alignMiddle = new Align(this, false, 2);
        this.alignBot = new Align(this, false, 1);
        this.bringToFront = new Reorg(this, true, false);
        this.sendToBack = new Reorg(this, false, false);
        this.normalTool = new NormalTool(BPxEditorPane.text("commands.normalTool"));
        this.addPolygonTool = new GeometryTool(BPxEditorPane.text("commands.addPolygonTool"), BDrawingTool.addPolygon);
        this.addPathTool = new GeometryTool(BPxEditorPane.text("commands.addPathTool"), BDrawingTool.addPath);
        this.addPointTool = new GeometryTool(BPxEditorPane.text("commands.addPointTool"), BDrawingTool.addPoint);
        this.deletePointTool = new GeometryTool(BPxEditorPane.text("commands.deletePointTool"), BDrawingTool.deletePoint);
        this.xyStatus = new BTextField("0,0", 9, false);
        this.zoomStatus = new BTextField("x1.0", 4, false);
        this.statusPane = new BGridPane(2);
        this.statusPane.add(null, (BValue)this.zoomStatus);
        this.statusPane.add(null, (BValue)this.xyStatus);
        propMgr.loadProperties();
        this.mainSplit = new BSplitPane();
        double d = propMgr.getd("divPos", -1.0);
        if (d == -1.0) {
            this.mainSplit.setDividerPosition(75.0);
        } else {
            this.mainSplit.setDividerPosition(d);
        }
        this.linkTo((BComponent)bPxEditorOptions, (Slot)BPxEditorOptions.propertyChanged, (Slot)optionChanged);
        this.linkTo((BComponent)this.zoomPane, (Slot)BZoomPane.zoomLevel, (Slot)zoomChanged);
    }

    public void doOptionChanged(BString bString) {
        this.zoomScrollPane.relayout();
        this.showGrid.frozen = true;
        this.useSnap.frozen = true;
        this.showHatch.frozen = true;
        this.showGrid.setSelected(this.getOptions().getShowGrid());
        this.useSnap.setSelected(this.getOptions().getUseSnap());
        this.showHatch.setSelected(this.getOptions().getShowHatch());
        this.showGrid.frozen = false;
        this.useSnap.frozen = false;
        this.showHatch.frozen = false;
        this.editor.firePxEvent(new PxEditorEvent(2, bString.toString()));
    }

    public void doZoomChanged(BDouble bDouble) {
        this.zoomStatus.setText("x" + this.zoomStatusFormat.format(bDouble.getDouble()));
    }

    public void deactivated() {
        propMgr.setb("sideBar", this.toggleToolPane.isSelected());
        propMgr.setd("divPos", this.mainSplit.getDividerPosition());
        this.persistSideBarPane();
        propMgr.saveProperties();
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        this.selected.resetHandles();
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("PxEditor");
        bMenu.add(null, (Command)this.editor.getToggleMode());
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, this.editor.getViewSource());
        bMenu.add(null, this.editor.getGotoSource());
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)this.showGrid);
        bMenu.add(null, (Command)this.useSnap);
        bMenu.add(null, (Command)this.showHatch);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)this.zoomIn);
        bMenu.add(null, (Command)this.zoomOut);
        bMenu.add(null, (Command)this.zoomReset);
        if (this.editor.isFileBased()) {
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)this.setTargetMedia);
        }
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)this.editor.getToggleMode());
        bToolBar.add(null, (Command)new ToggleCommand((BWidget)this, lexicon, "commands.sideBarMenu")).setMenuController((BAbstractButton.MenuController)new SideBarMenuController());
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (Command)this.alignLft);
        bToolBar.add(null, (Command)this.alignCenter);
        bToolBar.add(null, (Command)this.alignRgt);
        bToolBar.add(null, (Command)this.alignTop);
        bToolBar.add(null, (Command)this.alignMiddle);
        bToolBar.add(null, (Command)this.alignBot);
        bToolBar.add(null, (Command)this.bringToFront);
        bToolBar.add(null, (Command)this.sendToBack);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (Command)this.zoomIn);
        bToolBar.add(null, (Command)this.zoomOut);
        bToolBar.add(null, (Command)this.zoomReset);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add("normalTool", (Command)this.normalTool);
        bToolBar.add("addPolygonTool", (Command)this.addPolygonTool);
        bToolBar.add("addPathTool", (Command)this.addPathTool);
        bToolBar.add("addPointTool", (Command)this.addPointTool);
        bToolBar.add("deletePointTool", (Command)this.deletePointTool);
        return bToolBar;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.statusPane;
    }

    public void load(Context context) {
        this.sanityCheck(this.editor.getWidget());
        this.rootContainer.setRoot(this.editor.getWidget());
        BComponent bComponent = new BComponent();
        bComponent.add(null, (BValue)this.rootContainer);
        this.add(null, (BValue)bComponent);
        this.rootContainer.widgetSupport((Object)this.rootShellMgr);
        this.addPolygonTool.setEnabled(!this.editor.isReadonly());
        this.addPathTool.setEnabled(!this.editor.isReadonly());
        this.addPointTool.setEnabled(!this.editor.isReadonly());
        this.deletePointTool.setEnabled(!this.editor.isReadonly());
        this.setTargetMedia.setEnabled(!this.editor.isReadonly());
        this.editor.setTransferWidget(this.studio);
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        toggleCommandGroup.add((ToggleCommand)this.normalTool);
        toggleCommandGroup.add((ToggleCommand)this.addPolygonTool);
        toggleCommandGroup.add((ToggleCommand)this.addPathTool);
        toggleCommandGroup.add((ToggleCommand)this.addPointTool);
        toggleCommandGroup.add((ToggleCommand)this.deletePointTool);
        this.tool = BDrawingTool.normal;
        this.updateToolbar();
        this.loadProperties(this.editor.getWidget(), this.editor.getPxProperties());
        this.layerMgr.adjustInvisibleWidgets(false);
        BPxEditorPane.addDynamicPxIncludeProperties(this.editor.getWidget());
        this.forceRootLayout();
        this.loaded = true;
        this.restoreState();
    }

    public static void addDynamicPxIncludeProperties(BWidget bWidget) {
        if (bWidget instanceof BPxInclude) {
            BPxInclude bPxInclude = (BPxInclude)bWidget;
            Object[] objectArray = (Object[])bPxInclude.fw(304, null, null, null, null);
            PxProperty[] pxPropertyArray = (PxProperty[])objectArray[1];
            for (int i = 0; i < pxPropertyArray.length; ++i) {
                String string = pxPropertyArray[i].getName();
                BValue bValue = pxPropertyArray[i].getValue();
                BValue bValue2 = bPxInclude.get(string);
                if (bValue2 != null) continue;
                bPxInclude.add(string, bValue);
            }
        } else {
            BWidget[] bWidgetArray = bWidget.getChildWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                BPxEditorPane.addDynamicPxIncludeProperties(bWidgetArray[i]);
            }
        }
    }

    private void loadProperties(BWidget bWidget, PxProperty[] pxPropertyArray) {
        for (int i = 0; i < pxPropertyArray.length; ++i) {
            SlotPath[] slotPathArray = pxPropertyArray[i].getTargets();
            for (int j = 0; j < slotPathArray.length; ++j) {
                BOrd bOrd = BOrd.make((String)("slot:" + slotPathArray[j].getBody()));
                OrdTarget ordTarget = bOrd.resolve((BObject)bWidget);
                BComponent bComponent = ordTarget.getComponent();
                Property property = (Property)ordTarget.getSlotInComponent();
                PxPropertyComponent pxPropertyComponent = this.propComps.get(bComponent);
                if (pxPropertyComponent == null) {
                    pxPropertyComponent = new PxPropertyComponent(bComponent);
                    this.propComps.add(pxPropertyComponent);
                }
                pxPropertyComponent.addTarget(pxPropertyArray[i], property.getName());
            }
        }
    }

    private void sanityCheck(BWidget bWidget) {
        BWidget[] bWidgetArray;
        if (bWidget instanceof BShape) {
            bWidget.setLayout(BLayout.DEFAULT);
        } else {
            double d;
            double d2;
            BSize bSize;
            if (bWidget instanceof BCanvasPane) {
                bWidgetArray = (BWidget[])bWidget;
                bSize = bWidgetArray.getViewSize();
                d2 = this.ensureBetween(bSize.width(), 0, 10000);
                d = this.ensureBetween(bSize.height(), 0, 10000);
                bWidgetArray.setViewSize(BSize.make((double)d2, (double)d));
            }
            if ((bWidgetArray = bWidget.getParentWidget()) == null || !(bWidgetArray instanceof BCanvasPane)) {
                bWidget.setLayout(BLayout.DEFAULT);
            } else {
                bSize = bWidget.getLayout();
                d2 = this.ensureBetween(bSize.getX(), -1000, 10000);
                d = this.ensureBetween(bSize.getY(), -1000, 10000);
                double d3 = this.ensureBetween(bSize.getWidth(), -1000, 10000);
                double d4 = this.ensureBetween(bSize.getHeight(), -1000, 10000);
                int n = bSize.getXUnit();
                int n2 = bSize.getYUnit();
                int n3 = bSize.getWidthUnit();
                int n4 = bSize.getHeightUnit();
                bWidget.setLayout(BLayout.make((double)d2, (int)n, (double)d, (int)n2, (double)d3, (int)n3, (double)d4, (int)n4));
            }
        }
        bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.sanityCheck(bWidgetArray[i]);
        }
    }

    private double ensureBetween(double d, int n, int n2) {
        if (d < (double)n) {
            return n;
        }
        if (d > (double)n2) {
            return n2;
        }
        return d;
    }

    public BObject save(BObject bObject, Context context) {
        if (bObject instanceof BPxFile) {
            this.saveDirect((BPxFile)bObject);
        } else if (this.editor.getPxAgent() instanceof BPxView) {
            this.saveViaAgent((BPxView)this.editor.getPxAgent());
        }
        return bObject;
    }

    private void saveDirect(BPxFile bPxFile) {
        BPxView bPxView = new BPxView();
        bPxView.setMedia(this.editor.getMedia().getType().getTypeSpec());
        this.persist((BIFile)bPxFile, bPxView);
    }

    private void saveViaAgent(BPxView bPxView) {
        BOrd bOrd = bPxView.getPxFile();
        if (bOrd.isNull()) {
            throw new IllegalStateException();
        }
        BIFile bIFile = (BIFile)bOrd.get(this.editor.getCurrentValue());
        this.persist(bIFile, bPxView);
    }

    private void persist(BIFile bIFile, BPxView bPxView) {
        this.layerMgr.adjustInvisibleWidgets(true);
        this.editor.setWidget(this.rootContainer.getRoot());
        this.normalizeLayouts(this.editor.getWidget());
        try {
            this.encode(new ByteArrayOutputStream(), bPxView);
            this.encode(bIFile.getOutputStream(), bPxView);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        this.layerMgr.adjustInvisibleWidgets(false);
    }

    private void encode(OutputStream outputStream, BPxView bPxView) throws Exception {
        PxEncoder pxEncoder = new PxEncoder(outputStream);
        PxProperty[] pxPropertyArray = this.editor.getPxProperties();
        boolean bl = pxPropertyArray != null && pxPropertyArray.length > 0;
        pxEncoder.setPreserveIdentities(this.getOptions().getPreserveIdentities() || bl);
        pxEncoder.encodeDocument(this.editor.getWidget(), this.editor.getPxProperties(), this.editor.getPxLayers(), (BAbstractPxView)bPxView);
        pxEncoder.close();
    }

    private void normalizeLayouts(BWidget bWidget) {
        BWidget[] bWidgetArray;
        if (bWidget instanceof BShape) {
            bWidget.setLayout(BLayout.DEFAULT);
        } else {
            bWidgetArray = bWidget.getParentWidget();
            if (bWidgetArray == null || !(bWidgetArray instanceof BCanvasPane)) {
                bWidget.setLayout(BLayout.DEFAULT);
            }
        }
        bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.normalizeLayouts(bWidgetArray[i]);
        }
    }

    public void updateStatus(String string) {
        this.xyStatus.setText(string);
    }

    public BPxEditorOptions getOptions() {
        return BPxEditorOptions.make();
    }

    public void updateToolbar() {
        BTransferWidget bTransferWidget = this.editor.getTransferWidget();
        if (bTransferWidget == null) {
            return;
        }
        if (this.tool.getOrdinal() == 0) {
            BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
            this.alignLft.setEnabled(this.studio.alignable(bCanvasPane));
            this.alignCenter.setEnabled(this.studio.alignable(bCanvasPane));
            this.alignRgt.setEnabled(this.studio.alignable(bCanvasPane));
            this.alignTop.setEnabled(this.studio.alignable(bCanvasPane));
            this.alignMiddle.setEnabled(this.studio.alignable(bCanvasPane));
            this.alignBot.setEnabled(this.studio.alignable(bCanvasPane));
            BPane bPane = this.studio.getCurrentFreeForm();
            this.bringToFront.setEnabled(this.studio.reorgable(bPane));
            this.sendToBack.setEnabled(this.studio.reorgable(bPane));
            this.treePane.updateEnabledButtons(this.studio.reorgable(bPane));
            this.updateTransferToolbar(bTransferWidget);
        } else {
            this.alignLft.setEnabled(false);
            this.alignCenter.setEnabled(false);
            this.alignRgt.setEnabled(false);
            this.alignTop.setEnabled(false);
            this.alignMiddle.setEnabled(false);
            this.alignBot.setEnabled(false);
            this.bringToFront.setEnabled(false);
            this.sendToBack.setEnabled(false);
            bTransferWidget.setCutEnabled(false);
            bTransferWidget.setCopyEnabled(false);
            bTransferWidget.setPasteEnabled(false);
            bTransferWidget.setDuplicateEnabled(false);
            bTransferWidget.setDeleteEnabled(false);
        }
    }

    private void updateTransferToolbar(BTransferWidget bTransferWidget) {
        if (this.selected.size() == 0) {
            bTransferWidget.setCutEnabled(false);
            bTransferWidget.setCopyEnabled(false);
            bTransferWidget.setPasteEnabled(false);
            bTransferWidget.setDuplicateEnabled(false);
            bTransferWidget.setDeleteEnabled(false);
        } else if (this.selected.size() == 1) {
            BWidget bWidget = this.selected.get(0);
            if (bWidget instanceof BNullWidget) {
                bTransferWidget.setCutEnabled(false);
                bTransferWidget.setCopyEnabled(false);
                bTransferWidget.setPasteEnabled(true);
                bTransferWidget.setDuplicateEnabled(false);
                bTransferWidget.setDeleteEnabled(false);
            } else {
                bTransferWidget.setCutEnabled(true);
                bTransferWidget.setCopyEnabled(true);
                bTransferWidget.setPasteEnabled(true);
                bTransferWidget.setDuplicateEnabled(true);
                bTransferWidget.setDeleteEnabled(true);
                BWidget bWidget2 = bWidget.getParentWidget();
                if (bWidget2 == null || !Reflector.isFreeFormPane(bWidget2)) {
                    bTransferWidget.setDuplicateEnabled(false);
                }
                if (!Reflector.isFreeFormPane(bWidget)) {
                    bTransferWidget.setPasteEnabled(false);
                }
            }
        } else {
            bTransferWidget.setCutEnabled(true);
            bTransferWidget.setCopyEnabled(true);
            bTransferWidget.setPasteEnabled(false);
            bTransferWidget.setDuplicateEnabled(true);
            bTransferWidget.setDeleteEnabled(true);
        }
        if (bTransferWidget.isCutEnabled()) {
            bTransferWidget.setCutEnabled(!this.editor.isReadonly());
        }
        if (bTransferWidget.isPasteEnabled()) {
            bTransferWidget.setPasteEnabled(!this.editor.isReadonly());
        }
        if (bTransferWidget.isDuplicateEnabled()) {
            bTransferWidget.setDuplicateEnabled(!this.editor.isReadonly());
        }
        if (bTransferWidget.isDeleteEnabled()) {
            bTransferWidget.setDeleteEnabled(!this.editor.isReadonly());
        }
    }

    protected void setChildWidgets(BWidget bWidget) {
        this.setCenter(bWidget);
    }

    public void forceRootLayout() {
        BPxEditorPane.forceImageLoad((BComplex)this.rootContainer, this.editor.getWbShell().getActiveOrd());
        this.doForceLayout((BWidget)this.rootContainer, false);
    }

    private static void forceImageLoad(BComplex bComplex, BOrd bOrd) {
        SlotCursor slotCursor = bComplex.getProperties();
        while (slotCursor.nextObject()) {
            BImage bImage;
            BObject bObject = slotCursor.get();
            if (bObject instanceof BImage) {
                bImage = (BImage)bObject;
                bImage.sync();
                bImage.setBaseOrd(bOrd);
                continue;
            }
            if (bObject instanceof BBrush) {
                BPxEditorPane.loadBrush((BBrush)bObject, bOrd);
                continue;
            }
            if (bObject instanceof BBorder) {
                bImage = (BBorder)bObject;
                BPxEditorPane.loadBrush(bImage.topBrush, bOrd);
                BPxEditorPane.loadBrush(bImage.leftBrush, bOrd);
                BPxEditorPane.loadBrush(bImage.bottomBrush, bOrd);
                BPxEditorPane.loadBrush(bImage.rightBrush, bOrd);
                continue;
            }
            if (!(bObject instanceof BComplex)) continue;
            BPxEditorPane.forceImageLoad((BComplex)bObject, bOrd);
        }
    }

    private static void loadBrush(BBrush bBrush, BOrd bOrd) {
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.Image) {
            BImage bImage = ((BBrush.Image)paint).getImage();
            bImage.sync();
            bImage.setBaseOrd(bOrd);
        }
    }

    private void doForceLayout(BWidget bWidget, boolean bl) {
        if (bWidget instanceof BCanvasPane) {
            if (bl) {
                bWidget.fw(304, (Object)new Object[]{Boolean.FALSE}, (Object)new Object[]{Boolean.FALSE}, null, null);
            } else {
                bWidget.fw(304, (Object)new Object[]{this.getOptions().getShowGrid(), new Integer(this.getOptions().getGridSize()), this.getOptions().getGridColor()}, (Object)new Object[]{this.getOptions().getShowHatch(), this.getOptions().getHatchColor()}, null, null);
            }
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        bWidget.doLayout(bWidgetArray);
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.doForceLayout(bWidgetArray[i], bl ? true : bWidget instanceof BPxInclude);
        }
    }

    public void initSideBarPane() {
        this.sideBarPane = new BToolPane();
        BPxSideBar[] bPxSideBarArray = new BPxSideBar[5];
        this.boundOrds = new BBoundOrds(this.editor);
        bPxSideBarArray[0] = this.boundOrds;
        this.treePane = new BPxTreePane(this);
        bPxSideBarArray[1] = this.treePane;
        this.propSheet = new BPxPropSheet(this.editor);
        bPxSideBarArray[2] = this.propSheet;
        this.layerSheet = new BPxLayerSheet(this.editor);
        bPxSideBarArray[3] = this.layerSheet;
        this.cellSheet = new BPxCellSheet(this.editor);
        bPxSideBarArray[4] = this.cellSheet;
        this.sideBars = this.editor.getPxProfile().getSideBars(bPxSideBarArray);
        int n = this.sideBars.length;
        if (n > 0) {
            int n2;
            Boolean[] booleanArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                booleanArray[i] = Boolean.TRUE;
            }
            String string = new Integer(10000 / n).toString();
            StringBuffer stringBuffer = new StringBuffer("toolpane=");
            StringBuffer stringBuffer2 = new StringBuffer("visible=");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(";");
                    stringBuffer2.append(";");
                }
                stringBuffer.append(string);
                stringBuffer2.append("true");
            }
            String string2 = propMgr.get("sidePanesHeight", stringBuffer.toString());
            String string3 = propMgr.get("sidePanesVisible", stringBuffer2.toString());
            int n3 = TextUtil.split((String)string2.substring("toolpane=".length()), (char)';').length;
            String[] stringArray = TextUtil.split((String)string3.substring("visible=".length()), (char)';');
            if (stringArray.length == n) {
                for (n2 = 0; n2 < n; ++n2) {
                    booleanArray[n2] = new Boolean(stringArray[n2]);
                    if (!booleanArray[n2].booleanValue()) continue;
                    this.sideBarPane.addPane(this.sideBars[n2].getSideBarDescription(), this.sideBars[n2].getSideBarIcon(), (BWidget)this.sideBars[n2]);
                }
                this.sideBarPane.unpickle(string2);
            } else {
                for (n2 = 0; n2 < this.sideBars.length; ++n2) {
                    this.sideBarPane.addPane(this.sideBars[n2].getSideBarDescription(), this.sideBars[n2].getSideBarIcon(), (BWidget)this.sideBars[n2]);
                }
            }
            this.sideBarVisibility = new LinkedHashMap();
            for (n2 = 0; n2 < this.sideBars.length; ++n2) {
                this.sideBarVisibility.put(this.sideBars[n2], booleanArray[n2]);
            }
        }
        this.toggleToolPane = new ToggleToolPane();
        if (n > 0) {
            this.toggleToolPane.setSelected(propMgr.getb("sideBar", true));
            this.toggleToolPane.invoke();
        } else {
            this.setChildWidgets((BWidget)new BBorderPane((BWidget)this.zoomScrollPane, BBorder.DEFAULT, BInsets.DEFAULT));
        }
        this.sideBarPane.setMenuController(new BToolPane.MenuController(){

            public BMenu getMenu(BToolPane bToolPane, BWidget bWidget) {
                BMenu bMenu = new BMenu();
                bMenu.add(null, (Command)new CloseSideBar(bWidget));
                return bMenu;
            }
        });
    }

    private void persistSideBarPane() {
        propMgr.set("sidePanesHeight", this.sideBarPane.pickle());
        StringBuffer stringBuffer = new StringBuffer("visible=");
        Iterator iterator = this.sideBarVisibility.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n++ > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(iterator.next());
        }
        propMgr.set("sidePanesVisible", stringBuffer.toString());
    }

    private void reloadSideBarPane() {
        int n;
        BLabelPane[] bLabelPaneArray = (BLabelPane[])this.sideBarPane.getChildren(class$javax$baja$ui$pane$BLabelPane == null ? (class$javax$baja$ui$pane$BLabelPane = BPxEditorPane.class$("javax.baja.ui.pane.BLabelPane")) : class$javax$baja$ui$pane$BLabelPane);
        for (n = 0; n < bLabelPaneArray.length; ++n) {
            bLabelPaneArray[n].setContent((BWidget)new BNullWidget());
        }
        this.sideBarPane.removeAll();
        for (n = 0; n < this.sideBars.length; ++n) {
            Boolean bl = (Boolean)this.sideBarVisibility.get((Object)this.sideBars[n]);
            if (!bl.booleanValue()) continue;
            this.sideBarPane.addPane(this.sideBars[n].getSideBarDescription(), this.sideBars[n].getSideBarIcon(), (BWidget)this.sideBars[n]);
        }
    }

    private void restoreState() {
        if (!System.getProperty("niagara.pxEditor.stateEnabled", "true").equals("true")) {
            return;
        }
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        if (bWbShell == null) {
            return;
        }
        Map map = (Map)pxEditorStates.get(bWbShell.getActiveOrd());
        if (map == null) {
            return;
        }
        double d = ((BDouble)map.get("zoomLevel")).getDouble();
        RectGeom rectGeom = (RectGeom)map.get("scrollViewPort");
        this.zoomPane.setZoomLevel(d);
        this.zoomScrollPane.scrollToVisible(rectGeom);
    }

    public void saveState() {
        if (!System.getProperty("niagara.pxEditor.stateEnabled", "true").equals("true")) {
            return;
        }
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        if (bWbShell == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zoomLevel", BDouble.make((double)this.zoomPane.getZoomLevel()));
        hashMap.put("scrollViewPort", this.zoomScrollPane.getViewport());
        pxEditorStates.put(bWbShell.getActiveOrd(), hashMap);
    }

    public BPxEditor getPxEditor() {
        return this.editor;
    }

    public SelectedWidgets getSelectedWidgets() {
        return this.selected;
    }

    public RootShellManager getRootShellMgr() {
        return this.rootShellMgr;
    }

    public BRootContainer getRootContainer() {
        return this.rootContainer;
    }

    public CommandStudio getCommandStudio() {
        return this.studio;
    }

    public PainterStudio getPainterStudio() {
        return this.studio;
    }

    public RootStudio getRootStudio() {
        return this.studio;
    }

    public TrackerStudio getTrackerStudio() {
        return this.studio;
    }

    public TreeStudio getTreeStudio() {
        return this.studio;
    }

    public BStudio getStudio() {
        return this.studio;
    }

    public BDrawingTool getTool() {
        return this.tool;
    }

    public static PropertyManager propMgr() {
        return propMgr;
    }

    public static Lexicon lexicon() {
        return lexicon;
    }

    public static String text(String string) {
        return lexicon.getText(string);
    }

    public static BImage icon(String string) {
        return BImage.make((String)lexicon.getText(string));
    }

    public PxPropertyComponentArray getPxPropertyComponents() {
        return this.propComps;
    }

    public void setPxPropertyComponents(PxPropertyComponentArray pxPropertyComponentArray) {
        this.propComps = pxPropertyComponentArray;
        pxPropertyComponentArray.updateTargets(this.editor.getWidget(), this.editor.getPxProperties());
    }

    public LayerManager getLayerManager() {
        return this.layerMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OptionToggle
    extends ToggleCommand {
        Property prop;
        boolean frozen = false;

        OptionToggle(Property property) {
            super((BWidget)BPxEditorPane.this, lexicon, "commands." + property.getName());
            this.prop = property;
            super.setSelected(BPxEditorPane.this.getOptions().getBoolean(property));
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!this.frozen) {
                BPxEditorPane.this.getOptions().setBoolean(this.prop, bl);
                BPxEditorPane.this.studio.getPainter().reset();
                BPxEditorPane.this.repaint();
            }
        }
    }

    class SetTargetMedia
    extends Command {
        SetTargetMedia() {
            super((BWidget)BPxEditorPane.this, lexicon, "commands.setTargetMedia");
        }

        public CommandArtifact doInvoke() throws Exception {
            String string = BPxEditorPane.this.editor.getMedia().getType().toString();
            int n = 0;
            BList bList = new BList();
            bList.setMultipleSelection(false);
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BPxMedia.TYPE.getTypeInfo());
            for (int i = 0; i < typeInfoArray.length; ++i) {
                if (typeInfoArray[i].toString().equals(string)) {
                    n = i;
                }
                TypeInfoSpec typeInfoSpec = new TypeInfoSpec(typeInfoArray[i]);
                bList.addItem(typeInfoSpec.icon, (Object)typeInfoSpec);
            }
            bList.setSelectedIndex(n);
            String string2 = BPxEditorPane.text("commands.setTargetMedia.label");
            int n2 = BDialog.open((BWidget)BPxEditorPane.this, (String)string2, (Object)bList, (int)3);
            if (n2 != 1) {
                return null;
            }
            n = bList.getSelectedIndex();
            BPxMedia bPxMedia = (BPxMedia)typeInfoArray[n].getInstance();
            Artifact artifact = new Artifact(BPxEditorPane.this.editor.getMedia(), bPxMedia);
            artifact.redo();
            return artifact;
        }

        class Artifact
        implements CommandArtifact {
            BPxMedia oldMedia;
            BPxMedia newMedia;

            Artifact(BPxMedia bPxMedia, BPxMedia bPxMedia2) {
                this.oldMedia = bPxMedia;
                this.newMedia = bPxMedia2;
            }

            public void redo() throws Exception {
                BPxEditorPane.this.editor.setMedia(this.newMedia);
                BPxEditorPane.this.editor.setModified();
            }

            public void undo() throws Exception {
                BPxEditorPane.this.editor.setMedia(this.oldMedia);
                BPxEditorPane.this.editor.setModified();
            }
        }
    }

    class CloseSideBar
    extends Command {
        BWidget sideBar;

        CloseSideBar(BWidget bWidget) {
            super(bWidget, wbLexicon, "sideBar.close");
            this.sideBar = bWidget;
        }

        public CommandArtifact doInvoke() {
            BPxEditorPane.this.sideBarVisibility.put(this.sideBar, Boolean.FALSE);
            BPxEditorPane.this.reloadSideBarPane();
            return null;
        }
    }

    class ToggleToolPane
    extends ToggleCommand {
        ToggleToolPane() {
            super((BWidget)BPxEditorPane.this, lexicon, "commands.showSideBar");
        }

        public CommandArtifact doInvoke() throws Exception {
            BPxEditorPane.this.mainSplit.setWidget1((BWidget)new BNullWidget());
            BPxEditorPane.this.mainSplit.setWidget2((BWidget)new BNullWidget());
            BWidget bWidget = BPxEditorPane.this.zoomScrollPane.getParentWidget();
            if (bWidget != null) {
                ((BBorderPane)bWidget).setContent((BWidget)new BNullWidget());
            }
            if (this.isSelected()) {
                BPxEditorPane.this.mainSplit.setWidget1((BWidget)new BBorderPane((BWidget)BPxEditorPane.this.zoomScrollPane, BBorder.DEFAULT, BInsets.DEFAULT));
                BPxEditorPane.this.mainSplit.setWidget2((BWidget)BPxEditorPane.this.sideBarPane);
                BPxEditorPane.this.setChildWidgets((BWidget)BPxEditorPane.this.mainSplit);
            } else {
                BPxEditorPane.this.setChildWidgets((BWidget)new BBorderPane((BWidget)BPxEditorPane.this.zoomScrollPane, BBorder.DEFAULT, BInsets.DEFAULT));
            }
            return null;
        }
    }

    class ToggleSideBar
    extends ToggleCommand {
        BPxSideBar sideBar;

        ToggleSideBar(BPxSideBar bPxSideBar) {
            super((BWidget)BPxEditorPane.this, bPxSideBar.getSideBarDescription());
            this.sideBar = bPxSideBar;
            Boolean bl = (Boolean)BPxEditorPane.this.sideBarVisibility.get((Object)bPxSideBar);
            this.setSelected(bl);
        }

        public CommandArtifact doInvoke() throws Exception {
            Boolean bl = (Boolean)BPxEditorPane.this.sideBarVisibility.get((Object)this.sideBar);
            BPxEditorPane.this.sideBarVisibility.put(this.sideBar, bl != false ? Boolean.FALSE : Boolean.TRUE);
            BPxEditorPane.this.reloadSideBarPane();
            return null;
        }
    }

    class SideBarMenuController
    implements BAbstractButton.MenuController {
        SideBarMenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            if (BPxEditorPane.this.sideBars.length > 0) {
                BMenu bMenu = UiLexicon.bajaui.buildMenu("menu.sidebar.label");
                bMenu.add(null, (Command)BPxEditorPane.this.toggleToolPane);
                bMenu.add(null, (BValue)new BSeparator());
                for (int i = 0; i < BPxEditorPane.this.sideBars.length; ++i) {
                    bMenu.add(null, (Command)new ToggleSideBar(BPxEditorPane.this.sideBars[i]));
                }
                return bMenu;
            }
            return null;
        }
    }

    class GeometryTool
    extends ToggleCommand {
        BDrawingTool toolMode;

        GeometryTool(String string, BDrawingTool bDrawingTool) {
            super((BWidget)BPxEditorPane.this, lexicon, string);
            this.toolMode = bDrawingTool;
            super.setSelected(false);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl) {
                BPxEditorPane.this.selected.deselectAll();
                BPxEditorPane.this.tool = this.toolMode;
                switch (BPxEditorPane.this.tool.getOrdinal()) {
                    case 1: {
                        BPxEditorPane.this.studio.setTracker(new AddPolygonTracker(BPxEditorPane.this, BPxEditorPane.this.studio));
                        break;
                    }
                    case 2: {
                        BPxEditorPane.this.studio.setTracker(new AddPathTracker(BPxEditorPane.this, BPxEditorPane.this.studio));
                        break;
                    }
                    case 3: {
                        BPxEditorPane.this.studio.setTracker(new AddPointTracker(BPxEditorPane.this, BPxEditorPane.this.studio));
                        break;
                    }
                    case 4: {
                        BPxEditorPane.this.studio.setTracker(new DeletePointTracker(BPxEditorPane.this, BPxEditorPane.this.studio));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                BPxEditorPane.this.editor.firePxEvent(new PxEditorEvent(3, (Object)BPxEditorPane.this.tool));
            }
        }
    }

    class NormalTool
    extends ToggleCommand {
        NormalTool(String string) {
            super((BWidget)BPxEditorPane.this, lexicon, string);
            super.setSelected(true);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl && BPxEditorPane.this.loaded) {
                BPxEditorPane.this.tool = BDrawingTool.normal;
                BPxEditorPane.this.studio.setTracker(new UnpressedTracker(BPxEditorPane.this, BPxEditorPane.this.studio));
                BPxEditorPane.this.studio.setPainter(new DefaultPainter(BPxEditorPane.this.getPainterStudio()));
                BPxEditorPane.this.selected.deselectAll();
                BPxEditorPane.this.editor.firePxEvent(new PxEditorEvent(3, (Object)BPxEditorPane.this.tool));
            }
        }
    }
}

