/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui.device;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.ui.DdfMgrModelUtil;
import com.tridium.ddf.ui.DdfUiLexicon;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.device.DdfDeviceManagerLexicon;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DdfDeviceModel
extends DeviceModel
implements IDdfFacetConst {
    protected BIDeviceFolder folder;
    protected Type deviceType;
    protected Type folderType;

    protected MgrColumn[] makeColumns() {
        return DdfMgrModelUtil.makeColumns(this.getManager());
    }

    public void init() {
        this.folder = (BIDeviceFolder)this.getManager().getCurrentValue();
        try {
            this.deviceType = this.folder.getDeviceType();
            this.folderType = this.folder.getDeviceFolderType();
        }
        catch (Exception exception) {}
        if (this.deviceType == null) {
            throw new BajaRuntimeException(DdfUiLexicon.LEX.getText("MustSpecifyDeviceType", new Object[]{this.folder.getType().getTypeSpec()}));
        }
        if (this.deviceType.isAbstract()) {
            throw new BajaRuntimeException(DdfDeviceManagerLexicon.deviceTypeCannotBeAbstract(this.folder, this.deviceType));
        }
        super.init();
    }

    public void load(BComponent bComponent) {
        super.load(bComponent);
        BComponent[] bComponentArray = this.getTable().getComponentModel().getRows();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof BDdfDevice) {
                ((BDdfDeviceManager)this.getManager()).registerDeviceCommunicator((BDdfDevice)bComponentArray[n]);
            }
            ++n;
        }
    }

    public MgrTypeInfo[] getNewTypes() {
        if (this.deviceType.isAbstract()) {
            throw new BajaRuntimeException(DdfDeviceManagerLexicon.deviceTypeCannotBeAbstract(this.folder, this.deviceType));
        }
        String string = Sys.getRegistry().getDef("proto:" + this.deviceType.getTypeSpec().toString(), "false").toLowerCase();
        if (string.equals("true")) {
            Array array = new Array((Object[])Sys.getRegistry().getConcreteTypes(this.deviceType.getTypeInfo()));
            array.remove((Object)this.deviceType.getTypeInfo());
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])array.trim()));
        }
        return MgrTypeInfo.makeArray((Type)this.deviceType);
    }

    private final /* synthetic */ void this() {
        this.deviceType = BDdfDevice.TYPE;
        this.folderType = BDeviceFolder.TYPE;
    }

    public DdfDeviceModel(BDdfDeviceManager bDdfDeviceManager) {
        super((BDeviceManager)bDdfDeviceManager);
        this.this();
    }
}

