/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.req.util.DdfReadRequestUtil;
import com.tridium.ddf.comm.req.util.DdfRequestLexicon;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.point.BIDdfWritable;
import com.tridium.ddf.point.DdfPointLexicon;
import javax.baja.status.BStatusValue;

public class DdfWriteRequestUtil
implements IDdfFacetConst {
    public static void processResponse(BIDdfWriteRequest bIDdfWriteRequest, BIDdfResponse bIDdfResponse) {
        IDdfWritable[] iDdfWritableArray;
        if (bIDdfWriteRequest.getAutoWriteOk() && (iDdfWritableArray = bIDdfWriteRequest.getWritableSource()) != null) {
            DdfWriteRequestUtil.updateWritables(bIDdfResponse, iDdfWritableArray);
        }
    }

    public static void processTimeout(BIDdfWriteRequest bIDdfWriteRequest) {
        IDdfWritable[] iDdfWritableArray;
        if (bIDdfWriteRequest.getAutoWriteFailOnTimeout() && (iDdfWritableArray = bIDdfWriteRequest.getWritableSource()) != null) {
            int n = 0;
            while (n < iDdfWritableArray.length) {
                iDdfWritableArray[n].writeFail(DdfRequestLexicon.requestTimeout);
                ++n;
            }
        }
    }

    public static void processLateResponse(BIDdfWriteRequest bIDdfWriteRequest, BIDdfResponse bIDdfResponse) {
        IDdfWritable[] iDdfWritableArray;
        if (bIDdfWriteRequest.getAutoWriteOkLate() && (iDdfWritableArray = bIDdfWriteRequest.getWritableSource()) != null) {
            DdfWriteRequestUtil.updateWritables(bIDdfResponse, iDdfWritableArray);
        }
    }

    public static void processErrorResponse(BIDdfWriteRequest bIDdfWriteRequest, DdfResponseException ddfResponseException) {
        IDdfWritable[] iDdfWritableArray;
        if (bIDdfWriteRequest.getAutoWriteFailOnError() && (iDdfWritableArray = bIDdfWriteRequest.getWritableSource()) != null) {
            int n = 0;
            while (n < iDdfWritableArray.length) {
                iDdfWritableArray[n].writeFail(DdfDefaultCommLexicon.responseError(ddfResponseException));
                ++n;
            }
        }
    }

    private static final void updateReadValues(BIDdfReadResponse bIDdfReadResponse, IDdfWritable[] iDdfWritableArray) {
        if (iDdfWritableArray != null) {
            int n = 0;
            while (n < iDdfWritableArray.length) {
                if (iDdfWritableArray[n] instanceof IDdfReadable) {
                    DdfReadRequestUtil.callReadOk((IDdfReadable)((Object)iDdfWritableArray[n]), bIDdfReadResponse);
                }
                ++n;
            }
        }
    }

    private static final void updateWriteValues(IDdfWritable[] iDdfWritableArray) {
        int n = 0;
        while (n < iDdfWritableArray.length) {
            BStatusValue bStatusValue = iDdfWritableArray[n].getWriteValue();
            iDdfWritableArray[n].writeOk(bStatusValue);
            ++n;
        }
    }

    private static final void updateWritables(BIDdfResponse bIDdfResponse, IDdfWritable[] iDdfWritableArray) {
        DdfWriteRequestUtil.updateWriteValues(iDdfWritableArray);
        if (bIDdfResponse instanceof BIDdfReadResponse) {
            DdfWriteRequestUtil.updateReadValues((BIDdfReadResponse)bIDdfResponse, iDdfWritableArray);
        }
    }

    public static void doWrite(BIDdfWritable bIDdfWritable, BStatusValue bStatusValue) {
        BIDdfWriteRequest bIDdfWriteRequest = bIDdfWritable.makeWriteRequest();
        if (bIDdfWriteRequest == null) {
            String string = DdfPointLexicon.writeNotImplemented(bIDdfWritable.toString());
            bIDdfWritable.writeFail(string);
            bIDdfWritable.getDdfCommunicator().getLog().error(string);
        } else {
            bIDdfWritable.getDdfCommunicator().communicate(bIDdfWriteRequest);
        }
    }

    public static void doAuto(BIDdfWritable bIDdfWritable) {
        BIDdfWriteRequest bIDdfWriteRequest = bIDdfWritable.makeAutoRequest();
        if (bIDdfWriteRequest == null) {
            if (bIDdfWritable.getDdfCommunicator().getLog().isTraceOn()) {
                bIDdfWritable.getDdfCommunicator().getLog().trace(DdfPointLexicon.noAutoRequestDefined(bIDdfWritable.toString()));
            }
        } else {
            bIDdfWritable.getDdfCommunicator().communicate(bIDdfWriteRequest);
        }
    }
}

