/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.clock.BDdfScheduler;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfTransactionMgr;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRawTransmitRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;
import java.util.Hashtable;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfTransactionMgr
extends BComponent
implements BIDdfTransactionMgr {
    public static final Action checkOutstandingTimeout = BDdfTransactionMgr.newAction((int)4, (BValue)BString.make((String)"OverridePlease"), null);
    public static final Type TYPE;
    private BIDdfCommunicator ddfCommunicator;
    boolean stopped;
    ReceiveThread receiveThread;
    TransactionProcessor transactionProcessor;
    Hashtable requestTickets;
    static /* synthetic */ Class class$com$tridium$ddf$comm$defaultComm$BDdfTransactionMgr;

    public Type getType() {
        return TYPE;
    }

    public void checkOutstandingTimeout(BValue bValue) {
        this.invoke(checkOutstandingTimeout, bValue, Context.commit);
    }

    public final void started() throws Exception {
        this.transactionMgrStarted();
        super.started();
    }

    public final void stopped() throws Exception {
        this.transactionMgrStopped();
    }

    public void processTransaction(BIDdfRequest bIDdfRequest) {
        block6: {
            try {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.beginTransaction(bIDdfRequest));
                }
                this.beginTransaction(bIDdfRequest);
                if (bIDdfRequest.getResponseTimeout().equals((Object)BRelTime.DEFAULT)) {
                    if (this.getDdfCommunicator().getLog().isTraceOn()) {
                        this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.sendOnlyTransactionNotification + ": " + bIDdfRequest.toString());
                    }
                } else {
                    this.scheduleToCheckForTimeout(bIDdfRequest);
                }
            }
            catch (Exception exception) {
                if (!this.getDdfCommunicator().getLog().isTraceOn()) break block6;
                this.getDdfCommunicator().getLog().trace("TransactionError", (Throwable)exception);
            }
        }
    }

    public BIDdfCommunicator getDdfCommunicator() {
        if (this.ddfCommunicator == null) {
            this.ddfCommunicator = (BIDdfCommunicator)this.getParent();
        }
        return this.ddfCommunicator;
    }

    public void startTransactionMgr() {
        if (this.stopped) {
            this.stopped = false;
            this.transactionProcessor = new TransactionProcessor();
            this.transactionProcessor.start();
            this.receiveThread = new ReceiveThread();
            this.receiveThread.start();
            this.getDdfCommunicator().getDdfReceiver().startReceiver();
        }
    }

    public void stopTransactionMgr() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.receiveThread != null) {
                this.getDdfCommunicator().getDdfReceiver().stopReceiver();
                this.receiveThread.stopReceiving();
                this.receiveThread.interrupt();
                try {
                    this.receiveThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.transactionProcessor != null) {
                this.transactionProcessor.interrupt();
                this.transactionProcessor.stopProcessing();
                try {
                    this.transactionProcessor.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.ddfCommunicator = null;
        }
        if (this.receiveThread != null && this.receiveThread.isAlive() || this.transactionProcessor != null && this.transactionProcessor.isAlive()) {
            new ReceiverAndTransactionMgrKiller(this.receiveThread, this.transactionProcessor).start();
        }
    }

    protected abstract void beginTransaction(BIDdfRequest var1) throws Exception;

    protected abstract void doCheckOutstandingTimeout(BIDdfRequest var1);

    protected abstract void frameReceived(IDdfDataFrame var1);

    protected void transactionMgrStarted() {
    }

    protected void transactionMgrStopped() {
    }

    public void resetStatistics() {
    }

    public final void doCheckOutstandingTimeout(BValue bValue) {
        this.transactionProcessor.enqueue((BIDdfRequest)bValue);
    }

    protected void scheduleToCheckForTimeout(BIDdfRequest bIDdfRequest) {
        Clock.Ticket ticket = BDdfScheduler.INSTANCE.schedule((BComponent)this, bIDdfRequest.getResponseTimeout(), checkOutstandingTimeout, (BValue)bIDdfRequest);
        this.requestTickets.put(bIDdfRequest, ticket);
    }

    protected void routeToUnsolicited(IDdfDataFrame iDdfDataFrame) {
        BIDdfUnsolicitedMgr bIDdfUnsolicitedMgr = this.getDdfCommunicator().getDdfUnsolicitedMgr();
        if (bIDdfUnsolicitedMgr != null) {
            bIDdfUnsolicitedMgr.enqueueUnsolicitedFrame(iDdfDataFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reScheduleToCheckForTimeout(BIDdfRequest bIDdfRequest) {
        BIDdfRequest bIDdfRequest2 = bIDdfRequest;
        synchronized (bIDdfRequest2) {
            if (bIDdfRequest.getResponseTimeout().getMillis() >= 0L) {
                Clock.Ticket ticket = (Clock.Ticket)this.requestTickets.get(bIDdfRequest);
                if (ticket != null) {
                    ticket.cancel();
                }
                ticket = BDdfScheduler.INSTANCE.schedule((BComponent)this, bIDdfRequest.getResponseTimeout(), checkOutstandingTimeout, (BValue)bIDdfRequest);
                this.requestTickets.put(bIDdfRequest, ticket);
            }
            return;
        }
    }

    protected boolean isCompletedResponse(BIDdfResponse bIDdfResponse) {
        if (bIDdfResponse instanceof BIDdfMultiFrameResponse) {
            return ((BIDdfMultiFrameResponse)bIDdfResponse).isComplete();
        }
        return true;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIDdfCommunicator;
    }

    protected void transmitRspAckBytes(IDdfTransmitAckResponse iDdfTransmitAckResponse) {
        try {
            byte[] byArray = iDdfTransmitAckResponse.getBytes();
            if (byArray != null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.ackReplyTransmit(iDdfTransmitAckResponse));
                }
                this.getDdfCommunicator().getDdfTransmitter().forceTransmit(new BDdfRawTransmitRequest(byArray));
            }
        }
        catch (Exception exception) {
            this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.ackReplyTransmitError(iDdfTransmitAckResponse), (Throwable)exception);
        }
    }

    protected String getThreadSuffix() {
        BIDdfCommunicator bIDdfCommunicator = this.getDdfCommunicator();
        if (bIDdfCommunicator instanceof BDdfCommunicator) {
            return ((BDdfCommunicator)bIDdfCommunicator).getWorkerThreadName();
        }
        return "";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stopped = true;
        this.requestTickets = new Hashtable();
    }

    public BDdfTransactionMgr() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ddf$comm$defaultComm$BDdfTransactionMgr;
        if (clazz == null) {
            clazz = class$com$tridium$ddf$comm$defaultComm$BDdfTransactionMgr = BDdfTransactionMgr.class("[Lcom.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TransactionProcessor
    extends Thread {
        boolean isRunning;
        boolean isTransactionProcessorStopped;
        Queue itemsToProcess;

        void enqueue(IDdfDataFrame iDdfDataFrame) {
            this.itemsToProcess.enqueue((Object)iDdfDataFrame);
        }

        void enqueue(BIDdfRequest bIDdfRequest) {
            this.itemsToProcess.enqueue((Object)bIDdfRequest);
        }

        private final void process(IDdfDataFrame iDdfDataFrame) {
            BDdfTransactionMgr.this.frameReceived(iDdfDataFrame);
        }

        private final void process(BIDdfRequest bIDdfRequest) {
            Clock.Ticket ticket = (Clock.Ticket)BDdfTransactionMgr.this.requestTickets.get(bIDdfRequest);
            if (ticket == null) {
                BDdfTransactionMgr.this.doCheckOutstandingTimeout(bIDdfRequest);
            } else if (ticket.isExpired()) {
                BDdfTransactionMgr.this.requestTickets.remove(bIDdfRequest);
                BDdfTransactionMgr.this.doCheckOutstandingTimeout(bIDdfRequest);
            }
        }

        void stopProcessing() {
            this.isTransactionProcessorStopped = true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.isRunning = true;
                while (true) {
                    block10: {
                        if (!this.isTransactionProcessorStopped) break block10;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().message("Transaction mgr thread successfully stopped");
                        break;
                    }
                    try {
                        Object object = this.itemsToProcess.dequeue(-1);
                        if (object instanceof IDdfDataFrame) {
                            this.process((IDdfDataFrame)object);
                            continue;
                        }
                        if (!(object instanceof BIDdfRequest)) continue;
                        this.process((BIDdfRequest)object);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {
                        if (this.isTransactionProcessorStopped) continue;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().error(throwable.toString(), throwable);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.isRunning = false;
                throw throwable;
            }
            {
                Object var2_5 = null;
                this.isRunning = false;
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.isRunning = false;
            this.isTransactionProcessorStopped = false;
            this.itemsToProcess = new Queue();
        }

        TransactionProcessor() {
            super("Transaction:" + BDdfTransactionMgr.this.getThreadSuffix());
            this.this();
            this.isTransactionProcessorStopped = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ReceiveThread
    extends Thread {
        boolean isReceiveThreadStopped;
        boolean isRunning;

        void stopReceiving() {
            this.isReceiveThreadStopped = true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.isRunning = true;
                while (true) {
                    block8: {
                        if (!this.isReceiveThreadStopped) break block8;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().message("Receive thread successfully stopped");
                        break;
                    }
                    try {
                        IDdfDataFrame iDdfDataFrame = BDdfTransactionMgr.this.getDdfCommunicator().getDdfReceiver().receiveFrame();
                        if (iDdfDataFrame == null) continue;
                        BDdfTransactionMgr.this.transactionProcessor.enqueue(iDdfDataFrame.getFrameCopy());
                    }
                    catch (Throwable throwable) {
                        if (this.isReceiveThreadStopped) continue;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().error(throwable.toString(), throwable);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.isRunning = false;
                throw throwable;
            }
            {
                Object var2_5 = null;
                this.isRunning = false;
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.isReceiveThreadStopped = false;
            this.isRunning = false;
        }

        ReceiveThread() {
            super("Receive:" + BDdfTransactionMgr.this.getThreadSuffix());
            this.this();
            this.isReceiveThreadStopped = false;
            this.isRunning = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ReceiverAndTransactionMgrKiller
    extends Thread {
        ReceiveThread receiveThread;
        TransactionProcessor transactionProcessor;

        public void run() {
            while (this.receiveThread != null && this.receiveThread.isRunning || this.transactionProcessor != null && this.transactionProcessor.isRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.receiveThread != null && this.receiveThread.isRunning) {
                    this.receiveThread.interrupt();
                }
                if (this.transactionProcessor == null || !this.transactionProcessor.isRunning) continue;
                this.transactionProcessor.interrupt();
            }
        }

        ReceiverAndTransactionMgrKiller(ReceiveThread receiveThread, TransactionProcessor transactionProcessor) {
            this.receiveThread = receiveThread;
            this.transactionProcessor = transactionProcessor;
        }
    }
}

