/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfReceiver;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.baja.data.BIDataValue;
import javax.baja.io.ByteBuffer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfReceiver
extends BStruct
implements BIDdfReceiver {
    public static final Property responseTimeout = BDdfReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)DdfFacets.combine(IDdfFacetConst.MGR_INCLUDE, BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L))));
    public static final Property numFramesReceived = BDdfReceiver.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int MAYBE = 2;
    private static final int DEV_RX_STATE_SOH = 0;
    private static final int DEV_RX_STATE_DATA = 1;
    private static final int DEV_RX_STATE_DONE = 2;
    private BIDdfCommunicator ddfCommunicator;
    protected boolean stopped;
    DdfReceiveFrame receiveFrame;
    boolean receiving;
    int rxState;
    Method doTraceMethod;
    static /* synthetic */ Class class$com$tridium$ddf$comm$defaultComm$BDdfReceiver;
    static /* synthetic */ Class class$com$tridium$ddf$comm$IDdfDataFrame;

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public long getNumFramesReceived() {
        return this.getLong(numFramesReceived);
    }

    public void setNumFramesReceived(long l) {
        this.setLong(numFramesReceived, l, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Ddf Receiver");
        this.spyImpl(spyWriter);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    private final void spyImpl(SpyWriter spyWriter) {
        spyWriter.prop((Object)"Receiving", this.receiving);
        spyWriter.prop((Object)"Rx State", (Object)this.getStateTextForSpy());
        spyWriter.prop((Object)"Rx Buffer", (Object)this.spyBuffer());
    }

    private final String spyBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        DdfReceiveFrame ddfReceiveFrame = this.getInternalBuffer();
        if (ddfReceiveFrame != null) {
            IDdfDataFrame iDdfDataFrame = this.getInternalBuffer().getFrameCopy();
            int n = iDdfDataFrame.getFrameSize();
            byte[] byArray = this.getInternalBuffer().getFrameBytes();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(TextUtil.byteToHexString((int)byArray[n2]));
                if (n2 + 1 < n) {
                    stringBuffer.append(' ');
                }
                if (n2 % 16 == 0) {
                    stringBuffer.append('\n');
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "null";
    }

    public IDdfDataFrame receiveFrame() {
        try {
            IDdfDataFrame iDdfDataFrame = this.doReceiveFrame();
            if (iDdfDataFrame != null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.trace(iDdfDataFrame);
                }
                this.setNumFramesReceived(this.getNumFramesReceived() + 1L);
            }
            return iDdfDataFrame;
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.interrupted(), (Throwable)exception);
                }
            } else {
                BIDdfCommunicator bIDdfCommunicator = this.getDdfCommunicator();
                if (bIDdfCommunicator instanceof BDdfCommunicator) {
                    if (((BDdfCommunicator)bIDdfCommunicator).isCommEnabled()) {
                        this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError, (Throwable)exception);
                    }
                } else {
                    this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError, (Throwable)exception);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception2) {}
            return null;
        }
    }

    public void startReceiver() {
        this.stopped = false;
    }

    public void stopReceiver() {
        this.stopped = true;
        this.ddfCommunicator = null;
    }

    protected abstract int isStartOfFrame(IDdfDataFrame var1);

    protected abstract boolean isCompleteFrame(IDdfDataFrame var1);

    protected abstract boolean checkFrame(IDdfDataFrame var1);

    protected abstract int readByte() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDdfDataFrame doReceiveFrame() throws Exception {
        try {
            this.receiving = true;
            this.resetReceiveBuffer();
            this.rxState = 0;
            while (this.rxState != 2) {
                this.readByteToBuffer();
                if (this.rxState == 0) {
                    int n = this.isStartOfFrame(this.receiveFrame);
                    if (n == 0) {
                        this.rxState = 1;
                        continue;
                    }
                    if (n != 1) continue;
                    this.resetReceiveBuffer();
                    continue;
                }
                if (this.rxState != 1 || !this.isCompleteFrame(this.receiveFrame)) continue;
                if (this.checkFrame(this.receiveFrame)) {
                    this.rxState = 2;
                    continue;
                }
                this.resetReceiveBuffer();
                this.rxState = 0;
            }
            DdfReceiveFrame ddfReceiveFrame = this.getInternalBuffer();
            Object var2_3 = null;
            this.receiving = false;
            return ddfReceiveFrame;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.receiving = false;
            throw throwable;
        }
    }

    public void resetStatistics() {
        this.setNumFramesReceived(0L);
    }

    public BIDdfCommunicator getDdfCommunicator() {
        if (this.ddfCommunicator == null) {
            this.ddfCommunicator = (BIDdfCommunicator)this.getParent();
        }
        return this.ddfCommunicator;
    }

    protected void readByteToBuffer() throws Exception {
        this.receiveFrame.write(this.readByte());
    }

    public BRelTime getResponseTimeout(BIDdfRequest bIDdfRequest) {
        if (bIDdfRequest.getResponseTimeout().equals((Object)BDdfRequest.responseTimeout.getDefaultValue())) {
            return this.getResponseTimeout();
        }
        return bIDdfRequest.getResponseTimeout();
    }

    protected void resetReceiveBuffer() {
        this.receiveFrame.reset();
    }

    protected DdfReceiveFrame getInternalBuffer() {
        return this.receiveFrame;
    }

    protected BSimple computeTag(IDdfDataFrame iDdfDataFrame) {
        return BString.DEFAULT;
    }

    private final void trace(IDdfDataFrame iDdfDataFrame) {
        if (this.doTraceMethod != null) {
            try {
                this.doTraceMethod.invoke((Object)this, iDdfDataFrame);
                return;
            }
            catch (Exception exception) {
                this.doTraceMethod = null;
            }
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("RX:");
        ByteArrayUtil.hexDump((PrintWriter)printWriter, (byte[])iDdfDataFrame.getFrameBytes(), (int)0, (int)iDdfDataFrame.getFrameSize());
        printWriter.flush();
        printWriter.close();
        this.getDdfCommunicator().getLog().trace(stringWriter.toString());
    }

    private final String getStateTextForSpy() {
        switch (this.rxState) {
            case 0: {
                return "DEV_RX_STATE_SOH";
            }
            case 1: {
                return "DEV_RX_STATE_DATA";
            }
            case 2: {
                return "DEV_RX_STATE_DONE";
            }
        }
        return "" + this.rxState;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stopped = false;
        this.receiveFrame = new DdfReceiveFrame();
        this.receiving = false;
        this.rxState = 0;
    }

    public BDdfReceiver() {
        this.this();
        Class<?> clazz = this.getClass();
        try {
            Class[] classArray = new Class[1];
            Class clazz2 = class$com$tridium$ddf$comm$IDdfDataFrame;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$ddf$comm$IDdfDataFrame = BDdfReceiver.class("[Lcom.tridium.ddf.comm.IDdfDataFrame;", false);
            }
            classArray[0] = clazz2;
            this.doTraceMethod = clazz.getMethod("doTrace", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.doTraceMethod = null;
        }
    }

    static {
        Class clazz = class$com$tridium$ddf$comm$defaultComm$BDdfReceiver;
        if (clazz == null) {
            clazz = class$com$tridium$ddf$comm$defaultComm$BDdfReceiver = BDdfReceiver.class("[Lcom.tridium.ddf.comm.defaultComm.BDdfReceiver;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DdfReceiveFrame
    extends ByteBuffer
    implements IDdfDataFrame {
        public byte[] getFrameBytes() {
            return this.getBytes();
        }

        public int getFrameSize() {
            return this.getLength();
        }

        public BSimple getFrameTag() {
            return BDdfReceiver.this.computeTag(this);
        }

        public IDdfDataFrame getFrameCopy() {
            DdfReceiveFrame ddfReceiveFrame = new DdfReceiveFrame();
            ddfReceiveFrame.write(this.toByteArray());
            return ddfReceiveFrame;
        }

        DdfReceiveFrame() {
            super(512);
        }
    }
}

