/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.util.Stack;
import textuality.lark.Attribute;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.ANY;
import textuality.validator.Attlist;
import textuality.validator.DTD;
import textuality.validator.Defaulter;
import textuality.validator.EMPTY;
import textuality.validator.Grammar;
import textuality.validator.Mixed;

public class Validator {
    DTD mDTD;
    Handler mHandler;
    Grammar mCurrentGrammar;
    Stack mStack = new Stack();
    private static final String sAppearsInEmpty = "' appears in EMPTY element '";
    private static final String sAttributeOf = "' attribute of '";
    private static final String sBadEnd = "' ended prematurely.";
    private static final String sCantAppearHereIn = "' can't appear at this location within '";
    private static final String sCantBeAChildOf = "' can't be a child of '";
    private static final String sDoesNotMatchDTD = "' does not match declared DOCTYPE '";
    private static final String sElement = "Element '";
    private static final String sFirstElement = "First element '";
    private static final String sNotAllowed = "' has not been declared.";
    private static final String sNotInMixed = "' can't appear in Mixed-content element '";
    private static final String sNoTextHere = "Character data is not allowed in '";
    private static final String sUndeclared = "Undeclared element type '";

    public boolean checkEndTag(Entity entity, Element element) {
        String string = element.type();
        boolean bl = false;
        if (this.mCurrentGrammar == null) {
            return false;
        }
        if (!this.mCurrentGrammar.canEnd()) {
            bl = this.mHandler.doValidityError(entity, sElement + string + sBadEnd);
        }
        this.mCurrentGrammar.freeUp();
        if (!this.mStack.empty()) {
            this.mCurrentGrammar = (Grammar)this.mStack.pop();
        }
        return bl;
    }

    public Validator(DTD dTD, Handler handler) {
        this.mDTD = dTD;
        this.mHandler = handler;
    }

    public boolean checkStartTag(Entity entity, Element element, int n) {
        String string = element.type();
        Grammar grammar = null;
        Grammar grammar2 = null;
        Attribute[] attributeArray = element.allAttributes();
        boolean bl = false;
        if (this.mCurrentGrammar == null) {
            String string2 = this.mDTD.root();
            if (!string.equals(string2)) {
                bl = this.mHandler.doValidityError(entity, sFirstElement + string + sDoesNotMatchDTD + string2 + "'.");
            }
        } else if (this.mCurrentGrammar instanceof EMPTY) {
            bl = bl || this.mHandler.doValidityError(entity, sElement + string + sAppearsInEmpty + this.mCurrentGrammar.type() + "'.");
            grammar = this.mCurrentGrammar;
        } else if (this.mCurrentGrammar instanceof ANY) {
            grammar = this.mCurrentGrammar;
        } else if (this.mCurrentGrammar instanceof Mixed) {
            grammar = ((Mixed)this.mCurrentGrammar).tryType(string);
            if (grammar == null) {
                bl = bl || this.mHandler.doValidityError(entity, sElement + string + sNotInMixed + this.mCurrentGrammar.type() + "'.");
                grammar = this.mCurrentGrammar;
            }
        } else {
            grammar = this.mCurrentGrammar.tryElement(string, entity, element, this.mHandler);
            if (grammar == null) {
                bl = this.mCurrentGrammar instanceof Mixed ? this.mHandler.doValidityError(entity, "'" + string + sCantBeAChildOf + this.mCurrentGrammar.type() + "'.") : this.mHandler.doValidityError(entity, "'" + string + sCantAppearHereIn + this.mCurrentGrammar.type() + "'.");
                grammar = this.mCurrentGrammar;
            }
        }
        if ((grammar2 = this.mDTD.grammar(string)) == null) {
            this.mDTD.recordANY(string);
            grammar2 = this.mDTD.grammar(string);
            bl = bl || this.mHandler.doValidityError(entity, sUndeclared + string + "'.");
        }
        this.mStack.push(grammar);
        this.mCurrentGrammar = grammar2;
        int n2 = 0;
        while (n2 < n) {
            Object object = this.mDTD.attlist(string + '/' + attributeArray[n2].name());
            bl = object == null ? bl || this.mHandler.doValidityError(entity, "'" + attributeArray[n2].name() + sAttributeOf + string + sNotAllowed) : bl || ((Attlist)object).check(entity, element, attributeArray[n2].name(), this.mHandler);
            ++n2;
        }
        Object object = this.mDTD.defaulter(string);
        if (object != null) {
            bl = bl || ((Defaulter)object).check(element.allAttributes(), n, this.mHandler, entity);
        }
        return bl;
    }

    public boolean checkText(Entity entity, Element element, char[] cArray, int n) {
        if (this.mCurrentGrammar == null) {
            return false;
        }
        if (this.mCurrentGrammar.checkText(cArray, n)) {
            return this.mHandler.doValidityError(entity, sNoTextHere + element.type() + "'.");
        }
        return false;
    }
}

