/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.io.PrintStream;
import java.util.Vector;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.Sequence;

public abstract class Grammar {
    static final int sNoRepeat = 0;
    static final int sPlus = 1;
    static final int sStar = 2;
    static final int sQM = 3;
    static Object sUp = new Object();
    static Object sDown = new Object();
    Grammar mParent;
    String mType;
    int mRepeat;
    Object[] mMembers;
    boolean mInUse;
    Grammar mNext;

    public void addAnother(Grammar grammar) {
        grammar.setNext(this.mNext);
        this.mNext = grammar;
    }

    public boolean canBypass() {
        if (this.mRepeat == 2 || this.mRepeat == 3) {
            return true;
        }
        int n = 0;
        while (n < this.mMembers.length) {
            if (this.mMembers[n] instanceof String || !((Grammar)this.mMembers[n]).canBypass()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void dumpMe(PrintStream printStream) {
        if (this instanceof Sequence) {
            printStream.print("SEQ: (");
        } else {
            printStream.print("CHOICE: (");
        }
        int n = 0;
        while (n < this.mMembers.length) {
            if (this.mMembers[n] instanceof String) {
                printStream.print(this.mMembers[n] + " ");
            } else {
                printStream.print("* ");
            }
            ++n;
        }
        printStream.print(")");
        switch (this.mRepeat) {
            case 1: {
                printStream.print("+");
                break;
            }
            case 2: {
                printStream.print("*");
                break;
            }
            case 3: {
                printStream.print("?");
            }
        }
        printStream.println();
    }

    public Grammar tryElement(String string, Entity entity, Element element, Handler handler) {
        return null;
    }

    public void setRepeat(char c) {
        switch (c) {
            case '+': {
                this.mRepeat = 1;
                return;
            }
            case '*': {
                this.mRepeat = 2;
                return;
            }
            case '?': {
                this.mRepeat = 3;
                return;
            }
        }
    }

    public void setNext(Grammar grammar) {
        this.mNext = grammar;
    }

    public int probe(String string, Vector vector, boolean bl, boolean bl2) {
        return 0;
    }

    public abstract boolean checkText(char[] var1, int var2);

    public String type() {
        if (this.mType != null) {
            return this.mType;
        }
        return this.mParent.type();
    }

    public Grammar findUnused() {
        if (!this.mInUse) {
            this.showInUse();
            return this;
        }
        if (this.mNext != null) {
            return this.mNext.findUnused();
        }
        return null;
    }

    public boolean canEnd() {
        return true;
    }

    public void freeUp() {
        this.mInUse = false;
    }

    public void showInUse() {
        this.mInUse = true;
    }

    public void forceMatch(Object object) {
    }

    public void freeUpOne() {
        this.freeUp();
    }
}

