/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.ANY;
import textuality.validator.Attlist;
import textuality.validator.Defaulter;
import textuality.validator.EMPTY;
import textuality.validator.Grammar;
import textuality.validator.Mixed;
import textuality.validator.Placeholder;
import textuality.validator.Validator;

public class DTD {
    Hashtable mGrammars = new Hashtable();
    Hashtable mIDs = new Hashtable();
    Hashtable mUnparsedEntities = new Hashtable();
    Hashtable mNotations = new Hashtable();
    Hashtable mDefaulters = new Hashtable();
    Hashtable mAttlists = new Hashtable();
    Vector mIDREFs = new Vector();
    Vector mNotationsNamed = new Vector();
    Vector mUnparsedEntitiesNamed = new Vector();
    Vector mPlaceholders = new Vector();
    String mRoot;
    static final String sAttributeOf = "' attribute of '";
    static final String sBadIDREF = "' refers to nonexistent ID '";
    static final String sUndefEntity = "DTD refers to undeclared entity '";
    static final String sUndefNotation = "DTD refers to undeclared notation '";
    static final String sDeclarationOf = "' attribute default for '";
    Placeholder mCurrentPH;
    Placeholder mLastPH;

    public void startCM(String string) {
        this.mCurrentPH = new Placeholder(string);
        this.mLastPH = null;
        this.mPlaceholders.addElement(this.mCurrentPH);
    }

    public void recordANY(String string) {
        this.mGrammars.put(string, new ANY(string));
    }

    public boolean doneDTD(Entity entity, Handler handler) {
        String string;
        boolean bl = false;
        int n = 0;
        while (n < this.mPlaceholders.size()) {
            Placeholder placeholder = (Placeholder)this.mPlaceholders.elementAt(n);
            this.mGrammars.put(placeholder.type(), placeholder.makeGrammar(null));
            ++n;
        }
        n = 0;
        while (n < this.mNotationsNamed.size()) {
            string = (String)this.mNotationsNamed.elementAt(n);
            if (this.mNotations.get(string) == null) {
                bl = bl || handler.doValidityError((Entity)this.mNotationsNamed.elementAt(n + 1), sUndefNotation + string + "'");
            }
            n += 2;
        }
        n = 0;
        while (n < this.mUnparsedEntitiesNamed.size()) {
            string = (String)this.mUnparsedEntitiesNamed.elementAt(n);
            if (this.mUnparsedEntities.get(string) == null) {
                bl = bl || handler.doValidityError((Entity)this.mUnparsedEntitiesNamed.elementAt(n + 1), sUndefEntity + string + "'");
            }
            n += 2;
        }
        Enumeration enumeration = this.mDefaulters.elements();
        while (enumeration.hasMoreElements()) {
            Defaulter defaulter = (Defaulter)enumeration.nextElement();
            defaulter.doneDTD();
        }
        return bl;
    }

    public void recordMixed(Vector vector) {
        this.mGrammars.put(vector.elementAt(0), new Mixed(vector));
    }

    public void markConnector(int n) {
        this.mCurrentPH.setConnector((char)n);
    }

    public void endCP(Vector vector) {
        Placeholder placeholder = this.mCurrentPH.parent();
        this.mCurrentPH.addMembers(vector);
        this.mLastPH = this.mCurrentPH;
        if (placeholder != null) {
            placeholder.addMember(this.mCurrentPH);
            this.mCurrentPH = placeholder;
        }
    }

    public DTD(String string) {
        this.mRoot = string;
    }

    public void declareNotation(Entity entity, Vector vector) {
        this.mNotations.put(vector.elementAt(0), vector.elementAt(vector.size() - 1));
    }

    public void markRep(Vector vector, int n) {
        int n2 = vector.size();
        if (n2 > 0) {
            Placeholder placeholder = new Placeholder(this.mCurrentPH);
            --n2;
            int n3 = 0;
            while (n3 < n2) {
                this.mCurrentPH.addMember(vector.elementAt(n3));
                ++n3;
            }
            placeholder.addMember(vector.elementAt(n2));
            placeholder.setRepeat((char)n);
            this.mCurrentPH.addMember(placeholder);
            return;
        }
        this.mLastPH.setRepeat((char)n);
    }

    public Object attlist(String string) {
        return this.mAttlists.get(string);
    }

    public void declareUnparsed(Entity entity, Vector vector, Handler handler) {
        this.mNotationsNamed.addElement(vector.elementAt(vector.size() - 1));
        this.mNotationsNamed.addElement(Attlist.shutUpAndClone(entity, handler, entity));
        this.mUnparsedEntities.put(vector.elementAt(0), vector.elementAt(vector.size() - 1));
    }

    public Vector unparsedEntityVector() {
        return this.mUnparsedEntitiesNamed;
    }

    public Vector IDREFVector() {
        return this.mIDREFs;
    }

    public Validator validator(Handler handler) {
        return new Validator(this, handler);
    }

    public Hashtable idTable() {
        return this.mIDs;
    }

    public Grammar grammar(String string) {
        Grammar grammar = (Grammar)this.mGrammars.get(string);
        if (grammar == null) {
            return null;
        }
        if (grammar instanceof ANY || grammar instanceof EMPTY || grammar instanceof Mixed) {
            return grammar;
        }
        Grammar grammar2 = grammar.findUnused();
        if (grammar2 != null) {
            return grammar2;
        }
        int n = 0;
        while (n < this.mPlaceholders.size()) {
            if (string == ((Placeholder)this.mPlaceholders.elementAt(n)).type()) break;
            ++n;
        }
        grammar2 = (Grammar)((Placeholder)this.mPlaceholders.elementAt(n)).makeGrammar(null);
        grammar.addAnother(grammar2);
        return grammar2;
    }

    public void recordAttDecl(Vector vector, Entity entity, Handler handler, String string) {
        String string2 = (String)vector.elementAt(0);
        Defaulter defaulter = (Defaulter)this.mDefaulters.get(string2);
        if (defaulter == null) {
            defaulter = new Defaulter(string2);
            this.mDefaulters.put(string2, defaulter);
        }
        Attlist.registerAttlist(vector, this, entity, handler, string, defaulter, this.mAttlists);
    }

    public String root() {
        return this.mRoot;
    }

    public Object defaulter(String string) {
        return this.mDefaulters.get(string);
    }

    public void doneDocument(Handler handler) {
        int n = 0;
        while (n < this.mIDREFs.size()) {
            String string = (String)this.mIDREFs.elementAt(n);
            if (this.mIDs.get(string) == null) {
                String string2;
                String string3 = (String)this.mIDREFs.elementAt(n + 1);
                Entity entity = (Entity)this.mIDREFs.elementAt(n + 2);
                if (this.mIDREFs.elementAt(n + 3) instanceof Element) {
                    string2 = ((Element)this.mIDREFs.elementAt(n + 3)).type();
                    handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sBadIDREF + string + "'.");
                } else {
                    string2 = (String)this.mIDREFs.elementAt(n + 3);
                    handler.doValidityError(entity, "'" + string3 + sDeclarationOf + string2 + sBadIDREF + string + "'.");
                }
            }
            n += 4;
        }
    }

    public Vector notationVector() {
        return this.mNotationsNamed;
    }

    public void startCP(Vector vector) {
        Placeholder placeholder;
        this.mCurrentPH.addMembers(vector);
        this.mCurrentPH = placeholder = new Placeholder(this.mCurrentPH);
    }

    public Hashtable entityTable() {
        return this.mUnparsedEntities;
    }

    public void recordEMPTY(String string) {
        this.mGrammars.put(string, new EMPTY(string));
    }
}

