/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.util.Hashtable;
import java.util.Vector;
import textuality.lark.CharClasses;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.CheckCDATA;
import textuality.validator.CheckENTITIES;
import textuality.validator.CheckENTITY;
import textuality.validator.CheckENUMERATED;
import textuality.validator.CheckID;
import textuality.validator.CheckIDREF;
import textuality.validator.CheckIDREFS;
import textuality.validator.CheckNMTOKEN;
import textuality.validator.CheckNMTOKENS;
import textuality.validator.CheckNOTATION;
import textuality.validator.DTD;
import textuality.validator.Defaulter;

public class Attlist {
    static CheckCDATA mCheckCDATA;
    static CheckID mCheckID;
    static CheckIDREF mCheckIDREF;
    static CheckIDREFS mCheckIDREFS;
    static CheckENTITY mCheckENTITY;
    static CheckENTITIES mCheckENTITIES;
    static CheckNMTOKEN mCheckNMTOKEN;
    static CheckNMTOKENS mCheckNMTOKENS;
    static final String sAttributeOf = "' attribute of '";
    static final String sBadEnum = "' has undeclared value '";
    static final String sDeclarationOf = "' attribute default for '";
    static final String sDefaultShouldBeName = "' default value contains non-Name '";
    static final String sDefaultShouldBeNmtoken = "' default value contains non-NMtoken '";
    static final String sBadIdDefault = "' is of type ID but default is neither #REQUIRED nor #IMPLIED.";
    static final String sDuplicateID = "' is of type ID but its value is not unique.";
    static final String sShouldBeAName = "' should have a Name value, not '";
    static final String sShouldBeANmtoken = "' should have an Nmtoken value, not '";
    static final String sUndeclaredEntity = "' refers to nonexistent Entity'";
    static final String sUndeclaredNotation = "' contains invalid Notation name '";
    static boolean[] sIsNameC;
    static boolean[] sIsNameStart;
    static boolean[] sIsSpace;
    static final int sBeforeToken = 1;
    static final int sInToken = 2;
    static final int sAfterToken = 3;

    static boolean isSpace(char c) {
        return c < '\u0080' && sIsSpace[c];
    }

    static Vector parseList(String string) {
        int n = 1;
        int n2 = -1;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '(') break;
            ++n3;
        }
        ++n3;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            switch (n) {
                case 1: {
                    if (Attlist.isSpace(c)) break;
                    n2 = n3;
                    n = 2;
                    break;
                }
                case 2: {
                    if (c == '|') {
                        vector.addElement(string.substring(n2, n3));
                        n = 1;
                        break;
                    }
                    if (c == ')') {
                        vector.addElement(string.substring(n2, n3));
                        n = 3;
                        break;
                    }
                    if (!Attlist.isSpace(c)) break;
                    vector.addElement(string.substring(n2, n3));
                    n = 3;
                    break;
                }
                case 3: {
                    if (c != '|') break;
                    n = 1;
                }
            }
            ++n3;
        }
        if (n == 2) {
            vector.addElement(string.substring(n2, n3));
        }
        return vector;
    }

    static boolean isNmtoken(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '\u0080' ? !sIsNameC[c] : !CharClasses.isNameC(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean registerAttlist(Vector vector, DTD dTD, Entity entity, Handler handler, String string, Defaulter defaulter, Hashtable hashtable) {
        String string2 = (String)vector.elementAt(0);
        int n = vector.size() - 3;
        boolean bl = false;
        Object object = null;
        if (mCheckCDATA == null) {
            mCheckCDATA = new CheckCDATA();
            mCheckID = new CheckID(dTD);
            mCheckIDREF = new CheckIDREF(dTD);
            mCheckIDREFS = new CheckIDREFS(dTD);
            mCheckENTITY = new CheckENTITY(dTD);
            mCheckENTITIES = new CheckENTITIES(dTD);
            mCheckNMTOKEN = new CheckNMTOKEN();
            mCheckNMTOKENS = new CheckNMTOKENS();
        }
        String string3 = (String)vector.elementAt(n);
        String string4 = (String)vector.elementAt(n + 1);
        String string5 = vector.elementAt(n + 2) == null ? null : vector.elementAt(n + 2).toString();
        String string6 = string2 + '/' + string3;
        if (string4.equals("CDATA")) {
            hashtable.put(string6, mCheckCDATA);
        } else if (string4.equals("ID")) {
            hashtable.put(string6, mCheckID);
            if (string == null || string.equals("#FIXED")) {
                bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sBadIdDefault);
            }
        } else if (string4.equals("IDREF")) {
            hashtable.put(string6, mCheckIDREF);
            if (string5 != null) {
                Vector vector2 = dTD.IDREFVector();
                if (!Attlist.isName(string5)) {
                    bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeName + string5 + "'.");
                }
                vector2.addElement(string5);
                vector2.addElement(string3);
                object = Attlist.shutUpAndClone(entity, handler, entity);
                if (object == null) {
                    bl = true;
                }
                vector2.addElement(object);
                vector2.addElement(string2);
            }
        } else if (string4.equals("IDREFS")) {
            hashtable.put(string6, mCheckIDREFS);
            if (string5 != null) {
                Vector vector3 = dTD.IDREFVector();
                Vector vector4 = Attlist.tokenize(string5);
                int n2 = 0;
                while (n2 < vector4.size()) {
                    String string7 = (String)vector4.elementAt(n2);
                    if (!Attlist.isName(string7)) {
                        bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeName + string7 + "'.");
                    }
                    vector3.addElement(string7);
                    vector3.addElement(string3);
                    object = Attlist.shutUpAndClone(entity, handler, entity);
                    if (object == null) {
                        bl = true;
                    }
                    vector3.addElement(object);
                    vector3.addElement(string2);
                    ++n2;
                }
            }
        } else if (string4.equals("ENTITY")) {
            hashtable.put(string6, mCheckENTITY);
            if (string5 != null) {
                Vector vector5 = dTD.unparsedEntityVector();
                if (!Attlist.isName(string5)) {
                    bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeName + string5 + "'.");
                }
                vector5.addElement(string5);
                object = Attlist.shutUpAndClone(entity, handler, entity);
                if (object == null) {
                    bl = true;
                }
                vector5.addElement(object);
            }
        } else if (string4.equals("ENTITIES")) {
            hashtable.put(string6, mCheckENTITIES);
            if (string5 != null) {
                Vector vector6 = dTD.unparsedEntityVector();
                Vector vector7 = Attlist.tokenize(string5);
                int n3 = 0;
                while (n3 < vector7.size()) {
                    if (!Attlist.isName((String)vector7.elementAt(n3))) {
                        bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeName + vector7.elementAt(n3) + "'.");
                    }
                    vector6.addElement(vector7.elementAt(n3));
                    object = Attlist.shutUpAndClone(entity, handler, entity);
                    if (object == null) {
                        bl = true;
                    }
                    vector6.addElement(object);
                    ++n3;
                }
            }
        } else if (string4.equals("NMTOKEN")) {
            hashtable.put(string6, mCheckNMTOKEN);
            if (string5 != null && !Attlist.isNmtoken(string5)) {
                bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeNmtoken + string5 + "'.");
            }
        } else if (string4.equals("NMTOKENS")) {
            hashtable.put(string6, mCheckNMTOKENS);
            if (string5 != null) {
                Vector vector8 = Attlist.tokenize(string5);
                int n4 = 0;
                while (n4 < vector8.size()) {
                    if (!Attlist.isNmtoken((String)vector8.elementAt(n4))) {
                        bl = bl || handler.doValidityError(entity, "'" + string3 + sAttributeOf + string2 + sDefaultShouldBeName + vector8.elementAt(n4) + "'.");
                    }
                    ++n4;
                }
            }
        } else if (string4.startsWith("NOTATION")) {
            hashtable.put(string6, new CheckNOTATION(dTD, string4, string, string5, entity, handler));
        } else if (string4.charAt(0) == '(') {
            CheckENUMERATED checkENUMERATED = new CheckENUMERATED(string4);
            hashtable.put(string6, checkENUMERATED);
            if (string5 != null) {
                bl = checkENUMERATED.checkDefault(entity, string2, string5, handler);
            }
        }
        if (string != null && !bl) {
            if (string.equals("#REQUIRED")) {
                defaulter.addRequired(string3);
            } else if (string.equals("#FIXED")) {
                defaulter.addFixed(string3, string5);
            }
        }
        return bl;
    }

    public static Object shutUpAndClone(Object object, Handler handler, Entity entity) {
        Object object2 = null;
        try {
            object2 = object.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            handler.doValidityError(entity, "Cloning botch!?!?!?");
            object2 = null;
        }
        return object2;
    }

    static {
        sIsNameC = new boolean[128];
        sIsNameStart = new boolean[128];
        sIsSpace = new boolean[128];
        int n = 0;
        do {
            Attlist.sIsSpace[n] = false;
            Attlist.sIsNameStart[n] = false;
            Attlist.sIsNameC[n] = false;
        } while (++n < 128);
        n = 97;
        do {
            Attlist.sIsNameStart[n] = true;
            Attlist.sIsNameC[n] = true;
        } while (++n <= 122);
        n = 65;
        do {
            Attlist.sIsNameStart[n] = true;
            Attlist.sIsNameC[n] = true;
        } while (++n <= 90);
        n = 48;
        do {
            Attlist.sIsNameC[n] = true;
        } while (++n <= 57);
        Attlist.sIsNameC[58] = true;
        Attlist.sIsNameStart[58] = true;
        Attlist.sIsNameC[45] = true;
        Attlist.sIsNameStart[45] = true;
        Attlist.sIsNameC[45] = true;
        Attlist.sIsNameC[46] = true;
        Attlist.sIsSpace[13] = true;
        Attlist.sIsSpace[10] = true;
        Attlist.sIsSpace[9] = true;
        Attlist.sIsSpace[32] = true;
    }

    static void dump(Vector vector, String string) {
        int n = (vector.size() - 1) / 3;
        System.out.println("AL: " + vector.elementAt(0) + " (" + vector.size() + ")");
        int n2 = 0;
        while (n2 < n) {
            int n3 = 1 + 3 * n2;
            System.out.println("  [" + vector.elementAt(n3) + "] [" + vector.elementAt(n3 + 1) + "] [" + vector.elementAt(n3 + 2) + "]");
            ++n2;
        }
        System.out.println(" DefaultKW: " + string);
    }

    static Vector tokenize(String string) {
        int n = 1;
        int n2 = -1;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (n == 1) {
                if (!Attlist.isSpace(c)) {
                    n2 = n3;
                    n = 2;
                }
            } else if (Attlist.isSpace(c)) {
                vector.addElement(string.substring(n2, n3));
                n = 1;
            }
            ++n3;
        }
        if (n == 2) {
            vector.addElement(string.substring(n2));
        }
        return vector;
    }

    public boolean check(Entity entity, Element element, String string, Handler handler) {
        return false;
    }

    static boolean isName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c < '\u0080' ? !sIsNameStart[c] : !CharClasses.isNameStart(c)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (c < '\u0080' ? !sIsNameC[c] : !CharClasses.isNameC(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

