/*
 * Decompiled with CFR 0.152.
 */
package textuality.lark;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import textuality.lark.Segment;

public class XmlInputStream
extends BufferedInputStream {
    static final int sISOLatin1V = 1;
    static final int sNativeFEFFV = 2;
    static final int sNativeFFFEV = 3;
    static final int sFirstBytesV = 4;
    static final int sJustCharsV = 5;
    static final int sUTF8V = 6;
    static final int s2power6 = 64;
    static final int s2power12 = 4096;
    static final int s2power18 = 262144;
    static final int s2power24 = 0x1000000;
    static final int s2power30 = 0x40000000;
    static byte[] sJunkBytes = new byte[]{0, 0};
    static ByteArrayInputStream sJunkBA = new ByteArrayInputStream(sJunkBytes);
    static String sBotchedEncPI = "Broken Encoding Declaration in initial PI";
    static String sCantDo = "Can't process encoding: '";
    static String sNativeNoBOM = "Native (UCS-2 or UTF-16) encoding needs Byte Order Mark";
    int mInputEncoding = 1;
    int mCharBufInd;
    int mFirstBytesRead;
    char[] mCharBuf;
    int mLowUTF16Waiting;
    int mEncodingWillBe = -1;

    private void testStream() throws Exception {
        this.mCharBuf = new char[256];
        this.mCharBuf[0] = (char)super.read();
        this.mCharBuf[1] = (char)super.read();
        if (this.mCharBuf[0] == '\u00ff' && this.mCharBuf[1] == '\u00fe') {
            this.mInputEncoding = 3;
            return;
        }
        if (this.mCharBuf[0] == '\u00fe' && this.mCharBuf[1] == '\u00ff') {
            this.mInputEncoding = 2;
            return;
        }
        this.mEncodingWillBe = 1;
        int n = 2;
        this.mFirstBytesRead = 2;
        this.mInputEncoding = 4;
        if (this.mCharBuf[0] != '<' || this.mCharBuf[1] != '?') {
            return;
        }
        do {
            this.mCharBuf[n++] = (char)super.read();
        } while (this.mCharBuf[n - 2] != '?' || this.mCharBuf[n - 1] != '>');
        this.mFirstBytesRead = n;
        String string = new String(this.mCharBuf, 0, n);
        if (string.indexOf("<?xml") != 0) {
            return;
        }
        int n2 = string.indexOf("encoding");
        if (n2 == -1) {
            return;
        }
        n2 += 8;
        while (Segment.isSpaceChar(this.mCharBuf[n2]) && n2 < n) {
            ++n2;
        }
        if (n2 == n || this.mCharBuf[n2] != '=') {
            throw new Exception(sBotchedEncPI);
        }
        ++n2;
        while (Segment.isSpaceChar(this.mCharBuf[n2]) && n2 < n) {
            ++n2;
        }
        if (n2 == n) {
            throw new Exception(sBotchedEncPI);
        }
        if (this.mCharBuf[n2] != '\"' && this.mCharBuf[n2] != '\'') {
            throw new Exception(sBotchedEncPI);
        }
        char c = this.mCharBuf[n2];
        int n3 = ++n2;
        while (n3 < n && this.mCharBuf[n3] != c) {
            ++n3;
        }
        if (n3 == n) {
            throw new IOException(sBotchedEncPI);
        }
        string = new String(this.mCharBuf, n2, n3 - 1);
        if ((string = string.toUpperCase()).indexOf("UTF-16") != -1 || string.indexOf("UTF16") != -1 || string.indexOf("UCS-2") != -1 || string.indexOf("UCS2") != -1) {
            throw new Exception(sNativeNoBOM);
        }
        if (string.indexOf("UTF-8") != -1 || string.indexOf("UTF8") != -1) {
            this.mEncodingWillBe = 6;
            return;
        }
        if (string.indexOf("LATIN1") != -1 || string.indexOf("LATIN-1") != -1 || string.indexOf("ASCII") != -1) {
            return;
        }
        throw new Exception(sCantDo + string + "'");
    }

    public String encoding() {
        int n = this.mInputEncoding == 4 ? this.mEncodingWillBe : this.mInputEncoding;
        switch (n) {
            case 1: {
                return "ISOLatin1";
            }
            case 2: {
                return "Native";
            }
            case 3: {
                return "Native";
            }
            case 5: {
                return "Native";
            }
            case 6: {
                return "UTF-8";
            }
        }
        return "ISOLatin1";
    }

    public XmlInputStream(InputStream inputStream) throws IOException, Exception {
        super(inputStream);
        this.testStream();
    }

    public XmlInputStream(char[] cArray) {
        super(sJunkBA);
        this.mInputEncoding = 5;
        this.mCharBuf = cArray;
    }

    public int getXmlChar() throws IOException {
        switch (this.mInputEncoding) {
            case 1: {
                if (this.count > 0 && this.pos < this.count) {
                    int n;
                    if ((n = this.buf[this.pos++]) < 0) {
                        n = 128 + (n & 0x7F);
                    }
                    return n;
                }
                return this.read();
            }
            case 2: {
                int n;
                int n2;
                if (this.count > 0 && this.pos < this.count) {
                    if ((n2 = this.buf[this.pos++]) < 0) {
                        n2 = 128 + (n2 & 0x7F);
                    }
                } else {
                    n2 = this.read();
                }
                if (this.count > 0 && this.pos < this.count) {
                    if ((n = this.buf[this.pos++]) < 0) {
                        n = 128 + (n & 0x7F);
                    }
                } else {
                    n = this.read();
                }
                return n2 << 8 | n;
            }
            case 3: {
                int n;
                int n3;
                if (this.count > 0 && this.pos < this.count) {
                    if ((n3 = this.buf[this.pos++]) < 0) {
                        n3 = 128 + (n3 & 0x7F);
                    }
                } else {
                    n3 = this.read();
                }
                if (this.count > 0 && this.pos < this.count) {
                    if ((n = this.buf[this.pos++]) < 0) {
                        n = 128 + (n & 0x7F);
                    }
                } else {
                    n = this.read();
                }
                return n << 8 | n3;
            }
            case 4: {
                if (this.mCharBufInd == this.mFirstBytesRead) {
                    this.mInputEncoding = this.mEncodingWillBe;
                    return this.getXmlChar();
                }
                return this.mCharBuf[this.mCharBufInd++];
            }
            case 5: {
                if (this.mCharBufInd == this.mCharBuf.length) {
                    return -1;
                }
                return this.mCharBuf[this.mCharBufInd++];
            }
            case 6: {
                int n;
                if (this.mLowUTF16Waiting != 0) {
                    int n4 = this.mLowUTF16Waiting;
                    this.mLowUTF16Waiting = 0;
                    return n4;
                }
                if (this.count > 0 && this.pos < this.count) {
                    if ((n = this.buf[this.pos++]) < 0) {
                        n = 128 + (n & 0x7F);
                    }
                } else {
                    n = this.read();
                }
                if (n < 192) {
                    return n;
                }
                if (n < 224) {
                    int n5 = n;
                    int n6 = this.read();
                    return (n5 - 192) * 64 + (n6 - 128);
                }
                if (n < 240) {
                    int n7 = n;
                    int n8 = this.read();
                    int n9 = this.read();
                    return (n7 - 224) * 4096 + (n8 - 128) * 64 + (n9 - 128);
                }
                int n10 = 0;
                if (n < 248) {
                    int n11 = n;
                    int n12 = this.read();
                    int n13 = this.read();
                    int n14 = this.read();
                    n10 = (n11 - 240) * 262144 + (n12 - 128) * 4096 + (n13 - 128) * 64 + (n14 - 128);
                } else if (n < 252) {
                    int n15 = n;
                    int n16 = this.read();
                    int n17 = this.read();
                    int n18 = this.read();
                    int n19 = this.read();
                    n10 = (n15 - 248) * 0x1000000 + (n16 - 128) * 262144 + (n17 - 128) * 4096 + (n18 - 128) * 64 + (n19 - 128);
                } else {
                    int n20 = n;
                    int n21 = this.read();
                    int n22 = this.read();
                    int n23 = this.read();
                    int n24 = this.read();
                    int n25 = this.read();
                    n10 = (n20 - 252) * 0x40000000 + (n21 - 128) * 0x1000000 + (n22 - 128) * 262144 + (n23 - 128) * 4096 + (n24 - 128) * 64 + (n25 - 128);
                }
                int n26 = n10 >> 16;
                if (n10 >> 16 > 16) {
                    throw new IOException("UTF8 encodes non-Unicode character");
                }
                n10 &= 0xFFFF;
                this.mLowUTF16Waiting = (n10 |= --n26 << 16) & 0xDFFF;
                return n10 >> 10 & 0xDBFF;
            }
        }
        throw new IOException("Bogus Input Encoding in getXmlChar()");
    }
}

