/*
 * Decompiled with CFR 0.152.
 */
package textuality.lark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import textuality.lark.Attribute;
import textuality.lark.CharClasses;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.lark.Namer;
import textuality.lark.Segment;
import textuality.lark.Text;
import textuality.lark.XmlInputStream;

public class Lark {
    static final byte CharRefV = 1;
    static final byte ColdStartV = 2;
    static final byte DeclareNotationV = 3;
    static final byte DeclareUnparsedV = 4;
    static final byte DebugV = 5;
    static final byte DoANYV = 6;
    static final byte DoEMPTYV = 7;
    static final byte DoMixedV = 8;
    static final byte EndAttrValV = 9;
    static final byte EndAttributeV = 10;
    static final byte EndDTDV = 11;
    static final byte EndGIV = 12;
    static final byte EndSaveV = 13;
    static final byte EnterAttrValV = 14;
    static final byte EnterEntValV = 15;
    static final byte EnterIgnoredMSV = 16;
    static final byte EnterIncludedMSV = 17;
    static final byte FloatingMSEV = 18;
    static final byte GotXMLDV = 19;
    static final byte HashRefV = 20;
    static final byte HotStartV = 21;
    static final byte InKWV = 22;
    static final byte KeywordV = 23;
    static final byte LeaveMarkedSectV = 24;
    static final byte MarkAmpV = 25;
    static final byte MarkConnectorV = 26;
    static final byte MarkLtV = 27;
    static final byte MarkPCV = 28;
    static final byte MarkPcAtTopLevelV = 29;
    static final byte MarkRepV = 30;
    static final byte PopV = 31;
    static final byte PopCPV = 32;
    static final byte PushV = 33;
    static final byte ReportAttDeclV = 34;
    static final byte ReportAttlistV = 35;
    static final byte ReportDefKWV = 36;
    static final byte ReportDoctypeV = 37;
    static final byte ReportETagV = 38;
    static final byte ReportInternalEntityV = 39;
    static final byte ReportPIV = 40;
    static final byte ReportReferenceV = 41;
    static final byte ReportSTagV = 42;
    static final byte ReportEmptyV = 43;
    static final byte ReportSystemTextEntityV = 44;
    static final byte ReportTextV = 45;
    static final byte SaveExtraV = 46;
    static final byte SignalPEV = 47;
    static final byte StartCMV = 48;
    static final byte StartCPV = 49;
    static final byte StuffCharV = 50;
    static final String sOCT;
    static final String sOCSI;
    static final String sST;
    static final String sSI;
    static final String sNST;
    static final String sNSI;
    static final String sNCT;
    static final String sNCI;
    static final String sHT = "\ub8b8";
    static final String sHI = "\u0000";
    static final String sPub = "\u2525\u2626";
    static final String sPubI = "\u0000";
    static final String sEN = "\ud7d7\ud8d8";
    static final String sENI = "\u0000";
    static final String sDT;
    static final String sDS;
    static final byte[][] sSL;
    static final String[] sErrorMessages;
    static final String[] sKW;
    static final byte[] sFB;
    static final String sLarkMajorVersion = "1";
    static final String sLarkMinorVersion = "0 final beta";
    static final String sCopyright = "Copyright (c) 1997-98 Tim Bray.\n All rights reserved; the right to use these class files for any purpose\n is hereby granted to everyone.";
    static final int sScratchAttCount = 20;
    static short[][] sD;
    static final String sNullString;
    static char[] sOS;
    static final int sTextBufSize = 512;
    static final char[] sS;
    static short sStateMask;
    static short sSpecialMask;
    static byte sSpecialShift;
    static byte sMaxDigitsInHexCRef;
    static final String sBadNest = "Encountered ";
    static final String sBadParenInCM = "Too many )'s in content-model.";
    static final String sBadRefEnd = "Entity ended in middle of markup.";
    static final String sBustedKW = "Error trying to match keyword ";
    static final String sCantGetURL = "Can't fetch external entity: ";
    static final String sCaseBotch = "Start/End tags differ only in case: ";
    static final String sDupeAttributeName = "Duplicate attribute name: ";
    static final String sEntityNesting = "Element does not end in the same entity that it started in.";
    static final String sExpected = " expected ";
    static final String sExtRefInAttr = "External entity reference in attribute value: &";
    static final String sFloatingMSE = "Stray ]]>.";
    static final String sGenEnd = "\n ...assumed ";
    static final String sHexCRefTooLong = "Too many digits in &#X... reference.";
    static final String sIllegalCharacter = "Non-Unicode character";
    static final String sLTInAttrVal = "Less-than in attribute value.";
    static final String sMaybeExternal = " - maybe declared externally?";
    static final String sMSinSubset = "INCLUDE/IGNORE section in internal DTD subset.";
    static final String sNonNameChar = "Invalid character in name";
    static final String sNoRoot = "No root element.";
    static final String sNoSuchEntity = "Undeclared entity '";
    static final String sNoTopLevelPE = "PE in internal subset not at top level.";
    static final String sNotOpened = " with no start-tag.";
    static final String sPEwithNDATA = " NDATA keyword in parameter entity declaration.";
    static final String sPITargetXML = "PI target cannot match 'xml'.";
    static final String sPrematureEOF = "End of document entitity before end of root element.";
    static final String sRecursiveRef = "Recursive entity reference.";
    static final String sRottenURL = "Can't parse external URL: [";
    static final String sTagsPastRoot = "Encountered start-tag after end of root element.";
    static final byte[] sCharClasses;
    static final byte sNameCMask = 1;
    static final byte sNameStartMask = 2;
    static boolean[] sIsChar;
    int mStateBeforeDTD;
    static final int sDTDState = 48;
    static final int sAfterDocState = 179;
    static final int sDoneElementContentState = 127;
    static final int sInDocState = 176;
    static final int sDQAValState = 174;
    static final int sSQAValState = 172;
    Namer mANames = new Namer(false);
    Namer mElNames = new Namer(true);
    Namer mEntNames = new Namer(false);
    String mDocumentName = "(Document Entity)";
    boolean mBuildTree;
    boolean mBuilding;
    boolean mSawRoot;
    boolean mProcessExternalEntities;
    boolean mPEDecl;
    boolean mInEntityVal;
    boolean mWFError;
    boolean mRefIsToPE;
    boolean mInExternalDecls;
    boolean mBypassedExternalDecls;
    int mMarkedSectionDepth;
    int mIgnoredSection = -1;
    int mKeyword;
    int mKeywordPos;
    char[] mCharBuf = new char[512];
    int mSavedCharCount;
    boolean mSaving;
    int mThreshold = 511;
    byte[] mDocEntityBuffer;
    Stack mStack = new Stack();
    Hashtable mEmpty;
    Hashtable mInternalEntities = new Hashtable(100, 10.0f);
    Hashtable mExternalTextEntities = new Hashtable(100, 10.0f);
    Hashtable mInternalPEs = new Hashtable(100, 10.0f);
    Hashtable mExternalPEs = new Hashtable(100, 10.0f);
    Entity mCurrentEntity;
    int mInputCharCount;
    int mInputLineCount = 1;
    int mLineOffset;
    int[] mPushedState = new int[20];
    int mStateStackInd;
    Vector mSaved = new Vector(20);
    int mSavedStringCount;
    boolean mSaveText;
    Text mCurrentAttrVal;
    Attribute[][] mScratchAttrs = new Attribute[20][];
    int mState;
    Element mCurrentElement;
    int mLastLtOffset;
    int mLastAmpOffset;
    int mLastTextOffset;

    private void rememberDefaults(Vector vector, int n) {
        int n2;
        int n3 = 0;
        String string = (String)this.mSaved.elementAt(0);
        Attribute[] attributeArray = this.mElNames.getDefaults(string);
        boolean[] blArray = new boolean[(n - 1) / 3];
        int n4 = 1;
        while (n4 < n) {
            int n5 = (n4 - 1) / 3;
            blArray[n5] = false;
            if (this.mSaved.elementAt(n4 + 2) != null) {
                ++n3;
                blArray[n5] = true;
                if (attributeArray != null) {
                    n2 = 0;
                    while (n2 < attributeArray.length) {
                        if (this.mSaved.elementAt(n4) == attributeArray[n2].name()) {
                            --n3;
                            blArray[n5] = false;
                        }
                        ++n2;
                    }
                }
            }
            n4 += 3;
        }
        if (attributeArray != null) {
            n3 += attributeArray.length;
        }
        Attribute[] attributeArray2 = new Attribute[n3];
        n2 = 0;
        n4 = 1;
        while (n4 < n) {
            if (blArray[(n4 - 1) / 3]) {
                attributeArray2[n2++] = new Attribute((String)this.mSaved.elementAt(n4), (Text)this.mSaved.elementAt(n4 + 2));
            }
            n4 += 3;
        }
        if (attributeArray != null) {
            n4 = 0;
            while (n4 < attributeArray.length) {
                attributeArray2[n2++] = attributeArray[n4];
                ++n4;
            }
        }
        this.mElNames.updateDefaults(string, attributeArray2);
    }

    private void clearSaved() {
        this.mSaved.removeAllElements();
        this.mSavedStringCount = 0;
    }

    public String toString() {
        return "Lark V" + sLarkMajorVersion + "." + sLarkMinorVersion + " " + sCopyright;
    }

    public void buildTree(boolean bl) {
        this.mBuildTree = bl;
    }

    public void processExternalEntities(boolean bl) {
        this.mProcessExternalEntities = bl;
    }

    private boolean complain(Handler handler, String string, int n) {
        this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
        this.signalWFError();
        return handler.doSyntaxError(this.mCurrentEntity, string, n);
    }

    private void signalWFError() {
        this.mWFError = true;
    }

    static {
        int n;
        sOCT = "<\u0101\u2108\u013f\ucb02\u3e03\u033c\u0504\u3c06\u0521" + "\u0805\u3f0c\u0621\u0906\u3f0c\u0721\u0a07\u2fa3\u073f\u0c08" + "\u2d13\u0844\u0b09\u2d13\u0a2d\u120a\u5b1a\u0d3f\u100e\u3f11" + "\u0f3f\u1110\u3eb0\u113e\ub011\u3f11\u122d\u1413\u2d15\u142d" + "\u1615\u2d17\u162d\u1817\u2d19\u183e\ub019\u3eb0\u1a43\u0b1b" + "\u5b1c\u1c5d\u1d1d\u5d1e\u1e3e\ub01e\u5d1e\u213e\u0421\u5022" + "\u2153\u2a21\u5b30\u2255\u0b24\u2226\u2425\u3324\u2725\u2527" + "\ub026\u22b0\u2822\u2e28\u2533\u2827\u2d2a\u590b\u2c22\u2e2c" + "\u2533\u2c27\u2d2d\u27b0\u2e22\ub02f\u3e04\u2f5b\u3030\u2533" + "\u303c\u3630\u5d31\u313e\u0431\u5d32\u323e\u3034\u3bb0\u353e" + "\u0436\u2137\u363f\u0c37\u2d48\u3741\u0b37\u4578\u374e\u0b37" + "\u5b44\u3b50\u0b3b\u530b\u3d22\u263d\u2725\u3e3e\u303f\u222e" + "\u3f27\u2d3f\u3e30\u4122\u2e41\u272d\u423e\u3043\u3e30\u4425" + "\u3344\u4945\u4547\u0b45\u4e0b\u465b\u3047\u5b30\u482d\u4949" + "\u2d4a\u4a2d\u4b4b\u3e30\u4d25\u334f\u2533\u4f3e\u3051\u2533" + "\u5128\u5251\u430b\u5145\u5951\u4962\u514e\u6852\u2533\u5329" + "\u5753\u7c55\u5425\u3354\u2957\u547c\u5555\u2533\u5629\u5756" + "\u7c55\u594e\u5a5a\u545b\u5b49\u5c5c\u545d\u5d49\u5f5d\u595e" + "\u5f45\u6060\u5361\u6244\u6363\u5264\u6445\u6565\u4666\u6653" + "\u6768\u4d0b\u684f\u0b6a\u2533\u6a28\u6b6b\u2533\u6c29\u726c" + "\u7c6e\u6d25\u336d\u2972\u6d7c\u6e6e\u2533\u6f29\u726f\u7c6e" + "\u7053\u7172\u22af\u7223\u7372\u2533\u7227\uad73\u460b\u7349" + "\u0b73\u520b\u743e\u3075\u3e30\u7722\uaf77\u2533\u7727\uad78" + "\u4c0b\u784e\u0b7a\u2533\u7b25\u337b\u287e\u7b41\u0b7b\u450b" + "\u7c3e\u307d\u3e30\u7e23\u0b7e\u2533\u7e28\u817f\u2a80\u7f2b" + "\u807f\u3e30\u7f3f\u8080\u2533\u803e\u3081\u2533\u8128\u8182" + "\u2930\u822a\u8482\u2b84\u822c\u8582\u3f84\u827c\u8983\u2930" + "\u832a\u8483\u2b84\u832c\u8583\u3f84\u837c\u8984\u2533\u8429" + "\u3084\u2c85\u847c\u8985\u2533\u8528\u8186\u2930\u862a\u8886" + "\u2b88\u862c\u8586\u3f88\u8729\u3087\u2a88\u872b\u8887\u2c85" + "\u873f\u8888\u2533\u8829\u3088\u2c85\u8925\u3389\u2881\u8a29" + "\u308a\u2a8c\u8a2b\u8c8a\u3f8c\u8a7c\u898b\u2930\u8b2a\u8c8b" + "\u2b8c\u8b3f\u8c8b\u7c89\u8c25\u338c\u2930\u8c7c\u898d\u2533" + "\u8d29\u938d\u7c8e\u8e25\u338f\u2991\u8f7c\u8e90\u2533\u9029" + "\u9190\u7c8e\u912a\u9292\u2533\u923e\u3093\u2a92\u933e\u3095" + "\u2596\u9725\u3399\u229a\u9925\u3399\u279b\u9950\u2299\u532a" + "\u9a22\ub09a\u2533\u9a26\ub69b\u2533\u9b26\ub69b\u27b0\u9c25" + "\u339c\u3e30\u9d3e\u309e\u2533\u9e3e\u309e\u4e0b\ua025\u33a1" + "\u3e30\ua23e\u30a4\u3eb0\ua53e\ub0a6\u2fa7\ua63e\ub0a7\u3eb0" + "\ua82f\ua7a8\u3eb0\ua93d\uabaa\u3dab\uab22\uaeab\u27ac\uac26" + "\ub6ac\u27b0\uac3c\uacad\u26b6\uad27\ub0ae\u22b0\uae26\ub6ae" + "\u3cae\uaf22\ub0af\u26b6\ub026\ub6b0\u3c07\ub05d\ub1b1\u26b6" + "\ub13c\u07b1\u5db2\ub226\ub6b2\u3c07\ub23e\ub0b2\u5db2\ub33c" + "\ub4b4\u21b5\ub43f\u0cb5\u2d12\ub623\ub7b6\u61c3\ub667\ubbb6" + "\u6cbd\ub671\ubfb7\u30b7\ub731\ub7b7\u32b7\ub733\ub7b7\u34b7" + "\ub735\ub7b7\u36b7\ub737\ub7b7\u38b7\ub739\ub7b7\u3bb0\ub778" + "\ub8b8\u3bb0\ub93b\ub0ba\u3bb0\ubb74\ubcbc\u3bb0\ubd74\ubebe" + "\u3bb0\ubf75\uc0c0\u6fc1\uc174\uc2c2\u3bb0\uc36d\uc7c3\u70c4" + "\uc46f\uc5c5\u73c6\uc63b\ub0c7\u70c8\uc83b\ub0c9\u3eb0\uca3e" + "\u30cb\u78cc\ucc3f\u10cc\u6dcd\ucd3f\u10cd\u6cce\ucf76\u0bd0" + "\u3dd1\ud122\u0bd1\u270b\ud23f\ue2d3\u3fe2\ud365\u0bd3\u730b" + "\ud43d\ud6d5\u3dd6\ud622\ud8d6\u27d7\ud727\ud9d8\u22d9\ud93f" + "\ue2da\u3fe2\uda73\u0bdb\u3ddd\udc3d\udddd\u22df\udd27\udede" + "\u6e0b\ude79\u0bdf\u6e0b\udf79\u0be0\u3fe2\ue13f\ue2e2\u3eb0";
        sOCSI = "\u0100\u0200\u0101\u0002\u0003\u0000\u0405\u0607\u0800\u090a" + "\u000b\u0b00\u0000\u0000\u0000\u0c0d\u0e0f\u1000\u1112\u1314" + "\u1415\u1617\u1817\u1919\u1a1b\u1a1c\u1a1d\u1a19\u1915\u151e" + "\u0100\u1300\u1f20\u1300\u2100\u2200\u2300\u2425\u2626\u2728" + "\u2827\u2828\u2727\u2900\u2a2b\u2c2d\u0000\u0000\u2e2f\u3031" + "\u0a32\u0a0a\u0a33\u0900\u34095\u0900\u0000\u0000\u0000" + "\u0000\u0000\u00006\u37389\u0900\u3a09;\u0900" + "<\u0f3d\u3c3e\u3f40\u4141\u3c42\u3c43\u4445\u4600\u4748" + "\u494a\u4b4c\u4d4e\u4e00\u4e4fP\u5152\u5353\u5453\u5455" + "\u4e4e\u564e\u5657\u5556\u5658\u5952\u5353\u5a53\u554e\u4e00" + "\u4e5b\u5500\u5c5d\u5253\u5353\u5a55\u4e4e\u4e00\u5e55_" + "\u0000\u605a\u5a61\u0000\u6263b\u6200\u6465\u6665\u6767" + "\u1968\u696a\u6b19\u6c6d\u6e6f\u6e70\u7172\u7273\u745a\u7576" + "w\u7800\u7979\u7a7b\u017a\u7c7b\u7d01\u7c7d\u7e7f~" + "\u7f00\u7e7f\u8000\u0000\u8182\u0000\u0000\u0000\u0000\u0000" + "\u0000\u0000\u0083\u0083\u0c20\u0084\u0085\u0000\u0086\u0000" + "\u0000\u8700\u880f\u0000\u0900\u0900\u8900\u8a8b\u0000\u8c8d" + "\u0900\u0f0f\u0909\u0000\u8e09\u000f\u0f8f\u9091\u9209\u0093";
        sST = "\u0003\u0303\u0404\u0d0e\u0e0e\u1f1f\u20b0\u2121\u2324\u2424" + "\u2728\u2828\u2b2c\u2c2c\u2f2f\u3030\u3135\u3535\u3839\u3939" + "\u3a3b\u3b3b\u3c3d\u3e3f\u4041\u4243\u4444\u4646\u4747\u4c4d" + "\u4d4d\u4e4f\u4f4f\u5051\u5151\u5252\u5354\u5454\u5555\u5654" + "\u5772\u5872\u5e72\u6172\u6372\u6672\u6772\u696a\u6a6a\u6b6b" + "\u6c6d\u6d6d\u6e6e\u6f6d\u7072\u7172\u7272\u744f\u754f\u7677" + "\u7777\u797a\u7a7a\u7b7b\u7c7c\u7d7d\u7e7e\u7f80\u8080\u8181" + "\u8284\u8384\u8484\u8585\u8688\u8788\u8888\u8989\u8a8c\u8b8c" + "\u8c8c\u8d8d\u8e8e\u8f90\u9090\u9292\u9392\u9495\u9595\u9697" + "\u9797\u9899\u9999\u9c9c\u9d9e\u9e9e\u9fa0\ua0a0\ua1a2\ua2a2" + "\ua4a5\ua5a5\ua6a8\ua8a8\ua9aa\uaaaa\uabab\ub3b3\ucc0e\ucd0e" + "\ucecf\ucfcf\ud0d0\ud1d1\ud2d3\ud3d3\ud4d5\ud5d5\ud6d6\ud9da" + "\udada\udbdc\udcdc\udddd\ue0e1\ue1e1";
        sSI = "\u0000\t\u0000\u9400\u0000\u0000\u0000\u0000\u0000\u0000" + "\u0900\u0000\u0900\u0000\u0000\tx\u0000\u0000\u0000" + "\t\u0909\u0909\u0900\u0000\u0000\u0000\u0909\u0095\u9596" + "\u0000\u0000\u0000\u0000\u0000\u5a00\u0000\u5a00\u0000\u5a00" + "\u0000Z\u0000\u6200\u0097\t\u0000\u0000\u0000\u0000" + "\u5a00\u5a00\u7800\u0000\u0909\u0900\u0000\u0000\u0900\u0000" + "\t\u0000\u0900";
        sNST = "\u01a6\u05a6\u06a6\u07a6\u0c0d\u1f20\u3334\u393a\u4d4e\u4f50" + "\u6b6c\u6e6f\u7a20\u8586\u898a\u8e8f\u9598\u9633\u9798\ua0a1" + "\ua3a4\ua8a9\ub6ba\ucb0d";
        sNSI = "\u0a0a\u0a0a\u0098\n\u0a0a\u0000\u990a\u0a0a\u0a9a\u0a0a" + "\u0a0a\u0000";
        sNCT = "\u0d0d\u2020\u3434\u3a3a\u4e4e\u5050\u5253\u5353\u5556\u5656" + "\u6c6c\u6f6f\u7e82\u8182\u8282\u8686\u8a8a\u8f8f\u9898\ua1a1" + "\ua4a4\ua6a6\ua9a9\ubaba\ubbba\ubcba\ubdba\ubeba\ubfba\uc0ba" + "\uc1ba\uc2ba\uc3ba\uc4ba\uc5ba\uc6ba\uc7ba\uc8ba\ucc0d\ucd0d" + "\uce0d";
        sNCI = "\u0000\u0000\u0000\u0000\u0000\u0000\u9b0a\u0000\u0000\u0000" + "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + "\u0000";
        sDT = "\u0202\u0b0b\u0e0f\u0f0f\u110f\u1414\u1515\u1614\u1715\u1c1c" + "\u1d1c\u1e1c\u29b0\u2d2d\u2e2e\u4949\u4a49\u9a9a\u9b9b\uacac" + "\uadad\uaeae\uafaf\ub0b0\ub1b0\ub2b0\ub9b9\uc9c9\ucaca";
        sDS = "\u009c\u0a00\u0000\u0000\u0000\u9d9e\u9f00\u0000\u0000\u0000" + "\u0000\u0000\u0000\u0000\u0000";
        sSL = new byte[][]{{0}, {27}, {2, 33, -124}, {2, 33, -123}, {2, 33, 49}, {33, -124}, {23, 0, -96, 1}, {33, -123}, {33, 49}, {13}, {21}, {31, 40}, {31, 2}, {31}, {23, 1, -100, 1}, {2}, {45}, {45, 2}, {46, 1, 93, 45}, {11}, {33, -80}, {37}, {23, 2, -92, 2}, {2, 33, -88}, {28, 2, 33, -91}, {31, 13}, {2, 33, -86}, {28, 2, 33, -87}, {23, 3, -84, 2}, {28, 2, 33, -83}, {29, 2, 33, -79}, {24}, {31, 41}, {2, 33, -79}, {23, 5, -51, 1}, {23, 4, -71, 1}, {23, 7, -67, 1}, {23, 6, -63, 1}, {2, 33, -65}, {3}, {2, 33, -61}, {28, 2, 33, -59}, {23, 9, -56, 2}, {23, 8, -57, 2}, {17}, {16}, {28, 2, 33, -50}, {28, 2, 33, -48}, {35}, {28, 2, 33, -46}, {21, 23, 10, -39, 1}, {28, 2, 33, -45}, {28, 2, 33, -43}, {28, 2, 33, -42}, {23, 12, -15, 2}, {23, 11, -22, 2}, {28, 2, 33, -21}, {28, 2, 33, -20}, {28, 2, 33, -18}, {28, 2, 33, -17}, {2, 14, 33, -48}, {28, 2, 33, -13}, {23, 15, -9, 1}, {23, 14, -10, 1}, {23, 13, -11, 1}, {36, 34, 35}, {28, 2, 33, -8}, {23, 17, -6, 2}, {23, 16, 21, 2}, {28, 2, 33, -5}, {28, 2, 33, -4}, {23, 19, -2, 1}, {23, 18, -3, 1}, {7}, {6}, {23, 20, 14, 0}, {28, 2, 33, -1}, {48, 49, 33, 4}, {30}, {28, 2, 33, 1}, {28, 2, 33, 2}, {49, 33, 4}, {12, 32}, {12, 30}, {12, 26}, {32}, {26}, {28, 2, 33, 5}, {28, 2, 33, 6}, {49, 33, 8}, {12}, {28, 2, 33, 9}, {28, 2, 33, 10}, {49, 33, 12}, {28, 2, 33, 13}, {28, 2, 33, 14}, {28, 2, 33, 15}, {28, 2, 33, 17}, {8}, {28, 2, 33, 19}, {28, 2, 33, 24}, {2, 15, 33, 29}, {28, 2, 33, 26}, {33, 30}, {28, 2, 33, 27}, {25, 33, 27}, {28, 2, 33, 28}, {25, 33, 28}, {28, 2, 33, 29}, {39}, {44}, {28, 2, 33, 31}, {23, 21, 32, 1}, {28, 2, 33, 33}, {13, 4}, {12, 38}, {38}, {12, 42}, {43}, {42}, {10}, {2, 14, 33, 41}, {45, 25, 2, 33, 45}, {31, 9}, {31, 9, 34}, {45, 25, 2, 33, 47}, {45, 25, 2, 33, 49}, {45, 27}, {18}, {2, 33, 52}, {33, 52}, {31, 20}, {31, 1, 62}, {31, 1, 60}, {31, 1, 34}, {31, 1, 39}, {31, 1, 38}, {23, 22, 81, 1}, {23, 24, 83, 1}, {23, 23, 83, 1}, {21, 23, 25, 85, 1}, {21, 23, 26, 92, 1}, {21, 23, 27, 92, 1}, {23, 29, 97, 2}, {23, 28, 97, 2}, {21, 23, 31, 97, 2}, {21, 23, 30, 97, 2}, {31, 19}, {31, 12}, {36, 34}, {36}, {47}, {21, 33, -94}, {21, 33, -4}, {28, 21, 33, 22}, {21, 48}, {22}, {46, 1, 93}, {46, 2, 93, 93}, {31, 50}};
        sErrorMessages = new String[]{"in prolog", "", "", "", "after DTD", "after <", "", "", "after <!", "", "", "", "in processing instruction", "", "", "", "", "", "after <!-", "", "in comment", "in comment", "", "", "", "", "in <![CDATA[", "after <![CDATA", "", "", "", "after <!DOCTYPE", "reading element type", "after DOCTYPE Name", "in PUBLIC keyword", "after PUBLIC", "after PUBLIC keyword", "in PUBLIC identifier", "", "after PUBLIC identifier", "", "after SYSTEM identifier", "in SYSTEM keyword", "after SYSTEM", "after SYSTEM keyword", "", "", "after DTD SYSTEM identifier", "in internal subset", "] in internal subset", "]] in internal subset", "in PE reference", "", "after internal subset", "after < in internal subset", "after <! in internal subset", "after <!NOTATION", "", "", "", "after PUBLIC in <!NOTATION", "", "after PUBLIC identifier", "", "after SYSTEM in <!NOTATION", "", "after External ID in <!NOTATION", "", "after <![ in internal subset", "after <[I in internal subset", "after <![INCLUDE", "after <![IGNORE", "after <!- in internal subset", "in comment", "", "after '--' in comment in internal subset", "after <!ATTLIST", "after <!ATTLIST", "in element type in <!ATTLIST", "in <!ATTLIST", "in attribute name in <!ATTLIST", "after attribute name in <!ATTLIST", "in tokenized attribute value", "", "", "", "", "", "after CDATA in <!ATTLIST", "in ENTIT(Y,IES) keyword in <!ATTLIST", "", "", "", "", "", "", "", "", "in ID(REF(S)) keyword in <!ATTLIST", "", "", "", "", "", "after N in <!ATTLIST type keyword", "after NOTATION in <!ATTLIST", "after NOTATION in <!ATTLIST", "in NOTATION list in <!ATTLIST", "", "", "", "", "after NMTOKEN in <!ATTLIST", "", "after <!ATTLIST type", "after # in <!ATTLIST default", "after #REQUIRED", "after #IMPLIED", "after #FIXED", "", "after <!E in internal subset", "after <!ELEMENT", "", "after element type in declaration", "after EMPTY", "after ANY", "after <!ELEMENT (", "after element-content declaration", "", "start of content particle", "", "after first (...) of content particle", "", "after , in content particle", "", "after ) in content article", "after member of sequence", "after | in content particle", "", "after ) in content article", "after member of choice", "after #PCDATA", "after (#PCDATA|", "in element type in mixed declaration", "after element type in mixed declaration", "after mixed declaration", "", "after (#PCDATA)", "after <!ENTITY", "", "after <!ENTITY %", "after '<!ENTITY % '", "in <!ENTITY name", "after <!ENTITY name", "internal entity declaration", "", "after <!ENTITY value", "after entity SYSTEM ID", "", "after NDATA", "after NDATA keyword", "", "after NDATA entity declaration", "after </", "in element type in end-tag", "after element type in end-tag", "in element type in start-tag", "after '/' in start-tag", "in start-tag", "in attribute name in start-tag", "after attribute name in start-tag", "after AttrName= in start-tag", "", "", "", "", "in character data", "", "", "after end of document", "after '&lt;' after document", "after '&lt;!' after document", "after '&amp;'", "in numeric character ref", "in hex character ref", "", "in entity name", "after &amp;g", "after &amp;gt", "after &amp;l", "after &amp;lt", "after &amp;q", "after &amp;qu", "after &amp;quo", "after &amp;quot", "after &amp;a", "after &amp;ap", "after &amp;apo", "after &amp;apos", "after &amp;am", "after &amp;amp", "", "", "after <?", "after <?x", "after <?xm", "after <?xml", "in XML declaration", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        sKW = new String[]{"DOCTYPE", "CDATA", "PUBLIC", "SYSTEM", "NOTATION", "ATTLIST", "SYSTEM", "PUBLIC", "INCLUDE", "IGNORE", "CDATA", "NOTATION", "NMTOKEN", "REQUIRED", "IMPLIED", "FIXED", "ENTITY", "ELEMENT", "EMPTY", "ANY", "PCDATA", "NDATA", "version", "'1.0'", "\"1.0\"", "encoding", "standalone", "standalone", "'yes'", "'no'", "\"yes\"", "\"no\"", ""};
        sFB = new byte[]{-124, -125, -124, -125, -123, -122, -123, 74, 74, -123, 74, -127, 74, 74, 74, 74, 74, 74, 74, 74, -107, -107, -107, -107, -107, -107, -99, -99, 74, 74, 74, -96, -96, -94, -91, -91, 75, 75, 75, 75, -96, -96, -83, -83, 75, 74, 74, -96, -79, -79, -79, -79, -79, 49, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, -54, -54, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 74, 75, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 74, 75, 49, 49, 49, 52, 74, 74, 58, 58, 58, 49, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49};
        sNullString = new String("");
        sS = new char[]{' ', '\n', '\r', '\t'};
        sStateMask = (short)255;
        sSpecialMask = (short)-256;
        sSpecialShift = (byte)8;
        sMaxDigitsInHexCRef = (byte)4;
        sCharClasses = new byte[227];
        sD = new short[227][128];
        sOS = new char[128];
        int n2 = 0;
        do {
            int n3 = Lark.byteFromString(sOCT, n2 * 3);
            n = Lark.byteFromString(sOCT, n2 * 3 + 1);
            Lark.sD[n3][n] = (short)Lark.byteFromString(sOCT, n2 * 3 + 2);
            int n4 = Lark.byteFromString(sOCSI, n2);
            if (n4 == 0) continue;
            short[] sArray = sD[n3];
            int n5 = n;
            sArray[n5] = (short)(sArray[n5] | (short)(n4 << sSpecialShift));
        } while (++n2 < 360);
        Lark.doGT(sST, sSI, 126, sS, 4, (byte)0);
        n2 = 0;
        do {
            Lark.sOS[n2] = (char)(48 + n2);
        } while (++n2 < 10);
        n2 = 0;
        do {
            Lark.sOS[10 + n2] = (char)(97 + n2);
            Lark.sOS[16 + n2] = (char)(65 + n2);
        } while (++n2 < 6);
        Lark.doGT(sHT, "\u0000", 1, sOS, 22, (byte)0);
        n2 = 0;
        do {
            Lark.sCharClasses[n2] = 0;
        } while (++n2 < 227);
        n2 = 0;
        do {
            Lark.sOS[n2] = (char)(97 + n2);
            Lark.sOS[n2 + 26] = (char)(65 + n2);
        } while (++n2 < 26);
        Lark.doGT(sNST, sNSI, 24, sOS, 52, (byte)2);
        n2 = 0;
        do {
            Lark.sOS[n2 + 52] = (char)(48 + n2);
        } while (++n2 < 10);
        n2 = 62;
        Lark.sOS[n2++] = 45;
        Lark.sOS[n2++] = 46;
        Lark.sOS[n2++] = 95;
        Lark.sOS[n2++] = 58;
        Lark.doGT(sNCT, sNCI, 41, sOS, n2, (byte)1);
        Lark.doGT(sEN, "\u0000", 2, sOS, --n2, (byte)0);
        n2 = 62;
        Lark.sOS[n2++] = 45;
        Lark.sOS[n2++] = 39;
        Lark.sOS[n2++] = 40;
        Lark.sOS[n2++] = 41;
        Lark.sOS[n2++] = 43;
        Lark.sOS[n2++] = 44;
        Lark.sOS[n2++] = 46;
        Lark.sOS[n2++] = 47;
        Lark.sOS[n2++] = 58;
        Lark.sOS[n2++] = 61;
        Lark.sOS[n2++] = 63;
        Lark.sOS[n2++] = 32;
        Lark.doGT(sPub, "\u0000", 2, sOS, n2, (byte)0);
        sIsChar = new boolean[128];
        n2 = 0;
        do {
            Lark.sIsChar[n2] = false;
        } while (++n2 < 128);
        Lark.sIsChar[13] = true;
        Lark.sIsChar[10] = true;
        Lark.sIsChar[9] = true;
        n2 = 0;
        Lark.sOS[n2++] = 9;
        Lark.sOS[n2++] = 10;
        Lark.sOS[n2++] = 13;
        n = 32;
        do {
            Lark.sOS[n2++] = (char)n;
            Lark.sIsChar[n] = true;
        } while (++n < 128);
        Lark.doGT(sDT, sDS, 29, sOS, n2, (byte)0);
    }

    private void constructor(String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        int n = 1;
        do {
            this.mScratchAttrs[n] = new Attribute[n];
            int n2 = 0;
            while (n2 < n) {
                this.mScratchAttrs[n][n2] = new Attribute(null, null);
                ++n2;
            }
        } while (++n < 20);
        if (stringArray != null && this.mEmpty == null) {
            this.mEmpty = new Hashtable(stringArray.length * 10, 10.0f);
            n = 0;
            while (n < stringArray.length) {
                this.mEmpty.put(stringArray[n], sNullString);
                ++n;
            }
        }
        if (stringArray2 != null) {
            if (stringArray3 == null || stringArray2.length != stringArray3.length) {
                throw new Exception("Entity Name and Value args don't match");
            }
            n = 0;
            while (n < stringArray2.length) {
                char[] cArray = stringArray3[n].toCharArray();
                this.mInternalEntities.put(stringArray2[n], cArray);
                ++n;
            }
        }
    }

    private static void doGT(String string, String string2, int n, char[] cArray, int n2, byte by) {
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = n4 = Lark.byteFromString(string, n3 * 2);
            sCharClasses[n5] = (byte)(sCharClasses[n5] | by);
            int n6 = 0;
            while (n6 < n2) {
                char c = cArray[n6];
                if (sD[n4][c] == 0) {
                    Lark.sD[n4][c] = (short)Lark.byteFromString(string, n3 * 2 + 1);
                    int n7 = Lark.byteFromString(string2, n3);
                    if (n7 != 0) {
                        short[] sArray = sD[n4];
                        char c2 = c;
                        sArray[c2] = (short)(sArray[c2] | (short)(n7 << sSpecialShift));
                    }
                }
                ++n6;
            }
            ++n3;
        }
    }

    private Text currentText() {
        Object e;
        if (this.mCurrentAttrVal != null) {
            return this.mCurrentAttrVal;
        }
        if (!this.mBuildTree) {
            return null;
        }
        Vector vector = this.mCurrentElement.children();
        if (!vector.isEmpty() && (e = vector.lastElement()) instanceof Text) {
            return (Text)e;
        }
        Text text = new Text();
        vector.addElement(text);
        return text;
    }

    private Element reader(Handler handler, XmlInputStream xmlInputStream) throws IOException, InterruptedException, Exception {
        Element element;
        byte by = 0;
        int n = 0;
        int[] nArray = new int[2];
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        int n2 = 0;
        if (this.mCurrentElement == null) {
            this.mCurrentElement = handler.element();
        }
        while (bl) {
            char[] cArray;
            int n3;
            Object object;
            Segment segment;
            Text text;
            int n4;
            if (n2 == 0) {
                n4 = xmlInputStream.getXmlChar();
            } else {
                n4 = n2;
                n2 = 0;
            }
            while (n4 == -1 && this.mCurrentEntity.parent() != null) {
                text = this.currentText();
                if (text != null) {
                    segment = this.mSaveText || this.mCurrentAttrVal != null ? new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount, this.mSavedCharCount, this.mCharBuf) : new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mInputCharCount - this.mLastTextOffset);
                    text.addSegment(segment);
                }
                if (!this.mInEntityVal) {
                    this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                    if (this.mState == 176 && !this.mWFError) {
                        boolean bl3 = bl2 = bl2 || handler.doText(this.mCurrentEntity, this.mCurrentElement, this.mCharBuf, this.mSavedCharCount);
                    }
                }
                if (!this.mCurrentEntity.isPE()) {
                    this.mSavedCharCount = 0;
                }
                object = this.mCurrentEntity;
                this.mCurrentEntity = this.mCurrentEntity.parent();
                xmlInputStream = this.mCurrentEntity.input();
                this.mLastTextOffset = this.mInputCharCount = this.mCurrentEntity.offset();
                this.mInputLineCount = this.mCurrentEntity.lineCount();
                this.mLineOffset = this.mCurrentEntity.lineOffset();
                this.mStack.pop();
                n4 = ((Entity)object).isPE() && !this.mInEntityVal ? 32 : xmlInputStream.getXmlChar();
                if (this.mState == 48 && this.mStateStackInd == 1 && this.mPushedState[0] == this.mStateBeforeDTD && this.mCurrentEntity.parent() == null) {
                    this.mStateStackInd = 0;
                    this.mState = this.mStateBeforeDTD;
                    continue;
                }
                if (((Entity)object).isPE() || !this.mSawRoot || this.mState == 172 || this.mState == 174 || this.mState == 176 || !this.complain(handler, sBadRefEnd, 32)) continue;
                return null;
            }
            if (n4 == -1) {
                if (!this.mSawRoot) {
                    handler.doSyntaxError(this.mCurrentEntity, sNoRoot, 32);
                    this.signalWFError();
                    break;
                }
                if (this.mStack.empty()) break;
                handler.doSyntaxError(this.mCurrentEntity, sPrematureEOF, 32);
                this.signalWFError();
                break;
            }
            int n5 = n4;
            if (n4 > 127) {
                n3 = sCharClasses[this.mState];
                n5 = n3 == 0 ? (n4 > 55295 && n4 < 57344 || n4 == 65534 || n4 == 65535 ? 1 : 126) : ((n3 & 1) != 0 && CharClasses.isNameC((char)n4) ? 49 : ((n3 & 2) != 0 && CharClasses.isNameStart((char)n4) ? 97 : 0));
            }
            short s = sD[this.mState][n5];
            int n6 = s & sStateMask;
            int n7 = s >> sSpecialShift & 0xFF;
            if (n6 == 0) {
                if (n4 > 127 && n5 == 1) {
                    object = sIllegalCharacter;
                } else if (n4 > 127 && n5 == 0) {
                    object = sNonNameChar;
                } else {
                    n3 = this.mState;
                    while (sErrorMessages[n3].equals(sNullString)) {
                        --n3;
                    }
                    object = sErrorMessages[n3];
                }
                if (this.mStateStackInd > 0) {
                    this.mState = this.mPushedState[0];
                }
                n6 = sFB[this.mState] + 127;
                this.mSaving = false;
                this.clearSaved();
                this.mSavedCharCount = 0;
                this.mStateStackInd = 0;
                if (this.complain(handler, (String)object, n4)) {
                    return null;
                }
            }
            this.mState = n6;
            ++this.mInputCharCount;
            if (n4 == 10) {
                ++this.mInputLineCount;
                this.mLineOffset = 0;
            } else if (n4 != 13) {
                ++this.mLineOffset;
            }
            boolean bl4 = false;
            if (n7 != 0) {
                byte[] byArray = sSL[n7];
                n7 = 0;
                while (n7 < byArray.length) {
                    by = byArray[n7++];
                    switch (by) {
                        case 1: {
                            if (this.mInEntityVal) {
                                ++n7;
                                break;
                            }
                            this.mCharBuf[0] = (char)byArray[n7];
                            text = this.currentText();
                            if (text != null) {
                                segment = this.mSaveText || this.mCurrentAttrVal != null ? new Segment(this.mCurrentEntity, this.mLastAmpOffset, this.mInputCharCount - this.mLastAmpOffset, 1, byArray, n7) : new Segment(this.mCurrentEntity, this.mLastAmpOffset, this.mInputCharCount - this.mLastAmpOffset);
                                text.addSegment(segment);
                            }
                            if (this.mCurrentAttrVal == null && !this.mWFError) {
                                bl2 = handler.doText(this.mCurrentEntity, this.mCurrentElement, this.mCharBuf, 1);
                            }
                            ++n7;
                            this.mLastTextOffset = this.mInputCharCount;
                            bl4 = true;
                            this.mSavedCharCount = 0;
                            this.mSaving = false;
                            break;
                        }
                        case 2: {
                            bl4 = true;
                            this.mLastTextOffset = this.mInputCharCount;
                            break;
                        }
                        case 3: {
                            this.clearSaved();
                            break;
                        }
                        case 4: {
                            if (this.mPEDecl) {
                                bl2 = this.complain(handler, sPEwithNDATA, 32);
                            } else if (this.mIgnoredSection == -1) {
                                this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset - 1);
                                if (!this.mWFError) {
                                    bl2 = handler.doSystemBinaryEntity(this.mCurrentEntity, (String)this.mSaved.elementAt(0), (String)this.mSaved.elementAt(1), (String)this.mSaved.elementAt(2));
                                }
                            }
                            this.clearSaved();
                            break;
                        }
                        case 6: {
                            this.clearSaved();
                            break;
                        }
                        case 7: {
                            this.clearSaved();
                            break;
                        }
                        case 8: {
                            this.clearSaved();
                            break;
                        }
                        case 9: {
                            if (this.mSavedCharCount > 0) {
                                segment = new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount, this.mSavedCharCount, this.mCharBuf);
                                this.mCurrentAttrVal.addSegment(segment);
                            }
                            this.mSaving = false;
                            this.mSaved.addElement(this.mCurrentAttrVal);
                            this.mSavedCharCount = 0;
                            ++this.mSavedStringCount;
                            this.mCurrentAttrVal = null;
                            break;
                        }
                        case 10: {
                            this.mSaving = false;
                            this.mSaved.addElement(this.mANames.checkAndAdd(this.mCharBuf, this.mSavedCharCount));
                            this.mSavedCharCount = 0;
                            ++this.mSavedStringCount;
                            break;
                        }
                        case 12: {
                            this.mSaving = false;
                            this.mSaved.addElement(this.mElNames.checkAndAdd(this.mCharBuf, this.mSavedCharCount));
                            this.mSavedCharCount = 0;
                            ++this.mSavedStringCount;
                            break;
                        }
                        case 13: {
                            this.mSaving = false;
                            this.mSaved.addElement(new String(this.mCharBuf, 0, this.mSavedCharCount));
                            this.mSavedCharCount = 0;
                            ++this.mSavedStringCount;
                            break;
                        }
                        case 14: {
                            this.mCurrentAttrVal = new Text();
                            break;
                        }
                        case 15: {
                            this.mInEntityVal = true;
                            break;
                        }
                        case 16: {
                            if (!this.mInExternalDecls) {
                                bl2 = this.complain(handler, sMSinSubset, 32);
                            }
                            if (this.mIgnoredSection == -1) {
                                this.mIgnoredSection = this.mMarkedSectionDepth;
                            }
                            ++this.mMarkedSectionDepth;
                            break;
                        }
                        case 17: {
                            if (!this.mInExternalDecls) {
                                bl2 = this.complain(handler, sMSinSubset, 32);
                            }
                            ++this.mMarkedSectionDepth;
                            break;
                        }
                        case 18: {
                            bl2 = this.complain(handler, sFloatingMSE, 32);
                            break;
                        }
                        case 19: {
                            object = "1.0";
                            String string4 = null;
                            String string5 = null;
                            if (this.mSavedStringCount > 1) {
                                string = (String)this.mSaved.elementAt(1);
                                if (string.equals("encoding")) {
                                    string4 = (String)this.mSaved.elementAt(2);
                                } else {
                                    string5 = (String)this.mSaved.elementAt(2);
                                }
                            }
                            if (this.mSavedStringCount > 3) {
                                string5 = (String)this.mSaved.elementAt(4);
                            }
                            if (string5 != null) {
                                string5 = string5.substring(0, string5.length() - 1);
                            }
                            this.clearSaved();
                            bl2 = handler.doXmlDeclaration((String)object, string4, string5);
                            break;
                        }
                        case 20: {
                            int n8;
                            if (this.mInEntityVal) {
                                n8 = this.mSavedCharCount - (this.mInputCharCount - this.mLastAmpOffset);
                                n8 += 2;
                            } else {
                                n8 = 0;
                            }
                            if (this.mCharBuf[n8 + 1] == 'x') {
                                if (this.mSavedCharCount - (n8 + 2) > sMaxDigitsInHexCRef) {
                                    bl2 = this.complain(handler, sHexCRefTooLong, n4);
                                    n4 = 0;
                                } else {
                                    n4 = 0;
                                    n3 = 2;
                                    while (n8 + n3 < this.mSavedCharCount) {
                                        n4 = n4 * 16 + Character.digit(this.mCharBuf[n8 + n3], 16);
                                        ++n3;
                                    }
                                }
                            } else {
                                n4 = 0;
                                n3 = 1;
                                while (n8 + n3 < this.mSavedCharCount) {
                                    n4 = n4 * 10 + Character.digit(this.mCharBuf[n8 + n3], 10);
                                    ++n3;
                                }
                            }
                            if (n4 < 128 && !sIsChar[n4] || n4 > 55295 && n4 < 57344 || n4 == 65534 || n4 == 65535) {
                                bl2 = this.complain(handler, sIllegalCharacter, n4);
                            }
                            if (this.mInEntityVal) {
                                this.mSavedCharCount -= this.mInputCharCount - this.mLastAmpOffset;
                                ++this.mSavedCharCount;
                                break;
                            }
                            text = this.currentText();
                            this.mCharBuf[0] = (char)n4;
                            if (text != null) {
                                if (this.mSaveText || this.mCurrentAttrVal != null) {
                                    cArray = new char[]{(char)n4};
                                    segment = new Segment(this.mCurrentEntity, this.mLastAmpOffset, this.mInputCharCount - this.mLastAmpOffset, 1, cArray, 0);
                                } else {
                                    segment = new Segment(this.mCurrentEntity, this.mLastAmpOffset, this.mInputCharCount - this.mLastAmpOffset);
                                }
                                text.addSegment(segment);
                            }
                            if (this.mCurrentAttrVal == null && !this.mWFError) {
                                bl2 = handler.doText(this.mCurrentEntity, this.mCurrentElement, this.mCharBuf, 1);
                            }
                            this.mSavedCharCount = 0;
                            if (!this.mSaving) break;
                            this.mSaving = false;
                            bl4 = true;
                            break;
                        }
                        case 21: {
                            this.mCharBuf[this.mSavedCharCount++] = (char)n4;
                            bl4 = true;
                            break;
                        }
                        case 22: {
                            if (n4 != sKW[this.mKeyword].charAt(this.mKeywordPos++)) {
                                bl2 = this.complain(handler, sBustedKW + sKW[this.mKeyword], n4);
                                if (this.mStateStackInd > 0) {
                                    this.mState = this.mPushedState[0];
                                }
                                this.mState = sFB[this.mState] + 127;
                                this.clearSaved();
                                this.mSavedCharCount = 0;
                                break;
                            }
                            if (this.mKeywordPos < sKW[this.mKeyword].length()) break;
                            this.mState = this.mPushedState[this.mStateStackInd += -1];
                            break;
                        }
                        case 23: {
                            this.mKeyword = byArray[n7++];
                            this.mPushedState[this.mStateStackInd++] = byArray[n7++] + 127;
                            this.mKeywordPos = byArray[n7++];
                            break;
                        }
                        case 24: {
                            if (this.mMarkedSectionDepth == 0) {
                                bl2 = this.complain(handler, sFloatingMSE, 32);
                                break;
                            }
                            this.mMarkedSectionDepth += -1;
                            if (this.mIgnoredSection != this.mMarkedSectionDepth) break;
                            this.mIgnoredSection = -1;
                            break;
                        }
                        case 25: {
                            this.mLastAmpOffset = this.mInputCharCount - 1;
                            break;
                        }
                        case 27: {
                            if (this.mCurrentAttrVal != null) {
                                bl2 = this.complain(handler, sLTInAttrVal, 32);
                                break;
                            }
                            this.mLastLtOffset = this.mInputCharCount - 1;
                            break;
                        }
                        case 28: {
                            this.mRefIsToPE = true;
                            this.mLastAmpOffset = this.mInputCharCount - 1;
                            if (this.mInExternalDecls) break;
                            bl2 = this.complain(handler, sNoTopLevelPE, n4);
                            break;
                        }
                        case 29: {
                            this.mRefIsToPE = true;
                            this.mLastAmpOffset = this.mInputCharCount - 1;
                            break;
                        }
                        case 31: {
                            if (this.mStateStackInd <= 0) break;
                            this.mState = this.mPushedState[this.mStateStackInd += -1];
                            break;
                        }
                        case 32: {
                            if (this.mIgnoredSection != -1) {
                                this.clearSaved();
                                break;
                            }
                            this.mStateStackInd += -1;
                            if (this.mStateStackInd < n) {
                                bl2 = this.complain(handler, sBadParenInCM, n4);
                                break;
                            }
                            this.clearSaved();
                            this.mState = this.mPushedState[this.mStateStackInd];
                            break;
                        }
                        case 33: {
                            this.mPushedState[this.mStateStackInd++] = byArray[n7++] + 127;
                            break;
                        }
                        case 34: {
                            if (this.mIgnoredSection != -1 || (this.mSavedStringCount - 1) % 3 == 0) break;
                            this.mSaved.addElement(null);
                            ++this.mSavedStringCount;
                            break;
                        }
                        case 35: {
                            if (this.mIgnoredSection == -1) {
                                this.mCurrentEntity.setOffsets(this.mLastLtOffset, this.mInputLineCount, this.mLineOffset);
                                Object[] objectArray = new Object[this.mSavedStringCount];
                                n3 = 0;
                                while (n3 < this.mSavedStringCount) {
                                    objectArray[n3] = this.mSaved.elementAt(n3);
                                    ++n3;
                                }
                                if (!this.mWFError) {
                                    bl2 = handler.doAttlist(this.mCurrentEntity, objectArray);
                                }
                                this.rememberDefaults(this.mSaved, this.mSavedStringCount);
                            }
                            this.clearSaved();
                            break;
                        }
                        case 37: {
                            Object object2;
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                            if (!this.mWFError) {
                                string3 = null;
                                string = (String)this.mSaved.elementAt(0);
                                switch (this.mSavedStringCount) {
                                    case 1: {
                                        bl2 = handler.doDoctype(this.mCurrentEntity, string, null, null);
                                        break;
                                    }
                                    case 2: {
                                        string3 = (String)this.mSaved.elementAt(1);
                                        bl2 = handler.doDoctype(this.mCurrentEntity, string, null, string3);
                                        break;
                                    }
                                    case 3: {
                                        string3 = (String)this.mSaved.elementAt(2);
                                        bl2 = handler.doDoctype(this.mCurrentEntity, string, (String)this.mSaved.elementAt(1), string3);
                                    }
                                }
                                if (string3 != null) {
                                    if (!this.mProcessExternalEntities) {
                                        this.mBypassedExternalDecls = true;
                                    } else {
                                        object2 = null;
                                        try {
                                            object2 = new URL(this.mCurrentEntity.baseURL(), string3);
                                            xmlInputStream = new XmlInputStream(((URL)object2).openStream());
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            stringBuffer = new StringBuffer(sRottenURL).append(string3).append("]");
                                        }
                                        catch (IOException iOException) {
                                            stringBuffer = new StringBuffer(sCantGetURL).append(string3);
                                        }
                                        if (stringBuffer != null) {
                                            bl2 = handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), n4);
                                            this.signalWFError();
                                        } else {
                                            this.mInputCharCount = 0;
                                            this.mInputLineCount = 1;
                                            this.mCurrentEntity = new Entity(true, xmlInputStream, null, string3, this.mCurrentEntity, true, (URL)object2);
                                            this.mPushedState[0] = this.mStateBeforeDTD = this.mState;
                                            this.mInExternalDecls = true;
                                            this.mStateStackInd = 1;
                                            this.mState = 48;
                                            this.mStack.push(this.mCurrentEntity);
                                        }
                                    }
                                }
                            }
                            this.clearSaved();
                            break;
                        }
                        case 38: {
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                            string = (String)this.mSaved.elementAt(0);
                            this.clearSaved();
                            n6 = this.mStack.search(string);
                            if (n6 == 1) {
                                this.mStack.pop();
                                this.mLastTextOffset = this.mInputCharCount;
                                this.mCurrentElement.setOffsets(-1, this.mInputCharCount);
                                this.mCurrentElement.setType(string);
                                if (!this.mWFError) {
                                    boolean bl5 = bl2 = bl2 || handler.doETag(this.mCurrentEntity, this.mCurrentElement);
                                }
                                if (this.mBuildTree && (element = this.mCurrentElement.parent()) != null) {
                                    this.mCurrentElement = element;
                                }
                                if (this.mStack.empty()) {
                                    this.mState = 179;
                                    break;
                                }
                                bl4 = true;
                                break;
                            }
                            if (!this.mStack.empty() && this.mStack.peek() instanceof String && string.equalsIgnoreCase((String)this.mStack.peek())) {
                                stringBuffer = new StringBuffer(sCaseBotch);
                                stringBuffer = stringBuffer.append((String)this.mStack.pop()).append("/").append(string);
                            } else if (!this.mStack.empty() && this.mStack.peek() instanceof Entity) {
                                while (!this.mStack.empty() && !(this.mStack.peek() instanceof String)) {
                                    this.mStack.pop();
                                }
                                stringBuffer = new StringBuffer(sEntityNesting);
                                n6 = this.mStack.search(string);
                            } else if (n6 > 1) {
                                stringBuffer = new StringBuffer(sBadNest);
                                stringBuffer = stringBuffer.append("</").append(string).append(">");
                                stringBuffer = stringBuffer.append(sExpected).append("</");
                                stringBuffer = stringBuffer.append((String)this.mStack.peek()).append(">");
                                n3 = 1;
                                while (n3 < n6) {
                                    stringBuffer = stringBuffer.append(sGenEnd).append("</");
                                    stringBuffer = stringBuffer.append((String)this.mStack.pop()).append(">");
                                    if (this.mBuildTree) {
                                        this.mCurrentElement.offsets(nArray);
                                        stringBuffer = stringBuffer.append(" (start offset: " + nArray[0] + ", ");
                                        stringBuffer = stringBuffer.append("line " + this.mCurrentElement.startedOnLine());
                                    }
                                    if (this.mBuildTree && (element = this.mCurrentElement.parent()) != null) {
                                        this.mCurrentElement = element;
                                    }
                                    ++n3;
                                }
                                this.mStack.pop();
                                if (this.mBuildTree) {
                                    this.mCurrentElement = this.mCurrentElement.parent();
                                }
                            } else if (n6 == -1) {
                                stringBuffer = new StringBuffer(sBadNest);
                                stringBuffer = stringBuffer.append("</").append(string).append(">");
                                stringBuffer = stringBuffer.append(sNotOpened);
                            }
                            bl2 = handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), 32);
                            this.signalWFError();
                            break;
                        }
                        case 39: {
                            if (this.mIgnoredSection != -1) {
                                this.clearSaved();
                                break;
                            }
                            n3 = this.mSavedStringCount - 2;
                            int n9 = this.mSavedStringCount - 1;
                            string = (String)this.mSaved.elementAt(n9);
                            char[] cArray2 = string.toCharArray();
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                            this.mInEntityVal = false;
                            if (!this.mWFError) {
                                bl2 = handler.doInternalEntity(this.mCurrentEntity, (String)this.mSaved.elementAt(n3), cArray2);
                            }
                            string = (String)this.mSaved.elementAt(n3);
                            if (this.mPEDecl) {
                                if (this.mInternalPEs.get(string) == null && this.mExternalPEs.get(string) == null) {
                                    this.mInternalPEs.put(string, cArray2);
                                }
                            } else if (this.mInternalEntities.get(string) == null && this.mExternalTextEntities.get(string) == null) {
                                this.mInternalEntities.put((String)this.mSaved.elementAt(n3), cArray2);
                            }
                            this.mPEDecl = false;
                            this.mSaved.removeElementAt(n9);
                            this.mSaved.removeElementAt(n3);
                            this.mSavedStringCount -= 2;
                            break;
                        }
                        case 36: {
                            this.mSaving = false;
                            this.mSavedCharCount = 0;
                            break;
                        }
                        case 40: {
                            String string6 = null;
                            Object object2 = (String)this.mSaved.elementAt(0);
                            if (((String)object2).equalsIgnoreCase("xml")) {
                                bl2 = this.complain(handler, sPITargetXML, 32);
                            }
                            if (this.mSavedCharCount > 0) {
                                string6 = new String(this.mCharBuf, 0, this.mSavedCharCount - 1);
                            }
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                            if (!this.mWFError) {
                                bl2 = bl2 || handler.doPI(this.mCurrentEntity, (String)object2, string6);
                            }
                            this.mSavedCharCount = 0;
                            this.clearSaved();
                            this.mSaving = false;
                            if (this.mState != 176) break;
                            bl4 = true;
                            break;
                        }
                        case 41: {
                            Hashtable hashtable;
                            Hashtable hashtable2;
                            Object object3;
                            boolean bl6 = false;
                            if (this.mInEntityVal) {
                                if (!this.mRefIsToPE) break;
                                int n10 = this.mInputCharCount - this.mLastAmpOffset - 2;
                                object3 = new char[n10];
                                n3 = 0;
                                while (n3 < n10) {
                                    object3[n3] = this.mCharBuf[n3 + this.mSavedCharCount - n10];
                                    ++n3;
                                }
                                string = this.mEntNames.checkAndAdd((char[])object3, n10);
                                this.mSavedCharCount -= this.mInputCharCount - this.mLastAmpOffset;
                                ++this.mSavedCharCount;
                            } else {
                                string = this.mEntNames.checkAndAdd(this.mCharBuf, this.mSavedCharCount);
                            }
                            object3 = this.mCurrentEntity;
                            while (object3 != null) {
                                if (string == ((Entity)object3).name()) {
                                    bl2 = bl2 || handler.doSyntaxError(this.mCurrentEntity, sRecursiveRef, 32);
                                    this.signalWFError();
                                    bl6 = true;
                                }
                                object3 = ((Entity)object3).parent();
                            }
                            if (bl6) break;
                            this.mCurrentEntity.setOffsets(this.mLastAmpOffset, this.mInputLineCount, this.mLineOffset - (this.mInputCharCount - this.mLastAmpOffset));
                            if (this.mRefIsToPE) {
                                hashtable2 = this.mInternalPEs;
                                hashtable = this.mExternalPEs;
                            } else {
                                hashtable2 = this.mInternalEntities;
                                hashtable = this.mExternalTextEntities;
                            }
                            char[] cArray2 = (char[])hashtable2.get(string);
                            if (cArray2 != null) {
                                if (!this.mWFError) {
                                    bl2 = handler.doEntityReference(this.mCurrentEntity, string);
                                }
                                this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                                this.mInputCharCount = 0;
                                this.mInputLineCount = 1;
                                xmlInputStream = new XmlInputStream(cArray2);
                                this.mCurrentEntity = new Entity(false, xmlInputStream, string, "Internal: (" + string + ")", this.mCurrentEntity, this.mRefIsToPE, this.mCurrentEntity.baseURL());
                            } else {
                                string3 = (String)hashtable.get(string);
                                if (string3 != null) {
                                    if (!this.mWFError) {
                                        bl2 = handler.doEntityReference(this.mCurrentEntity, string);
                                    }
                                    this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                                    if (this.mCurrentAttrVal != null) {
                                        stringBuffer = new StringBuffer(sExtRefInAttr).append(string).append(";");
                                        bl2 = handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), 32);
                                        this.signalWFError();
                                        bl6 = true;
                                    } else {
                                        URL uRL = null;
                                        if (this.mProcessExternalEntities) {
                                            try {
                                                uRL = new URL(this.mCurrentEntity.baseURL(), string3);
                                                xmlInputStream = new XmlInputStream(uRL.openStream());
                                            }
                                            catch (MalformedURLException malformedURLException) {
                                                stringBuffer = new StringBuffer(sRottenURL).append(string3);
                                            }
                                            catch (IOException iOException) {
                                                stringBuffer = new StringBuffer(sCantGetURL).append(string3);
                                            }
                                            if (stringBuffer != null) {
                                                bl2 = handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), 32);
                                                this.signalWFError();
                                                bl6 = true;
                                            } else {
                                                this.mInputCharCount = 0;
                                                this.mInputLineCount = 1;
                                                this.mCurrentEntity = new Entity(true, xmlInputStream, string, string3, this.mCurrentEntity, this.mRefIsToPE, uRL);
                                            }
                                        } else if (this.mState == 48 && !this.mInExternalDecls && this.mRefIsToPE) {
                                            this.mBypassedExternalDecls = true;
                                            bl6 = true;
                                        }
                                    }
                                } else {
                                    bl6 = true;
                                    stringBuffer = new StringBuffer(sNoSuchEntity);
                                    stringBuffer = stringBuffer.append(string).append("'");
                                    if (this.mBypassedExternalDecls) {
                                        stringBuffer = stringBuffer.append(sMaybeExternal);
                                        bl2 = handler.doWarning(this.mCurrentEntity, stringBuffer.toString());
                                    } else {
                                        this.signalWFError();
                                        bl2 = handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), 32);
                                    }
                                    this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                                }
                            }
                            if (this.mRefIsToPE && !this.mInEntityVal) {
                                n2 = 32;
                            } else {
                                bl4 = true;
                                this.mLastTextOffset = this.mInputCharCount;
                            }
                            if (!bl6) {
                                this.mStack.push(this.mCurrentEntity);
                            }
                            this.mSaving = false;
                            if (!this.mInEntityVal) {
                                this.mSavedCharCount = 0;
                            }
                            this.mRefIsToPE = false;
                            break;
                        }
                        case 42: 
                        case 43: {
                            boolean bl7;
                            Attribute[] attributeArray;
                            int n11;
                            int n9;
                            int n8;
                            Attribute[] attributeArray2 = null;
                            int n12 = (this.mSavedStringCount - 1) / 2;
                            attributeArray2 = this.mElNames.defaultAttributes();
                            int n13 = n11 = attributeArray2 == null ? 0 : attributeArray2.length;
                            n3 = 1;
                            while (n3 < this.mSavedStringCount) {
                                string = (String)this.mSaved.elementAt(n3);
                                n9 = 0;
                                while (n9 < n11) {
                                    if (string == attributeArray2[n9].name()) {
                                        --n13;
                                    }
                                    ++n9;
                                }
                                n8 = n3 + 2;
                                while (n8 < this.mSavedStringCount) {
                                    if (string == (String)this.mSaved.elementAt(n8)) {
                                        bl2 = this.complain(handler, sDupeAttributeName + string, 32);
                                    }
                                    n8 += 2;
                                }
                                n3 += 2;
                            }
                            if (this.mBuildTree) {
                                element = this.mCurrentElement;
                                this.mCurrentElement = handler.element();
                                if (this.mBuilding) {
                                    this.mCurrentElement.setParent(element);
                                }
                                this.mBuilding = true;
                                attributeArray = new Attribute[n12 + n13];
                                n3 = 0;
                                while (n3 < n12) {
                                    attributeArray[n3] = new Attribute(null, null);
                                    ++n3;
                                }
                            } else {
                                attributeArray = this.mScratchAttrs[n12 + n13];
                            }
                            string = (String)this.mSaved.elementAt(0);
                            this.mCurrentElement.setType(string);
                            if (by == 43) {
                                this.mCurrentElement.setEmpty(true);
                                bl7 = true;
                            } else if (this.mEmpty != null && this.mEmpty.get(string) != null) {
                                this.mCurrentElement.setEmpty(true);
                                bl7 = true;
                            } else {
                                bl7 = false;
                                this.mCurrentElement.setEmpty(false);
                                this.mStack.push(string);
                            }
                            n3 = 0;
                            while (n3 < n12) {
                                attributeArray[n3].setName((String)this.mSaved.elementAt(n3 * 2 + 1));
                                attributeArray[n3].setValue((Text)this.mSaved.elementAt(n3 * 2 + 2));
                                ++n3;
                            }
                            n13 = 0;
                            n3 = 0;
                            while (n3 < n11) {
                                n9 = 0;
                                while (n9 < n12) {
                                    if (this.mSaved.elementAt(n9 * 2 + 1) == attributeArray2[n3].name()) break;
                                    ++n9;
                                }
                                if (n9 == n12) {
                                    attributeArray[n12 + n13++] = attributeArray2[n3];
                                }
                                ++n3;
                            }
                            this.mCurrentElement.setAllAttributes(attributeArray);
                            this.mCurrentEntity.setOffsets(this.mLastLtOffset, this.mInputLineCount, this.mLineOffset);
                            if (bl7) {
                                this.mCurrentElement.setOffsets(this.mLastLtOffset, this.mInputCharCount);
                            } else {
                                this.mCurrentElement.setOffsets(this.mLastLtOffset, -1);
                            }
                            this.mCurrentElement.setStartedOnLine(this.mInputLineCount);
                            this.mSawRoot = true;
                            if (!this.mWFError) {
                                bl2 = handler.doSTag(this.mCurrentEntity, this.mCurrentElement);
                            }
                            if (this.mBuildTree && (element = this.mCurrentElement.parent()) != null) {
                                element.addChild(this.mCurrentElement);
                                if (bl7) {
                                    this.mCurrentElement = element;
                                }
                            }
                            if (bl7 && this.mStack.empty()) {
                                this.mState = 179;
                            }
                            this.mLastTextOffset = this.mInputCharCount;
                            bl4 = true;
                            this.clearSaved();
                            break;
                        }
                        case 44: {
                            if (this.mIgnoredSection != -1) {
                                this.clearSaved();
                                break;
                            }
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset);
                            string = this.mSavedStringCount == 2 ? (String)this.mSaved.elementAt(1) : (String)this.mSaved.elementAt(2);
                            string2 = (String)this.mSaved.elementAt(0);
                            if (this.mPEDecl) {
                                if (this.mInternalPEs.get(string2) == null && this.mExternalPEs.get(string2) == null) {
                                    this.mExternalPEs.put(string2, string);
                                }
                            } else if (this.mInternalEntities.get(string2) == null && this.mExternalTextEntities.get(string2) == null) {
                                this.mExternalTextEntities.put(string2, string);
                            }
                            if (!this.mWFError) {
                                bl2 = handler.doSystemTextEntity(this.mCurrentEntity, (String)this.mSaved.elementAt(0), string);
                            }
                            this.clearSaved();
                            break;
                        }
                        case 45: {
                            this.mSaving = false;
                            if (this.mSavedCharCount == 0) break;
                            text = this.currentText();
                            if (text != null) {
                                segment = this.mCurrentAttrVal != null ? new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount, this.mSavedCharCount, this.mCharBuf) : (this.mSaveText ? (this.mDocEntityBuffer != null ? new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount, this.mSavedCharCount, this.mDocEntityBuffer, this.mLastTextOffset) : new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount, this.mSavedCharCount, this.mCharBuf)) : new Segment(this.mCurrentEntity, this.mLastTextOffset, this.mSavedCharCount));
                                text.addSegment(segment);
                            }
                            this.mCurrentEntity.setOffsets(this.mInputCharCount, this.mInputLineCount, this.mLineOffset - 1);
                            if (this.mCurrentAttrVal == null && !this.mWFError) {
                                bl2 = bl2 || handler.doText(this.mCurrentEntity, this.mCurrentElement, this.mCharBuf, this.mSavedCharCount);
                            }
                            this.mSavedCharCount = 0;
                            break;
                        }
                        case 46: {
                            byte by2 = byArray[n7++];
                            n3 = 0;
                            while (n3 < by2) {
                                this.mCharBuf[this.mSavedCharCount++] = (char)byArray[n7++];
                                ++n3;
                            }
                            this.mSaving = true;
                            break;
                        }
                        case 47: {
                            this.mPEDecl = true;
                            break;
                        }
                        case 48: {
                            n = this.mStateStackInd;
                            this.mPushedState[this.mStateStackInd++] = 127;
                            this.clearSaved();
                            break;
                        }
                        case 49: {
                            this.clearSaved();
                            break;
                        }
                        case 50: {
                            n2 = n4;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break;
                }
            }
            if (this.mSaving) {
                if (this.mSavedCharCount == this.mThreshold) {
                    cArray = new char[this.mCharBuf.length * 2];
                    n3 = 0;
                    while (n3 < this.mCharBuf.length) {
                        cArray[n3] = this.mCharBuf[n3];
                        ++n3;
                    }
                    this.mCharBuf = cArray;
                    this.mThreshold = this.mCharBuf.length - 1;
                }
                this.mCharBuf[this.mSavedCharCount++] = (char)n4;
            }
            if (!bl4) continue;
            this.mSaving = true;
        }
        if (this.mWFError || !this.mBuildTree) {
            return null;
        }
        if (this.mBuildTree) {
            Element element2 = this.mCurrentElement;
            element = element2.parent();
            element = element2.parent();
            while (element != null) {
                element2 = element;
                element = element2.parent();
            }
            return element2;
        }
        return this.mCurrentElement;
    }

    public Lark() throws Exception {
        this.constructor(null, null, null);
    }

    public Lark(String[] stringArray) throws Exception {
        this.constructor(stringArray, null, null);
    }

    public Lark(String[] stringArray, String[] stringArray2) throws Exception {
        this.constructor(null, stringArray, stringArray2);
    }

    public Lark(String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        this.constructor(stringArray, stringArray2, stringArray3);
    }

    public void setDocumentEntityName(String string) {
        this.mDocumentName = string;
        if (this.mCurrentEntity != null) {
            this.mCurrentEntity.setDescription(string);
        }
    }

    private static int byteFromString(String string, int n) {
        char c = string.charAt(n / 2);
        if ((n & 1) != 0) {
            return c & 0xFF;
        }
        return c >> 8;
    }

    public Element readXML(Handler handler) throws IOException, Exception, InterruptedException {
        if (this.mCurrentEntity == null) {
            throw new Exception("Called readXML with no input stream established.");
        }
        return this.reader(handler, this.mCurrentEntity.input());
    }

    public Element readXML(Handler handler, XmlInputStream xmlInputStream) throws IOException, InterruptedException, Exception {
        this.mCurrentEntity = new Entity(true, xmlInputStream, null, this.mDocumentName, null, false, null);
        return this.reader(handler, xmlInputStream);
    }

    public Element readXML(Handler handler, XmlInputStream xmlInputStream, String string) throws IOException, InterruptedException, Exception {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            StringBuffer stringBuffer = new StringBuffer(sRottenURL).append(string);
            stringBuffer = stringBuffer.append("]");
            this.mCurrentEntity = new Entity(true, xmlInputStream, null, "Dummy", null, false, null);
            handler.doSyntaxError(this.mCurrentEntity, stringBuffer.toString(), 32);
            return null;
        }
        this.mCurrentEntity = new Entity(true, xmlInputStream, null, this.mDocumentName, null, false, uRL);
        return this.reader(handler, xmlInputStream);
    }

    public Element readXML(Handler handler, byte[] byArray) throws IOException, InterruptedException, Exception {
        this.mDocEntityBuffer = byArray;
        XmlInputStream xmlInputStream = new XmlInputStream(new ByteArrayInputStream(byArray));
        this.mCurrentEntity = new Entity(true, xmlInputStream, null, this.mDocumentName, null, false, null);
        return this.reader(handler, xmlInputStream);
    }

    public void saveText(boolean bl) {
        this.mSaveText = bl;
    }
}

