/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.BDemoYearDataTypeEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BWeekday;

public class YearGenerator {
    public static final Log log = Log.getLog((String)"easdemo");
    public static final int LEAP_YEAR_15 = 35136;
    public static final long I_15_MILLIS = 900000L;
    public static final String GOOD = "good";
    public static final BDemoYearDataTypeEnum GOOD_TYPE = BDemoYearDataTypeEnum.normal;
    public static final String EARLY_SCHEDULE = "earlySchedule";
    public static final BDemoYearDataTypeEnum EARLY_TYPE = BDemoYearDataTypeEnum.faultyEarlySchedule;
    int oldYear;
    int newYear;
    File dir;
    BDemoYearDataTypeEnum type = GOOD_TYPE;

    public YearGenerator(int n, int n2, File file, BDemoYearDataTypeEnum bDemoYearDataTypeEnum) {
        this.oldYear = n;
        this.newYear = n2;
        this.dir = file;
        this.type = bDemoYearDataTypeEnum;
    }

    public void generate() throws IOException {
        if (!this.dir.exists()) {
            throw new IOException("Directory does not exist: " + this.dir.getAbsolutePath());
        }
        String string = Integer.toString(this.oldYear);
        String[] stringArray = new String[]{"/com/tridium/easdemo/docs/" + string + "kW.csv", "/com/tridium/easdemo/docs/" + string + "kWh.csv", "/com/tridium/easdemo/docs/" + string + "temp.csv", "/com/tridium/easdemo/docs/" + string + "dp.csv", "/com/tridium/easdemo/docs/" + string + "gas.csv"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.endsWith("temp.csv")) {
                this.generate(this.oldYear, this.newYear, this.dir, string2, GOOD_TYPE);
                continue;
            }
            this.generate(this.oldYear, this.newYear, this.dir, string2, this.type);
        }
    }

    public void generate(int n, int n2, File file, String string, BDemoYearDataTypeEnum bDemoYearDataTypeEnum) throws IOException {
        Object object;
        Object object2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
        Vector<Record> vector = new Vector<Record>(35136);
        String string2 = null;
        int n3 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            ++n3;
            int n4 = string2.indexOf(44);
            if (n4 == -1) {
                throw new IllegalStateException("Invalid csv line: (" + n3 + "):" + string2);
            }
            object2 = string2.substring(0, n4);
            object = string2.substring(n4 + 1);
            vector.addElement(new Record(this.parseTime((String)object2), (String)object));
        }
        String string3 = this.getNewFileName(string, n2);
        if (log.isTraceOn()) {
            log.trace("Generating " + string3 + " from " + string.substring(string.lastIndexOf(47) + 1) + "...");
        }
        if (bDemoYearDataTypeEnum.equals((Object)EARLY_TYPE) && log.isTraceOn()) {
            log.trace("  using the earlySchedule bad data generation method.");
        }
        if (((File)(object2 = new File(file, string3))).exists()) {
            ((File)object2).delete();
        }
        object = new PrintWriter(new FileOutputStream((File)object2));
        BWeekday bWeekday = BAbsTime.getWeekday((int)n2, (BMonth)BMonth.january, (int)1);
        int n5 = this.getStartIndex(bWeekday, vector);
        long l = BAbsTime.make((int)(n2 + 1), (BMonth)BMonth.january, (int)1).getMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        int n6 = 0;
        for (long i = BAbsTime.make((int)n2, (BMonth)BMonth.january, (int)1).getMillis(); i < l; i += 900000L) {
            Record record = (Record)vector.elementAt(n5);
            Date date = new Date(i);
            ((PrintWriter)object).print(simpleDateFormat.format(date));
            ((PrintWriter)object).print(',');
            if (bDemoYearDataTypeEnum.equals((Object)EARLY_TYPE)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n7 = calendar.get(11);
                String string4 = record.value;
                if (n7 >= 1 && n7 <= 7 && vector.size() > n5 + 8) {
                    Record record2 = (Record)vector.elementAt(n5 + 8);
                    string4 = record2.value;
                }
                ((PrintWriter)object).println(string4);
            } else {
                ((PrintWriter)object).println(record.value);
            }
            ++n6;
            n5 = (n5 + 1) % vector.size();
        }
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
        if (log.isTraceOn()) {
            log.trace("  generated " + n6 + " records");
        }
    }

    public BAbsTime parseTime(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ :");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        int n6 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n6 = Integer.parseInt(stringTokenizer.nextToken());
        }
        return BAbsTime.make((int)n3, (BMonth)BMonth.make((int)(n - 1)), (int)n2, (int)n4, (int)n5, (int)n6, (int)0);
    }

    public int getStartIndex(BWeekday bWeekday, Vector vector) {
        int n = 0;
        while (((Record)vector.elementAt((int)n)).tstamp.getWeekday() != bWeekday) {
            ++n;
        }
        return n;
    }

    public String getNewFileName(String string, int n) {
        return Integer.toString(n) + string.substring(string.lastIndexOf(47) + 5);
    }

    public static void dumpUsage(Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        System.out.println("Usage: YearGenerator <oldYear> <newYear> [type] [directory]");
        System.out.println("  Where [type] is one of the following:");
        System.out.println("    good <default>");
        System.out.println("    earlySchedule");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            YearGenerator.dumpUsage(null);
            System.exit(-1);
        }
        int n = 0;
        int n2 = 0;
        File file = null;
        BDemoYearDataTypeEnum bDemoYearDataTypeEnum = GOOD_TYPE;
        try {
            n = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            if (stringArray.length > 2 && stringArray[2].equalsIgnoreCase(EARLY_SCHEDULE)) {
                bDemoYearDataTypeEnum = EARLY_TYPE;
            }
            file = new File(".");
            if (stringArray.length > 3) {
                file = new File(stringArray[3]);
            }
        }
        catch (Exception exception) {
            YearGenerator.dumpUsage(exception);
            System.exit(-1);
        }
        YearGenerator yearGenerator = new YearGenerator(n, n2, file, bDemoYearDataTypeEnum);
        yearGenerator.generate();
    }

    public static class Record {
        BAbsTime tstamp;
        String value;

        public Record(BAbsTime bAbsTime, String string) {
            this.tstamp = bAbsTime;
            this.value = string;
        }

        public String toString() {
            return this.tstamp.toString() + "," + this.value;
        }
    }
}

