/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.eas.BEasService;
import com.tridium.eas.EasDatabase;
import com.tridium.easdemo.BDemoDataParameters;
import com.tridium.easdemo.BDemoGenerationTypeEnum;
import com.tridium.easdemo.BEasDemoGenerator;
import com.tridium.easdemo.EasDPNode;
import com.tridium.easdemo.EasDemoDataLoader;
import com.tridium.easdemo.EasMeterNode;
import com.tridium.easdemo.EasNodeProperty;
import com.tridium.easdemo.EasSiteNode;
import com.tridium.easdemo.EasXMLHandler;
import com.tridium.easdemo.xml.TParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Statement;
import javax.baja.log.Log;
import javax.baja.sys.Sys;

public class MasterDemoGen {
    private static BEasService eas;
    private BDemoDataParameters params;
    private static String DB_XML_FILE;
    private static String[] SHORT_LIST;
    public static final Log log;

    public MasterDemoGen(BEasService bEasService, BDemoDataParameters bDemoDataParameters) {
        eas = bEasService;
        this.params = bDemoDataParameters;
    }

    public void generate() {
        String string = Sys.getStation().getStationName();
        boolean bl = true;
        try {
            Object object;
            int n;
            long l = System.currentTimeMillis();
            if (log.isTraceOn()) {
                log.trace("Preparing to build demo for " + string + ".");
            }
            if (log.isTraceOn()) {
                log.trace("Opening " + DB_XML_FILE + " and parsing to build EasNodes.");
            }
            TParser tParser = new TParser();
            EasXMLHandler easXMLHandler = new EasXMLHandler(tParser);
            tParser.setDocumentHandler(easXMLHandler);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(DB_XML_FILE));
            tParser.parse(DB_XML_FILE, DB_XML_FILE, bufferedInputStream);
            if (log.isTraceOn()) {
                log.trace("Retrieving the database connection from the EAS Service.");
            }
            EasDatabase easDatabase = eas.getDatabase();
            Connection connection = easDatabase.getConnection();
            if (log.isTraceOn()) {
                log.trace("Cleaning up the EAS schema by removing any previous data.");
            }
            Statement statement = connection.createStatement();
            statement.executeUpdate("DELETE FROM " + easDatabase.getDBSpecific().getFullTableName("EAS", "GROUPS") + " WHERE TYPE = 'P'");
            statement.executeUpdate("DELETE FROM " + easDatabase.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " WHERE GROUP_ID > 2008 AND GROUP_ID < 2001");
            statement.executeUpdate("DELETE FROM " + easDatabase.getDBSpecific().getFullTableName("EAS", "METER"));
            statement.executeUpdate("DELETE FROM " + easDatabase.getDBSpecific().getFullTableName("EAS", "DATA_POINT"));
            statement.close();
            if (log.isTraceOn()) {
                log.trace("Adding EasNodes to SQL Tables.");
            }
            EasSiteNode[] easSiteNodeArray = EasSiteNode.getSites();
            int n2 = SHORT_LIST.length;
            int n3 = 1;
            int n4 = this.params.getStartYear();
            int n5 = this.params.getEndYear();
            boolean[] blArray = new boolean[n5 - n4 + 1];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < easSiteNodeArray.length; ++n) {
                int n6;
                EasSiteNode easSiteNode = easSiteNodeArray[n];
                if (!MasterDemoGen.inShortList(easSiteNode.getName())) continue;
                if (log.isTraceOn()) {
                    log.trace("Working with site " + n3 + " of " + n2);
                }
                easSiteNode.addSite(connection);
                object = easSiteNode.getProperties();
                for (n6 = 0; n6 < ((Object)object).length; ++n6) {
                    ((EasNodeProperty)object[n6]).addProperty(connection);
                }
                if (this.params.getGenerate().equals((Object)BDemoGenerationTypeEnum.historiesAndConfiguration)) {
                    boolean bl2 = false;
                    EasDemoDataLoader easDemoDataLoader = new EasDemoDataLoader(easDatabase, string, easSiteNode.getName().toUpperCase(), easSiteNode.getProperty("floorarea").getValueAsInt(), easSiteNode.getProperty("stateprov").getValue().toUpperCase());
                    for (n6 = n4; n6 <= n5; ++n6) {
                        boolean bl3 = easDemoDataLoader.addData(n6, bl2);
                        if (!blArray[n6 - n4]) {
                            blArray[n6 - n4] = bl3;
                        }
                        bl2 = true;
                    }
                }
                ++n3;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (!blArray[n]) continue;
                BEasDemoGenerator.purgeYear(n4 + n);
            }
            EasMeterNode[] easMeterNodeArray = EasMeterNode.getMeters();
            for (int i = 0; i < easMeterNodeArray.length; ++i) {
                object = easMeterNodeArray[i];
                if (!MasterDemoGen.inShortList(((EasMeterNode)object).getParent().getName())) continue;
                ((EasMeterNode)object).addMeter(connection);
            }
            EasDPNode[] easDPNodeArray = EasDPNode.getAllDatapoints();
            for (int i = 0; i < easDPNodeArray.length; ++i) {
                EasDPNode easDPNode = easDPNodeArray[i];
                if (!MasterDemoGen.inShortList(easDPNode.getParentSite().getName())) continue;
                easDPNode.addDP(connection);
            }
            connection.close();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("test.xml"));
            bufferedWriter.write("<?xml version=\"3.0\" ?>\n");
            bufferedWriter.write("<db>\n");
            for (int i = 0; i < easSiteNodeArray.length; ++i) {
                EasSiteNode easSiteNode = easSiteNodeArray[i];
                bufferedWriter.write(easSiteNode.getAsXML());
            }
            bufferedWriter.write("</db>");
            bufferedWriter.close();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            long l4 = l3 / 3600000L;
            long l5 = (l3 %= 3600000L) / 60000L;
            long l6 = (l3 %= 60000L) / 1000L;
            l3 %= 1000L;
            if (log.isTraceOn()) {
                log.trace("MasterDemoGen took " + l4 + ":" + l5 + ":" + l6 + "." + l3 + " to complete.");
            }
        }
        catch (Exception exception) {
            log.error("Cannot run MasterDemoGen", (Throwable)exception);
        }
    }

    private static boolean inShortList(String string) {
        boolean bl = false;
        for (int i = 0; i < SHORT_LIST.length; ++i) {
            if (!string.equalsIgnoreCase(SHORT_LIST[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getDbTableName(Connection connection, String string) {
        return eas.getDatabase().getDBSpecific().getFullTableName("EAS", string);
    }

    static {
        DB_XML_FILE = "/com/tridium/easdemo/docs/new_sites.xml";
        SHORT_LIST = new String[]{"Arlington", "Atlanta", "Augusta", "Charleston", "Charlotte", "Richmond East", "Spartanburg", "Winston Salem"};
        log = Log.getLog((String)"easdemo");
    }
}

