/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.EasDatapointHandler;
import com.tridium.easdemo.EasMeterHandler;
import com.tridium.easdemo.EasNode;
import com.tridium.easdemo.EasNodePropertyHandler;
import com.tridium.easdemo.EasSiteNode;
import com.tridium.easdemo.xml.TAttributeList;
import com.tridium.easdemo.xml.TLocation;
import com.tridium.easdemo.xml.TStateHandler;

public class EasSiteHandler
extends TStateHandler {
    private EasSiteNode siteNode;
    private int state = 0;
    private static final int IGNORE = 0;
    private static final int ID = 1;
    private static final int NAME = 2;

    public EasSiteHandler(TStateHandler tStateHandler, TAttributeList tAttributeList, TLocation tLocation) {
        super(tStateHandler);
        this.createSite(tAttributeList, tLocation);
    }

    public void createSite(TAttributeList tAttributeList, TLocation tLocation) {
        this.siteNode = new EasSiteNode(Integer.parseInt(tAttributeList.get("handle")));
        this.siteNode.setParent(EasNode.ROOT_NODE);
        EasNode.ROOT_NODE.addChild(this.siteNode);
    }

    public void startElement(String string, TAttributeList tAttributeList, TLocation tLocation) throws Exception {
        if (string.equals("id")) {
            this.state = 1;
        } else if (string.equals("name")) {
            this.state = 2;
        } else if (string.equals("property")) {
            this.pushHandler(new EasNodePropertyHandler(this, tAttributeList, tLocation, this.siteNode));
        } else if (string.equals("meter")) {
            this.pushHandler(new EasMeterHandler(this, tAttributeList, tLocation, this.siteNode));
        } else if (string.equals("datapoint")) {
            this.pushHandler(new EasDatapointHandler(this, tAttributeList, tLocation, this.siteNode));
        } else {
            throw new Exception("Encountered tag <" + string + ">");
        }
    }

    public void endElement(String string, TLocation tLocation) throws Exception {
        if (string.equals("site")) {
            this.popHandler(tLocation);
        }
        this.state = 0;
    }

    public void characters(char[] cArray, int n, int n2, TLocation tLocation) throws Exception {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.siteNode.setId(Integer.parseInt(new String(cArray, n, n2)));
                break;
            }
            case 2: {
                this.siteNode.setName(new String(cArray, n, n2));
                break;
            }
            default: {
                throw new IllegalStateException("Bad state");
            }
        }
    }

    public void processingInstruction(String string, String string2, TLocation tLocation) throws Exception {
    }
}

