/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.MasterDemoGen;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.baja.units.BUnit;

public class EasNodeProperty {
    private BUnit unit = BUnit.NULL;
    private char type = (char)32;
    private int parent = -1;
    private String name = "";
    private String value = "";

    public String getAsXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<property name=\"" + this.name + "\">\n");
        stringBuffer.append("<type>" + this.type + "</type>\n");
        stringBuffer.append("<value>" + this.value + "</value>\n");
        stringBuffer.append("<unit>" + this.getUnit() + "</unit>\n");
        stringBuffer.append("</property>\n");
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getParent() {
        return this.parent;
    }

    public char getType() {
        return this.type;
    }

    public String getUnit() {
        String string = "null";
        if (this.unit != null) {
            string = this.unit.getUnitName();
        }
        return string;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getValueAsBoolean() {
        boolean bl = false;
        try {
            bl = new Boolean(this.value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public float getValueAsFloat() {
        float f = 0.0f;
        try {
            f = new Float(this.value).floatValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public int getValueAsInt() {
        int n = 0;
        try {
            n = new Integer(this.value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(int n) {
        this.parent = n;
    }

    public void setType(String string) {
        this.type = string.charAt(0);
    }

    public void setUnit(String string) {
        this.unit = BUnit.getUnit((String)string);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void addProperty(Connection connection) {
        try {
            if (this.type == 'S') {
                PreparedStatement preparedStatement = connection.prepareStatement("insert into " + MasterDemoGen.getDbTableName(connection, "GROUP_PROP") + " (group_id, name, value, vunit) values (?,?,?,?)");
                preparedStatement.setInt(1, this.getParent());
                preparedStatement.setString(2, this.getName());
                preparedStatement.setString(3, this.getValue());
                preparedStatement.setString(4, this.getUnit());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            } else {
                PreparedStatement preparedStatement = connection.prepareStatement("insert into " + MasterDemoGen.getDbTableName(connection, "GROUP_PROP") + " (group_id, name, nvalue, vunit) values (?,?,?,?)");
                preparedStatement.setInt(1, this.getParent());
                preparedStatement.setString(2, this.getName());
                preparedStatement.setInt(3, this.getValueAsInt());
                preparedStatement.setString(4, this.getUnit());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

