/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.eas.EasDatabase;
import com.tridium.easdemo.BEasDemoGenerator;
import com.tridium.easdemo.EasCsvImporter;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

public class EasDemoDataLoader {
    private EasDatabase easDb;
    private String station;
    private String site;
    private String state;
    private int floorarea;
    private BIHistory[] EAS_LOGS = new BIHistory[11];
    private String[] EAS_TABLES = new String[11];
    private static final int MAIN_EC_POS = 0;
    private static final int MAIN_ED_POS = 1;
    private static final int SUB_LC_POS = 2;
    private static final int SUB_LD_POS = 3;
    private static final int SUB_HC_POS = 4;
    private static final int SUB_HD_POS = 5;
    private static final int SUB_PC_POS = 6;
    private static final int SUB_PD_POS = 7;
    private static final int MAIN_OAT_POS = 8;
    private static final int MAIN_GAS_POS = 9;
    private static final int SUB_LR_POS = 10;
    private static final String MAIN_EC_TABLE = " MAIN ELECTRIC C";
    private static final String MAIN_ED_TABLE = " MAIN ELECTRIC D";
    private static final String SUB_LC_TABLE = " SUB LIGHTING C";
    private static final String SUB_LD_TABLE = " SUB LIGHTING D";
    private static final String SUB_HC_TABLE = " SUB HVAC C";
    private static final String SUB_HD_TABLE = " SUB HVAC D";
    private static final String SUB_PC_TABLE = " SUB PLUG C";
    private static final String SUB_PD_TABLE = " SUB PLUG D";
    private static final String MAIN_OAT_TABLE = " OUTSIDE AIR TEMP";
    private static final String MAIN_GAS_TABLE = " MAIN GAS C";
    private static final String[] FLOAT_TABLES = new String[]{" MAIN ELECTRIC C", " MAIN ELECTRIC D", " SUB LIGHTING C", " SUB LIGHTING D", " SUB HVAC C", " SUB HVAC D", " SUB PLUG C", " SUB PLUG D", " OUTSIDE AIR TEMP", " MAIN GAS C"};
    private static final String[] UNIT_NAMES = new String[]{"kilowatt hour", "kilowatt", "kilowatt hour", "kilowatt", "kilowatt hour", "kilowatt", "kilowatt hour", "kilowatt", "fahrenheit", "kilobtu"};
    private static final String SUB_LR_TABLE = " SUB LIGHTING RUNTIME";
    private static final String[] BINARY_TABLES = new String[]{" SUB LIGHTING RUNTIME"};
    private static final int BASE_FLOORAREA = 104050;
    private static final long FIFTEEN = 900000L;
    private static final Hashtable TEMP_OFFSETS = new Hashtable();
    public static final Hashtable SUB_OFFSETS;
    public static final Hashtable SITE_ELEC_OFFSETS;
    public static final Hashtable SITE_GAS_OFFSETS;
    public static final Log log;
    private BNumericTrendRecord numericRecord = new BNumericTrendRecord();
    private BBooleanTrendRecord booleanRecord = new BBooleanTrendRecord();

    public EasDemoDataLoader(EasDatabase easDatabase, String string, String string2, int n, String string3) {
        this.easDb = easDatabase;
        this.station = string;
        this.site = string2;
        this.state = string3;
        this.floorarea = n;
    }

    public boolean addData(int n, boolean bl) {
        boolean bl2 = false;
        try {
            BHistoryConfig bHistoryConfig;
            BHistoryId bHistoryId;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            BHistoryService bHistoryService;
            BHistoryDatabase bHistoryDatabase;
            if (log.isTraceOn()) {
                log.trace("Opening or creating Tables and Histories for " + this.site + ".");
            }
            if ((bHistoryDatabase = (bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()) == null) {
                log.error("Failed!  Local history database not available.");
                return false;
            }
            for (n2 = 0; n2 < FLOAT_TABLES.length; ++n2) {
                object4 = this.site.toUpperCase() + FLOAT_TABLES[n2];
                object3 = UNIT_NAMES[n2];
                try {
                    object2 = "/" + this.station + "/" + (String)object4;
                    if (bl) {
                        object = this.easDb.getLog((String)object2);
                    } else {
                        bHistoryId = BHistoryId.make((String)object2);
                        bHistoryConfig = EasDemoDataLoader.makeEasConfig(bHistoryId, (String)object3, BNumericTrendRecord.TYPE.getTypeSpec());
                        if (bHistoryDatabase.exists(bHistoryId)) {
                            bHistoryDatabase.deleteHistory(bHistoryId, null);
                        }
                        bHistoryDatabase.createHistory(bHistoryConfig);
                        object = bHistoryDatabase.getHistory(bHistoryId);
                    }
                    this.EAS_LOGS[n2] = object;
                    this.EAS_TABLES[n2] = object2;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n2 = 0; n2 < BINARY_TABLES.length; ++n2) {
                object4 = this.site.toUpperCase() + BINARY_TABLES[n2];
                object3 = "null";
                try {
                    object2 = "/" + this.station + "/" + (String)object4;
                    if (bl) {
                        object = this.easDb.getLog((String)object2);
                    } else {
                        bHistoryId = BHistoryId.make((String)object2);
                        bHistoryConfig = EasDemoDataLoader.makeEasConfig(bHistoryId, (String)object3, BBooleanTrendRecord.TYPE.getTypeSpec());
                        if (bHistoryDatabase.exists(bHistoryId)) {
                            bHistoryDatabase.deleteHistory(bHistoryId, null);
                        }
                        bHistoryDatabase.createHistory(bHistoryConfig);
                        object = bHistoryDatabase.getHistory(bHistoryId);
                    }
                    this.EAS_LOGS[EasDemoDataLoader.FLOAT_TABLES.length + n2] = object;
                    this.EAS_TABLES[EasDemoDataLoader.FLOAT_TABLES.length + n2] = object2;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (log.isTraceOn()) {
                log.trace("Opening " + n + " baseline files for data manipulation and integration.");
            }
            EasCsvImporter easCsvImporter = new EasCsvImporter(n + "kW.csv");
            try {
                easCsvImporter.open();
            }
            catch (Exception exception) {
                BEasDemoGenerator.createMissingYear(n);
                bl2 = true;
                easCsvImporter.open();
            }
            object4 = new EasCsvImporter(n + "kWh.csv");
            try {
                ((EasCsvImporter)object4).open();
            }
            catch (Exception exception) {
                BEasDemoGenerator.createMissingYear(n);
                bl2 = true;
                ((EasCsvImporter)object4).open();
            }
            object3 = new EasCsvImporter(n + "temp.csv");
            try {
                ((EasCsvImporter)object3).open();
            }
            catch (Exception exception) {
                BEasDemoGenerator.createMissingYear(n);
                bl2 = true;
                ((EasCsvImporter)object3).open();
            }
            object2 = new EasCsvImporter(n + "dp.csv");
            try {
                ((EasCsvImporter)object2).open();
            }
            catch (Exception exception) {
                BEasDemoGenerator.createMissingYear(n);
                bl2 = true;
                ((EasCsvImporter)object2).open();
            }
            object = new EasCsvImporter(n + "gas.csv");
            try {
                ((EasCsvImporter)object).open();
            }
            catch (Exception exception) {
                BEasDemoGenerator.createMissingYear(n);
                bl2 = true;
                ((EasCsvImporter)object).open();
            }
            float f = (float)this.floorarea / 104050.0f;
            float f2 = ((Float)TEMP_OFFSETS.get(this.state.toUpperCase())).floatValue();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 0, 1, 0, 0, 0);
            gregorianCalendar.setTimeZone((TimeZone)BTimeZone.getLocal().tzSupport());
            long l = gregorianCalendar.getTime().getTime();
            if (log.isTraceOn()) {
                log.trace("Preparing to load data for " + n + " to " + this.site + ". This might take a while.");
            }
            int n3 = BAbsTime.isLeapYear((int)n) ? 35136 : 35040;
            for (int i = 0; i < n3; ++i) {
                long l2 = l + 900000L * (long)i;
                float f3 = EasDemoDataLoader.randomizer(0);
                float f4 = EasDemoDataLoader.randomizer(1);
                boolean bl3 = easCsvImporter.next();
                boolean bl4 = ((EasCsvImporter)object4).next();
                boolean bl5 = ((EasCsvImporter)object3).next();
                boolean bl6 = ((EasCsvImporter)object2).next();
                boolean bl7 = ((EasCsvImporter)object).next();
                float f5 = 0.0f;
                float f6 = 0.0f;
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = 0.0f;
                if (bl3) {
                    f5 = new Float(easCsvImporter.getToken(1)).floatValue() * f;
                    if (SITE_ELEC_OFFSETS.containsKey(this.site.toUpperCase())) {
                        f5 *= ((Float)SITE_ELEC_OFFSETS.get(this.site.toUpperCase())).floatValue();
                    }
                    f5 *= f3;
                }
                if (bl4) {
                    f6 = new Float(((EasCsvImporter)object4).getToken(1)).floatValue() * f;
                    if (SITE_ELEC_OFFSETS.containsKey(this.site.toUpperCase())) {
                        f6 *= ((Float)SITE_ELEC_OFFSETS.get(this.site.toUpperCase())).floatValue();
                    }
                    f6 *= f3;
                }
                if (bl5) {
                    f7 = new Float(((EasCsvImporter)object3).getToken(1)).floatValue() + f2 + f4;
                }
                if (bl6) {
                    f8 = EasDemoDataLoader.randomizeDigitalPoint(new Float(((EasCsvImporter)object2).getToken(1)).floatValue());
                }
                if (bl7) {
                    f9 = new Float(((EasCsvImporter)object).getToken(1)).floatValue() * f;
                    if (SITE_GAS_OFFSETS.containsKey(this.site.toUpperCase())) {
                        f9 *= ((Float)SITE_GAS_OFFSETS.get(this.site.toUpperCase())).floatValue();
                    }
                    f9 *= f3;
                }
                for (int j = 0; j < this.EAS_LOGS.length; ++j) {
                    float f10 = 0.0f;
                    boolean bl8 = false;
                    switch (j) {
                        case 0: {
                            f10 = f6;
                            break;
                        }
                        case 1: {
                            f10 = f5;
                            break;
                        }
                        case 2: {
                            f10 = f6 * ((Float)SUB_OFFSETS.get("LIGHTING")).floatValue();
                            break;
                        }
                        case 3: {
                            f10 = f5 * ((Float)SUB_OFFSETS.get("LIGHTING")).floatValue();
                            break;
                        }
                        case 4: {
                            f10 = f6 * ((Float)SUB_OFFSETS.get("HVAC")).floatValue();
                            break;
                        }
                        case 5: {
                            f10 = f5 * ((Float)SUB_OFFSETS.get("HVAC")).floatValue();
                            break;
                        }
                        case 6: {
                            f10 = f6 * ((Float)SUB_OFFSETS.get("PLUG")).floatValue();
                            break;
                        }
                        case 7: {
                            f10 = f5 * ((Float)SUB_OFFSETS.get("PLUG")).floatValue();
                            break;
                        }
                        case 8: {
                            f10 = f7;
                            break;
                        }
                        case 9: {
                            f10 = f9;
                            break;
                        }
                        case 10: {
                            f10 = f8;
                            bl8 = EasDemoDataLoader.getBoolean(f8);
                        }
                    }
                    if (j < FLOAT_TABLES.length) {
                        this.EAS_LOGS[j].append((BIHistoryRecordSet)this.numericRecord.set(BAbsTime.make((long)l2), (double)f10, BStatus.ok));
                        continue;
                    }
                    this.EAS_LOGS[j].append((BIHistoryRecordSet)this.booleanRecord.set(BAbsTime.make((long)l2), bl8, BStatus.ok));
                }
                if (i % 50 == 0) {
                    System.gc();
                }
                if (i % 3504 != 0 || !log.isTraceOn()) continue;
                log.trace((float)i / 35040.0f * 100.0f + "% done");
            }
            if (log.isTraceOn()) {
                log.trace("Successfully added data for " + n + " to " + this.site + ".");
            }
            if (log.isTraceOn()) {
                log.trace("Closing all " + n + " baseline files.");
            }
            easCsvImporter.close();
            ((EasCsvImporter)object4).close();
            ((EasCsvImporter)object3).close();
            ((EasCsvImporter)object2).close();
            ((EasCsvImporter)object).close();
        }
        catch (Exception exception) {
            log.error("Encountered exception while adding data.", (Throwable)exception);
        }
        return bl2;
    }

    private static BHistoryConfig makeEasConfig(BHistoryId bHistoryId, String string, BTypeSpec bTypeSpec) {
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, bTypeSpec, BCapacity.makeUnlimited());
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        bHistoryConfig.setInterval(BCollectionInterval.REGULAR_15_MIN);
        BFacets bFacets = BFacets.make((String)"TimeZone", (BIDataValue)BTimeZone.getLocal(), (String)"units", (BIDataValue)BUnit.getUnit((String)string));
        BTrendRecord bTrendRecord = (BTrendRecord)bHistoryConfig.makeRecord();
        Property property = bTrendRecord.getValueProperty();
        String string2 = property.getName() + "Facets";
        bHistoryConfig.add(string2, (BValue)bFacets);
        bHistoryConfig.add("useDelta", (BValue)BBoolean.FALSE);
        return bHistoryConfig;
    }

    private static float randomizer(int n) {
        float f = 1.0f;
        int n2 = (int)(Math.random() * 100.0);
        if (n == 0) {
            if (n2 <= 1) {
                f = 1.08f;
            } else if (n2 <= 2) {
                f = 0.92f;
            } else if (n2 <= 5) {
                f = 1.07f;
            } else if (n2 <= 8) {
                f = 0.93f;
            } else if (n2 <= 13) {
                f = 1.06f;
            } else if (n2 <= 18) {
                f = 0.94f;
            } else if (n2 <= 23) {
                f = 1.05f;
            } else if (n2 <= 28) {
                f = 0.95f;
            } else if (n2 <= 35) {
                f = 1.04f;
            } else if (n2 <= 42) {
                f = 0.96f;
            } else if (n2 <= 49) {
                f = 1.03f;
            } else if (n2 <= 56) {
                f = 0.97f;
            } else if (n2 <= 64) {
                f = 1.02f;
            } else if (n2 <= 73) {
                f = 0.98f;
            } else if (n2 <= 82) {
                f = 1.01f;
            } else if (n2 <= 91) {
                f = 0.99f;
            }
        } else if (n == 1) {
            if (n2 <= 20) {
                f = -1.0f;
            } else if (n2 <= 40) {
                f = 1.0f;
            } else if (n2 <= 60) {
                f = -2.0f;
            } else if (n2 <= 80) {
                f = 2.0f;
            }
        }
        return f;
    }

    private static float randomizeDigitalPoint(float f) {
        int n = (int)(Math.random() * 100.0);
        if (n > 90) {
            f = f == 0.0f ? 1.0f : 0.0f;
        }
        return f;
    }

    private static boolean getBoolean(float f) {
        boolean bl = false;
        if (f == 1.0f) {
            bl = true;
        }
        return bl;
    }

    static {
        TEMP_OFFSETS.put("GA", new Float(5.0f));
        TEMP_OFFSETS.put("SC", new Float(4.0f));
        TEMP_OFFSETS.put("VA", new Float(-2.0f));
        TEMP_OFFSETS.put("WV", new Float(-3.0f));
        TEMP_OFFSETS.put("NC", new Float(0.0f));
        SUB_OFFSETS = new Hashtable();
        SUB_OFFSETS.put("LIGHTING", new Float(0.34f));
        SUB_OFFSETS.put("HVAC", new Float(0.42f));
        SUB_OFFSETS.put("PLUG", new Float(0.24f));
        SITE_ELEC_OFFSETS = new Hashtable();
        SITE_ELEC_OFFSETS.put("ARLINGTON", new Float(1.11f));
        SITE_ELEC_OFFSETS.put("ATLANTA", new Float(1.12f));
        SITE_ELEC_OFFSETS.put("AUGUSTA", new Float(1.02f));
        SITE_ELEC_OFFSETS.put("BLUEFIELD", new Float(1.13f));
        SITE_ELEC_OFFSETS.put("CHARLESTON", new Float(1.07f));
        SITE_ELEC_OFFSETS.put("CHARLOTTE", new Float(1.08f));
        SITE_ELEC_OFFSETS.put("COLUMBUS", new Float(1.015f));
        SITE_ELEC_OFFSETS.put("FLORENCE", new Float(0.98f));
        SITE_ELEC_OFFSETS.put("GREENVILLE", new Float(1.005f));
        SITE_ELEC_OFFSETS.put("HUNTINGTON", new Float(0.995f));
        SITE_ELEC_OFFSETS.put("LYNCHBURG", new Float(1.003f));
        SITE_ELEC_OFFSETS.put("MACON", new Float(0.998f));
        SITE_ELEC_OFFSETS.put("NORFOLK", new Float(1.0f));
        SITE_ELEC_OFFSETS.put("PARKERSBURG", new Float(1.012f));
        SITE_ELEC_OFFSETS.put("RALEIGH", new Float(0.999f));
        SITE_ELEC_OFFSETS.put("RICHMOND EAST", new Float(1.008f));
        SITE_ELEC_OFFSETS.put("RICHMOND WEST", new Float(1.019f));
        SITE_ELEC_OFFSETS.put("SAVANNAH", new Float(0.993f));
        SITE_ELEC_OFFSETS.put("SPARTANBURG", new Float(1.029f));
        SITE_ELEC_OFFSETS.put("WATERSON", new Float(0.98f));
        SITE_ELEC_OFFSETS.put("WHEELING", new Float(1.009f));
        SITE_ELEC_OFFSETS.put("WILMINGTON", new Float(0.996f));
        SITE_ELEC_OFFSETS.put("WINSTON SALEM", new Float(1.011f));
        SITE_GAS_OFFSETS = new Hashtable();
        SITE_GAS_OFFSETS.put("ARLINGTON", new Float(1.12f));
        SITE_GAS_OFFSETS.put("ATLANTA", new Float(1.08f));
        SITE_GAS_OFFSETS.put("AUGUSTA", new Float(1.02f));
        SITE_GAS_OFFSETS.put("BLUEFIELD", new Float(1.06f));
        SITE_GAS_OFFSETS.put("CHARLESTON", new Float(1.09f));
        SITE_GAS_OFFSETS.put("CHARLOTTE", new Float(1.06f));
        SITE_GAS_OFFSETS.put("COLUMBUS", new Float(1.015f));
        SITE_GAS_OFFSETS.put("FLORENCE", new Float(0.98f));
        SITE_GAS_OFFSETS.put("GREENVILLE", new Float(1.005f));
        SITE_GAS_OFFSETS.put("HUNTINGTON", new Float(0.995f));
        SITE_GAS_OFFSETS.put("LYNCHBURG", new Float(1.003f));
        SITE_GAS_OFFSETS.put("MACON", new Float(0.998f));
        SITE_GAS_OFFSETS.put("NORFOLK", new Float(1.0f));
        SITE_GAS_OFFSETS.put("PARKERSBURG", new Float(1.012f));
        SITE_GAS_OFFSETS.put("RALEIGH", new Float(0.999f));
        SITE_GAS_OFFSETS.put("RICHMOND EAST", new Float(1.008f));
        SITE_GAS_OFFSETS.put("RICHMOND WEST", new Float(1.019f));
        SITE_GAS_OFFSETS.put("SAVANNAH", new Float(0.993f));
        SITE_GAS_OFFSETS.put("SPARTANBURG", new Float(1.029f));
        SITE_GAS_OFFSETS.put("WATERSON", new Float(0.98f));
        SITE_GAS_OFFSETS.put("WHEELING", new Float(1.009f));
        SITE_GAS_OFFSETS.put("WILMINGTON", new Float(0.996f));
        SITE_GAS_OFFSETS.put("WINSTON SALEM", new Float(1.011f));
        log = Log.getLog((String)"easdemo");
    }
}

