/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.EasDPNode;
import com.tridium.easdemo.EasMeterNode;
import com.tridium.easdemo.EasSiteNode;
import com.tridium.easdemo.xml.TAttributeList;
import com.tridium.easdemo.xml.TLocation;
import com.tridium.easdemo.xml.TStateHandler;

public class EasDatapointHandler
extends TStateHandler {
    private int state;
    private EasMeterNode meterNode;
    private EasDPNode datapointNode;
    private static final int IGNORE = 0;
    private static final int ID = 1;
    private static final int NAME = 2;
    private static final int DESCRIPTION = 3;
    private static final int TYPE = 4;
    private static final int SUBTYPE = 5;
    private static final int MAIN = 6;
    private static final int FUNIT = 9;
    private static final int FVALUE = 10;
    private static final int STATION = 11;
    private static final int METER = 12;

    public EasDatapointHandler(TStateHandler tStateHandler, TAttributeList tAttributeList, TLocation tLocation, EasSiteNode easSiteNode) {
        super(tStateHandler);
        this.createDatapoint(tAttributeList, tLocation, easSiteNode);
    }

    public void createDatapoint(TAttributeList tAttributeList, TLocation tLocation, EasSiteNode easSiteNode) {
        this.datapointNode = new EasDPNode(Integer.parseInt(tAttributeList.get("handle")));
        this.datapointNode.setParentSite(easSiteNode);
        easSiteNode.addChild(this.datapointNode);
    }

    public void startElement(String string, TAttributeList tAttributeList, TLocation tLocation) throws Exception {
        if (string.equals("id")) {
            this.state = 1;
        } else if (string.equals("name")) {
            this.state = 2;
        } else if (string.equals("description")) {
            this.state = 3;
        } else if (string.equals("type")) {
            this.state = 4;
        } else if (string.equals("subtype")) {
            this.state = 5;
        } else if (string.equals("main")) {
            this.state = 6;
        } else if (string.equals("floorareaUnit")) {
            this.state = 9;
        } else if (string.equals("floorareaValue")) {
            this.state = 10;
        } else if (string.equals("stationId")) {
            this.state = 11;
        } else if (string.equals("meterId")) {
            this.state = 12;
        } else {
            throw new Exception("Encountered tag <" + string + ">");
        }
    }

    public void endElement(String string, TLocation tLocation) throws Exception {
        if (string.equals("datapoint")) {
            this.popHandler(tLocation);
        }
        this.state = 0;
    }

    public void characters(char[] cArray, int n, int n2, TLocation tLocation) throws Exception {
        switch (this.state) {
            case 0: {
                return;
            }
            case 1: {
                this.datapointNode.setId(Integer.parseInt(new String(cArray, n, n2)));
                break;
            }
            case 2: {
                this.datapointNode.setName(new String(cArray, n, n2));
                break;
            }
            case 3: {
                this.datapointNode.setDescription(new String(cArray, n, n2));
                break;
            }
            case 4: {
                this.datapointNode.setRcType(new String(cArray, n, n2));
                break;
            }
            case 5: {
                this.datapointNode.setRcSubType(new String(cArray, n, n2));
                break;
            }
            case 6: {
                this.datapointNode.setIsMain(Boolean.valueOf(new String(cArray, n, n2)));
                break;
            }
            case 9: {
                this.datapointNode.setFUnit(new String(cArray, n, n2));
                break;
            }
            case 10: {
                this.datapointNode.setFValue(new Integer(new String(cArray, n, n2)));
                break;
            }
            case 12: {
                this.addToMeter(Integer.parseInt(new String(cArray, n, n2)));
                break;
            }
            default: {
                throw new IllegalStateException("Bad state: " + this.state);
            }
        }
    }

    public void processingInstruction(String string, String string2, TLocation tLocation) throws Exception {
    }

    public void addToMeter(int n) {
        this.meterNode = EasMeterNode.getMeter(n);
        if (this.meterNode != null) {
            this.datapointNode.setParentMeter(this.meterNode);
            this.meterNode.addChild(this.datapointNode);
        }
    }
}

