/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.BEasDemoGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class EasCsvImporter {
    private String curLine;
    private String fileName;
    private BufferedReader reader;

    public EasCsvImporter(String string) {
        this.fileName = string;
    }

    public void open() throws IOException {
        try {
            File file = new File(BEasDemoGenerator.getEasDemoYearDirectory(), this.fileName);
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (Exception exception) {
            this.reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/com/tridium/easdemo/docs/" + this.fileName)));
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean next() {
        boolean bl = true;
        try {
            String string = this.reader.readLine();
            this.curLine = string != null ? string : "";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.curLine.equals("")) {
            bl = false;
        }
        return bl;
    }

    public String getRow() {
        return this.curLine;
    }

    public String[] getRowAsArray(int n) {
        String[] stringArray = new String[n];
        if (!this.curLine.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.curLine, ",");
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public String getToken(int n) {
        String[] stringArray = new String[n + 1];
        String string = "";
        if (!this.curLine.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.curLine, ",");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    for (int i = 0; i < n + 1; ++i) {
                        stringArray[i] = stringTokenizer.nextToken();
                    }
                    string = stringArray[n];
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string;
    }
}

