/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.eas.BEasService;
import com.tridium.easdemo.BDemoDataParameters;
import com.tridium.easdemo.BDemoYearDataTypeEnum;
import com.tridium.easdemo.BYearEnum;
import com.tridium.easdemo.BYearTemplateParameters;
import com.tridium.easdemo.MasterDemoGen;
import com.tridium.easdemo.YearGenerator;
import java.io.File;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BEasDemoGenerator
extends BComponent
implements Runnable {
    public static final Action generateDemoData = BEasDemoGenerator.newAction((int)128, (BValue)new BDemoDataParameters(), null);
    public static final Action generateYearTemplate = BEasDemoGenerator.newAction((int)128, (BValue)new BYearTemplateParameters(), null);
    public static final Action purgeGeneratedYearTemplates = BEasDemoGenerator.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$easdemo$BEasDemoGenerator == null ? (class$com$tridium$easdemo$BEasDemoGenerator = BEasDemoGenerator.class$("com.tridium.easdemo.BEasDemoGenerator")) : class$com$tridium$easdemo$BEasDemoGenerator));
    private static boolean easFeatureLicensed = false;
    private static final BIcon icon = BIcon.make((String)"module://eas/com/tridium/eas/ui/images/trend.png");
    public static final Log log = Log.getLog((String)"easdemo");
    private static boolean generatingData = false;
    private static Object syncObject = new Object();
    private BDemoDataParameters demoDataParameters;
    static /* synthetic */ Class class$com$tridium$easdemo$BEasDemoGenerator;

    public void generateDemoData(BDemoDataParameters bDemoDataParameters) {
        this.invoke(generateDemoData, (BValue)bDemoDataParameters, null);
    }

    public void generateYearTemplate(BYearTemplateParameters bYearTemplateParameters) {
        this.invoke(generateYearTemplate, (BValue)bYearTemplateParameters, null);
    }

    public void purgeGeneratedYearTemplates() {
        this.invoke(purgeGeneratedYearTemplates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BEasService;
    }

    public void started() throws Exception {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "eas");
        if (feature == null) {
            throw new FeatureNotLicensedException("eas not licensed");
        }
        feature.check();
        easFeatureLicensed = true;
    }

    public BEasService getEasService() {
        return (BEasService)this.getParent();
    }

    public static File getEasDemoYearDirectory() {
        File file = Sys.getStationHome();
        return new File(file, "easDemoYearTemplates");
    }

    public static void purgeYear(int n) {
        File file;
        if (!easFeatureLicensed) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Purging year template data for " + n + "...");
        }
        if ((file = BEasDemoGenerator.getEasDemoYearDirectory()).exists()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].startsWith(Integer.toString(n))) continue;
                    File file2 = new File(file, stringArray[i]);
                    file2.delete();
                }
            }
            if ((stringArray = file.list()) == null || stringArray.length == 0) {
                file.delete();
            }
        }
        if (log.isTraceOn()) {
            log.trace("Finished purging year template data for " + n);
        }
    }

    public static void createMissingYear(int n) {
        if (!easFeatureLicensed) {
            return;
        }
        BYearTemplateParameters bYearTemplateParameters = new BYearTemplateParameters();
        bYearTemplateParameters.setNewYear(n);
        bYearTemplateParameters.setModelYear(BYearEnum.y2005);
        bYearTemplateParameters.setDataType(BDemoYearDataTypeEnum.normal);
        if (log.isTraceOn()) {
            log.trace("Creating missing template year " + n + "...");
        }
        BEasDemoGenerator.generateYear(bYearTemplateParameters);
    }

    private static void generateYear(BYearTemplateParameters bYearTemplateParameters) {
        try {
            File file = BEasDemoGenerator.getEasDemoYearDirectory();
            if (!file.exists()) {
                file.mkdirs();
            }
            YearGenerator yearGenerator = new YearGenerator(bYearTemplateParameters.getModelYear().getOrdinal(), bYearTemplateParameters.getNewYear(), file, bYearTemplateParameters.getDataType());
            yearGenerator.generate();
            if (log.isTraceOn()) {
                log.trace("Successfully generated " + bYearTemplateParameters.getNewYear() + " template year data using model year " + bYearTemplateParameters.getModelYear().getOrdinal() + ".");
            }
        }
        catch (Exception exception) {
            log.error("Could not generate year template for " + bYearTemplateParameters.getNewYear() + " from " + bYearTemplateParameters.getModelYear().getOrdinal(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateYearTemplate(BYearTemplateParameters bYearTemplateParameters) {
        if (this.isRunning()) {
            if (!easFeatureLicensed) {
                log.warning("Cannot invoke action because eas not licensed!");
                return;
            }
            Object object = syncObject;
            synchronized (object) {
                if (generatingData) {
                    throw new LocalizableRuntimeException("easdemo", "error.generationInProgress");
                }
            }
            object = new Thread((Runnable)new YearGeneration(bYearTemplateParameters), "EasYearTemplateGenerator");
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPurgeGeneratedYearTemplates() {
        if (this.isRunning()) {
            if (!easFeatureLicensed) {
                log.warning("Cannot invoke action because eas not licensed!");
                return;
            }
            Object object = syncObject;
            synchronized (object) {
                if (generatingData) {
                    log.error("Cannot purge generated year templates because there is a data generation already in progress.");
                    throw new LocalizableRuntimeException("easdemo", "error.generationInProgress");
                }
                generatingData = true;
            }
            if (log.isTraceOn()) {
                log.trace("Purging all generated year template data...");
            }
            try {
                object = BEasDemoGenerator.getEasDemoYearDirectory();
                if (((File)object).exists()) {
                    String[] stringArray = ((File)object).list();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            File file = new File((File)object, stringArray[i]);
                            file.delete();
                        }
                    }
                    ((File)object).delete();
                }
                if (log.isTraceOn()) {
                    log.trace("Finished purging all generated year template data.");
                }
            }
            catch (Exception exception) {
                log.error("Encountered a problem purging the generated year templates.", (Throwable)exception);
            }
            finally {
                Object object2 = syncObject;
                synchronized (object2) {
                    generatingData = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateDemoData(BDemoDataParameters bDemoDataParameters) {
        if (this.isRunning()) {
            if (!easFeatureLicensed) {
                log.warning("Cannot invoke action because eas not licensed!");
                return;
            }
            Object object = syncObject;
            synchronized (object) {
                if (generatingData) {
                    throw new LocalizableRuntimeException("easdemo", "error.generationInProgress");
                }
            }
            this.demoDataParameters = bDemoDataParameters;
            object = new Thread((Runnable)this, "EasDemoGenerator");
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!easFeatureLicensed) {
            return;
        }
        BEasService bEasService = this.getEasService();
        if (bEasService == null) {
            log.error("Cannot generate demo data because the Eas Service could not be found.");
            return;
        }
        if (!bEasService.isOperational()) {
            log.error("Cannot generate demo data because the Eas Service is not operational.");
            return;
        }
        if (!bEasService.getDatabaseConfiguration().getDatabaseConnected()) {
            log.error("Cannot generate demo data because the Eas Service's database is not connected.");
            return;
        }
        Object object = syncObject;
        synchronized (object) {
            if (generatingData) {
                log.error("Cannot generate demo data because there is a data generation already in progress.");
                return;
            }
            generatingData = true;
            bEasService.configFail("Cannot use while demo data is being generated...");
        }
        try {
            object = new MasterDemoGen(bEasService, this.demoDataParameters);
            ((MasterDemoGen)object).generate();
        }
        catch (Exception exception) {
            log.error("Caught exception while generating EAS demo data.", (Throwable)exception);
        }
        object = syncObject;
        synchronized (object) {
            generatingData = false;
            if (bEasService.getDatabaseConfiguration().getDatabaseConnected()) {
                bEasService.configOk();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class YearGeneration
    implements Runnable {
        private BYearTemplateParameters yearTemplateParameters;

        public YearGeneration(BYearTemplateParameters bYearTemplateParameters) {
            this.yearTemplateParameters = bYearTemplateParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = syncObject;
            synchronized (object) {
                if (generatingData) {
                    log.error("Cannot generate " + this.yearTemplateParameters.getNewYear() + " year template because there is a data generation already in progress.");
                    return;
                }
                generatingData = true;
            }
            if (log.isTraceOn()) {
                log.trace("Issued request to generating year template data for " + this.yearTemplateParameters.getNewYear() + " using model year " + this.yearTemplateParameters.getModelYear().getOrdinal() + ".");
            }
            BEasDemoGenerator.generateYear(this.yearTemplateParameters);
            object = syncObject;
            synchronized (object) {
                generatingData = false;
            }
        }
    }
}

