/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.baja.log.Log;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;

public final class WebDev {
    private static final Map webDevs;
    private static final Log log;
    private static volatile Properties props;
    private static volatile BAbsTime lastModified;
    private String name;
    private boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final WebDev get(String string) {
        WebDev.load();
        WebDev webDev = null;
        Map map = webDevs;
        synchronized (map) {
            webDev = (WebDev)webDevs.get(string);
            if (webDev == null) {
                webDev = new WebDev(string);
                webDevs.put(string, webDev);
                lastModified = BAbsTime.now();
            }
            return webDev;
        }
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
        lastModified = BAbsTime.now();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final WebDev[] getWebDevs() {
        Map map = webDevs;
        synchronized (map) {
            Object[] objectArray = new WebDev[webDevs.size()];
            Object[] objectArray2 = new String[objectArray.length];
            Object[] objectArray3 = webDevs.keySet().toArray();
            int n = 0;
            while (true) {
                if (n >= objectArray3.length) {
                    SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
                    return objectArray;
                }
                objectArray[n] = (WebDev)webDevs.get(objectArray3[n]);
                objectArray2[n] = ((WebDev)objectArray[n]).getName().toLowerCase();
                ++n;
            }
        }
    }

    public static final BAbsTime getLastModified() {
        WebDev.load();
        return lastModified;
    }

    public static final File getWebDevFile() {
        return new File(System.getProperty("baja.home") + File.separator + "lib" + File.separator + "webdev.properties");
    }

    public static final void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(WebDev.getWebDevFile()));
            printWriter.println("#");
            printWriter.println("# WebDev file saved: " + new Date());
            printWriter.println("#");
            WebDev[] webDevArray = WebDev.getWebDevs();
            int n = 0;
            while (n < webDevArray.length) {
                printWriter.println(webDevArray[n].getName() + '=' + (webDevArray[n].isEnabled() ? "true" : "false"));
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Canot save 'webdev.properties'");
            System.out.println("  " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void load() {
        var0 = WebDev.webDevs;
        synchronized (var0) {
            block9: {
                if (WebDev.props != null) break block9;
                WebDev.props = new Properties();
                ** try [egrp 1[TRYBLOCK] [2 : 28->92)] { 
lbl7:
                // 1 sources

                {
                    var2_1 = WebDev.getWebDevFile();
                    try {
                        var3_2 = var2_1.lastModified();
                        WebDev.lastModified = var3_2 <= 0L ? BAbsTime.now() : BAbsTime.make((long)var3_2);
                    }
                    catch (Exception var3_3) {
                        WebDev.lastModified = BAbsTime.now();
                    }
                    var3_4 = new FileInputStream((File)var2_1);
                    WebDev.props.load(var3_4);
                    var3_4.close();
                }
lbl21:
                // 1 sources

                catch (Exception v1) {}
                if (WebDev.props != null) {
                    var2_1 = WebDev.props.keys();
                    while (var2_1.hasMoreElements()) {
                        var3_4 = var2_1.nextElement();
                        var4_5 = new WebDev(var3_4.toString(), WebDev.props.get(var3_4).equals("true"));
                        WebDev.webDevs.put(var3_4.toString(), var4_5);
                    }
                }
            }
            return;
        }
    }

    private WebDev(String string) {
        this.name = string;
    }

    private WebDev(String string, boolean bl) {
        this.name = string;
        this.enabled = bl;
    }

    static {
        Spy.ROOT.add("webDevSetup", (Spy)new WebDevSpy());
        webDevs = new HashMap();
        log = Log.getLog((String)"webDev");
        lastModified = BAbsTime.NULL;
    }

    private static class WebDevSpy
    extends Spy
    implements ISpyDir {
        public String[] list() {
            return new String[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Spy find(String string) {
            if (string.equals("save")) {
                log.message("Saved 'webdev.properties'.");
                WebDev.save();
                return new MessageWebDevSetupSpy("Saved 'webdev.properties' file");
            }
            if (string.equals("enableAll")) {
                Map map = webDevs;
                synchronized (map) {
                    Iterator iterator = webDevs.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return new MessageWebDevSetupSpy("Enabled All");
                        }
                        WebDev webDev = (WebDev)webDevs.get(iterator.next());
                        webDev.setEnabled(true);
                    }
                }
            }
            if (string.equals("disableAll")) {
                Map map = webDevs;
                synchronized (map) {
                    Iterator iterator = webDevs.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return new MessageWebDevSetupSpy("Disabled All");
                        }
                        WebDev webDev = (WebDev)webDevs.get(iterator.next());
                        webDev.setEnabled(false);
                    }
                }
            }
            if (string.indexOf("enable-") == 0) {
                String string2 = string.substring(7, string.length());
                Map map = webDevs;
                synchronized (map) {
                    WebDev webDev = (WebDev)webDevs.get(string2);
                    // MONITOREXIT @DISABLED, blocks:[2, 20, 6] lbl43 : MonitorExitStatement: MONITOREXIT : var4_10
                    if (webDev == null) return new MessageWebDevSetupSpy("Error enabing: could not find: " + string2);
                    webDev.setEnabled(true);
                    return new MessageWebDevSetupSpy("Enabled: " + string2);
                }
            }
            if (string.indexOf("disable-") != 0) {
                return null;
            }
            String string3 = string.substring(8, string.length());
            Map map = webDevs;
            synchronized (map) {
                WebDev webDev = (WebDev)webDevs.get(string3);
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl57 : MonitorExitStatement: MONITOREXIT : var4_11
                if (webDev == null) return new MessageWebDevSetupSpy("Error disabling: could not find: " + string3);
                webDev.setEnabled(false);
                return new MessageWebDevSetupSpy("Disabled: " + string3);
            }
        }

        public void write(SpyWriter spyWriter) throws Exception {
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Web Devs [<a href='spy:/webDevSetup/save'>Save To File</a>] [<a href='spy:/webDevSetup/enableAll'>Enable All</a>]  [<a href='spy:/webDevSetup/disableAll'>Disable All</a>]", 2);
            spyWriter.w((Object)"<tr><th align='left'>webdev.properties</th><td align='left'>").w((Object)lastModified).w((Object)"</td></tr>\n");
            spyWriter.w((Object)"<tr><th align='left'>Module Dev Mode</th><td align='left'>").w((Object)(System.getProperty("niagara.module.dev", "false").equals("true") ? "[Enabled]" : "[Disabled]")).w((Object)"</td></tr>\n");
            spyWriter.w((Object)"<tr>").thTitle((Object)"Name").thTitle((Object)"State").w((Object)"</tr>");
            WebDev[] webDevArray = WebDev.getWebDevs();
            int n = 0;
            while (n < webDevArray.length) {
                WebDev webDev = webDevArray[n];
                String string = webDev.getName();
                boolean bl = webDev.isEnabled();
                spyWriter.w((Object)"<tr>");
                spyWriter.w((Object)"<td align='left' nowrap='true'>").w((Object)string).w((Object)"</td>");
                spyWriter.w((Object)"<td>");
                spyWriter.w((Object)"[<a href='spy:/webDevSetup/");
                spyWriter.w((Object)(bl ? "disable-" : "enable-"));
                spyWriter.w((Object)string);
                spyWriter.w((Object)"'>");
                spyWriter.w((Object)(bl ? "Enabled" : "Disabled"));
                spyWriter.w((Object)"</a>]");
                spyWriter.w((Object)"</td>");
                spyWriter.w((Object)"</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }

        private WebDevSpy() {
        }
    }

    private static final class MessageWebDevSetupSpy
    extends WebDevSpy {
        String message;

        public final void write(SpyWriter spyWriter) throws Exception {
            spyWriter.write("<br/><b>");
            spyWriter.write(this.message);
            spyWriter.write("</b><br/><br/>");
            super.write(spyWriter);
        }

        private MessageWebDevSetupSpy(String string) {
            this.message = string;
        }
    }
}

