/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.httpd.CookieUtil;
import com.tridium.net.HttpUtil;
import com.tridium.sys.license.Brand;
import com.tridium.web.SysServlet;
import com.tridium.web.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.baja.file.BFileScheme;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.log.Log;
import javax.baja.naming.BLocalScheme;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Base64;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.BWebStartConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebStartServlet {
    private static final String PATH_QUERY_PREFIX = "path=";
    private static final String INITIAL_PATH_COOKIE_NAME = "niagara_webstart_path";
    static Log log = Log.getLog((String)"web.webstart");
    private static BWebService webService;
    private static long jnlpTimestamp;
    private SysServlet sys;

    public void service(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = WebStartServlet.getWebStartConfig().getWebStartEnabled();
        boolean bl2 = this.sys.licenseWb();
        if ("/webstart/webstartparams".equals(string)) {
            if (!bl) {
                this.sendStatusWithMessage(httpServletRequest, httpServletResponse, 403, "webStart.notEnabled");
            } else if (!bl2) {
                this.sendStatusWithMessage(httpServletRequest, httpServletResponse, 403, "webStart.notLicensed");
            } else {
                this.getInitialWebStartParameters(httpServletRequest, httpServletResponse);
            }
            return;
        }
        if (!bl2 || !bl) {
            httpServletResponse.sendError(403);
            return;
        }
        if ("/webstart/jnlp".equals(string = string.toLowerCase())) {
            this.generateJnlpDownloadPage(webService, httpServletRequest, httpServletResponse);
        } else if ("/webstart/jnlp_download".equals(string)) {
            this.getJnlpRedirectForHost(httpServletRequest, httpServletResponse);
        } else if (string.startsWith("/webstart/jnlp_redirect/")) {
            this.generateJnlpForWebStartApp(httpServletRequest, httpServletResponse);
        } else if ("/webstart/wbwebstart.jnlp".equals(string)) {
            this.generateJnlpForWebStartApp(httpServletRequest, httpServletResponse);
        } else if ("/webstart/jnlpdownload.css".equals(string)) {
            this.getJnlpDownloadPageCss(httpServletRequest, httpServletResponse);
        } else if ("/webstart/shortcut-icon".equals(string)) {
            this.getShortcutIcon(httpServletRequest, httpServletResponse);
        } else if ("/webstart/app-icon".equals(string)) {
            this.getBrandAppIcon(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private final void sendStatusWithMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws Exception {
        String string2 = Lexicon.make((String)"web", (Context)new WebStartJnlpContext(httpServletRequest)).get(string);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string2);
        printWriter.close();
        httpServletResponse.setStatus(n);
    }

    public void getJnlpRedirectForHost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = "/webstart/jnlp_redirect/" + Sys.getStation().getStationName() + ".jnlp";
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null) {
            string = string + '?' + string2;
        }
        httpServletResponse.setContentType("application/x-java-jnlp-file");
        httpServletResponse.sendRedirect(WebUtil.getRedirect(httpServletRequest, string));
    }

    static String getCodeBaseHref(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        stringBuffer.append(string).append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equalsIgnoreCase("https") && n != 443 || string.equalsIgnoreCase("http") && n != 80) {
            stringBuffer.append(':').append(n);
        }
        stringBuffer.append(WebUtil.getAbsolutePathBase(httpServletRequest));
        return stringBuffer.toString();
    }

    private final String getJnlpHref(HttpServletRequest httpServletRequest) {
        return WebUtil.getAbsolutePathBase(httpServletRequest) + "webstart/wbwebstart.jnlp";
    }

    static String getAppletHref() {
        String string = Sys.getRegistry().getModule("web").getVendorVersion().toString();
        return "wbapplet-" + string + ".jar";
    }

    /*
     * Exception decompiling
     */
    public void generateJnlpForWebStartApp(HttpServletRequest var1_1, HttpServletResponse var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 588->592)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final long getJnlpModificationDate() {
        return jnlpTimestamp / 1000L * 1000L;
    }

    public static void onWebStartConfigChanged() {
        jnlpTimestamp = System.currentTimeMillis();
    }

    private final boolean createMenuShortcut() {
        return WebStartServlet.getWebStartConfig().getCreateStartMenuShortcut();
    }

    private final boolean createDesktopShortcut() {
        return WebStartServlet.getWebStartConfig().getCreateDesktopShortcut();
    }

    private final String getSubMenuText(HttpServletRequest httpServletRequest) {
        BFormat bFormat = WebStartServlet.getWebStartConfig().getShortcutFolderName();
        return bFormat.format((Object)new ShortcutFormatValues(httpServletRequest));
    }

    private final String getTitle(HttpServletRequest httpServletRequest) {
        BFormat bFormat = WebStartServlet.getWebStartConfig().getAppTitle();
        return bFormat.format((Object)new ShortcutFormatValues(httpServletRequest));
    }

    private final String getVendor() {
        return JnlpOptions.instance().getBrandVendor();
    }

    private final Iterator getArguments() throws Exception {
        JnlpOptions jnlpOptions = JnlpOptions.instance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-title " + WebStartServlet.encodeArgumentText(jnlpOptions.getAppTitle()));
        if (jnlpOptions.hasBrandAppIcon()) {
            arrayList.add("-icon");
        }
        return arrayList.iterator();
    }

    private static final String encodeArgumentText(String string) throws Exception {
        byte[] byArray = string.getBytes("UTF-8");
        return Base64.encode((byte[])byArray);
    }

    private final void setJnlpCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith(PATH_QUERY_PREFIX)) continue;
                try {
                    String string3 = URLDecoder.decode(string2.substring(PATH_QUERY_PREFIX.length()), "UTF-8");
                    Cookie cookie = new Cookie(CookieUtil.getCookieName(httpServletRequest, INITIAL_PATH_COOKIE_NAME), string3);
                    cookie.setPath(WebUtil.getAbsolutePathBase(httpServletRequest));
                    cookie.setMaxAge(-1);
                    httpServletResponse.addCookie(cookie);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        }
    }

    private final void getShortcutIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.sendImageFile(JnlpOptions.instance().getShortcutIconOrd(), httpServletRequest, httpServletResponse);
    }

    private final void getBrandAppIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        JnlpOptions jnlpOptions = JnlpOptions.instance();
        if (!jnlpOptions.hasBrandAppIcon()) {
            httpServletResponse.sendError(404);
            return;
        }
        this.sendImageFile(jnlpOptions.getBrandAppIconOrd(), httpServletRequest, httpServletResponse);
    }

    private final void sendImageFile(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        BOrd bOrd = BOrd.make((String)string).normalize();
        if (!bOrd.isNull()) {
            BIFile bIFile;
            OrdQuery[] ordQueryArray = bOrd.parse();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            while (n < ordQueryArray.length) {
                if (BModuleScheme.INSTANCE.getId().equals(ordQueryArray[n].getScheme())) {
                    bl = true;
                } else if (BFileScheme.INSTANCE.getId().equals(ordQueryArray[n].getScheme())) {
                    FilePath filePath = (FilePath)ordQueryArray[n];
                    if (this.isValidImageDirectory(filePath)) {
                        bl4 = true;
                    } else if (log.isTraceOn()) {
                        log.trace("Forbidden file path for web start brand image: " + filePath);
                    }
                } else if (ordQueryArray[n].isHost()) {
                    if (!BLocalScheme.INSTANCE.getId().equals(ordQueryArray[n].getScheme())) {
                        bl2 = true;
                    }
                } else {
                    bl3 = true;
                }
                ++n;
            }
            if ((bl || bl4) && !bl2 && !bl3 && (bIFile = this.resolveImageFile(bOrd)) != null) {
                this.sys.sendFile(httpServletRequest, httpServletResponse, bIFile);
                return;
            }
        }
        httpServletResponse.sendError(404);
    }

    private final BIFile resolveImageFile(BOrd bOrd) {
        block5: {
            try {
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                if (!bIFile.isDirectory() && this.isValidImageFileType(bIFile)) {
                    return bIFile;
                }
            }
            catch (UnresolvedException unresolvedException) {
                if (log.isTraceOn()) {
                    log.trace("Could not resolve brand image ord for web start: " + bOrd.toDebugString());
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block5;
                log.trace("Error getting brand image for web start.", (Throwable)exception);
            }
        }
        return null;
    }

    private final boolean isValidImageDirectory(FilePath filePath) {
        String[] stringArray;
        return filePath.isSysHomeAbsolute() && (stringArray = filePath.getNames()).length == 3 && "workbench".equals(stringArray[0]) && "webstart".equals(stringArray[1]);
    }

    private final boolean isValidImageFileType(BIFile bIFile) {
        String string = bIFile.getMimeType();
        boolean bl = false;
        if ("image/gif".equals(string) || "image/png".equals(string) || "image/x-icon".equals(string) || "image/jpeg".equals(string)) {
            bl = true;
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private final void getInitialWebStartParameters(HttpServletRequest var1_1, HttpServletResponse var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 176->180)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void generateJnlpDownloadPage(BWebService var1_1, HttpServletRequest var2_2, HttpServletResponse var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 541->545)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void getJnlpDownloadPageCss(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        BOrd bOrd = BOrd.make((String)"module://web/com/tridium/web/rc/jnlpdownload.css");
        BIFile bIFile = (BIFile)bOrd.resolve().get();
        this.sys.sendFile(httpServletRequest, httpServletResponse, bIFile);
    }

    private static final BWebStartConfig getWebStartConfig() {
        if (webService == null) {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        return webService.getWebStartConfig();
    }

    static String makeWebStartJnlpPath(String string) {
        return "webstart/wbwebstart.jnlp?path=" + HttpUtil.encodeUrl((String)string);
    }

    WebStartServlet(SysServlet sysServlet) {
        this.sys = sysServlet;
    }

    static {
        jnlpTimestamp = System.currentTimeMillis();
    }

    private static class WebStartJnlpContext
    implements Context {
        String lang;

        public String getLanguage() {
            return this.lang;
        }

        public BObject getFacet(String string) {
            return null;
        }

        public BFacets getFacets() {
            return null;
        }

        public BUser getUser() {
            return null;
        }

        public Context getBase() {
            return null;
        }

        public WebStartJnlpContext(HttpServletRequest httpServletRequest) {
            this.lang = WebUtil.getLocale(httpServletRequest, null).toString();
        }
    }

    private static class JnlpOptions {
        private static final String DEFAULT_APP_TITLE = "Niagara Web Start";
        private static final String DEFAULT_SHORTCUT_ICON = "module://icons/x32/workbench.png";
        private static final String DEFAULT_VENDOR = "Tridium";
        private String vmArgs;
        private String appTitle;
        private String shortcutIcon;
        private String appIcon;
        private String brandVendor;

        static JnlpOptions instance() {
            return JnlpOptionsHolder.INSTANCE;
        }

        private final String getAppTitle() {
            return this.appTitle;
        }

        private final String getJavaVmOptions() {
            return this.vmArgs;
        }

        private final String getShortcutIconOrd() {
            return this.shortcutIcon;
        }

        private final String getBrandVendor() {
            return this.brandVendor;
        }

        private final boolean hasBrandAppIcon() {
            boolean bl = false;
            if (this.appIcon != null) {
                bl = true;
            }
            return bl;
        }

        private final String getBrandAppIconOrd() {
            return this.appIcon;
        }

        private final void loadVmOptions() {
            try {
                File file = new File(Sys.getBajaHome(), "lib" + File.separator + "nre.properties");
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    this.vmArgs = properties.getProperty("webstart.java.options", null);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private final void loadBrandOptions() {
            block6: {
                this.appTitle = DEFAULT_APP_TITLE;
                this.shortcutIcon = DEFAULT_SHORTCUT_ICON;
                this.brandVendor = DEFAULT_VENDOR;
                try {
                    File file = new File(Sys.getBajaHome(), "lib" + File.separator + "brand.properties");
                    if (!file.exists()) break block6;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    this.appTitle = properties.getProperty("webstart.title", DEFAULT_APP_TITLE);
                    this.shortcutIcon = properties.getProperty("webstart.shortcut.icon", DEFAULT_SHORTCUT_ICON);
                    this.appIcon = properties.getProperty("webstart.icon", null);
                    this.brandVendor = properties.getProperty("webstart.vendor", null);
                    if (this.brandVendor != null) break block6;
                    try {
                        this.brandVendor = Brand.getBrandId();
                    }
                    catch (FeatureNotLicensedException featureNotLicensedException) {
                    }
                    catch (LicenseDatabaseException licenseDatabaseException) {}
                    if (this.brandVendor == null) {
                        this.brandVendor = properties.getProperty("brand.id", DEFAULT_VENDOR);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        static final /* synthetic */ String access$0(JnlpOptions jnlpOptions) {
            return jnlpOptions.getJavaVmOptions();
        }

        private JnlpOptions() {
            this.loadVmOptions();
            this.loadBrandOptions();
        }

        private static class JnlpOptionsHolder {
            private static final JnlpOptions INSTANCE = new JnlpOptions();

            private JnlpOptionsHolder() {
            }
        }
    }

    public static class ShortcutFormatValues {
        private final String server;
        private final String station;

        public String getServer() {
            return this.server;
        }

        public String getStation() {
            return this.station;
        }

        public String getApp() {
            return JnlpOptions.instance().getAppTitle();
        }

        public String getVendor() {
            return JnlpOptions.instance().getBrandVendor();
        }

        private ShortcutFormatValues(HttpServletRequest httpServletRequest) {
            String string = WebUtil.getAbsolutePathBase(httpServletRequest);
            String string2 = httpServletRequest.getHeader("host");
            this.server = string.startsWith("/tunnel/") ? string.substring("/tunnel/".length(), string.length() - 1) : (string2 != null ? HttpUtil.parseHost((String)string2) : "localhost");
            this.station = WebUtil.getStationDisplayName(new WebStartJnlpContext(httpServletRequest));
        }
    }
}

