/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import java.io.File;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.sys.BModule;
import javax.baja.web.WebDev;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpHeaderUtil {
    public static int MAX_AGE_ONE_DAY = 86400;
    public static int MAX_AGE_THREE_DAYS = 259200;
    public static final String H_ACCEPT_ENCODING = "accept-encoding";
    public static final String H_CACHE_CONTROL = "cache-control";
    public static final String H_CONTENT_ENCODING = "content-encoding";
    public static final String H_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String H_LAST_MODIFIED = "Last-Modified";
    public static final String H_TRANSFER_ENCODING = "transfer-encoding";
    public static final String ADD_EXPIRES_PROPERTY = "niagara.web.addExpires";

    public static long getLastModified(BIFile bIFile) {
        return bIFile.getLastModified().getMillis() / 1000L * 1000L;
    }

    public static long getLastModified(File file) {
        return file.lastModified() / 1000L * 1000L;
    }

    public static void setLastModified(HttpServletResponse httpServletResponse, BIFile bIFile) {
        long l = HttpHeaderUtil.getLastModified(bIFile);
        httpServletResponse.setDateHeader(H_LAST_MODIFIED, l);
    }

    public static void setLastModified(HttpServletResponse httpServletResponse, File file) {
        long l = HttpHeaderUtil.getLastModified(file);
        httpServletResponse.setDateHeader(H_LAST_MODIFIED, l);
    }

    public static boolean isModifiedSince(HttpServletRequest httpServletRequest, BIFile bIFile) {
        long l = HttpHeaderUtil.getLastModified(bIFile);
        long l2 = httpServletRequest.getDateHeader(H_IF_MODIFIED_SINCE);
        boolean bl = false;
        if (l2 == (long)-1 || l > l2) {
            bl = true;
        }
        return bl;
    }

    public static void cacheAndRevalidateAfter(HttpServletResponse httpServletResponse, int n) {
        httpServletResponse.setHeader(H_CACHE_CONTROL, "private, must-revalidate, max-age=" + n);
    }

    public static void cacheAndAlwaysRevalidate(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(H_CACHE_CONTROL, "private, must-revalidate");
    }

    public static void neverCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(H_CACHE_CONTROL, "no-cache, no-store");
    }

    public static boolean shouldAddExpires(BIFile bIFile) {
        if (!System.getProperty(ADD_EXPIRES_PROPERTY, "false").equals("true")) {
            return false;
        }
        BFileSpace bFileSpace = bIFile.getFileSpace();
        boolean bl = false;
        if (bFileSpace != null && bFileSpace instanceof BModule) {
            bl = true;
        }
        return bl;
    }

    public static boolean shouldDisableCache() {
        return WebDev.get("fileServlet").isEnabled();
    }

    public static void setCacheHeader(HttpServletResponse httpServletResponse, int n) {
        if (HttpHeaderUtil.shouldDisableCache()) {
            HttpHeaderUtil.neverCache(httpServletResponse);
        } else {
            HttpHeaderUtil.cacheAndRevalidateAfter(httpServletResponse, n);
        }
    }
}

