/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.Httpd;
import com.tridium.httpd.ServiceThread;
import com.tridium.web.BHttpTunnelFactory;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RequestQueue {
    public static final int DEFAULT_CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("niagara.web.defaultConnectionTimeout", "60000"));
    public static final int IDLE_THREAD_TIMEOUT = Integer.parseInt(System.getProperty("niagara.web.idleThreadTimeout", "60000"));
    public static final int SOCKET_LISTEN_TIMEOUT = Integer.parseInt(System.getProperty("niagara.web.socketListenTimeout", "750"));
    public static final int SSL_SOCKET_LISTEN_TIMEOUT = Integer.parseInt(System.getProperty("niagara.web.ssl.socketListenTimeout", "10000"));
    private static Class SSLSocketClass = null;
    private static Method startHandshake = null;
    private static Object connectIdMonitor;
    private static int nextConnectionId;
    private int busyThreads;
    private int maxQueueSize;
    private int maxThreads;
    private int minThreads;
    private int peakThreads;
    private int peakBusyThreads;
    private int peakQueueSize;
    private int peakConnections;
    private LinkedList queue;
    private boolean running;
    private ThreadGroup threadGroup;
    private double totalRequests;
    private int threadsCreated;
    LinkedList threads;
    LinkedList connections;
    Httpd httpd;

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int n) {
        this.maxQueueSize = n;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxThreads(int n) {
        this.maxThreads = n;
        RequestQueue requestQueue = this;
        synchronized (requestQueue) {
            this.notifyAll();
            return;
        }
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int n) {
        this.minThreads = n;
        if (this.running) {
            int n2 = this.getTotalThreads();
            while (n2 <= n) {
                new ServiceThread(this.threadGroup, this, "HttpdThread-" + this.threadsCreated++).start();
                ++n2;
            }
        }
    }

    public int getBusyThreads() {
        return this.busyThreads;
    }

    public void setBusyThreads(int n) {
        this.busyThreads = n;
        if (this.busyThreads > this.peakBusyThreads) {
            this.peakBusyThreads = this.busyThreads;
        }
    }

    public int getTotalThreads() {
        return this.threads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getThreads() {
        LinkedList linkedList = this.threads;
        synchronized (linkedList) {
            return this.threads.toArray();
        }
    }

    public int getPeakBusyThreads() {
        return this.peakBusyThreads;
    }

    public void setPeakBusyThreads(int n) {
        this.peakBusyThreads = n;
    }

    public int getPeakThreads() {
        return this.peakThreads;
    }

    public void setPeakThreads(int n) {
        this.peakThreads = n;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getPeakQueueSize() {
        return this.peakQueueSize;
    }

    public int getThreadsCreated() {
        return this.threadsCreated;
    }

    public double getRequestsReceived() {
        return this.totalRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getConnections() {
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            return this.connections.toArray();
        }
    }

    public int getTotalConnections() {
        return this.connections.size();
    }

    public int getPeakConnections() {
        return this.peakConnections;
    }

    public synchronized void clearQueue() {
        while (!this.queue.isEmpty()) {
            ((Connection)this.queue.removeFirst()).close();
        }
    }

    public synchronized Connection dequeue() {
        if (!this.isRunning()) {
            this.notifyAll();
            return null;
        }
        if (this.queue.size() == 0) {
            return null;
        }
        Connection connection = (Connection)this.queue.removeFirst();
        if (Httpd.serverLog.isTraceOn()) {
            Httpd.serverLog.trace("dequeuing connection " + connection.getConnectionId());
        }
        return connection;
    }

    public synchronized void enqueue(Connection connection) throws QueueFullException {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        if (this.queue.size() >= this.getMaxQueueSize()) {
            throw new QueueFullException();
        }
        if (Httpd.serverLog.isTraceOn()) {
            Httpd.serverLog.trace("enqueuing connection " + connection.getConnectionId());
        }
        if (connection.getRequestCount() == 0) {
            this.queue.addFirst(connection);
        } else {
            this.queue.addLast(connection);
        }
        if (this.queue.size() > this.getPeakQueueSize()) {
            this.peakQueueSize = this.queue.size();
        }
        if (this.getTotalThreads() - this.getBusyThreads() < this.queue.size() && this.getMaxThreads() > this.getTotalThreads()) {
            new ServiceThread(this.threadGroup, this, "HttpdThread-" + this.threadsCreated++).start();
        }
        this.notify();
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException();
        }
        this.running = true;
        int n = this.getMinThreads();
        while (--n >= 0) {
            new ServiceThread(this.threadGroup, this, "HttpdThread-" + this.threadsCreated++).start();
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.clearQueue();
        this.notifyAll();
        Iterator iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            ((ServiceThread)iterator.next()).interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int getNextConnectionId() {
        Object object = connectIdMonitor;
        synchronized (object) {
            return nextConnectionId++;
        }
    }

    private final /* synthetic */ void this() {
        this.busyThreads = 0;
        this.maxQueueSize = 1000;
        this.maxThreads = 15;
        this.minThreads = 3;
        this.peakThreads = 0;
        this.peakBusyThreads = 0;
        this.peakQueueSize = 0;
        this.peakConnections = 0;
        this.queue = new LinkedList();
        this.running = false;
        this.threadsCreated = 0;
        this.threads = new LinkedList();
        this.connections = new LinkedList();
    }

    public RequestQueue() {
        this.this();
    }

    public RequestQueue(Httpd httpd, int n, int n2, int n3) {
        this.this();
        this.threadGroup = new ThreadGroup("Service Threads");
        this.minThreads = n;
        this.maxThreads = n2;
        this.maxQueueSize = n3;
        this.httpd = httpd;
    }

    static {
        try {
            SSLSocketClass = Class.forName("javax.net.ssl.SSLSocket");
            startHandshake = SSLSocketClass.getMethod("startHandshake", new Class[0]);
        }
        catch (Exception exception) {}
        connectIdMonitor = new Object();
        nextConnectionId = 1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Connection {
        public Socket socket;
        public String serverName;
        public String scheme;
        private boolean ssl;
        private boolean firstHandshake;
        public int port;
        public int timeout;
        public long lastActivityTicks;
        public int id;
        private long created;
        private int requests;
        private String protocol;
        BufferedInputStream in;
        OutputStream out;

        public boolean isLongPoll() {
            return this.getProtocol().equals("ws");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() {
            Object object;
            if (Httpd.serverLog.isTraceOn()) {
                Httpd.serverLog.trace("closing connection " + this.id);
            }
            if (!this.isLongPoll()) {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {}
                object = (BHttpTunnelFactory)RequestQueue.this.httpd.tunnelFactory;
                if (object != null) {
                    ((BHttpTunnelFactory)object).notifyTunnelClosed(this.socket);
                }
            }
            object = RequestQueue.this.connections;
            synchronized (object) {
                RequestQueue.this.connections.remove(this);
                return;
            }
        }

        public synchronized boolean waitForRequest(int n) throws EOFException, IOException {
            int n2;
            this.in.mark(1);
            if (!this.isSsl()) {
                this.socket.setSoTimeout(n);
            }
            try {
                n2 = this.in.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                return false;
            }
            if (n2 == -1) {
                throw new EOFException();
            }
            this.in.reset();
            RequestQueue requestQueue = RequestQueue.this;
            requestQueue.totalRequests = requestQueue.totalRequests + 1.0;
            ++this.requests;
            return true;
        }

        public synchronized boolean waitForRequest() throws EOFException, IOException {
            return this.waitForRequest(this.timeout);
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public synchronized void startHandshake() {
            if (!this.firstHandshake) {
                return;
            }
            try {
                if (startHandshake != null && SSLSocketClass.isAssignableFrom(this.socket.getClass())) {
                    startHandshake.invoke((Object)this.socket, new Object[0]);
                }
            }
            catch (Exception exception) {}
            this.firstHandshake = true;
        }

        public int getRequestCount() {
            return this.requests;
        }

        public BRelTime getAge() {
            return BRelTime.make((long)(Clock.ticks() - this.created));
        }

        public BRelTime getLastActivity() {
            return BRelTime.make((long)(Clock.ticks() - this.lastActivityTicks));
        }

        public int getConnectionId() {
            return this.id;
        }

        public BRelTime getTimeout() {
            return BRelTime.make((long)this.timeout);
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String string) {
            this.protocol = string;
        }

        private final /* synthetic */ void this() {
            this.ssl = false;
            this.firstHandshake = false;
            this.timeout = DEFAULT_CONNECTION_TIMEOUT;
            this.id = 0;
            this.protocol = "http";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection(Socket socket, String string, String string2, int n) throws IOException {
            block7: {
                this.this();
                this.socket = socket;
                this.serverName = string;
                this.scheme = string2;
                this.port = n;
                this.lastActivityTicks = Clock.ticks();
                this.created = Clock.ticks();
                this.id = RequestQueue.getNextConnectionId();
                if (Httpd.serverLog.isTraceOn()) {
                    Httpd.serverLog.trace("creating connection " + this.id);
                }
                this.in = new BufferedInputStream(socket.getInputStream());
                this.out = socket.getOutputStream();
                if (string2.equalsIgnoreCase("https")) {
                    this.ssl = true;
                }
                LinkedList linkedList = RequestQueue.this.connections;
                synchronized (linkedList) {
                    RequestQueue.this.connections.add(this);
                    if (RequestQueue.this.connections.size() > RequestQueue.this.peakConnections) {
                        RequestQueue.this.peakConnections = RequestQueue.this.connections.size();
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl24 : MonitorExitStatement: MONITOREXIT : var6_6
                    if (this.in.markSupported()) break block7;
                    this.close();
                }
                Httpd.serverLog.error("Mark must be supported on the incoming input stream.");
            }
            if (this.isSsl()) {
                socket.setSoTimeout(SSL_SOCKET_LISTEN_TIMEOUT);
            }
        }
    }

    public static class QueueFullException
    extends RuntimeException {
    }
}

