/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RequestLine {
    private String method;
    private String protocol;
    private String host;
    private int port;
    private String uri;
    private String query;
    private String version;
    private int major;
    private int minor;
    private StringBuffer sbuf;

    public final String getMethod() {
        return this.method;
    }

    public final String getUri() {
        return this.uri;
    }

    public final void setUri(String string) {
        this.uri = string;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getQuery() {
        return this.query;
    }

    public final int getMajorVersion() {
        if (this.major == -1) {
            this.parseVersion(this.version);
        }
        return this.major;
    }

    public final int getMinorVersion() {
        if (this.minor == -1) {
            this.parseVersion(this.version);
        }
        return this.minor;
    }

    public void read(InputStream inputStream) throws IOException {
        this.sbuf = new StringBuffer(64);
        int n = inputStream.read();
        int n2 = 0;
        while (n2 < 4) {
            if (n == -1 || n != 10 && n != 13) break;
            n = inputStream.read();
            ++n2;
        }
        while (n != -1 && n != 32) {
            this.sbuf.append((char)n);
            n = inputStream.read();
        }
        if (n == -1) {
            throw new EOFException("EOF while on reading request line");
        }
        this.method = this.sbuf.toString();
        this.sbuf.setLength(0);
        n = inputStream.read();
        if (n != 47) {
            n = this.readFullUri(inputStream, n);
        }
        while (n != -1 && n != 32 && n != 63) {
            this.sbuf.append((char)n);
            n = inputStream.read();
        }
        this.uri = this.sbuf.toString();
        if (this.uri.length() == 0) {
            this.uri = "/";
        }
        this.sbuf.setLength(0);
        if (n == 63) {
            n = inputStream.read();
            while (n != -1 && n != 32) {
                this.sbuf.append((char)n);
                n = inputStream.read();
            }
        }
        if (this.sbuf.length() > 0) {
            this.query = this.sbuf.toString();
        }
        this.sbuf.setLength(0);
        n = inputStream.read();
        while (n != -1 && n != 13) {
            this.sbuf.append((char)n);
            n = inputStream.read();
        }
        this.version = this.sbuf.toString();
        this.sbuf.setLength(0);
        inputStream.read();
        this.sbuf = null;
    }

    private final int readFullUri(InputStream inputStream, int n) throws IOException {
        this.sbuf.setLength(0);
        int n2 = n;
        while (n2 != -1 && n2 != 58) {
            this.sbuf.append((char)n2);
            n2 = inputStream.read();
        }
        if (n2 != 58) {
            throw new IOException("Invalid URL.");
        }
        this.match(inputStream, 47);
        this.match(inputStream, 47);
        this.protocol = this.sbuf.toString();
        this.sbuf.setLength(0);
        n2 = inputStream.read();
        while (n2 != -1 && n2 != 47 && n2 != 58) {
            this.sbuf.append((char)n2);
            n2 = inputStream.read();
        }
        if (n2 == -1) {
            throw new IOException("Invalid URL.");
        }
        this.host = this.sbuf.toString();
        this.sbuf.setLength(0);
        if (n2 == 58) {
            n2 = inputStream.read();
            while (n2 != -1 && n2 != 47) {
                this.sbuf.append((char)n2);
                n2 = inputStream.read();
            }
            if (n2 == -1) {
                throw new IOException("Invalid URL");
            }
            this.port = Integer.parseInt(this.sbuf.toString());
            this.sbuf.setLength(0);
        } else {
            this.port = -1;
        }
        return n2;
    }

    private final void parseVersion(String string) {
        int n = string.lastIndexOf(47);
        this.version = string.substring(n + 1);
        n = this.version.indexOf(46);
        this.major = Integer.parseInt(this.version.substring(0, n));
        this.minor = Integer.parseInt(this.version.substring(n + 1));
    }

    protected int match(InputStream inputStream, int n) throws IOException {
        int n2 = inputStream.read();
        if (n2 == n) {
            return n2;
        }
        throw new IOException("Expecting " + (char)n);
    }

    public void write(PrintWriter printWriter) {
        printWriter.print(this.method);
        printWriter.print(' ');
        printWriter.print(this.uri);
        if (this.query != null) {
            printWriter.print('?');
            printWriter.print(this.query);
        }
        printWriter.print(' ');
        printWriter.print(this.version);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.method).append(' ');
        stringBuffer.append(this.uri);
        if (this.query != null) {
            stringBuffer.append('?').append(this.query);
        }
        stringBuffer.append(' ').append(this.version);
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.major = -1;
        this.minor = -1;
    }

    public RequestLine() {
        this.this();
    }
}

