/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.BIHttpTunnelFactory;
import com.tridium.httpd.FileServlet;
import com.tridium.httpd.HttpResponseHeader;
import com.tridium.httpd.Logger;
import com.tridium.httpd.NHttpSessionContext;
import com.tridium.httpd.NServletContext;
import com.tridium.httpd.RequestQueue;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Httpd
implements Runnable {
    public static final String SERVER_INFO = "Niagara Web Server/" + Sys.getRegistry().getModule("web").getVendorVersion();
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String WEBSOCKETS = "ws";
    static final Log serverLog = Log.getLog((String)"web.server");
    static final Log requestLog = Log.getLog((String)"web.server.requests");
    static final Log pathLog = Log.getLog((String)"web.server.paths");
    private String serverName;
    private boolean alive;
    private RequestQueue requestQueue;
    private Settings settings;
    private ServerSocket httpSocket;
    private Thread httpThread;
    private ServerSocket httpsSocket;
    private Thread httpsThread;
    private NServletContext servletContext;
    BIHttpTunnelFactory tunnelFactory;
    private HttpResponseHeader stdResponse;
    private Logger logger;
    NHttpSessionContext sessionContext;

    public synchronized NServletContext getServletContext() {
        return this.getServletContext(null);
    }

    public synchronized NServletContext getServletContext(String string) {
        if (this.servletContext == null) {
            this.servletContext = new NServletContext(this);
        }
        return this.servletContext;
    }

    public void registerServlet(String string, Servlet servlet, Dictionary dictionary) throws ServletException {
        this.getServletContext().registerServlet(string, servlet, dictionary);
    }

    public void unregister(String string) {
        this.getServletContext().unregister(string);
    }

    public void run() {
        if (this.settings == null) {
            throw new IllegalStateException("Http.Settings have not been applied.");
        }
        this.alive = true;
        try {
            if (this.logger != null) {
                this.logger.init();
            }
        }
        catch (Exception exception) {
            serverLog.error("Cannot initialize logger.", (Throwable)exception);
        }
        this.requestQueue = this.settings.getRequestQueue();
        this.requestQueue.start();
        if (this.settings.isHttpEnabled()) {
            this.httpThread = new Thread((Runnable)new MainLoop(HTTP), "Http:MainLoop");
            this.httpThread.start();
        }
        if (this.settings.isHttpsEnabled()) {
            this.httpsThread = new Thread((Runnable)new MainLoop(HTTPS), "Https:MainLoop");
            this.httpsThread.start();
        }
    }

    public void stop() {
        this.alive = false;
        if (this.httpThread != null) {
            this.httpThread.interrupt();
        }
        if (this.httpsThread != null) {
            this.httpsThread.interrupt();
        }
        try {
            if (this.httpSocket != null) {
                this.httpSocket.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.httpsSocket != null) {
                this.httpsSocket.close();
            }
        }
        catch (IOException iOException) {}
        if (this.requestQueue != null) {
            this.requestQueue.stop();
        }
        if (this.logger != null) {
            this.logger.close();
        }
    }

    public String getServerName() {
        if (this.serverName == null) {
            try {
                this.serverName = Sys.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.serverName = "localhost";
            }
        }
        return this.serverName;
    }

    public String getDefaultContentType() {
        return "text/plain";
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public boolean isServing() {
        boolean bl = false;
        if (this.alive && (this.httpSocket != null && this.httpSocket.isBound() && !this.httpSocket.isClosed() || this.httpsSocket != null && this.httpsSocket.isBound() && !this.httpsSocket.isClosed())) {
            bl = true;
        }
        return bl;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void installLogger(Logger logger) throws Exception {
        if (this.logger != null) {
            this.logger.close();
        }
        this.logger = logger;
        if (this.logger != null && this.requestQueue != null) {
            this.logger.init();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setStdResponse(String string, String string2) {
        if (this.stdResponse == null) {
            this.stdResponse = new HttpResponseHeader();
        }
        this.stdResponse.set(string, string2);
    }

    public HttpResponseHeader getStdResponse() {
        return this.stdResponse;
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    public HttpSession getHttpSession(String string) {
        return this.sessionContext.getSession(string);
    }

    public void installTunnelFactory(BIHttpTunnelFactory bIHttpTunnelFactory) {
        if (this.tunnelFactory != null) {
            this.tunnelFactory.destroy();
        }
        this.tunnelFactory = bIHttpTunnelFactory;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: Httpd <document root>");
            System.exit(0);
        }
        String string = stringArray[0];
        int n = 80;
        if (stringArray.length == 2) {
            n = Integer.parseInt(stringArray[1]);
        }
        System.out.println("Starting HTTPD on port " + n + " (" + string + ')');
        Httpd httpd = new Httpd(new SimpleSettings(n, string));
        FileServlet fileServlet = new FileServlet(string);
        httpd.registerServlet("/", fileServlet, null);
        Thread thread = new Thread((Runnable)httpd, "httpd");
        thread.start();
        System.out.println("press any key to quit...");
        System.in.read();
        httpd.stop();
    }

    static /* synthetic */ ServerSocket access$2(Httpd httpd) {
        return httpd.httpSocket;
    }

    static /* synthetic */ ServerSocket access$4(Httpd httpd) {
        return httpd.httpsSocket;
    }

    private final /* synthetic */ void this() {
        this.alive = true;
    }

    public Httpd() {
        this.this();
        this.setStdResponse("Server", SERVER_INFO);
        this.sessionContext = new NHttpSessionContext(this);
    }

    public Httpd(Settings settings) {
        this();
        this.setSettings(settings);
    }

    public static interface Settings {
        public String getDocRoot();

        public ServerSocket getHttpServerSocket() throws BindException, IOException;

        public ServerSocket getHttpsServerSocket() throws BindException, IOException;

        public RequestQueue getRequestQueue();

        public boolean isHttpEnabled();

        public int getHttpPort();

        public boolean isHttpsEnabled();

        public int getHttpsPort();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MainLoop
    implements Runnable {
        private String scheme;

        public void run() {
            ServerSocket serverSocket = null;
            int n = 80;
            block16: while (Httpd.this.alive) {
                try {
                    if (this.scheme.equals(Httpd.HTTP)) {
                        n = Httpd.this.settings.getHttpPort();
                        Httpd.this.httpSocket = Httpd.this.settings.getHttpServerSocket();
                    } else {
                        n = Httpd.this.settings.getHttpsPort();
                        Httpd.this.httpsSocket = Httpd.this.settings.getHttpsServerSocket();
                    }
                }
                catch (BindException bindException) {
                    serverLog.error(this.scheme.toUpperCase() + " server failed to bind to port [" + n + "]\n" + bindException.getMessage());
                    serverSocket = null;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (serverLog.isTraceOn()) {
                        serverLog.error(this.scheme.toUpperCase() + " server failed to start on port [" + n + ']', (Throwable)illegalArgumentException);
                    } else {
                        serverLog.error(this.scheme.toUpperCase() + " server failed to start on port [" + n + "]\n" + illegalArgumentException.getLocalizedMessage());
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (serverLog.isTraceOn()) {
                        serverLog.error(this.scheme.toUpperCase() + " server failed to start on port [" + n + ']', (Throwable)iOException);
                    } else {
                        serverLog.error(this.scheme.toUpperCase() + " server failed to start on port [" + n + "]\n" + iOException.getLocalizedMessage());
                    }
                    return;
                }
                if (serverSocket == null) continue;
                try {
                    serverLog.message(this.scheme.toUpperCase() + " server started on port [" + n + ']');
                    Socket socket = null;
                    while (Httpd.this.alive) {
                        try {
                            socket = serverSocket.accept();
                            if (!Httpd.this.alive) continue block16;
                            if (serverLog.isTraceOn()) {
                                serverLog.trace(this.scheme + ": New connection accepted from " + socket.getInetAddress().getHostAddress() + " on port " + serverSocket.getLocalPort());
                            }
                            RequestQueue requestQueue = Httpd.this.requestQueue;
                            RequestQueue requestQueue2 = Httpd.this.requestQueue;
                            requestQueue2.getClass();
                            requestQueue.enqueue(new RequestQueue.Connection(requestQueue2, socket, Httpd.this.getServerName(), this.scheme, socket.getLocalPort()));
                        }
                        catch (RequestQueue.QueueFullException queueFullException) {
                            if (serverLog.isTraceOn()) {
                                serverLog.trace(this.scheme + ": Server too busy, closing connection.");
                            }
                            try {
                                if (socket != null) {
                                    PrintStream printStream = new PrintStream(socket.getOutputStream());
                                    printStream.print("HTTP/1.1 503 Service Unavailable\r\n\r\n");
                                    printStream.print("<html>Server Busy</html>");
                                    printStream.flush();
                                    printStream.close();
                                }
                            }
                            catch (Exception exception) {}
                            if (socket == null) continue;
                            socket.close();
                        }
                        catch (IOException iOException) {
                            if (Httpd.this.alive && (iOException.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || iOException.getClass().getName().equals("iaik.security.ssl.SSLException"))) {
                                if (serverLog.isTraceOn()) {
                                    serverLog.warning("Server accept " + iOException.getClass().getName() + ": " + iOException.getLocalizedMessage(), (Throwable)iOException);
                                    continue;
                                }
                                serverLog.warning("Server accept " + iOException.getClass().getName() + ": " + iOException.getLocalizedMessage());
                                continue;
                            }
                            serverLog.warning("Server accept exception: " + iOException.getLocalizedMessage());
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    if (!Httpd.this.alive) continue;
                    serverLog.error(this.scheme + ": Error in main loop.", throwable);
                }
            }
            serverLog.message(this.scheme.toUpperCase() + " server stopped on port [" + n + ']');
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {}
            }
        }

        public MainLoop(String string) {
            this.scheme = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SimpleSettings
    implements Settings {
        int port;
        String docRoot;
        RequestQueue requestQueue;

        public String getDocRoot() {
            return this.docRoot;
        }

        public RequestQueue getThreadPool() {
            return new RequestQueue();
        }

        public boolean isHttpEnabled() {
            return true;
        }

        public int getHttpPort() {
            return this.port;
        }

        public boolean isHttpsEnabled() {
            return false;
        }

        public int getHttpsPort() {
            return -1;
        }

        public RequestQueue getRequestQueue() {
            if (this.requestQueue == null) {
                this.requestQueue = new RequestQueue();
            }
            return this.requestQueue;
        }

        public ServerSocket getHttpServerSocket() throws IOException {
            return new ServerSocket(this.port, 10, null);
        }

        public ServerSocket getHttpsServerSocket() throws IOException {
            throw new UnsupportedOperationException("HTTPS not supported.");
        }

        private final /* synthetic */ void this() {
            this.port = 80;
            this.docRoot = ".";
        }

        public SimpleSettings() {
            this.this();
        }

        public SimpleSettings(int n, String string) {
            this.this();
            this.port = n;
            this.docRoot = string;
        }
    }
}

