/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.util.BIOpcPollable;
import com.tridium.opc.client.util.BOpcDataType;
import com.tridium.opc.client.util.BOpcLimit;
import com.tridium.opc.client.util.BOpcQuality;
import com.tridium.opc.client.util.BOpcQualityBad;
import com.tridium.opc.client.util.BOpcQualityGood;
import com.tridium.opc.client.util.BOpcQualityUncertain;
import com.tridium.opc.client.util.BOpcQualityUnknown;
import com.tridium.opc.client.util.BOpcReadMode;
import com.tridium.opc.client.util.BOpcTuningPolicy;
import com.tridium.opc.jni.client.da.OpcItemMgt;
import com.tridium.opc.jni.client.da.OpcSyncIo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOpcProxyExt
extends BProxyExt
implements BIOpcPollable {
    public static final Property id = BOpcProxyExt.newProperty((int)0, (String)"", null);
    public static final Property opcDataType = BOpcProxyExt.newProperty((int)0, (BValue)BOpcDataType.vtEmpty, null);
    public static final Property opcReadTime = BOpcProxyExt.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property opcQuality = BOpcProxyExt.newProperty((int)67, (BValue)BOpcQuality.good, null);
    public static final Property opcQualitySubcode = BOpcProxyExt.newProperty((int)67, (BValue)BOpcQualityGood.nonSpecific, null);
    public static final Property opcLimit = BOpcProxyExt.newProperty((int)67, (BValue)BOpcLimit.notLimited, null);
    public static final Property serverHandle = BOpcProxyExt.newProperty((int)67, (int)0, null);
    public static final Property mode = BOpcProxyExt.newProperty((int)65, (BValue)BReadWriteMode.readWrite, null);
    public static final Property opcActualDataType = BOpcProxyExt.newProperty((int)0, (BValue)BOpcDataType.vtEmpty, null);
    public static final Action read = BOpcProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BOpcProxyExt.newAction((int)0, null);
    public static final Type TYPE;
    private BOpcDaClient daClient;
    private BOpcPointDeviceExt deviceExt;
    private BOpcPointFolder folder;
    private boolean subscribed;
    private boolean writePending;
    private boolean itemIdChanged;
    private boolean isWriteInProgress;
    private Object syncIsWriteInProgress;
    private boolean isReadInProgress;
    private Object syncIsReadInProgress;
    private boolean isAddRemoveInProgress;
    Log opcLog;
    Log opcWriteLog;
    static /* synthetic */ Class class$com$tridium$opc$client$point$BOpcProxyExt;

    public String getId() {
        return this.getString(id);
    }

    public void setId(String string) {
        this.setString(id, string, null);
    }

    public BOpcDataType getOpcDataType() {
        return (BOpcDataType)this.get(opcDataType);
    }

    public void setOpcDataType(BOpcDataType bOpcDataType) {
        this.set(opcDataType, (BValue)bOpcDataType, null);
    }

    public BAbsTime getOpcReadTime() {
        return (BAbsTime)this.get(opcReadTime);
    }

    public void setOpcReadTime(BAbsTime bAbsTime) {
        this.set(opcReadTime, (BValue)bAbsTime, null);
    }

    public BOpcQuality getOpcQuality() {
        return (BOpcQuality)this.get(opcQuality);
    }

    public void setOpcQuality(BOpcQuality bOpcQuality) {
        this.set(opcQuality, (BValue)bOpcQuality, null);
    }

    public BFrozenEnum getOpcQualitySubcode() {
        return (BFrozenEnum)this.get(opcQualitySubcode);
    }

    public void setOpcQualitySubcode(BFrozenEnum bFrozenEnum) {
        this.set(opcQualitySubcode, (BValue)bFrozenEnum, null);
    }

    public BOpcLimit getOpcLimit() {
        return (BOpcLimit)this.get(opcLimit);
    }

    public void setOpcLimit(BOpcLimit bOpcLimit) {
        this.set(opcLimit, (BValue)bOpcLimit, null);
    }

    public int getServerHandle() {
        return this.getInt(serverHandle);
    }

    public void setServerHandle(int n) {
        this.setInt(serverHandle, n, null);
    }

    public BReadWriteMode getMode() {
        return (BReadWriteMode)this.get(mode);
    }

    public void setMode(BReadWriteMode bReadWriteMode) {
        this.set(mode, (BValue)bReadWriteMode, null);
    }

    public BOpcDataType getOpcActualDataType() {
        return (BOpcDataType)this.get(opcActualDataType);
    }

    public void setOpcActualDataType(BOpcDataType bOpcDataType) {
        this.set(opcActualDataType, (BValue)bOpcDataType, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != Context.decoding && this.subscribed && this.isRunning()) {
            BOpcDaClient bOpcDaClient;
            if (property == id) {
                this.itemIdChanged = true;
                this.readUnsubscribed(context);
                this.readSubscribed(context);
            }
            if ((bOpcDaClient = this.getDaClient()).isDown() || bOpcDaClient.isDisabled()) {
                this.readUnsubscribed(null);
            }
        }
    }

    public void doRead() {
        if (!this.isRunning()) {
            return;
        }
        this.getOpcPointDeviceExt().read(this);
    }

    public final Type getDeviceExtType() {
        return BOpcPointDeviceExt.TYPE;
    }

    public final BOpcPointFolder getFolder() {
        if (this.folder == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BOpcPointFolder) {
                    this.folder = (BOpcPointFolder)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.folder;
    }

    public final BOpcDevice getOpcDevice() {
        return (BOpcDevice)this.getDevice();
    }

    public final BOpcDaClient getDaClient() {
        if (this.daClient == null) {
            this.daClient = (BOpcDaClient)this.getDevice();
        }
        return this.daClient;
    }

    public final BOpcPointDeviceExt getOpcPointDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BOpcPointDeviceExt)this.getDeviceExt();
        }
        return this.deviceExt;
    }

    public final BOpcNetwork getOpcNetwork() {
        return this.getOpcDevice().getOpcNetwork();
    }

    public BPollFrequency getPollFrequency() {
        return ((BOpcTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public final boolean isReadSubscribed() {
        return this.subscribed;
    }

    public void poll() {
        if (BOpcReadMode.cov != this.getOpcPointDeviceExt().getReadMode()) {
            this.read();
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        this.getOpcNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readSubscribed(Context context) {
        BOpcProxyExt bOpcProxyExt = this;
        synchronized (bOpcProxyExt) {
            if (this.subscribed) {
                return;
            }
            this.subscribed = true;
        }
        this.getOpcPointDeviceExt().subscribe(this, context);
        this.writeReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readUnsubscribed(Context context) {
        BOpcProxyExt bOpcProxyExt = this;
        synchronized (bOpcProxyExt) {
            if (!this.subscribed) {
                return;
            }
            this.setSubscribed(false);
            this.getOpcDevice().getPollScheduler().unsubscribe(this);
            BOpcDaClient bOpcDaClient = this.getDaClient();
            if (bOpcDaClient.isDown() || bOpcDaClient.isDisabled() || bOpcDaClient.getState().isDisengaged()) {
                this.setServerHandle(0);
            } else {
                this.getOpcPointDeviceExt().unsubscribe(this, context);
            }
            this.writeReset();
            return;
        }
    }

    public final void setStale(boolean bl, Context context) {
        super.setStale(bl, context);
        if (bl && this.subscribed) {
            if (this.getServerHandle() == 0) {
                this.readUnsubscribed(context);
                this.readSubscribed(context);
            } else {
                this.read();
            }
        }
    }

    public final void started() throws Exception {
        if (this.isWritablePoint()) {
            this.setMode(BReadWriteMode.readWrite);
        } else {
            this.setMode(BReadWriteMode.readonly);
        }
        BOpcPointDeviceExt bOpcPointDeviceExt = this.getOpcPointDeviceExt();
        bOpcPointDeviceExt.add(this);
    }

    public final void stopped() throws Exception {
        this.readUnsubscribed(null);
        this.deviceExt = null;
        this.folder = null;
        super.stopped();
    }

    public boolean write(Context context) {
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull()) {
            return false;
        }
        this.writePending = true;
        if (!this.subscribed) {
            this.opcWriteLog.trace("Proxy::Write,point not subscribed.Calling read subscribed::" + this.getId());
            this.readSubscribed(null);
        } else if (this.getServerHandle() == 0) {
            if (!this.subscribed) {
                this.readSubscribed(null);
            }
        } else {
            this.opcWriteLog.trace("Proxy::Write,point subscribed.adding to pendingWriteMap::" + this.getId());
            this.getOpcPointDeviceExt().write(this, context);
        }
        return false;
    }

    public void writablePointActionInvoked() {
        super.writablePointActionInvoked();
        this.getParentPoint().execute();
    }

    public void doForceWrite() {
        this.write(null);
    }

    protected void addResult(BOpcPointDeviceExt bOpcPointDeviceExt, OpcItemMgt.ItemResult itemResult) {
        BOpcDaClient bOpcDaClient = this.getDaClient();
        bOpcDaClient.getPollScheduler().unsubscribe(this);
        String string = "";
        this.setIsAddRemoveInProgress(false);
        if (itemResult == null) {
            this.setServerHandle(0);
            string = "Add item, no result";
            this.readFail(string);
            if (!this.isRunning() || this.isDisabled() || this.isDown()) {
                bOpcPointDeviceExt.unsubscribe(this, null);
                this.opcLog.trace("Proxy::Additem, no result.Point " + this.getId() + " is unsubscribed");
                return;
            }
            bOpcPointDeviceExt.subscribe(this, null);
            this.opcLog.trace("Proxy::Additem, no result. Subscribing " + this.getId() + " again for adding in next trail ");
            return;
        }
        if (OpcEnv.failed(itemResult.hresult)) {
            string = OpcEnv.resultString(itemResult.hresult);
            this.readFail(string);
            if (this.isRunning() && !this.isDisabled() && !this.isDown()) {
                bOpcPointDeviceExt.subscribe(this, null);
                this.opcLog.trace("Proxy::Additem failed with hresult::" + Integer.toHexString(itemResult.hresult) + ". Putting the Point subscribe list for next trial " + this.getId());
            } else {
                return;
            }
        }
        this.opcLog.trace("Proxy::Add item succeeded::" + itemResult.hresult + " for item " + this.getId() + ", Name::" + this.getName());
        this.setServerHandle(itemResult.serverHandle);
        bOpcPointDeviceExt.addToServerHandleMap(this);
        bOpcPointDeviceExt.add(this);
        boolean bl = OpcEnv.isReadable(itemResult.access);
        boolean bl2 = OpcEnv.isWritable(itemResult.access);
        if (bl && bl2) {
            if (this.isWritablePoint() && this.getMode() != BReadWriteMode.readWrite) {
                this.setMode(BReadWriteMode.readWrite);
            }
        } else if (bl2) {
            if (this.isWritablePoint() && this.getMode() != BReadWriteMode.writeonly) {
                this.setMode(BReadWriteMode.writeonly);
            }
        } else if (this.getMode() != BReadWriteMode.readonly) {
            this.setMode(BReadWriteMode.readonly);
        }
        try {
            this.setOpcDataType(BOpcDataType.make(itemResult.dataType));
            this.setOpcActualDataType(BOpcDataType.make(itemResult.actualdataType));
        }
        catch (Exception exception) {
            this.opcLog.error("Unexpected datatype: " + itemResult.dataType);
        }
        if (bOpcPointDeviceExt.getReadMode() != BOpcReadMode.cov) {
            bOpcDaClient.getPollScheduler().subscribe(this);
        }
        if (this.writePending) {
            this.write(null);
        }
    }

    protected boolean isValidItem() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.isDown() || this.isDisabled()) {
            this.opcWriteLog.error("Proxy::IsValidItem, UnOperationl. Returning from write operation::" + this.getId());
            return false;
        }
        if (this.getServerHandle() == 0) {
            this.getOpcPointDeviceExt().write(this, null);
            this.opcWriteLog.error("Proxy::IsValidItem, Serverhandle is 0. Returning from write operation::" + this.getId());
            return false;
        }
        this.writePending = false;
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull()) {
            this.writePending = true;
            this.writeOk(bStatusValue);
            this.opcWriteLog.trace("Proxy::IsValidItem, value.getStatus =Null, WriteOK called, Returning.." + this.getId());
            return false;
        }
        return true;
    }

    protected boolean isNumericOutofRange(BStatusValue bStatusValue) {
        double d = ((BStatusNumeric)bStatusValue).getNumeric();
        BNumber bNumber = (BNumber)this.getDeviceFacets().get("min");
        if (bNumber != null && bNumber.getDouble() > d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        bNumber = (BNumber)this.getDeviceFacets().get("max");
        if (bNumber != null && bNumber.getDouble() < d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        BControlPoint bControlPoint = (BControlPoint)this.getParent();
        bNumber = (BNumber)bControlPoint.getFacets().get("min");
        if (bNumber != null && bNumber.getDouble() > d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        bNumber = (BNumber)bControlPoint.getFacets().get("max");
        if (bNumber != null && bNumber.getDouble() < d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        return false;
    }

    protected boolean isValidDataType(BStatusValue bStatusValue) {
        int n = 0;
        String string = ((BStatusString)bStatusValue).getValue();
        String[] stringArray = TextUtil.split((String)string, (char)',');
        boolean bl = true;
        if (stringArray.length == 0) {
            if (this.getOpcActualDataType().getOrdinal() == 8) {
                return true;
            }
            if (this.getOpcActualDataType().getOrdinal() == 8200) {
                return true;
            }
            n = -1073479676;
        } else {
            if (this.getOpcActualDataType().getOrdinal() == 8) {
                return true;
            }
            if (8203 == this.getOpcActualDataType().getOrdinal()) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    block14: {
                        try {
                            stringArray[n2] = stringArray[n2].trim();
                            if (stringArray[n2].length() != 0) break block14;
                            n = -1073479676;
                            bl = false;
                        }
                        catch (Exception exception) {
                            bl = false;
                            break;
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    return true;
                }
                n = -1073479676;
            } else {
                if (this.getOpcActualDataType().getOrdinal() == 8200) {
                    return true;
                }
                int n3 = this.validateOpcDataType(bStatusValue, this.getOpcActualDataType().getOrdinal());
                if (n3 == 0) {
                    return true;
                }
                n = 1 == n3 ? -1073479669 : -1073479676;
            }
        }
        if (OpcEnv.failed(n)) {
            this.opcWriteLog.error(this.getId() + " write failed 1 [val=" + bStatusValue.getValueValue() + "] " + OpcEnv.getDescription(n));
            this.writeFail(OpcEnv.getDescription(n));
        }
        return false;
    }

    protected String getStringArrayValue(BStatusValue bStatusValue) {
        String string = "";
        String string2 = ((BStatusString)bStatusValue).getValue();
        String[] stringArray = TextUtil.split((String)string2, (char)',');
        boolean bl = true;
        if (8203 == this.getOpcActualDataType().getOrdinal()) {
            int n = 0;
            while (n < stringArray.length) {
                block7: {
                    try {
                        stringArray[n] = stringArray[n].trim();
                        if (stringArray[n].length() == 0) break block7;
                        int n2 = Integer.parseInt(stringArray[n]);
                        string = n2 != 0 ? string + "true" : string + "false";
                        if (n == stringArray.length - 1) break block7;
                        string = string + ',';
                    }
                    catch (Exception exception) {
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
            if (bl) {
                return string;
            }
        } else if (this.getOpcActualDataType().getOrdinal() == 8200) {
            return ((BStatusString)bStatusValue).getValue().trim();
        }
        return string2;
    }

    protected void updateWriteResult(int n) {
        if (OpcEnv.failed(n)) {
            this.opcWriteLog.error(this.getId() + " write failed 2 [val=" + this.getWriteValue().getValueValue() + "] " + OpcEnv.getDescription(n));
            this.writeFail(OpcEnv.getDescription(n));
        } else {
            this.opcWriteLog.trace(this.getId() + " write success [val=" + this.getWriteValue().getValueValue() + "] " + OpcEnv.getDescription(n));
            this.writeOk(this.getWriteValue());
            if (this.getParentPoint().isSubscribed()) {
                this.read();
            }
        }
    }

    protected void updateReadResult(int n) {
        if (OpcEnv.failed(n)) {
            this.setIsReadInProgress(false);
            this.readFail(OpcEnv.getDescription(n));
            this.opcLog.trace("PointDeviceExt::updateReadResult()-Point::" + this.getId() + " read failed. HRESULT::" + OpcEnv.getDescription(n));
        }
    }

    protected void performWrite(OpcSyncIo opcSyncIo) {
        BControlPoint bControlPoint;
        Object object;
        if (!this.isRunning()) {
            return;
        }
        if (this.isDown() || this.isDisabled() || this.isFatalFault()) {
            this.opcWriteLog.error("Proxy::PerformWrite, UnOperationl. Returning from write operation::" + this.getId());
            return;
        }
        if (this.getServerHandle() == 0) {
            this.getOpcPointDeviceExt().write(this, null);
            this.opcWriteLog.error("Proxy::PerformWrite, Serverhandle is 0. Returning from write operation::" + this.getId());
            return;
        }
        this.writePending = false;
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull()) {
            this.writePending = true;
            this.writeOk(bStatusValue);
            this.opcWriteLog.trace("Proxy::PerformWrite, value.getStatus =Null, WriteOK called, Returning.." + this.getId());
            return;
        }
        if (bStatusValue instanceof BStatusNumeric) {
            double d = ((BStatusNumeric)bStatusValue).getNumeric();
            object = (BNumber)this.getDeviceFacets().get("min");
            if (object != null && object.getDouble() > d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            object = (BNumber)this.getDeviceFacets().get("max");
            if (object != null && object.getDouble() < d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            bControlPoint = (BControlPoint)this.getParent();
            object = (BNumber)bControlPoint.getFacets().get("min");
            if (object != null && object.getDouble() > d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            object = (BNumber)bControlPoint.getFacets().get("max");
            if (object != null && object.getDouble() < d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
        }
        try {
            int n = 0;
            if (bStatusValue instanceof BStatusBoolean) {
                n = opcSyncIo.writeBoolean(this.getServerHandle(), ((BStatusBoolean)bStatusValue).getValue());
            } else if (bStatusValue instanceof BStatusNumeric) {
                n = opcSyncIo.writeNumeric(this.getServerHandle(), this.getOpcDataType().getOrdinal(), ((BStatusNumeric)bStatusValue).getValue());
            } else {
                String string = "";
                object = ((BStatusString)bStatusValue).getValue();
                bControlPoint = TextUtil.split((String)object, (char)',');
                boolean bl = true;
                if (((String[])bControlPoint).length == 0) {
                    n = this.getOpcActualDataType().getOrdinal() == 8 ? opcSyncIo.writeString(this.getServerHandle(), ((BStatusString)bStatusValue).getValue(), this.getOpcActualDataType().getOrdinal()) : (this.getOpcActualDataType().getOrdinal() == 8200 ? opcSyncIo.writeString(this.getServerHandle(), ((BStatusString)bStatusValue).getValue(), this.getOpcActualDataType().getOrdinal()) : -1073479676);
                } else if (this.getOpcActualDataType().getOrdinal() == 8) {
                    n = opcSyncIo.writeString(this.getServerHandle(), ((BStatusString)bStatusValue).getValue(), this.getOpcActualDataType().getOrdinal());
                } else if (8203 == this.getOpcActualDataType().getOrdinal()) {
                    int n2 = 0;
                    while (n2 < ((BControlPoint)bControlPoint).length) {
                        block32: {
                            try {
                                bControlPoint[n2] = bControlPoint[n2].trim();
                                if (bControlPoint[n2].length() == 0) {
                                    n = -1073479676;
                                    bl = false;
                                    break block32;
                                }
                                int n3 = Integer.parseInt((String)bControlPoint[n2]);
                                string = n3 != 0 ? string + "true" : string + "false";
                                if (n2 == ((BControlPoint)bControlPoint).length - 1) break block32;
                                string = string + ',';
                            }
                            catch (Exception exception) {
                                bl = false;
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (bl) {
                        ((BStatusString)bStatusValue).setValue(string);
                        n = opcSyncIo.writeString(this.getServerHandle(), string, this.getOpcActualDataType().getOrdinal());
                    } else {
                        n = -1073479676;
                    }
                } else if (this.getOpcActualDataType().getOrdinal() == 8200) {
                    ((BStatusString)bStatusValue).setValue(((BStatusString)bStatusValue).getValue().trim());
                    n = opcSyncIo.writeString(this.getServerHandle(), ((BStatusString)bStatusValue).getValue(), this.getOpcActualDataType().getOrdinal());
                } else {
                    int n4 = this.validateOpcDataType(bStatusValue, this.getOpcActualDataType().getOrdinal());
                    n = n4 == 0 ? opcSyncIo.writeString(this.getServerHandle(), ((BStatusString)bStatusValue).getValue(), this.getOpcActualDataType().getOrdinal()) : (1 == n4 ? -1073479669 : -1073479676);
                }
            }
            if (OpcEnv.failed(n)) {
                this.opcWriteLog.error(this.getId() + " write failed 3 [val=" + bStatusValue.getValueValue() + "] " + OpcEnv.getDescription(n));
                this.writeFail(OpcEnv.getDescription(n));
            } else {
                this.opcWriteLog.trace("Proxy::PerformWrite, Write successful::" + this.getId());
                this.writeOk(bStatusValue);
                if (this.getParentPoint().isSubscribed()) {
                    this.read();
                }
            }
        }
        catch (Exception exception) {
            this.opcWriteLog.error("Write fail [val=" + bStatusValue.getValueValue() + "] " + this.getId(), (Throwable)exception);
            this.writeFail(exception.getMessage());
        }
    }

    protected void readResult(BStatusValue bStatusValue, long l, int n, int n2) {
        BFrozenEnum bFrozenEnum;
        this.setIsReadInProgress(false);
        this.setOpcReadTime(BAbsTime.make((long)l));
        this.setOpcQuality(BOpcQuality.getQuality(n));
        this.setOpcLimit(BOpcLimit.getLimit(n));
        if (BOpcQuality.isBad(n)) {
            bFrozenEnum = BOpcQualityBad.getQuality(n);
            if (bStatusValue != null) {
                bStatusValue.setStatus(BStatus.fault);
            }
            this.setOpcQualitySubcode(bFrozenEnum);
        } else if (BOpcQuality.isGood(n)) {
            bFrozenEnum = BOpcQualityGood.getQuality(n);
            if (bStatusValue != null && bFrozenEnum == BOpcQualityGood.localOverride) {
                bStatusValue.setStatus(BStatus.overridden);
            }
            this.setOpcQualitySubcode(bFrozenEnum);
        } else if (BOpcQuality.isUncertain(n)) {
            this.setOpcQualitySubcode(BOpcQualityUncertain.getQuality(n));
        } else {
            this.setOpcQualitySubcode(BOpcQualityUnknown.getQuality(n));
        }
        if (bStatusValue != null) {
            if (bStatusValue instanceof BStatusString) {
                try {
                    int n3;
                    bFrozenEnum = (BControlPoint)this.getParent();
                    BInteger bInteger = (BInteger)bFrozenEnum.getFacets().getFacet("precision");
                    if (bInteger != null && (n3 = bInteger.getInt()) > 0) {
                        String string;
                        String string2 = "0.";
                        int n4 = 0;
                        while (n4 < n3) {
                            string2 = string2 + '0';
                            ++n4;
                        }
                        String string3 = ((BStatusString)bStatusValue).getValue();
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            arrayList.add(string);
                        }
                        string = "";
                        int n5 = 0;
                        while (n5 < arrayList.size()) {
                            float f = Float.parseFloat((String)arrayList.get(n5));
                            string = string + new DecimalFormat(string2).format(f);
                            if (n5 != arrayList.size() - 1) {
                                string = string + ',';
                            }
                            ++n5;
                        }
                        bStatusValue = new BStatusString(string);
                    }
                }
                catch (Exception exception) {}
            }
            this.readOk(bStatusValue);
        } else {
            this.readFail(OpcEnv.resultString(n2));
            this.opcLog.trace("Proxy::write, Read failed with hresult ::" + n2 + "for Point ::" + this.getId());
        }
    }

    /*
     * Unable to fully structure code
     */
    public int validateOpcDataType(BStatusValue var1_1, int var2_2) {
        block14: {
            block15: {
                var3_3 = 0;
                var4_4 = ((BStatusString)var1_1).getValue();
                var5_5 = TextUtil.split((String)var4_4, (char)',');
                if (var5_5.length == 0) break block15;
                var6_6 = 0;
                while (var6_6 < var5_5.length) {
                    block13: {
                        block16: {
                            if (var5_5[var6_6].length() == 0) ** GOTO lbl38
                            var7_7 = Double.parseDouble(var5_5[var6_6]);
                            var9_9 = new BStatusNumeric(var7_7);
                            var10_10 = var9_9.getNumeric();
                            var12_11 = (BNumber)this.getDeviceFacets().get("min");
                            if (var12_11 != null && var12_11.getDouble() > var10_10) {
                                return 1;
                            }
                            var12_11 = (BNumber)this.getDeviceFacets().get("max");
                            if (var12_11 != null && var12_11.getDouble() < var10_10) {
                                return 1;
                            }
                            if (var2_2 != 8208) ** GOTO lbl23
                            if (var10_10 > 127.0 || var10_10 < -127.0) {
                                return 1;
                            }
                            ** GOTO lbl35
lbl23:
                            // 1 sources

                            if (var2_2 != 8209) ** GOTO lbl28
                            if (var10_10 > 255.0 || var10_10 < 0.0) {
                                return 1;
                            }
                            ** GOTO lbl35
lbl28:
                            // 1 sources

                            if (var2_2 != 8210) ** GOTO lbl33
                            if (var10_10 > 65535.0 || var10_10 < 0.0) {
                                return 1;
                            }
                            break block16;
lbl33:
                            // 1 sources

                            if (var2_2 == 8211 && var10_10 < 0.0) {
                                return 1;
                            }
                        }
                        try {
                            break block13;
lbl38:
                            // 1 sources

                            return 2;
                        }
                        catch (Exception var7_8) {
                            var3_3 = 2;
                        }
                    }
                    if (var3_3 != 0) break block14;
                    ++var6_6;
                }
                break block14;
            }
            var3_3 = 2;
        }
        return var3_3;
    }

    public boolean getItemIDChanged() {
        return this.itemIdChanged;
    }

    public void setItemIDChanged(boolean bl) {
        this.itemIdChanged = bl;
    }

    private final boolean isWritablePoint() {
        boolean bl = false;
        BControlPoint bControlPoint = this.getParentPoint();
        TypeInfo typeInfo = bControlPoint.getType().getTypeInfo();
        bl = typeInfo.is(BIWritablePoint.TYPE);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIsReadInProgress() {
        Object object = this.syncIsReadInProgress;
        synchronized (object) {
            return this.isReadInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setIsReadInProgress(boolean bl) {
        Object object = this.syncIsReadInProgress;
        synchronized (object) {
            this.isReadInProgress = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIsWriteInProgress() {
        Object object = this.syncIsWriteInProgress;
        synchronized (object) {
            return this.isWriteInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setIsWriteInProgress(boolean bl) {
        Object object = this.syncIsWriteInProgress;
        synchronized (object) {
            this.isWriteInProgress = bl;
            return;
        }
    }

    public synchronized boolean getIsAddRemoveInProgress() {
        return this.isAddRemoveInProgress;
    }

    public synchronized void setIsAddRemoveInProgress(boolean bl) {
        this.isAddRemoveInProgress = bl;
    }

    public boolean getIsInUse() {
        boolean bl = false;
        if (this.getIsReadInProgress() || this.getIsWriteInProgress()) {
            bl = true;
        }
        return bl;
    }

    public void setSubscribed(boolean bl) {
        this.subscribed = bl;
    }

    public void readOk(BStatusValue bStatusValue) {
        super.readOk(bStatusValue);
        if (this.getIsReadInProgress()) {
            this.setIsReadInProgress(false);
        }
    }

    public void readFail(String string) {
        super.readFail(string);
        if (this.getIsReadInProgress()) {
            this.setIsReadInProgress(false);
        }
    }

    public void writeOk(BStatusValue bStatusValue) {
        super.writeOk(bStatusValue);
        if (this.getIsWriteInProgress()) {
            this.setIsWriteInProgress(false);
        }
    }

    public void writeFail(String string) {
        super.writeFail(string);
        if (this.getIsWriteInProgress()) {
            this.setIsWriteInProgress(false);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.folder = null;
        this.subscribed = false;
        this.writePending = false;
        this.itemIdChanged = false;
        this.isWriteInProgress = false;
        this.syncIsWriteInProgress = new Object();
        this.isReadInProgress = false;
        this.syncIsReadInProgress = new Object();
        this.isAddRemoveInProgress = false;
        this.opcLog = Log.getLog((String)"OpcDaLog");
        this.opcWriteLog = Log.getLog((String)"OpcDaWriteLog");
    }

    public BOpcProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$opc$client$point$BOpcProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$opc$client$point$BOpcProxyExt = BOpcProxyExt.class("[Lcom.tridium.opc.client.point.BOpcProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

