/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDiscoveryJob;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.point.BOpcProxyExt;
import com.tridium.opc.client.util.BOpcReadMode;
import com.tridium.opc.client.util.BOpcState;
import com.tridium.opc.client.util.BOpcWriteMode;
import com.tridium.opc.jni.client.da.OpcAsyncIo2;
import com.tridium.opc.jni.client.da.OpcGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOpcPointDeviceExt
extends BPointDeviceExt {
    public static final Property readDelay = BOpcPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)2000L), null);
    public static final Property writeDelay = BOpcPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)4000L), null);
    public static final Property groupName = BOpcPointDeviceExt.newProperty((int)0, (String)"tridium", null);
    public static final Property percentDeadband = BOpcPointDeviceExt.newProperty((int)0, (double)0.0, null);
    public static final Property updateRate = BOpcPointDeviceExt.newProperty((int)0, (int)1000, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property revisedUpdateRate = BOpcPointDeviceExt.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property batchLimit = BOpcPointDeviceExt.newProperty((int)0, (int)500, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)25.0)));
    public static final Property message = BOpcPointDeviceExt.newProperty((int)67, (String)"", null);
    public static final Property messageTime = BOpcPointDeviceExt.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property serverHandle = BOpcPointDeviceExt.newProperty((int)67, (int)0, null);
    public static final Property state = BOpcPointDeviceExt.newProperty((int)3, (BValue)BOpcState.detached, null);
    public static final Property asyncIo = BOpcPointDeviceExt.newProperty((int)67, (boolean)false, null);
    public static final Property readMode = BOpcPointDeviceExt.newProperty((int)0, (BValue)BOpcReadMode.cov, null);
    public static final Property writeMode = BOpcPointDeviceExt.newProperty((int)0, (BValue)BOpcWriteMode.async, null);
    public static final Property WriteAsACollection = BOpcPointDeviceExt.newProperty((int)5, (boolean)false, null);
    public static final Property defaultPointFacets = BOpcPointDeviceExt.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property readTrigger = BOpcPointDeviceExt.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)1))), null);
    public static final Property writeTrigger = BOpcPointDeviceExt.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)1))), null);
    public static final Property flatDiscovery = BOpcPointDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action getDeviceOrd = BOpcPointDeviceExt.newAction((int)4, null);
    public static final Action read = BOpcPointDeviceExt.newAction((int)20, null);
    public static final Action submitPointDiscoveryJob = BOpcPointDeviceExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action write = BOpcPointDeviceExt.newAction((int)20, null);
    public static final Type TYPE;
    private BAbsTime attachTime;
    private BOpcDaClient daClient;
    private TreeMap extMap;
    private TreeMap extServerHandleMap;
    private Object mutexRead;
    private Object mutexSubscribe;
    private Object mutexUnsubscribe;
    private Object mutexWrite;
    private Object mutexReadWriteInProgress;
    private Object mutexAsyncReadMap;
    private Object mutexAsyncWriteMap;
    private Object mutexUnregisterCallbackInProgress;
    private OpcGroup peer;
    private TreeMap pendingRead;
    private TreeMap pendingSubscribe;
    private TreeMap pendingUnsubscribe;
    private TreeMap pendingWrite;
    private boolean reading;
    private boolean writing;
    private Counter readTxsId;
    private Counter writeTxsId;
    private TreeMap extAsyncWriteMap;
    private TreeMap extAsyncReadMap;
    private boolean isFirstTime;
    Log opcLog;
    Log opcWriteLog;
    Log opcSubscriptionLog;
    static /* synthetic */ Class class$com$tridium$opc$client$point$BOpcPointDeviceExt;

    public BRelTime getReadDelay() {
        return (BRelTime)this.get(readDelay);
    }

    public void setReadDelay(BRelTime bRelTime) {
        this.set(readDelay, (BValue)bRelTime, null);
    }

    public BRelTime getWriteDelay() {
        return (BRelTime)this.get(writeDelay);
    }

    public void setWriteDelay(BRelTime bRelTime) {
        this.set(writeDelay, (BValue)bRelTime, null);
    }

    public String getGroupName() {
        return this.getString(groupName);
    }

    public void setGroupName(String string) {
        this.setString(groupName, string, null);
    }

    public double getPercentDeadband() {
        return this.getDouble(percentDeadband);
    }

    public void setPercentDeadband(double d) {
        this.setDouble(percentDeadband, d, null);
    }

    public int getUpdateRate() {
        return this.getInt(updateRate);
    }

    public void setUpdateRate(int n) {
        this.setInt(updateRate, n, null);
    }

    public int getRevisedUpdateRate() {
        return this.getInt(revisedUpdateRate);
    }

    public void setRevisedUpdateRate(int n) {
        this.setInt(revisedUpdateRate, n, null);
    }

    public int getBatchLimit() {
        return this.getInt(batchLimit);
    }

    public void setBatchLimit(int n) {
        this.setInt(batchLimit, n, null);
    }

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String string) {
        this.setString(message, string, null);
    }

    public BAbsTime getMessageTime() {
        return (BAbsTime)this.get(messageTime);
    }

    public void setMessageTime(BAbsTime bAbsTime) {
        this.set(messageTime, (BValue)bAbsTime, null);
    }

    public int getServerHandle() {
        return this.getInt(serverHandle);
    }

    public void setServerHandle(int n) {
        this.setInt(serverHandle, n, null);
    }

    public BOpcState getState() {
        return (BOpcState)this.get(state);
    }

    public void setState(BOpcState bOpcState) {
        this.set(state, (BValue)bOpcState, null);
    }

    public boolean getAsyncIo() {
        return this.getBoolean(asyncIo);
    }

    public void setAsyncIo(boolean bl) {
        this.setBoolean(asyncIo, bl, null);
    }

    public BOpcReadMode getReadMode() {
        return (BOpcReadMode)this.get(readMode);
    }

    public void setReadMode(BOpcReadMode bOpcReadMode) {
        this.set(readMode, (BValue)bOpcReadMode, null);
    }

    public BOpcWriteMode getWriteMode() {
        return (BOpcWriteMode)this.get(writeMode);
    }

    public void setWriteMode(BOpcWriteMode bOpcWriteMode) {
        this.set(writeMode, (BValue)bOpcWriteMode, null);
    }

    public boolean getWriteAsACollection() {
        return this.getBoolean(WriteAsACollection);
    }

    public void setWriteAsACollection(boolean bl) {
        this.setBoolean(WriteAsACollection, bl, null);
    }

    public BFacets getDefaultPointFacets() {
        return (BFacets)this.get(defaultPointFacets);
    }

    public void setDefaultPointFacets(BFacets bFacets) {
        this.set(defaultPointFacets, (BValue)bFacets, null);
    }

    public BTimeTrigger getReadTrigger() {
        return (BTimeTrigger)this.get(readTrigger);
    }

    public void setReadTrigger(BTimeTrigger bTimeTrigger) {
        this.set(readTrigger, (BValue)bTimeTrigger, null);
    }

    public BTimeTrigger getWriteTrigger() {
        return (BTimeTrigger)this.get(writeTrigger);
    }

    public void setWriteTrigger(BTimeTrigger bTimeTrigger) {
        this.set(writeTrigger, (BValue)bTimeTrigger, null);
    }

    public boolean getFlatDiscovery() {
        return this.getBoolean(flatDiscovery);
    }

    public void setFlatDiscovery(boolean bl) {
        this.setBoolean(flatDiscovery, bl, null);
    }

    public BOrd getDeviceOrd() {
        return (BOrd)this.invoke(getDeviceOrd, null, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public BOrd submitPointDiscoveryJob(BValue bValue) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, bValue, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void attach() {
        block9: {
            if (this.getState().isEngaged()) {
                this.opcLog.trace("PointDeviceExt::Attach()--Already attached. Returning");
                return;
            }
            this.setAttaching();
            this.resetFlags();
            this.opcLog.trace("PointDeviceExt::Attach()--Attaching");
            BOpcDaClient bOpcDaClient = this.getDaClient();
            if (bOpcDaClient == null || !bOpcDaClient.getState().isAttached()) {
                this.opcLog.trace("PointDeviceExt::Attach()--Server is not attached. Returning");
                this.setDetached();
                return;
            }
            String string = this.getGroupName();
            this.peer = bOpcDaClient.getPeer().getGroup(string);
            if (this.peer == null) {
                this.opcLog.trace("Add group");
                try {
                    this.peer = bOpcDaClient.getPeer().addGroup(string, true, this.getUpdateRate(), this.getHandle().hashCode(), 0, (float)this.getPercentDeadband(), 0);
                    if (this.peer != null) {
                        this.setRevisedUpdateRate(this.peer.revisedUpdateRate);
                        this.setServerHandle(this.peer.serverHandle);
                        this.setAttached();
                        this.opcLog.trace("PointDeviceExt::Attach()--Attached successfully");
                        this.isFirstTime = true;
                        this.attachTime = Clock.time();
                        BTuningPolicyMap bTuningPolicyMap = this.getOpcNetwork().getTuningPolicies();
                        BTuningPolicy bTuningPolicy = bTuningPolicyMap.getDefaultPolicy();
                        if (!bTuningPolicy.getWriteOnUp()) {
                            BControlPoint[] bControlPointArray = this.getPoints();
                            int n = 0;
                            while (n < bControlPointArray.length) {
                                BAbstractProxyExt bAbstractProxyExt = bControlPointArray[n].getProxyExt();
                                if (bAbstractProxyExt instanceof BOpcProxyExt) {
                                    ((BOpcProxyExt)bAbstractProxyExt).writeReset();
                                }
                                ++n;
                            }
                        }
                        this.peer.setGroupListener(new Listener());
                        this.registerCallback();
                        break block9;
                    }
                    this.message("Add group failed - peer is equal to NULL");
                    this.opcLog.error("Add group: " + string);
                    this.setDetached();
                    return;
                }
                catch (Exception exception) {
                    this.message("Add group failed (" + exception.getMessage() + ')');
                    this.opcLog.error("Add group: " + string, (Throwable)exception);
                    this.setDetached();
                    return;
                }
            }
            this.message("Group name already in use.");
            this.opcLog.error("Duplicate group name [" + string + "] " + this.toPathString());
            this.setDetached();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void detach() {
        this.cancelTransaction();
        this.setDetaching();
        BOpcDaClient bOpcDaClient = this.getDaClient();
        this.opcLog.trace("Removing group");
        if (this.peer != null && !bOpcDaClient.isDown() && !bOpcDaClient.isFault()) {
            try {
                try {
                    this.peer.setGroupListener(null);
                    bOpcDaClient.getPeer().removeGroup(this.peer);
                    this.opcLog.trace("PointDeviceExt::detach()--Removed group");
                    this.setAsyncIo(false);
                }
                catch (Exception exception) {
                    this.opcLog.error("Removing group", (Throwable)exception);
                    this.setAsyncIo(false);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.setDetached();
                this.setServerHandle(0);
                this.isFirstTime = false;
                this.peer = null;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.setDetached();
                this.setServerHandle(0);
                this.isFirstTime = false;
                this.peer = null;
            }
        }
        this.setDetached();
        this.opcLog.trace("PointDeviceExt::detach()--Detached");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRead() {
        block11: {
            block10: {
                block9: {
                    block8: {
                        try {
                            if (!this.isRunning()) {
                                this.opcLog.trace("PointDeviceExt::doRead()-Not running. Returning");
                                Object var2_1 = null;
                                this.reading = false;
                                return;
                            }
                            if (!this.getState().isAttached()) {
                                this.opcLog.trace("PointDeviceExt::doRead()-Not attached. Returning");
                                break block8;
                            }
                            if (this.peer == null) {
                                this.opcLog.trace("PointDeviceExt::doRead()-Peer is null. Returning");
                                break block9;
                            }
                            if (Clock.time().isBefore(this.attachTime.add(this.getReadDelay()))) {
                                this.opcLog.trace("PointDeviceExt::doRead()-Poll time is less than read delay. Returning");
                                break block10;
                            }
                            this.checkReadWriteMode();
                            this.performUnsubscribe();
                            this.performSubscribe();
                            if (this.getReadMode() != BOpcReadMode.cov) {
                                this.performRead();
                            }
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var2_5 = null;
                            this.reading = false;
                            throw throwable;
                        }
                    }
                    Object var2_2 = null;
                    this.reading = false;
                    return;
                }
                Object var2_3 = null;
                this.reading = false;
                return;
            }
            Object var2_4 = null;
            this.reading = false;
            return;
        }
        Object var2_6 = null;
        this.reading = false;
    }

    public final BOrd doGetDeviceOrd() {
        return this.getOpcDevice().getSlotPathOrd();
    }

    public final BOrd doSubmitPointDiscoveryJob(BValue bValue, Context context) {
        return new BOpcPointDiscoveryJob(this, (BValue)BString.make((String)"")).submit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWrite() {
        block61: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            try {
                block56: {
                    block62: {
                        if (!this.isRunning()) {
                            this.opcWriteLog.trace("PointDeviceExt::doWrite()-Not running. Returning");
                            var7_6 = null;
                            this.writing = false;
                            if (var2_2 != null) {
                                var2_2.release();
                            }
                            if (var1_1 == null) return;
                            var1_1.release();
                            return;
                        }
                        if (!this.getState().isAttached()) {
                            this.opcWriteLog.trace("PointDeviceExt::doWrite()-Not attached. Returning");
                            var7_7 = null;
                            this.writing = false;
                            if (var2_2 != null) {
                                var2_2.release();
                            }
                            if (var1_1 == null) return;
                            var1_1.release();
                            return;
                        }
                        if (Clock.time().isBefore(this.attachTime.add(this.getWriteDelay()))) {
                            this.opcWriteLog.trace("PointDeviceExt::doWrite()-Write time is less than write delay. Returning");
                            var7_8 = null;
                            this.writing = false;
                            if (var2_2 != null) {
                                var2_2.release();
                            }
                            if (var1_1 == null) return;
                            var1_1.release();
                            return;
                        }
                        this.checkReadWriteMode();
                        var8_14 = null;
                        var8_14 = this.pendingWrite.values();
                        var9_15 = this.mutexWrite;
                        synchronized (var9_15) {
                            if (var8_14.size() != 0) ** break block51
                        }
                        var7_9 = null;
                        this.writing = false;
                        if (var2_2 != null) {
                            var2_2.release();
                        }
                        if (var1_1 == null) return;
                        var1_1.release();
                        return;
                        {
                            this.pendingWrite = new TreeMap<K, V>();
                        }
                        var9_15 = this.mutexReadWriteInProgress;
                        synchronized (var9_15) {
                            var11_16 = new ArrayList();
                            var12_18 = var8_14.iterator();
                            var3_3 = var8_14.size();
                            var13_20 = 0;
                            if (true) ** GOTO lbl83
                            do {
                                if ((var14_24 = (String[])var12_18.next()).getIsAddRemoveInProgress()) {
                                    var15_25 = this.mutexWrite;
                                    synchronized (var15_25) {
                                        this.pendingWrite.put(var14_24.getHandle(), var14_24);
                                    }
                                } else {
                                    var14_24.setIsWriteInProgress(true);
                                    var11_16.add(var14_24);
                                }
                                var12_18.remove();
                                ++var13_20;
lbl83:
                                // 2 sources

                            } while (var13_20 < var3_3);
                            var8_14 = var11_16;
                        }
                        var3_3 = var8_14.size();
                        this.opcWriteLog.trace("Write List Size::" + this.pendingWrite.size() + " Items actually getting written =" + var3_3);
                        if (var3_3 <= 0) {
                            var7_10 = null;
                            this.writing = false;
                            if (var2_2 != null) {
                                var2_2.release();
                            }
                            if (var1_1 == null) return;
                            var1_1.release();
                            return;
                        }
                        this.opcWriteLog.trace("Writing " + var8_14.size() + " items");
                        try {
                            if (this.getAsyncIo()) {
                                var1_1 = this.peer.getAsyncIo();
                                var2_2 = this.peer.getSyncIo();
                            } else {
                                var2_2 = this.peer.getSyncIo();
                            }
                        }
                        catch (Exception var11_17) {
                            var12_18 = var11_17.getMessage();
                            this.message("Write failed: " + (String)var12_18);
                            this.opcWriteLog.error("Write", (Throwable)var11_17);
                            var13_21 = var8_14.iterator();
                            this.opcWriteLog.trace("PointDeviceExt::doWrite()-SyncIo/AsyncIo interface is not valid. Setting all points to write failed");
                            if (true) ** GOTO lbl128
                        }
                        this.opcWriteLog.trace("PointDeviceExt::doWrite()-Sync IO object is valid");
                        if (!this.getWriteAsACollection()) break block62;
                        var11_16 = new BOpcProxyExt[var3_3];
                        var12_18 = new int[var3_3];
                        var13_22 = new int[var3_3];
                        var14_24 = new String[var3_3];
                        var15_25 = null;
                        var17_26 = var8_14.iterator();
                        var18_28 = 0;
                        if (true) ** GOTO lbl167
                    }
                    var11_16 = var8_14.iterator();
                    var12_19 = 0;
                    if (true) ** GOTO lbl251
                    do {
                        ((BOpcProxyExt)var13_21.next()).writeFail((String)var12_18);
lbl128:
                        // 2 sources

                    } while (var13_21.hasNext());
                    var7_11 = null;
                    this.writing = false;
                    if (var2_2 != null) {
                        var2_2.release();
                    }
                    if (var1_1 == null) return;
                    var1_1.release();
                    return;
                    do {
                        block64: {
                            block66: {
                                block67: {
                                    block65: {
                                        block63: {
                                            var11_16[var18_28] = (BOpcProxyExt)var17_26.next();
                                            if (var11_16[var18_28].isValidItem()) break block63;
                                            var11_16[var18_28].setIsWriteInProgress(false);
                                            break block64;
                                        }
                                        var16_33 = var11_16[var18_28].getWriteValue();
                                        if (!(var16_33 instanceof BStatusNumeric)) break block65;
                                        if (var11_16[var18_28].isNumericOutofRange(var16_33)) break block64;
                                        var19_35 = ((BStatusNumeric)var16_33).getNumeric();
                                        var15_25 = Double.toString(var19_35);
                                        break block66;
                                    }
                                    if (!(var16_33 instanceof BStatusBoolean)) break block67;
                                    var19_36 = ((BStatusBoolean)var16_33).getValue();
                                    var20_38 = new Boolean(var19_36).toString();
                                    var15_25 = var20_38;
                                    break block66;
                                }
                                if (!var11_16[var18_28].isValidDataType(var16_33)) break block64;
                                if (8203 == var11_16[var18_28].getOpcActualDataType().getOrdinal() || 8200 == var11_16[var18_28].getOpcActualDataType().getOrdinal()) {
                                    var15_25 = var11_16[var18_28].getStringArrayValue(var16_33);
                                }
                                var15_25 = ((BStatusString)var16_33).getValue();
                            }
                            var14_24[var4_4] = var15_25;
                            var12_18[var4_4] = var11_16[var18_28].getServerHandle();
                            var13_22[var4_4] = var11_16[var18_28].getOpcDataType().getOrdinal();
                            ++var4_4;
                        }
                        ++var18_28;
lbl167:
                        // 2 sources

                    } while (var18_28 < var3_3 && var17_26 != null && var17_26.hasNext());
                    var18_29 = this.mutexUnregisterCallbackInProgress;
                    synchronized (var18_29) {
                        block55: {
                            block68: {
                                block53: {
                                    block54: {
                                        if (this.getWriteMode() != BOpcWriteMode.async) break block53;
                                        if (var1_1 == null) break block54;
                                        this.opcWriteLog.trace("Doing Asynchronous Write");
                                        var5_5 = var1_1.writeAsync(var4_4, this.writeTxsId.increment(), (int[])var12_18, var13_22, var14_24);
                                        break block55;
                                    }
                                    var17_26 = var8_14.iterator();
                                    if (true) ** GOTO lbl194
                                }
                                if (var2_2 == null) break block68;
                                this.opcWriteLog.trace("Doing Synchronous Write");
                                var5_5 = var2_2.writeArray(var4_4, (int[])var12_18, var13_22, var14_24);
                                break block55;
                            }
                            var17_26 = var8_14.iterator();
                            if (true) ** GOTO lbl198
                        }
lbl190:
                        // 3 sources

                        while (true) {
                            break block56;
                            break;
                        }
                        do {
                            ((BOpcProxyExt)var17_26.next()).writeFail("Write Fail: AsyncIo2 Object is null");
lbl194:
                            // 2 sources

                        } while (var17_26.hasNext());
                        ** GOTO lbl190
                        do {
                            ((BOpcProxyExt)var17_26.next()).writeFail("Write Fail: SyncIo Object is null");
lbl198:
                            // 2 sources

                        } while (var17_26.hasNext());
                        ** continue;
                    }
                    do {
                        block59: {
                            block71: {
                                block72: {
                                    block70: {
                                        block69: {
                                            var4_4 = 0;
                                            var13_23 = new BOpcProxyExt[1];
                                            var14_24 = (String[])new int[1];
                                            var15_25 = new int[1];
                                            var16_34 = new String[1];
                                            var13_23[var4_4] = (BOpcProxyExt)var11_16.next();
                                            if (var13_23[var4_4].isValidItem()) break block69;
                                            var13_23[var4_4].setIsWriteInProgress(false);
                                            break block59;
                                        }
                                        var17_27 = var13_23[var4_4].getWriteValue();
                                        if (!(var17_27 instanceof BStatusNumeric)) break block70;
                                        if (var13_23[var4_4].isNumericOutofRange(var17_27)) break block59;
                                        var18_31 = ((BStatusNumeric)var17_27).getNumeric();
                                        var16_34[var4_4] = Double.toString(var18_31);
                                        break block71;
                                    }
                                    if (!(var17_27 instanceof BStatusBoolean)) break block72;
                                    var18_32 = ((BStatusBoolean)var17_27).getValue();
                                    var16_34[var4_4] = var19_37 = new Boolean(var18_32).toString();
                                    break block71;
                                }
                                if (!var13_23[var4_4].isValidDataType(var17_27)) break block59;
                                if (8203 == var13_23[var4_4].getOpcActualDataType().getOrdinal() || 8200 == var13_23[var4_4].getOpcActualDataType().getOrdinal()) {
                                    var16_34[var4_4] = var13_23[var4_4].getStringArrayValue(var17_27);
                                }
                                var16_34[var4_4] = ((BStatusString)var17_27).getValue();
                            }
                            var14_24[var4_4] = (String)var13_23[var4_4].getServerHandle();
                            var15_25[var4_4] = var13_23[var4_4].getOpcDataType().getOrdinal();
                            var18_30 = this.mutexUnregisterCallbackInProgress;
                            synchronized (var18_30) {
                                block57: {
                                    block58: {
                                        if (this.getWriteMode() != BOpcWriteMode.async) break block57;
                                        if (var1_1 == null) break block58;
                                        this.opcWriteLog.trace("Doing Asynchronous Write");
                                        var5_5 = var1_1.writeAsync(1, this.writeTxsId.increment(), (int[])var14_24, (int[])var15_25, var16_34);
                                        break block59;
                                    }
                                    var11_16 = var8_14.iterator();
                                    if (true) ** GOTO lbl275
                                }
                                if (var2_2 == null) {
                                    var11_16 = var8_14.iterator();
                                    break block60;
                                }
                                this.opcWriteLog.trace("Doing Synchronous Write");
                                var5_5 = var2_2.writeArray(1, (int[])var14_24, (int[])var15_25, var16_34);
                            }
                        }
lbl250:
                        // 3 sources

                        ++var12_19;
lbl251:
                        // 2 sources

                        if (var12_19 >= var3_3 || var11_16 == null) break;
                    } while (var11_16.hasNext());
                }
                var7_13 = null;
                this.writing = false;
                if (var2_2 == null) break block61;
            }
            catch (Throwable var6_39) {
                var7_12 = null;
                this.writing = false;
                if (var2_2 != null) {
                    var2_2.release();
                }
                if (var1_1 == null) throw var6_39;
                var1_1.release();
                throw var6_39;
            }
            var2_2.release();
        }
        if (var1_1 == null) return;
        var1_1.release();
        return;
        {
            block60: {
                do {
                    ((BOpcProxyExt)var11_16.next()).writeFail("Write Fail: AsyncIo2 Object is null");
lbl275:
                    // 2 sources

                } while (var11_16.hasNext());
                ** GOTO lbl250
lbl277:
                // 1 sources

                ((BOpcProxyExt)var11_16.next()).writeFail("Write Fail: SyncIo Object is null");
            }
            if (var11_16.hasNext()) ** GOTO lbl277
        }
    }

    public final BOpcDaClient getDaClient() {
        if (this.daClient == null) {
            this.daClient = (BOpcDaClient)this.getParent();
        }
        return this.daClient;
    }

    public final Type getDeviceType() {
        return BOpcDevice.TYPE;
    }

    public final BOpcDevice getOpcDevice() {
        return (BOpcDevice)this.getParent();
    }

    public final BOpcNetwork getOpcNetwork() {
        return this.getOpcDevice().getOpcNetwork();
    }

    public final Type getPointFolderType() {
        return BOpcPointFolder.TYPE;
    }

    public final Type getProxyExtType() {
        return BOpcProxyExt.TYPE;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == read) {
            if (this.reading) {
                return null;
            }
            this.reading = true;
        } else if (action == write) {
            if (this.writing) {
                return null;
            }
            this.writing = true;
        }
        BOpcNetwork bOpcNetwork = this.getOpcNetwork();
        if (bOpcNetwork != null) {
            bOpcNetwork.enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(BOpcProxyExt bOpcProxyExt) {
        Object object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.put(bOpcProxyExt.getId(), bOpcProxyExt);
            return;
        }
    }

    public void started() throws Exception {
        this.reading = false;
        this.writing = false;
        BTimeTrigger bTimeTrigger = this.getReadTrigger();
        this.linkTo("readLink", (BComponent)bTimeTrigger, (Slot)BTimeTrigger.fireTrigger, (Slot)read);
        bTimeTrigger = this.getWriteTrigger();
        this.linkTo("writeLink", (BComponent)bTimeTrigger, (Slot)BTimeTrigger.fireTrigger, (Slot)write);
        super.started();
    }

    public void stopped() throws Exception {
        try {
            Property property = this.getProperty("readLink");
            if (property != null) {
                this.remove(property, null);
            }
            if ((property = this.getProperty("writeLink")) != null) {
                this.opcWriteLog.trace("OpcPointDeviceExt::Stopped, Write Link stopped...");
                this.remove(property, null);
            }
        }
        catch (Exception exception) {}
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(BOpcProxyExt bOpcProxyExt, Context context) {
        this.opcSubscriptionLog.trace("PointDeviceExt::Subscribe() called for point:: " + bOpcProxyExt.getId());
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.put(bOpcProxyExt.getHandle(), bOpcProxyExt);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsubscribe(BOpcProxyExt bOpcProxyExt, Context context) {
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(bOpcProxyExt.getHandle(), bOpcProxyExt);
            this.opcSubscriptionLog.trace("PointDeviceExt::unSubscribe() called-for point::" + bOpcProxyExt.getId());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(BOpcProxyExt bOpcProxyExt, Context context) {
        Object object = this.mutexWrite;
        synchronized (object) {
            this.pendingWrite.put(bOpcProxyExt.getHandle(), bOpcProxyExt);
            return;
        }
    }

    public void cancelTransaction() {
        Map.Entry entry;
        Iterator iterator;
        int n = 0;
        Integer n2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        OpcAsyncIo2 opcAsyncIo2 = null;
        try {
            opcAsyncIo2 = this.peer.getAsyncIo();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            this.message("Cancel failed: " + string);
            this.opcLog.error("Cancel", (Throwable)exception);
            return;
        }
        if (this.extAsyncReadMap != null && this.extAsyncReadMap.size() > 0) {
            nArray = new int[this.extAsyncReadMap.size()];
            iterator = this.extAsyncReadMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                n2 = (Integer)entry.getValue();
                nArray[n] = n2;
                ++n;
            }
        }
        if (this.extAsyncWriteMap != null && this.extAsyncWriteMap.size() > 0) {
            nArray2 = new int[this.extAsyncWriteMap.size()];
            iterator = this.extAsyncWriteMap.entrySet().iterator();
            n = 0;
            while (iterator.hasNext()) {
                entry = iterator.next();
                n2 = (Integer)entry.getValue();
                nArray2[n] = n2;
                ++n;
            }
        }
        opcAsyncIo2.cancel2(nArray, nArray2);
    }

    protected synchronized void add(BOpcProxyExt bOpcProxyExt) {
        if (this.extMap == null) {
            this.extMap = new TreeMap(new Comparator(){

                public final int compare(Object object, Object object2) {
                    int n;
                    int n2 = object.hashCode();
                    if (n2 > (n = object2.hashCode())) {
                        return -1;
                    }
                    if (n2 < n) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.extMap.put(bOpcProxyExt.getHandle(), bOpcProxyExt);
    }

    protected OpcGroup getPeer() {
        return this.peer;
    }

    protected synchronized void remove(BOpcProxyExt bOpcProxyExt) {
        this.extMap.remove(bOpcProxyExt.getHandle());
    }

    protected synchronized void addToServerHandleMap(BOpcProxyExt bOpcProxyExt) {
        if (this.extServerHandleMap == null) {
            this.extServerHandleMap = new TreeMap(new Comparator(){

                public final int compare(Object object, Object object2) {
                    int n;
                    int n2 = object.hashCode();
                    if (n2 > (n = object2.hashCode())) {
                        return -1;
                    }
                    if (n2 < n) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.extServerHandleMap.put(new Integer(bOpcProxyExt.getServerHandle()), bOpcProxyExt);
    }

    protected synchronized void removeFromServerHandleMap(int n) {
        if (this.extServerHandleMap != null) {
            this.extServerHandleMap.remove(new Integer(n));
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void checkReadWriteMode() {
        if (this.getReadMode() == BOpcReadMode.sync && this.getWriteMode() == BOpcWriteMode.sync) {
            if (!this.getAsyncIo()) return;
            try {
                this.opcLog.trace("PointDeviceExt::Unregistering async callback");
                this.isFirstTime = true;
                Object object = this.mutexUnregisterCallbackInProgress;
                synchronized (object) {
                    this.cancelTransaction();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    this.peer.unregisterAsyncCallback();
                    this.resetFlags();
                    this.setAsyncIo(false);
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.isFirstTime) return;
                this.opcLog.warning("Unregistering async callback: " + this.toPathString(), (Throwable)exception);
                this.isFirstTime = false;
                return;
            }
        }
        if (this.getAsyncIo()) return;
        try {
            this.opcLog.trace("PointDeviceExt::Registering async callback");
            this.peer.registerAsyncCallback();
            this.setAsyncIo(true);
            this.isFirstTime = true;
            return;
        }
        catch (Exception exception) {
            if (this.isFirstTime) {
                this.opcLog.warning("Registering async callback: " + this.toPathString(), (Throwable)exception);
                this.isFirstTime = false;
            }
            this.setReadMode(BOpcReadMode.sync);
            this.setWriteMode(BOpcWriteMode.sync);
            this.setAsyncIo(false);
        }
    }

    private final void registerCallback() {
        try {
            this.opcLog.trace("PointDeviceExt::Registering async callback from attach");
            this.peer.registerAsyncCallback();
            this.setAsyncIo(true);
        }
        catch (Exception exception) {
            this.opcLog.trace("Registering async callback: " + this.toPathString(), (Throwable)exception);
            this.setReadMode(BOpcReadMode.sync);
            this.setWriteMode(BOpcWriteMode.sync);
            this.setAsyncIo(false);
        }
    }

    private final BOpcProxyExt getProxyExtFromClientHandle(int n) {
        if (this.extMap == null) {
            return null;
        }
        return (BOpcProxyExt)this.extMap.get(new Integer(n));
    }

    private final BOpcProxyExt getProxyExtFromServerHandle(int n) {
        if (this.extServerHandleMap == null) {
            return null;
        }
        if (this.extServerHandleMap.isEmpty()) {
            return null;
        }
        return (BOpcProxyExt)this.extServerHandleMap.get(new Integer(n));
    }

    private final void message(String string) {
        this.setMessage(string);
        this.setMessageTime(Clock.time());
    }

    /*
     * Exception decompiling
     */
    private final void performRead() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 17->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void performSubscribe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 17->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void performUnsubscribe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 17->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void readResult(int n, BStatusValue bStatusValue, long l, int n2, int n3, boolean bl) {
        BOpcProxyExt bOpcProxyExt = null;
        bOpcProxyExt = bl ? this.getProxyExtFromServerHandle(n) : this.getProxyExtFromClientHandle(n);
        BOpcDaClient bOpcDaClient = this.getDaClient();
        if (bOpcProxyExt == null) {
            this.opcLog.trace("Item not found " + this.toPathString() + " client handle : " + n + " HRESULT " + n3);
            return;
        }
        if (OpcEnv.failed(n3)) {
            bOpcProxyExt.readFail(OpcEnv.resultString(n3));
            bOpcProxyExt.setIsReadInProgress(false);
            this.opcLog.trace("PointDeviceExt::readResult()-Point::" + bOpcProxyExt.getId() + " read failed. HRESULT::" + n3);
            return;
        }
        bOpcProxyExt.readResult(bStatusValue, l, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void onReadCompleted(int var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5, int[] var6_6, String[] var7_7, int[] var8_8, long[] var9_9, int[] var10_10) {
        var11_11 = null;
        this.opcLog.trace("PointDeviceExt::onReadCompleted, gets called for item");
        try {
            block14: {
                block13: {
                    if (var5_5 == null) break block13;
                    var13_12 = 0;
                    if (true) ** GOTO lbl27
                }
                this.opcLog.trace("PointDeviceExr::onReadCompleted, clientHandle array is null");
                break block14;
                do {
                    if (1 == var6_6[var13_12]) {
                        var14_16 = Double.valueOf(var7_7[var13_12].trim());
                        var12_15 /* !! */  = new BStatusNumeric(var14_16);
                    } else if (2 == var6_6[var13_12]) {
                        var14_17 = false;
                        if (var7_7[var13_12].trim().equalsIgnoreCase("true")) {
                            var14_17 = true;
                        }
                        var12_15 /* !! */  = new BStatusBoolean(var14_17);
                    } else {
                        var12_15 /* !! */  = 3 == var6_6[var13_12] ? new BStatusString(var7_7[var13_12].trim()) : null;
                    }
                    if (var3_3 == 0) {
                        this.readResult(var5_5[var13_12], (BStatusValue)var12_15 /* !! */ , var9_9[var13_12], var8_8[var13_12], 0, false);
                    } else {
                        this.readResult(var5_5[var13_12], (BStatusValue)var12_15 /* !! */ , var9_9[var13_12], var8_8[var13_12], var10_10[var13_12], false);
                    }
                    ++var13_12;
lbl27:
                    // 2 sources

                } while (var13_12 < var4_4);
            }
            if (this.extAsyncReadMap.size() <= 0) return;
            var13_13 = this.mutexAsyncReadMap;
            synchronized (var13_13) {
                this.extAsyncReadMap.remove(new Integer(var1_1));
                return;
            }
        }
        catch (Exception var13_14) {
            this.opcLog.error("onReadCompleted", (Throwable)var13_14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void onWriteCompleted(int var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5, int[] var6_6) {
        this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted get called......::" + var4_4 + ", master result ::" + (var3_3 == 0 ? "OK" : "NOT OK"));
        var7_7 = null;
        try {
            block15: {
                block17: {
                    block16: {
                        if (var5_5 == null) break block15;
                        if (var3_3 != 0) break block16;
                        var8_8 = 0;
                        if (true) ** GOTO lbl37
                    }
                    if (var6_6 == null) break block17;
                    var8_8 = 0;
                    if (true) ** GOTO lbl45
                }
                this.opcWriteLog.trace("PointDeviceExr::OnWriteCompleted, hresultArray array is null");
                var8_8 = 0;
                if (true) ** GOTO lbl53
            }
            this.opcWriteLog.trace("PointDeviceExr::OnWriteCompleted, clientHandle array is null");
lbl18:
            // 4 sources

            while (true) {
                if (this.extAsyncWriteMap.size() <= 0) return;
                var8_9 = this.mutexAsyncWriteMap;
                synchronized (var8_9) {
                    this.extAsyncWriteMap.remove(new Integer(var1_1));
                    return;
                }
                break;
            }
        }
        catch (Exception var8_10) {
            this.opcWriteLog.error("OnWriteCompleted", (Throwable)var8_10);
        }
        return;
        do {
            if ((var7_7 = this.getProxyExtFromClientHandle(var5_5[var8_8])) != null) {
                var7_7.updateWriteResult(var6_6[var8_8]);
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
            }
            ++var8_8;
lbl37:
            // 2 sources

        } while (var8_8 < var4_4);
        ** GOTO lbl18
        do {
            if ((var7_7 = this.getProxyExtFromClientHandle(var5_5[var8_8])) != null) {
                var7_7.updateWriteResult(var6_6[var8_8]);
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
            }
            ++var8_8;
lbl45:
            // 2 sources

        } while (var8_8 < var4_4);
        ** GOTO lbl18
        do {
            if ((var7_7 = this.getProxyExtFromClientHandle(var5_5[var8_8])) != null) {
                var7_7.updateWriteResult(-2147467259);
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
            }
            ++var8_8;
lbl53:
            // 2 sources

        } while (var8_8 < var4_4);
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void onReturnReadAsync(int var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5, int[] var6_6) {
        var7_7 = null;
        var8_8 = false;
        try {
            block19: {
                block17: {
                    block20: {
                        block21: {
                            block18: {
                                if (var5_5 == null) break block17;
                                if (var1_1 != 0) break block18;
                                this.opcLog.trace("PointDeviceExt::onReturnReadAsync, Read Async operation was succeeded will get an Callback");
                                var8_8 = true;
                                break block19;
                            }
                            if (1 != var1_1) break block20;
                            if (var6_6 == null) break block21;
                            var9_9 = 0;
                            if (true) ** GOTO lbl49
                        }
                        this.opcLog.trace("PointDeviceExt::onReturnReadAsync, hresultArray is null");
                        var9_9 = 0;
                        if (true) ** GOTO lbl55
                    }
                    this.opcLog.trace("PointDeviceExt::onReturnReadAsync," + OpcEnv.getDescription(var1_1));
                    var9_9 = 0;
                    if (true) ** GOTO lbl63
                }
                this.opcLog.trace("PointDeviceExt::onReturnReadAsync, incoming array is null");
            }
lbl25:
            // 4 sources

            while (true) {
                if (var8_8 == false) return;
                if (this.extAsyncReadMap == null) return;
                var9_10 = this.mutexAsyncReadMap;
                synchronized (var9_10) {
                    this.extAsyncReadMap.put(new Integer(var3_3), new Integer(var4_4));
                    return;
                }
                break;
            }
        }
        catch (Exception var9_11) {
            this.opcLog.error("onReturnReadAsync", (Throwable)var9_11);
        }
        return;
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                if (var6_6[var9_9] == 0) {
                    var8_8 = true;
                } else {
                    var7_7.updateReadResult(var6_6[var9_9]);
                }
            } else {
                this.opcLog.trace("PointDeviceExt::onReturnReadAsync, serverHandle object is null");
            }
            ++var9_9;
lbl49:
            // 2 sources

        } while (var9_9 < var2_2);
        ** GOTO lbl25
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                var7_7.updateReadResult(-2147467259);
            }
            ++var9_9;
lbl55:
            // 2 sources

        } while (var9_9 < var2_2);
        ** GOTO lbl25
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                var7_7.updateReadResult(var1_1);
            } else {
                this.opcLog.trace("PointDeviceExt::onReturnReadAsync, serverHandle object is null");
            }
            ++var9_9;
lbl63:
            // 2 sources

        } while (var9_9 < var2_2);
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void onReturnWriteAsync(int var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5, int[] var6_6) {
        var7_7 = null;
        var8_8 = false;
        try {
            block20: {
                block18: {
                    block21: {
                        block22: {
                            block19: {
                                if (var5_5 == null) break block18;
                                if (var1_1 != 0) break block19;
                                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, Write Async operation was succeeded");
                                var8_8 = true;
                                break block20;
                            }
                            if (1 != var1_1) break block21;
                            if (var6_6 == null) break block22;
                            var9_9 = 0;
                            if (true) ** GOTO lbl49
                        }
                        this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, hresultArray is null");
                        var9_9 = 0;
                        if (true) ** GOTO lbl57
                    }
                    this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray," + OpcEnv.getDescription(var1_1));
                    var9_9 = 0;
                    if (true) ** GOTO lbl65
                }
                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, incoming array is null");
            }
lbl25:
            // 4 sources

            while (true) {
                if (var8_8 == false) return;
                if (this.extAsyncWriteMap == null) return;
                var9_10 = this.mutexAsyncWriteMap;
                synchronized (var9_10) {
                    this.extAsyncWriteMap.put(new Integer(var3_3), new Integer(var4_4));
                    return;
                }
                break;
            }
        }
        catch (Exception var9_11) {
            this.opcWriteLog.error("OnReturnWriteArray", (Throwable)var9_11);
        }
        return;
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                if (var6_6[var9_9] == 0) {
                    var8_8 = true;
                } else {
                    var7_7.updateWriteResult(var6_6[var9_9]);
                }
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
            }
            ++var9_9;
lbl49:
            // 2 sources

        } while (var9_9 < var2_2);
        ** GOTO lbl25
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                var7_7.updateWriteResult(-2147467259);
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
            }
            ++var9_9;
lbl57:
            // 2 sources

        } while (var9_9 < var2_2);
        ** GOTO lbl25
        do {
            if ((var7_7 = this.getProxyExtFromServerHandle(var5_5[var9_9])) != null) {
                var7_7.updateWriteResult(var1_1);
            } else {
                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
            }
            ++var9_9;
lbl65:
            // 2 sources

        } while (var9_9 < var2_2);
        ** while (true)
    }

    private final void onReturnWriteSync(int n, int n2, int[] nArray, int[] nArray2) {
        BOpcProxyExt bOpcProxyExt = null;
        try {
            if (nArray != null) {
                if (n == 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        bOpcProxyExt = this.getProxyExtFromServerHandle(nArray[n3]);
                        if (bOpcProxyExt != null) {
                            bOpcProxyExt.updateWriteResult(0);
                        } else {
                            this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                        }
                        ++n3;
                    }
                } else if (1 == n) {
                    if (nArray2 != null) {
                        int n4 = 0;
                        while (n4 < n2) {
                            bOpcProxyExt = this.getProxyExtFromServerHandle(nArray[n4]);
                            if (bOpcProxyExt != null) {
                                bOpcProxyExt.updateWriteResult(nArray2[n4]);
                            } else {
                                this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                            }
                            ++n4;
                        }
                    } else {
                        this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, hresultArray is null");
                    }
                } else {
                    this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync," + OpcEnv.getDescription(n));
                    int n5 = 0;
                    while (n5 < n2) {
                        bOpcProxyExt = this.getProxyExtFromServerHandle(nArray[n5]);
                        if (bOpcProxyExt != null) {
                            bOpcProxyExt.updateWriteResult(n);
                        } else {
                            this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                        }
                        ++n5;
                    }
                }
            } else {
                this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, incoming array is null");
            }
        }
        catch (Exception exception) {
            this.opcWriteLog.error("onReturnWriteSync", (Throwable)exception);
        }
    }

    private final void setAttached() {
        this.setState(BOpcState.attached);
    }

    private final void setAttaching() {
        this.setState(BOpcState.attaching);
    }

    private final void setDetached() {
        this.setState(BOpcState.detached);
    }

    private final void setDetaching() {
        this.setState(BOpcState.detaching);
    }

    private final void resetFlags() {
        BControlPoint[] bControlPointArray = this.getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            if (bControlPointArray[n].getProxyExt() instanceof BOpcProxyExt) {
                ((BOpcProxyExt)bControlPointArray[n].getProxyExt()).setIsReadInProgress(false);
                ((BOpcProxyExt)bControlPointArray[n].getProxyExt()).setIsWriteInProgress(false);
                ((BOpcProxyExt)bControlPointArray[n].getProxyExt()).setIsAddRemoveInProgress(false);
                ((BOpcProxyExt)bControlPointArray[n].getProxyExt()).writeReset();
            }
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mutexRead = new Object();
        this.mutexSubscribe = new Object();
        this.mutexUnsubscribe = new Object();
        this.mutexWrite = new Object();
        this.mutexReadWriteInProgress = new Object();
        this.mutexAsyncReadMap = new Object();
        this.mutexAsyncWriteMap = new Object();
        this.mutexUnregisterCallbackInProgress = new Object();
        this.peer = null;
        this.pendingRead = new TreeMap();
        this.pendingSubscribe = new TreeMap();
        this.pendingUnsubscribe = new TreeMap();
        this.pendingWrite = new TreeMap();
        this.reading = false;
        this.writing = false;
        this.readTxsId = new Counter();
        this.writeTxsId = new Counter();
        this.extAsyncWriteMap = new TreeMap();
        this.extAsyncReadMap = new TreeMap();
        this.isFirstTime = true;
        this.opcLog = Log.getLog((String)"OpcDaLog");
        this.opcWriteLog = Log.getLog((String)"OpcDaWriteLog");
        this.opcSubscriptionLog = Log.getLog((String)"OpcDaSubLog");
    }

    public BOpcPointDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$opc$client$point$BOpcPointDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$opc$client$point$BOpcPointDeviceExt = BOpcPointDeviceExt.class("[Lcom.tridium.opc.client.point.BOpcPointDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Listener
    implements OpcGroup.GroupListener {
        public void asyncCallbackDeleted() {
            BOpcPointDeviceExt.this.getState().isEngaged();
        }

        public void updateBoolean(int n, boolean bl, long l, int n2, int n3, boolean bl2) {
            BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
            BOpcPointDeviceExt.this.readResult(n, (BStatusValue)bStatusBoolean, l, n2, n3, bl2);
        }

        public void updateError(int n, long l, int n2, int n3, boolean bl) {
            BOpcPointDeviceExt.this.readResult(n, null, l, n2, n3, bl);
        }

        public void updateNumeric(int n, double d, long l, int n2, int n3, boolean bl) {
            BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
            BOpcPointDeviceExt.this.readResult(n, (BStatusValue)bStatusNumeric, l, n2, n3, bl);
        }

        public void updateString(int n, String string, long l, int n2, int n3, boolean bl) {
            BStatusString bStatusString = new BStatusString(string);
            BOpcPointDeviceExt.this.readResult(n, (BStatusValue)bStatusString, l, n2, n3, bl);
        }

        public void OnWriteCompleted(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
            BOpcPointDeviceExt.this.onWriteCompleted(n, n2, n3, n4, nArray, nArray2);
        }

        public void OnReturnWrite(boolean bl, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
            if (bl) {
                BOpcPointDeviceExt.this.onReturnWriteSync(n, n2, nArray, nArray2);
            } else {
                BOpcPointDeviceExt.this.onReturnWriteAsync(n, n2, n3, n4, nArray, nArray2);
            }
        }

        public void OnReturnRead(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
            BOpcPointDeviceExt.this.onReturnReadAsync(n, n2, n3, n4, nArray, nArray2);
        }

        public void OnReadCompleted(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, String[] stringArray, int[] nArray3, long[] lArray, int[] nArray4) {
            BOpcPointDeviceExt.this.onReadCompleted(n, n2, n3, n4, nArray, nArray2, stringArray, nArray3, lArray, nArray4);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Counter {
        private int count;

        public int increment() {
            if (this.count == Integer.MAX_VALUE) {
                this.count = 1;
            }
            return this.count++;
        }

        private final /* synthetic */ void this() {
            this.count = 1;
        }

        private Counter() {
            this.this();
        }
    }
}

