/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDASecurity;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcDeviceFolder;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.jni.client.common.OpcServer;
import com.tridium.opc.jni.client.da.OpcDaServer;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOpcDaClient
extends BOpcDevice {
    public static final Property serverState = BOpcDaClient.newProperty((int)3, (String)"", null);
    public static final Property serverCurrentTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property serverLastUpdateTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property serverStartTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property serverGroupCount = BOpcDaClient.newProperty((int)3, (int)0, null);
    public static final Property serverBandWidth = BOpcDaClient.newProperty((int)3, (int)0, null);
    public static final Property serverMajorVersion = BOpcDaClient.newProperty((int)3, (int)0, null);
    public static final Property serverMinorVersion = BOpcDaClient.newProperty((int)3, (int)0, null);
    public static final Property serverBuildNumber = BOpcDaClient.newProperty((int)3, (int)0, null);
    public static final Property serverVendorInfo = BOpcDaClient.newProperty((int)3, (String)"", null);
    public static final Property lastConnectTime = BOpcDaClient.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property lastShutdownRequest = BOpcDaClient.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property points = BOpcDaClient.newProperty((int)0, (BValue)new BOpcPointDeviceExt(), null);
    public static final Property security = BOpcDaClient.newProperty((int)0, (BValue)new BOpcDASecurity(), null);
    public static final Property isUserLoggedIn = BOpcDaClient.newProperty((int)5, (boolean)false, null);
    public static final Action attach = BOpcDaClient.newAction((int)20, null);
    public static final Action detach = BOpcDaClient.newAction((int)20, null);
    public static final Action setSecurity = BOpcDaClient.newAction((int)4, null);
    public static final Action getServerSecured = BOpcDaClient.newAction((int)4, null);
    public static final Action setServerSecured = BOpcDaClient.newAction((int)4, (BValue)BBoolean.FALSE, null);
    public static final Type TYPE;
    private Object detachMutex;
    private Object attachMutex;
    private OpcDaServer server;
    boolean bNTSecurityInterfaceSupport;
    boolean bPrivateSecurityInterfaceSupport;
    Log opcLog;
    Log opcPingLog;
    static /* synthetic */ Class class$com$tridium$opc$client$BOpcDaClient;

    public String getServerState() {
        return this.getString(serverState);
    }

    public void setServerState(String string) {
        this.setString(serverState, string, null);
    }

    public BAbsTime getServerCurrentTime() {
        return (BAbsTime)this.get(serverCurrentTime);
    }

    public void setServerCurrentTime(BAbsTime bAbsTime) {
        this.set(serverCurrentTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getServerLastUpdateTime() {
        return (BAbsTime)this.get(serverLastUpdateTime);
    }

    public void setServerLastUpdateTime(BAbsTime bAbsTime) {
        this.set(serverLastUpdateTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getServerStartTime() {
        return (BAbsTime)this.get(serverStartTime);
    }

    public void setServerStartTime(BAbsTime bAbsTime) {
        this.set(serverStartTime, (BValue)bAbsTime, null);
    }

    public int getServerGroupCount() {
        return this.getInt(serverGroupCount);
    }

    public void setServerGroupCount(int n) {
        this.setInt(serverGroupCount, n, null);
    }

    public int getServerBandWidth() {
        return this.getInt(serverBandWidth);
    }

    public void setServerBandWidth(int n) {
        this.setInt(serverBandWidth, n, null);
    }

    public int getServerMajorVersion() {
        return this.getInt(serverMajorVersion);
    }

    public void setServerMajorVersion(int n) {
        this.setInt(serverMajorVersion, n, null);
    }

    public int getServerMinorVersion() {
        return this.getInt(serverMinorVersion);
    }

    public void setServerMinorVersion(int n) {
        this.setInt(serverMinorVersion, n, null);
    }

    public int getServerBuildNumber() {
        return this.getInt(serverBuildNumber);
    }

    public void setServerBuildNumber(int n) {
        this.setInt(serverBuildNumber, n, null);
    }

    public String getServerVendorInfo() {
        return this.getString(serverVendorInfo);
    }

    public void setServerVendorInfo(String string) {
        this.setString(serverVendorInfo, string, null);
    }

    public BAbsTime getLastConnectTime() {
        return (BAbsTime)this.get(lastConnectTime);
    }

    public void setLastConnectTime(BAbsTime bAbsTime) {
        this.set(lastConnectTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastShutdownRequest() {
        return (BAbsTime)this.get(lastShutdownRequest);
    }

    public void setLastShutdownRequest(BAbsTime bAbsTime) {
        this.set(lastShutdownRequest, (BValue)bAbsTime, null);
    }

    public BOpcPointDeviceExt getPoints() {
        return (BOpcPointDeviceExt)this.get(points);
    }

    public void setPoints(BOpcPointDeviceExt bOpcPointDeviceExt) {
        this.set(points, (BValue)bOpcPointDeviceExt, null);
    }

    public BOpcDASecurity getSecurity() {
        return (BOpcDASecurity)this.get(security);
    }

    public void setSecurity(BOpcDASecurity bOpcDASecurity) {
        this.set(security, (BValue)bOpcDASecurity, null);
    }

    public boolean getIsUserLoggedIn() {
        return this.getBoolean(isUserLoggedIn);
    }

    public void setIsUserLoggedIn(boolean bl) {
        this.setBoolean(isUserLoggedIn, bl, null);
    }

    public void attach() {
        this.invoke(attach, null, null);
    }

    public void detach() {
        this.invoke(detach, null, null);
    }

    public BLong setSecurity() {
        return (BLong)this.invoke(setSecurity, null, null);
    }

    public BBoolean getServerSecured() {
        return (BBoolean)this.invoke(getServerSecured, null, null);
    }

    public void setServerSecured(BBoolean bBoolean) {
        this.invoke(setServerSecured, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * Exception decompiling
     */
    public void doAttach() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [8 : 13->396)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDetach() {
        Object object = this.detachMutex;
        synchronized (object) {
            if (this.getState().isDetached()) {
                return;
            }
            try {
                try {
                    this.opcLog.trace("Disconnecting");
                    this.setDetaching();
                    if (this.server != null) {
                        this.getPoints().detach();
                        this.server.release();
                        this.opcLog.trace("Server release() called");
                    }
                    this.opcLog.trace("Disconnected");
                }
                catch (Throwable throwable) {
                    this.opcLog.error("Failure disconnecting", throwable);
                    this.opcLog.trace("doDetach::AsyncIo set to false");
                }
                Object var4_5 = null;
                this.server = null;
                this.setServerState("");
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.server = null;
                this.setServerState("");
                this.setDetached();
                this.opcLog.trace("doDetach::Detached");
                throw throwable;
            }
            this.setDetached();
            this.opcLog.trace("doDetach::Detached");
            return;
        }
    }

    public void doPing() {
        OpcEnv.initializeThread();
        this.opcPingLog.trace("doPing()::Initialized Threads");
        try {
            if (this.getState().isAttached()) {
                this.opcPingLog.trace("doPing()::Server is attached already. Refreshing status");
                OpcDaServer.Status status = this.server.getStatus();
                this.setServerStartTime(BAbsTime.make((long)status.startTime, (BTimeZone)BTimeZone.UTC));
                this.setServerCurrentTime(BAbsTime.make((long)status.currentTime, (BTimeZone)BTimeZone.UTC));
                this.setServerLastUpdateTime(BAbsTime.make((long)status.lastUpdateTime, (BTimeZone)BTimeZone.UTC));
                boolean bl = this.setServerStatusInfo(status);
                if (bl) {
                    this.pingOk();
                    this.opcPingLog.trace("doPing()::Ping is successful");
                } else {
                    this.pingFail(this.getServerState());
                    this.opcPingLog.trace("doPing()::Ping failed. The server state is:: " + this.getServerState());
                }
            } else if (this.getState().isDetached()) {
                this.opcPingLog.trace("doPing()::Currently server detached. calling Attach()");
                this.attach();
            }
        }
        catch (Throwable throwable) {
            this.opcPingLog.error("Ping failed", throwable);
            this.pingFail(throwable.getMessage());
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BOpcNetwork || bComponent instanceof BOpcDeviceFolder;
    }

    private final boolean setServerStatusInfo(OpcDaServer.Status status) {
        boolean bl = this.updateServerState(status.state);
        this.setServerGroupCount(status.groupCount);
        this.setServerBandWidth(status.bandwidth);
        this.setServerMajorVersion(status.majorVersion);
        this.setServerMinorVersion(status.minorVersion);
        this.setServerBuildNumber(status.buildNumber);
        this.setServerVendorInfo(status.vendorInfo);
        return bl;
    }

    public OpcDaServer getPeer() {
        return this.server;
    }

    private final boolean updateServerState(int n) {
        String string = null;
        boolean bl = true;
        BOpcNetwork bOpcNetwork = this.getOpcNetwork();
        if (bOpcNetwork == null) {
            System.out.println("Network object is NULL");
            return bl;
        }
        switch (n) {
            case 1: {
                string = bOpcNetwork.lex("daServerState.running");
                bl = true;
                break;
            }
            case 2: {
                string = bOpcNetwork.lex("daServerState.failed");
                bl = false;
                break;
            }
            case 3: {
                string = bOpcNetwork.lex("daServerState.noConfig");
                bl = false;
                break;
            }
            case 4: {
                string = bOpcNetwork.lex("daServerState.suspended");
                bl = false;
                break;
            }
            case 5: {
                string = bOpcNetwork.lex("daServerState.test");
                bl = true;
                break;
            }
            case 6: {
                string = bOpcNetwork.lex("daServerState.commFault");
                bl = true;
                break;
            }
            default: {
                string = bOpcNetwork.lex("daServerState.unknown") + ": " + n;
                bl = true;
            }
        }
        if (!this.getServerState().equals(string)) {
            this.setServerState(string);
            if (!bl) {
                this.opcLog.warning("Server state: " + string);
            }
        }
        return bl;
    }

    public BLong doSetSecurity() {
        BLong bLong = BLong.make((long)this.setSecurityConfiguration());
        return bLong;
    }

    public BBoolean doGetServerSecured() {
        return BBoolean.make((boolean)this.getIsUserLoggedIn());
    }

    public void doSetServerSecured(BBoolean bBoolean) {
        this.setIsUserLoggedIn(bBoolean.getBoolean());
    }

    public long setSecurityConfiguration() {
        long l = 0L;
        long l2 = 0L;
        this.opcLog.trace("Set Security Configuration");
        if (!this.getSecurity().getPrivateSecurity()) {
            this.opcLog.trace("Private security is not selected");
            if (this.bNTSecurityInterfaceSupport) {
                this.opcLog.trace("NT security is supported by the server");
                l2 = this.getPeer().getNTSecurity().changeUser(this.getSecurity().getLoginName(), this.getSecurity().getLoginPassword().getString());
                switch ((int)l2) {
                    case 0: {
                        l = 0L;
                        break;
                    }
                    case -1: {
                        l = -1;
                        break;
                    }
                    case -2: {
                        l = -2L;
                        break;
                    }
                    case -3: {
                        l = -3L;
                        break;
                    }
                    case -4: {
                        l = -4L;
                        break;
                    }
                    case -5: {
                        l = -5L;
                        break;
                    }
                }
            } else {
                l = 1L;
            }
        } else if (this.getSecurity().getPrivateSecurity()) {
            this.opcLog.trace("Private security is selected");
            if (this.bPrivateSecurityInterfaceSupport) {
                this.opcLog.trace("Private security is supported by the server");
                if (this.getSecurity().getState().getOrdinal() == 0) {
                    l2 = this.getPeer().getPrivateSecurity().logOn(this.getSecurity().getLoginName(), this.getSecurity().getLoginPassword().getString());
                    switch ((int)l2) {
                        case 0: {
                            l = 0L;
                            break;
                        }
                        case -1: {
                            l = -6L;
                            break;
                        }
                        case -2: {
                            l = -7L;
                            break;
                        }
                        case -3: {
                            l = -8L;
                            break;
                        }
                        case -4: {
                            l = -9L;
                            break;
                        }
                        case -5: {
                            l = -10L;
                            break;
                        }
                    }
                } else {
                    boolean bl = this.getPeer().getPrivateSecurity().logOff();
                    l = bl ? 0L : -11L;
                }
            } else {
                l = 2;
            }
        }
        this.setIsUserLoggedIn(true);
        this.lease(5);
        return l;
    }

    private final void setLoginSettingsToCurrentInstance() {
        if (this.getSecurity().getLoginName() != "" && this.getSecurity().getLoginPassword().getString() != "") {
            this.setSecurityConfiguration();
        }
    }

    private final void MakeSlotsReadOnly() {
        if (!this.bNTSecurityInterfaceSupport && !this.bPrivateSecurityInterfaceSupport) {
            this.setFlags(this.getSlot("security"), 4);
        } else {
            this.getSecurity().MakeSlotsReadOnly(this.bNTSecurityInterfaceSupport, this.bPrivateSecurityInterfaceSupport);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.detachMutex = new Object();
        this.attachMutex = new Object();
        this.bNTSecurityInterfaceSupport = false;
        this.bPrivateSecurityInterfaceSupport = false;
        this.opcLog = Log.getLog((String)"OpcDaLog");
        this.opcPingLog = Log.getLog((String)"OpcDaPingLog");
    }

    public BOpcDaClient() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$opc$client$BOpcDaClient;
        if (clazz == null) {
            clazz = class$com$tridium$opc$client$BOpcDaClient = BOpcDaClient.class("[Lcom.tridium.opc.client.BOpcDaClient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Shutdown
    implements OpcServer.ShutdownListener {
        public void shutdownDeleted() {
            if (BOpcDaClient.this.getState().isAttached() && BOpcDaClient.this.isRunning()) {
                BOpcDaClient.this.opcLog.warning("Shutdown callback deleted.");
                BOpcDaClient.this.server.setShutdownListener(this);
            }
        }

        public void shutdownRequest(String string) {
            BOpcDaClient.this.setLastShutdownRequest(Clock.time());
            BOpcDaClient.this.opcLog.warning("Shutdown request. Detaching...");
            BOpcDaClient.this.doDetach();
            BOpcDaClient.this.pingFail("Server shutdown request");
        }

        private Shutdown() {
        }
    }
}

