/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.concurrent.AbstractExecutorService;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.Executors;
import com.tridium.util.backport.concurrent.Future;
import com.tridium.util.backport.concurrent.RejectedExecutionException;
import com.tridium.util.backport.concurrent.RejectedExecutionHandler;
import com.tridium.util.backport.concurrent.ThreadFactory;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.atomic.AtomicInteger;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;
    private final AtomicInteger ctl;
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock;
    private final HashSet workers;
    private final Condition termination;
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;

    private static final int runStateOf(int n) {
        return n & 0xE0000000;
    }

    private static final int workerCountOf(int n) {
        return n & 0x1FFFFFFF;
    }

    private static final int ctlOf(int n, int n2) {
        return n | n2;
    }

    private static final boolean runStateLessThan(int n, int n2) {
        boolean bl = false;
        if (n < n2) {
            bl = true;
        }
        return bl;
    }

    private static final boolean runStateAtLeast(int n, int n2) {
        boolean bl = false;
        if (n >= n2) {
            bl = true;
        }
        return bl;
    }

    private static final boolean isRunning(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean compareAndIncrementWorkerCount(int n) {
        return this.ctl.compareAndSet(n, n + 1);
    }

    private final boolean compareAndDecrementWorkerCount(int n) {
        return this.ctl.compareAndSet(n, n - 1);
    }

    private final void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    private final void advanceRunState(int n) {
        int n2;
        while (!ThreadPoolExecutor.runStateAtLeast(n2 = this.ctl.get(), n) && !this.ctl.compareAndSet(n2, ThreadPoolExecutor.ctlOf(n, ThreadPoolExecutor.workerCountOf(n2)))) {
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void tryTerminate() {
        int n;
        while (!(ThreadPoolExecutor.isRunning(n = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(n, 0x40000000) || ThreadPoolExecutor.runStateOf(n) == 0 && !this.workQueue.isEmpty())) {
            Object var4_3;
            if (ThreadPoolExecutor.workerCountOf(n) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (this.ctl.compareAndSet(n, ThreadPoolExecutor.ctlOf(0x40000000, 0))) {
                    try {
                        this.terminated();
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                        throw throwable;
                    }
                    {
                        Object var6_6 = null;
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                    }
                    var4_3 = null;
                    reentrantLock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                var4_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                var4_3 = null;
                reentrantLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkShutdownAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) return;
        securityManager.checkPermission(shutdownPerm);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                securityManager.checkAccess(worker.thread);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var4_7 = null;
            reentrantLock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void interruptWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                try {
                    worker.thread.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var3_6 = null;
            reentrantLock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void interruptIdleWorkers(boolean bl) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                Thread thread = worker.thread;
                if (!thread.isInterrupted() && worker.tryLock()) {
                    Object var9_6;
                    try {
                        try {
                            thread.interrupt();
                        }
                        catch (SecurityException securityException) {}
                    }
                    catch (Throwable throwable) {
                        var9_6 = null;
                        worker.unlock();
                        throw throwable;
                    }
                    {
                        var9_6 = null;
                    }
                    worker.unlock();
                }
                if (!bl) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var4_10 = null;
            reentrantLock.unlock();
            return;
        }
    }

    private final void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    private final void clearInterruptsForTaskRun() {
        if (ThreadPoolExecutor.runStateLessThan(this.ctl.get(), 0x20000000) && Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) {
            Thread.currentThread().interrupt();
        }
    }

    final void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean bl) {
        int n = ThreadPoolExecutor.runStateOf(this.ctl.get());
        boolean bl2 = false;
        if (n == -536870912 || n == 0 && bl) {
            bl2 = true;
        }
        return bl2;
    }

    private final List drainQueue() {
        BlockingQueue blockingQueue = this.workQueue;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        blockingQueue.drainTo(arrayList);
        if (!blockingQueue.isEmpty()) {
            Runnable[] runnableArray = blockingQueue.toArray(new Runnable[0]);
            int n = 0;
            while (n < runnableArray.length) {
                Runnable runnable = runnableArray[n];
                if (blockingQueue.remove(runnable)) {
                    arrayList.add(runnable);
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean addWorker(Runnable runnable, boolean bl) {
        ReentrantLock reentrantLock;
        Thread thread;
        while (true) {
            int n;
            int n2;
            if ((n2 = ThreadPoolExecutor.runStateOf(n = this.ctl.get())) >= 0 && (n2 != 0 || runnable != null || this.workQueue.isEmpty())) {
                return false;
            }
            do {
                int n3;
                if ((n3 = ThreadPoolExecutor.workerCountOf(n)) < 0x1FFFFFFF && n3 < (bl ? this.corePoolSize : this.maximumPoolSize)) {
                    if (!this.compareAndIncrementWorkerCount(n)) continue;
                    Worker worker = new Worker(runnable);
                    thread = worker.thread;
                    reentrantLock = this.mainLock;
                    reentrantLock.lock();
                    int n4 = this.ctl.get();
                    int n5 = ThreadPoolExecutor.runStateOf(n4);
                    if (thread == null || n5 >= 0 && (n5 != 0 || runnable != null)) {
                        this.decrementWorkerCount();
                        this.tryTerminate();
                        boolean bl2 = false;
                        Object var7_12 = null;
                        reentrantLock.unlock();
                        return bl2;
                    }
                    this.workers.add(worker);
                    int n6 = this.workers.size();
                    if (n6 > this.largestPoolSize) {
                        this.largestPoolSize = n6;
                    }
                }
                return false;
            } while (ThreadPoolExecutor.runStateOf(n = this.ctl.get()) == n2);
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var7_14 = null;
            reentrantLock.unlock();
            thread.start();
        }
        if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x20000000 && !thread.isInterrupted()) {
            thread.interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processWorkerExit(Worker worker, boolean bl) {
        int n;
        if (bl) {
            this.decrementWorkerCount();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            this.workers.remove(worker);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var5_6 = null;
            reentrantLock.unlock();
            this.tryTerminate();
            n = this.ctl.get();
        }
        if (ThreadPoolExecutor.runStateLessThan(n, 0x20000000)) {
            if (!bl) {
                int n2;
                int n3 = 0;
                if (!this.allowCoreThreadTimeOut) {
                    n3 = this.corePoolSize;
                }
                if ((n2 = n3) == 0 && !this.workQueue.isEmpty()) {
                    n2 = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(n) >= n2) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private final Runnable getTask() {
        boolean bl = false;
        while (true) {
            boolean bl2;
            block7: {
                int n;
                int n2;
                if ((n2 = ThreadPoolExecutor.runStateOf(n = this.ctl.get())) >= 0 && (n2 >= 0x20000000 || this.workQueue.isEmpty())) {
                    this.decrementWorkerCount();
                    return null;
                }
                do {
                    int n3 = ThreadPoolExecutor.workerCountOf(n);
                    boolean bl3 = false;
                    if (this.allowCoreThreadTimeOut || n3 > this.corePoolSize) {
                        bl3 = bl2 = true;
                    }
                    if (n3 <= this.maximumPoolSize && (!bl || !bl2)) break block7;
                    if (!this.compareAndDecrementWorkerCount(n)) continue;
                    return null;
                } while (ThreadPoolExecutor.runStateOf(n = this.ctl.get()) == n2);
                continue;
            }
            try {
                Runnable runnable;
                Runnable runnable2 = runnable = bl2 ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take();
                if (runnable != null) {
                    return runnable;
                }
                bl = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void runWorker(Worker worker) {
        Runnable runnable = worker.firstTask;
        worker.firstTask = null;
        boolean bl = true;
        try {
            while (true) {
                Object var7_4;
                block14: {
                    if (runnable != null || (runnable = this.getTask()) != null) break block14;
                    bl = false;
                    break;
                }
                worker.lock();
                this.clearInterruptsForTaskRun();
                try {
                    Object var10_6;
                    this.beforeExecute(worker.thread, runnable);
                    Throwable throwable = null;
                    try {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException runtimeException) {
                            throwable = runtimeException;
                            throw runtimeException;
                        }
                        catch (Error error) {
                            throwable = error;
                            throw error;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw new Error(throwable2);
                        }
                    }
                    catch (Throwable throwable3) {
                        var10_6 = null;
                        this.afterExecute(runnable, throwable);
                        throw throwable3;
                    }
                    {
                        var10_6 = null;
                        this.afterExecute(runnable, throwable);
                    }
                }
                catch (Throwable throwable) {
                    var7_4 = null;
                    runnable = null;
                    ++worker.completedTasks;
                    worker.unlock();
                    throw throwable;
                }
                {
                    var7_4 = null;
                    runnable = null;
                    ++worker.completedTasks;
                }
                worker.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            this.processWorkerExit(worker, bl);
            throw throwable;
        }
        {
            Object var5_14 = null;
            this.processWorkerExit(worker, bl);
            return;
        }
    }

    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        int n = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(n) < this.corePoolSize) {
            if (this.addWorker(runnable, true)) {
                return;
            }
            n = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(n) && this.workQueue.offer(runnable)) {
            int n2 = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(n2) && this.remove(runnable)) {
                this.reject(runnable);
            } else if (ThreadPoolExecutor.workerCountOf(n2) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(runnable, false)) {
            this.reject(runnable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            reentrantLock.unlock();
            this.tryTerminate();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List shutdownNow() {
        List list;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            list = this.drainQueue();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var4_5 = null;
            reentrantLock.unlock();
            this.tryTerminate();
            return list;
        }
    }

    public boolean isShutdown() {
        return ThreadPoolExecutor.isRunning(this.ctl.get()) ^ true;
    }

    public boolean isTerminating() {
        int n = this.ctl.get();
        boolean bl = false;
        if (!ThreadPoolExecutor.isRunning(n) && ThreadPoolExecutor.runStateLessThan(n, 0x60000000)) {
            bl = true;
        }
        return bl;
    }

    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        ReentrantLock reentrantLock;
        block6: {
            boolean bl2;
            long l2 = timeUnit.toNanos(l);
            long l3 = Utils.nanoTime() + l2;
            reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                    boolean bl3 = true;
                    Object var10_9 = null;
                    reentrantLock.unlock();
                    return bl3;
                }
                while (true) {
                    if (l2 <= 0L) {
                        bl = false;
                        break block6;
                    }
                    this.termination.await(l2, TimeUnit.NANOSECONDS);
                    if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                        bl2 = true;
                        break;
                    }
                    l2 = l3 - Utils.nanoTime();
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            Object var10_10 = null;
            reentrantLock.unlock();
            return bl2;
        }
        Object var10_11 = null;
        reentrantLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = n - this.corePoolSize;
        this.corePoolSize = n;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > n) {
            this.interruptIdleWorkers();
        } else if (n2 > 0) {
            int n3 = Math.min(n2, this.workQueue.size());
            while (n3-- > 0 && this.addWorker(null, true)) {
                if (this.workQueue.isEmpty()) break;
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        boolean bl = false;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true)) {
            bl = true;
        }
        return bl;
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (bl != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = bl;
            if (bl) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int n) {
        if (n <= 0 || n < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = n;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > n) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = l2 - this.keepAliveTime;
        this.keepAliveTime = l2;
        if (l3 < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        boolean bl = this.workQueue.remove(runnable);
        this.tryTerminate();
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void purge() {
        block5: {
            var1_1 = this.workQueue;
            try {
                var2_2 = var1_1.iterator();
                while (var2_2.hasNext()) {
                    var3_4 = (Runnable)var2_2.next();
                    if (!(var3_4 instanceof Future) || !((Future)var3_4).isCancelled()) continue;
                    var2_2.remove();
                }
                break block5;
            }
            catch (ConcurrentModificationException var2_3) {
                var3_5 = var1_1.toArray();
                var4_6 = 0;
                ** while (var4_6 < var3_5.length)
            }
lbl-1000:
            // 1 sources

            {
                var5_7 = var3_5[var4_6];
                if (var5_7 instanceof Future && ((Future)var5_7).isCancelled()) {
                    var1_1.remove(var5_7);
                }
                ++var4_6;
                continue;
            }
        }
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            if (!ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000)) {
                n = this.workers.size();
            }
            int n2 = n;
            Object var3_3 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                if (!worker.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            Object var3_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var3_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                l += worker.completedTasks;
                if (!worker.isLocked()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            Object var3_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            Iterator iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                Worker worker = (Worker)iterator.next();
                l += worker.completedTasks;
            }
            long l2 = l;
            Object var3_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    private final /* synthetic */ void this() {
        this.ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
        this.mainLock = new ReentrantLock();
        this.workers = new HashSet();
        this.termination = this.mainLock.newCondition();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.this();
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Worker
    extends ReentrantLock
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        public final void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }

        Worker(Runnable runnable) {
            this.firstTask = runnable;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }
}

