/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.AbstractQueue;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SynchronousQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unlinkCancelledConsumer(Node node) {
        if (!this.waitingConsumers.shouldUnlink(node)) return;
        this.qlock.lock();
        try {
            if (this.waitingConsumers.shouldUnlink(node)) {
                this.waitingConsumers.unlink(node);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.qlock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.qlock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unlinkCancelledProducer(Node node) {
        if (!this.waitingProducers.shouldUnlink(node)) return;
        this.qlock.lock();
        try {
            if (this.waitingProducers.shouldUnlink(node)) {
                this.waitingProducers.unlink(node);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.qlock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.qlock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Object object) throws InterruptedException {
        Node node;
        if (object == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var6_5;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                boolean bl2 = false;
                if (node == null) {
                    bl2 = bl = true;
                }
                if (bl2) {
                    node = this.waitingProducers.enq(object);
                }
            }
            catch (Throwable throwable) {
                var6_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                var6_5 = null;
                reentrantLock.unlock();
                if (!bl) continue;
            }
            try {
                node.waitForTake();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledProducer(node);
                throw interruptedException;
            }
        } while (!node.setItem(object));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        if (object == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var11_8;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                boolean bl2 = false;
                if (node == null) {
                    bl2 = bl = true;
                }
                if (bl2) {
                    node = this.waitingProducers.enq(object);
                }
            }
            catch (Throwable throwable) {
                var11_8 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                var11_8 = null;
                reentrantLock.unlock();
                if (!bl) continue;
            }
            try {
                boolean bl3 = node.waitForTake(l2);
                if (!bl3) {
                    this.unlinkCancelledProducer(node);
                }
                return bl3;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledProducer(node);
                throw interruptedException;
            }
        } while (!node.setItem(object));
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object take() throws InterruptedException {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var5_4;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                boolean bl2 = false;
                if (node == null) {
                    bl2 = bl = true;
                }
                if (bl2) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                var5_4 = null;
                reentrantLock.unlock();
                if (!bl) continue;
            }
            try {
                return node.waitForPut();
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledConsumer(node);
                throw interruptedException;
            }
        } while ((object = node.getItem()) == null);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        Object object;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var10_7;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                boolean bl2 = false;
                if (node == null) {
                    bl2 = bl = true;
                }
                if (bl2) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            catch (Throwable throwable) {
                var10_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                var10_7 = null;
                reentrantLock.unlock();
                if (!bl) continue;
            }
            try {
                object = node.waitForPut(l2);
                if (object == null) {
                    this.unlinkCancelledConsumer(node);
                }
                return object;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledConsumer(node);
                throw interruptedException;
            }
        } while ((object = node.getItem()) == null);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(Object object) {
        Node node;
        if (object == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var5_4;
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                var5_4 = null;
                reentrantLock.unlock();
                if (node == null) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        } while (!node.setItem(object));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll() {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var4_3;
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                var4_3 = null;
                reentrantLock.unlock();
                if (node == null) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                var4_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        } while ((object = node.getItem()) == null);
        return object;
    }

    public boolean isEmpty() {
        return true;
    }

    public int size() {
        return 0;
    }

    public int remainingCapacity() {
        return 0;
    }

    public void clear() {
    }

    public boolean contains(Object object) {
        return false;
    }

    public boolean remove(Object object) {
        return false;
    }

    public boolean containsAll(Collection collection) {
        return collection.isEmpty();
    }

    public boolean removeAll(Collection collection) {
        return false;
    }

    public boolean retainAll(Collection collection) {
        return false;
    }

    public Object peek() {
        return null;
    }

    public Iterator iterator() {
        return new EmptyIterator();
    }

    public Object[] toArray() {
        return new Object[0];
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length > 0) {
            objectArray[0] = null;
        }
        return objectArray;
    }

    public int drainTo(Collection collection) {
        Object object;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((object = this.poll()) != null) {
            collection.add(object);
            ++n;
        }
        return n;
    }

    public int drainTo(Collection collection, int n) {
        Object object;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < n && (object = this.poll()) != null) {
            collection.add(object);
            ++n2;
        }
        return n2;
    }

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean bl) {
        if (bl) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        abstract Node enq(Object var1);

        abstract Node deq();

        abstract void unlink(Node var1);

        abstract boolean shouldUnlink(Node var1);

        WaitQueue() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class Node
    implements Serializable {
        private static final long serialVersionUID = -3223113410248163686L;
        private static final int ACK = 1;
        private static final int CANCEL = -1;
        int state;
        Object item;
        Node next;

        private final Object extract() {
            Object object = this.item;
            this.item = null;
            return object;
        }

        private final void checkCancellationOnInterrupt(InterruptedException interruptedException) throws InterruptedException {
            if (this.state == 0) {
                this.state = -1;
                this.notify();
                throw interruptedException;
            }
            Thread.currentThread().interrupt();
        }

        final synchronized boolean setItem(Object object) {
            if (this.state != 0) {
                return false;
            }
            this.item = object;
            this.state = 1;
            this.notify();
            return true;
        }

        final synchronized Object getItem() {
            if (this.state != 0) {
                return null;
            }
            this.state = 1;
            this.notify();
            return this.extract();
        }

        final synchronized void waitForTake() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
        }

        final synchronized Object waitForPut() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }

        private final boolean attempt(long l) throws InterruptedException {
            if (this.state != 0) {
                return true;
            }
            if (l <= 0L) {
                this.state = -1;
                this.notify();
                return false;
            }
            long l2 = Utils.nanoTime() + l;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, l);
                if (this.state == 0) continue;
                return true;
            } while ((l = l2 - Utils.nanoTime()) > 0L);
            this.state = -1;
            this.notify();
            return false;
        }

        final synchronized boolean waitForTake(long l) throws InterruptedException {
            try {
                if (!this.attempt(l)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return true;
        }

        final synchronized Object waitForPut(long l) throws InterruptedException {
            try {
                if (!this.attempt(l)) {
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }

        private final /* synthetic */ void this() {
            this.state = 0;
        }

        Node(Object object) {
            this.this();
            this.item = object;
        }

        Node(Object object, Node node) {
            this.this();
            this.item = object;
            this.next = node;
        }
    }

    static class EmptyIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }

        EmptyIterator() {
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3623113410248163686L;
        private transient Node head;
        private transient Node last;

        final Node enq(Object object) {
            Node node = new Node(object);
            this.last = this.last == null ? (this.head = node) : (this.last.next = node);
            return node;
        }

        final Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                if (this.head == null) {
                    this.last = null;
                }
                node.next = null;
            }
            return node;
        }

        final boolean shouldUnlink(Node node) {
            boolean bl = false;
            if (node == this.last || node.next != null) {
                bl = true;
            }
            return bl;
        }

        final void unlink(Node node) {
            Node node2 = this.head;
            Node node3 = null;
            while (node2 != null) {
                if (node2 == node) {
                    Node node4 = node2.next;
                    if (node3 == null) {
                        this.head = node4;
                    } else {
                        node3.next = node4;
                    }
                    if (this.last != node) break;
                    this.last = node3;
                    break;
                }
                node3 = node2;
                node2 = node2.next;
            }
        }

        FifoWaitQueue() {
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3633113410248163686L;
        private transient Node head;

        final Node enq(Object object) {
            this.head = new Node(object, this.head);
            return this.head;
        }

        final Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                node.next = null;
            }
            return node;
        }

        final boolean shouldUnlink(Node node) {
            boolean bl = false;
            if (node == this.head || node.next != null) {
                bl = true;
            }
            return bl;
        }

        final void unlink(Node node) {
            Node node2 = this.head;
            Node node3 = null;
            while (node2 != null) {
                if (node2 == node) {
                    Node node4 = node2.next;
                    if (node3 == null) {
                        this.head = node4;
                        break;
                    }
                    node3.next = node4;
                    break;
                }
                node3 = node2;
                node2 = node2.next;
            }
        }

        LifoWaitQueue() {
        }
    }
}

