/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.AbstractQueue;
import com.tridium.util.backport.Arrays;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.Callable;
import com.tridium.util.backport.concurrent.Delayed;
import com.tridium.util.backport.concurrent.Executors;
import com.tridium.util.backport.concurrent.Future;
import com.tridium.util.backport.concurrent.FutureTask;
import com.tridium.util.backport.concurrent.RejectedExecutionHandler;
import com.tridium.util.backport.concurrent.RunnableScheduledFuture;
import com.tridium.util.backport.concurrent.ScheduledExecutorService;
import com.tridium.util.backport.concurrent.ScheduledFuture;
import com.tridium.util.backport.concurrent.ThreadFactory;
import com.tridium.util.backport.concurrent.ThreadPoolExecutor;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.atomic.AtomicLong;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown;
    private volatile boolean removeOnCancel;

    final long now() {
        return Utils.nanoTime();
    }

    boolean canRunInCurrentRunState(boolean bl) {
        return this.isRunningOrShutdown(bl ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private final void delayedExecute(RunnableScheduledFuture runnableScheduledFuture) {
        if (this.isShutdown()) {
            this.reject(runnableScheduledFuture);
        } else {
            super.getQueue().add(runnableScheduledFuture);
            if (this.isShutdown() && !this.canRunInCurrentRunState(runnableScheduledFuture.isPeriodic()) && this.remove(runnableScheduledFuture)) {
                runnableScheduledFuture.cancel(false);
            } else {
                this.prestartCoreThread();
            }
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture runnableScheduledFuture) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(runnableScheduledFuture);
            if (!this.canRunInCurrentRunState(true) && this.remove(runnableScheduledFuture)) {
                runnableScheduledFuture.cancel(false);
            } else {
                this.prestartCoreThread();
            }
        }
    }

    void onShutdown() {
        BlockingQueue blockingQueue = super.getQueue();
        boolean bl = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean bl2 = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!bl && !bl2) {
            blockingQueue.clear();
        } else {
            Object[] objectArray = blockingQueue.toArray();
            int n = 0;
            while (n < objectArray.length) {
                RunnableScheduledFuture runnableScheduledFuture;
                Object object = objectArray[n];
                if (object instanceof RunnableScheduledFuture && (!((runnableScheduledFuture = (RunnableScheduledFuture)object).isPeriodic() ? bl2 : bl) || runnableScheduledFuture.isCancelled()) && blockingQueue.remove(runnableScheduledFuture)) {
                    runnableScheduledFuture.cancel(false);
                }
                ++n;
            }
        }
        this.tryTerminate();
    }

    protected RunnableScheduledFuture decorateTask(Runnable runnable, RunnableScheduledFuture runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    protected RunnableScheduledFuture decorateTask(Callable callable, RunnableScheduledFuture runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    public ScheduledFuture schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            l = 0L;
        }
        long l2 = this.now() + timeUnit.toNanos(l);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l2));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture schedule(Callable callable, long l, TimeUnit timeUnit) {
        if (callable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            l = 0L;
        }
        long l2 = this.now() + timeUnit.toNanos(l);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(callable, (RunnableScheduledFuture)new ScheduledFutureTask(callable, l2));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l < 0L) {
            l = 0L;
        }
        long l3 = this.now() + timeUnit.toNanos(l);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l3, timeUnit.toNanos(l2)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l < 0L) {
            l = 0L;
        }
        long l3 = this.now() + timeUnit.toNanos(l);
        RunnableScheduledFuture runnableScheduledFuture = this.decorateTask(runnable, (RunnableScheduledFuture)new ScheduledFutureTask(runnable, null, l3, timeUnit.toNanos(-l2)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    public void execute(Runnable runnable) {
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable runnable) {
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable runnable, Object object) {
        return this.schedule(Executors.callable(runnable, object), 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Callable callable) {
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl) {
        this.continueExistingPeriodicTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl) {
        this.executeExistingDelayedTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean bl) {
        this.removeOnCancel = bl;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    public void shutdown() {
        super.shutdown();
    }

    public List shutdownNow() {
        return super.shutdownNow();
    }

    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    private final /* synthetic */ void this() {
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.removeOnCancel = false;
    }

    public ScheduledThreadPoolExecutor(int n) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
        this.this();
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), threadFactory);
        this.this();
    }

    public ScheduledThreadPoolExecutor(int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), rejectedExecutionHandler);
        this.this();
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, rejectedExecutionHandler);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScheduledFutureTask
    extends FutureTask
    implements RunnableScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;
        int heapIndex;

        public long getDelay(TimeUnit timeUnit) {
            long l = timeUnit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return l;
        }

        public int compareTo(Object object) {
            Delayed delayed = (Delayed)object;
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof ScheduledFutureTask) {
                ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)object;
                long l = this.time - scheduledFutureTask.time;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long l = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            int n = 0;
            if (l != 0L) {
                n = l < 0L ? -1 : 1;
            }
            return n;
        }

        public boolean isPeriodic() {
            boolean bl = false;
            if (this.period != 0L) {
                bl = true;
            }
            return bl;
        }

        private final void setNextRunTime() {
            long l = this.period;
            this.time = l > 0L ? (this.time += l) : ScheduledThreadPoolExecutor.this.now() - l;
        }

        public boolean cancel(boolean bl) {
            boolean bl2 = super.cancel(bl);
            if (bl2 && ScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                ScheduledThreadPoolExecutor.this.remove(this);
            }
            return bl2;
        }

        public void run() {
            boolean bl = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(bl)) {
                this.cancel(false);
            } else if (!bl) {
                super.run();
            } else if (super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this);
            }
        }

        ScheduledFutureTask(Runnable runnable, Object object, long l) {
            super(runnable, object);
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, Object object, long l, long l2) {
            super(runnable, object);
            this.time = l;
            this.period = l2;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long l) {
            super(callable);
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DelayedWorkQueue
    extends AbstractQueue
    implements BlockingQueue {
        private static final int INITIAL_CAPACITY = 64;
        private transient RunnableScheduledFuture[] queue;
        private final transient ReentrantLock lock;
        private final transient Condition available;
        private int size;

        private final void setIndex(Object object, int n) {
            if (object instanceof ScheduledFutureTask) {
                ((ScheduledFutureTask)object).heapIndex = n;
            }
        }

        private final void siftUp(int n, RunnableScheduledFuture runnableScheduledFuture) {
            while (n > 0) {
                int n2 = n - 1 >>> 1;
                RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n2];
                if (runnableScheduledFuture.compareTo(runnableScheduledFuture2) >= 0) break;
                this.queue[n] = runnableScheduledFuture2;
                this.setIndex(runnableScheduledFuture2, n);
                n = n2;
            }
            this.queue[n] = runnableScheduledFuture;
            this.setIndex(runnableScheduledFuture, n);
        }

        private final void siftDown(int n, RunnableScheduledFuture runnableScheduledFuture) {
            int n2 = this.size >>> 1;
            while (n < n2) {
                int n3 = (n << 1) + 1;
                RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n3];
                int n4 = n3 + 1;
                if (n4 < this.size && runnableScheduledFuture2.compareTo(this.queue[n4]) > 0) {
                    n3 = n4;
                    runnableScheduledFuture2 = this.queue[n3];
                }
                if (runnableScheduledFuture.compareTo(runnableScheduledFuture2) <= 0) break;
                this.queue[n] = runnableScheduledFuture2;
                this.setIndex(runnableScheduledFuture2, n);
                n = n3;
            }
            this.queue[n] = runnableScheduledFuture;
            this.setIndex(runnableScheduledFuture, n);
        }

        private final RunnableScheduledFuture finishPoll(RunnableScheduledFuture runnableScheduledFuture) {
            int n = --this.size;
            RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n];
            this.queue[n] = null;
            if (n != 0) {
                this.siftDown(0, runnableScheduledFuture2);
                this.available.signalAll();
            }
            this.setIndex(runnableScheduledFuture, -1);
            return runnableScheduledFuture;
        }

        private final void grow() {
            int n = this.queue.length;
            int n2 = n + (n >> 1);
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            RunnableScheduledFuture[] runnableScheduledFutureArray = new RunnableScheduledFuture[n2];
            System.arraycopy(this.queue, 0, runnableScheduledFutureArray, 0, this.queue.length);
            this.queue = runnableScheduledFutureArray;
        }

        private final int indexOf(Object object) {
            if (object != null) {
                int n = 0;
                while (n < this.size) {
                    if (object.equals(this.queue[n])) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean remove(Object object) {
            boolean bl;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n = object instanceof ScheduledFutureTask ? ((ScheduledFutureTask)object).heapIndex : this.indexOf(object);
                boolean bl2 = false;
                if (n >= 0 && n < this.size && this.queue[n] == object) {
                    bl2 = bl = true;
                }
                if (bl2) {
                    this.setIndex(object, -1);
                    int n2 = --this.size;
                    RunnableScheduledFuture runnableScheduledFuture = this.queue[n2];
                    this.queue[n2] = null;
                    if (n2 != n) {
                        this.siftDown(n, runnableScheduledFuture);
                        if (this.queue[n] == runnableScheduledFuture) {
                            this.siftUp(n, runnableScheduledFuture);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var5_9 = null;
                reentrantLock.unlock();
                return bl;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int size() {
            int n;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                n = this.size;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var4_5 = null;
                reentrantLock.unlock();
                return n;
            }
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.size() == 0) {
                bl = true;
            }
            return bl;
        }

        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
                Object var3_3 = null;
                reentrantLock.unlock();
                return runnableScheduledFuture;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean offer(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            RunnableScheduledFuture runnableScheduledFuture = (RunnableScheduledFuture)object;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean bl;
                int n = this.size;
                if (n >= this.queue.length) {
                    this.grow();
                }
                this.size = n + 1;
                if (n == 0) {
                    bl = true;
                    this.queue[0] = runnableScheduledFuture;
                    this.setIndex(runnableScheduledFuture, 0);
                } else {
                    boolean bl2 = false;
                    if (runnableScheduledFuture.compareTo(this.queue[0]) < 0) {
                        bl2 = true;
                    }
                    bl = bl2;
                    this.siftUp(n, runnableScheduledFuture);
                }
                if (bl) {
                    this.available.signalAll();
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var5_8 = null;
                reentrantLock.unlock();
                return true;
            }
        }

        public void put(Object object) {
            this.offer(object);
        }

        public boolean add(Runnable runnable) {
            return this.offer(runnable);
        }

        public boolean offer(Object object, long l, TimeUnit timeUnit) {
            return this.offer(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll() {
            RunnableScheduledFuture runnableScheduledFuture;
            ReentrantLock reentrantLock;
            block3: {
                reentrantLock = this.lock;
                reentrantLock.lock();
                try {
                    runnableScheduledFuture = this.queue[0];
                    if (runnableScheduledFuture != null && runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block3;
                    Object var4_3 = null;
                    Object var3_5 = null;
                    reentrantLock.unlock();
                    return var4_3;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
            RunnableScheduledFuture runnableScheduledFuture2 = this.finishPoll(runnableScheduledFuture);
            Object var3_6 = null;
            reentrantLock.unlock();
            return runnableScheduledFuture2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object take() throws InterruptedException {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lockInterruptibly();
            try {
                while (true) {
                    RunnableScheduledFuture runnableScheduledFuture;
                    if ((runnableScheduledFuture = this.queue[0]) == null) {
                        this.available.await();
                        continue;
                    }
                    long l = runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS);
                    if (l <= 0L) {
                        RunnableScheduledFuture runnableScheduledFuture2 = this.finishPoll(runnableScheduledFuture);
                        Object var3_5 = null;
                        reentrantLock.unlock();
                        return runnableScheduledFuture2;
                    }
                    this.available.await(l, TimeUnit.NANOSECONDS);
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object poll(long l, TimeUnit timeUnit) throws InterruptedException {
            RunnableScheduledFuture runnableScheduledFuture;
            ReentrantLock reentrantLock;
            block8: {
                Object var11_9;
                block7: {
                    long l2 = timeUnit.toNanos(l);
                    long l3 = Utils.nanoTime() + l2;
                    reentrantLock = this.lock;
                    reentrantLock.lockInterruptibly();
                    try {
                        RunnableScheduledFuture runnableScheduledFuture2;
                        while (true) {
                            if ((runnableScheduledFuture2 = this.queue[0]) == null) {
                                if (l2 <= 0L) {
                                    Object var11_8 = null;
                                    Object var10_11 = null;
                                    reentrantLock.unlock();
                                    return var11_8;
                                }
                                this.available.await(l2, TimeUnit.NANOSECONDS);
                                l2 = l3 - Utils.nanoTime();
                                continue;
                            }
                            long l4 = runnableScheduledFuture2.getDelay(TimeUnit.NANOSECONDS);
                            if (l4 <= 0L) break;
                            if (l2 <= 0L) {
                                var11_9 = null;
                                break block7;
                            }
                            if (l4 > l2) {
                                l4 = l2;
                            }
                            this.available.await(l4, TimeUnit.NANOSECONDS);
                            l2 = l3 - Utils.nanoTime();
                        }
                        runnableScheduledFuture = this.finishPoll(runnableScheduledFuture2);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        reentrantLock.unlock();
                        throw throwable;
                    }
                }
                Object var10_12 = null;
                reentrantLock.unlock();
                return var11_9;
            }
            Object var10_13 = null;
            reentrantLock.unlock();
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n = 0;
                while (true) {
                    block5: {
                        if (n < this.size) break block5;
                        this.size = 0;
                        break;
                    }
                    RunnableScheduledFuture runnableScheduledFuture = this.queue[n];
                    if (runnableScheduledFuture != null) {
                        this.queue[n] = null;
                        this.setIndex(runnableScheduledFuture, -1);
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var3_6 = null;
                reentrantLock.unlock();
                return;
            }
        }

        private final RunnableScheduledFuture pollExpired() {
            RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
            if (runnableScheduledFuture == null || runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                return null;
            }
            this.setIndex(runnableScheduledFuture, -1);
            int n = --this.size;
            RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n];
            this.queue[n] = null;
            if (n != 0) {
                this.siftDown(0, runnableScheduledFuture2);
            }
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int drainTo(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            if (collection == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture;
                int n = 0;
                while ((runnableScheduledFuture = this.pollExpired()) != null) {
                    collection.add(runnableScheduledFuture);
                    ++n;
                }
                if (n > 0) {
                    this.available.signalAll();
                }
                int n2 = n;
                Object var4_6 = null;
                reentrantLock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int drainTo(Collection collection, int n) {
            if (collection == null) {
                throw new NullPointerException();
            }
            if (collection == this) {
                throw new IllegalArgumentException();
            }
            if (n <= 0) {
                return 0;
            }
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n2 = 0;
                while (n2 < n) {
                    RunnableScheduledFuture runnableScheduledFuture = this.pollExpired();
                    if (runnableScheduledFuture == null) break;
                    collection.add(runnableScheduledFuture);
                    ++n2;
                }
                if (n2 > 0) {
                    this.available.signalAll();
                }
                int n3 = n2;
                Object var5_7 = null;
                reentrantLock.unlock();
                return n3;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                Object[] objectArray = Arrays.copyOf(this.queue, this.size);
                Object var3_3 = null;
                reentrantLock.unlock();
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] objectArray) {
            ReentrantLock reentrantLock;
            block4: {
                reentrantLock = this.lock;
                reentrantLock.lock();
                try {
                    if (objectArray.length >= this.size) break block4;
                    Object[] objectArray2 = Arrays.copyOf(this.queue, this.size, objectArray.getClass());
                    Object var4_5 = null;
                    reentrantLock.unlock();
                    return objectArray2;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
            System.arraycopy(this.queue, 0, objectArray, 0, this.size);
            if (objectArray.length > this.size) {
                objectArray[this.size] = null;
            }
            Object[] objectArray3 = objectArray;
            Object var4_6 = null;
            reentrantLock.unlock();
            return objectArray3;
        }

        public Iterator iterator() {
            return new Itr(this.toArray());
        }

        private final /* synthetic */ void this() {
            this.queue = new RunnableScheduledFuture[64];
            this.lock = new ReentrantLock();
            this.available = this.lock.newCondition();
            this.size = 0;
        }

        DelayedWorkQueue() {
            this.this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class Itr
        implements Iterator {
            final Object[] array;
            int cursor;
            int lastRet = -1;

            public boolean hasNext() {
                boolean bl = false;
                if (this.cursor < this.array.length) {
                    bl = true;
                }
                return bl;
            }

            public Object next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return (Runnable)this.array[this.cursor++];
            }

            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }

            Itr(Object[] objectArray) {
                this.array = objectArray;
            }
        }
    }
}

