/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.concurrent.Callable;
import com.tridium.util.backport.concurrent.CancellationException;
import com.tridium.util.backport.concurrent.ExecutionException;
import com.tridium.util.backport.concurrent.Executors;
import com.tridium.util.backport.concurrent.RunnableFuture;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.TimeoutException;
import com.tridium.util.backport.concurrent.helpers.Utils;

public class FutureTask
implements RunnableFuture {
    private static final int READY = 0;
    private static final int RUNNING = 1;
    private static final int RAN = 2;
    private static final int CANCELLED = 4;
    private final Callable callable;
    private Object result;
    private Throwable exception;
    private int state;
    private volatile Thread runner;

    public synchronized boolean isCancelled() {
        boolean bl = false;
        if (this.state == 4) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isDone() {
        boolean bl = false;
        if (this.ranOrCancelled() && this.runner == null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cancel(boolean bl) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            Thread thread;
            if (this.ranOrCancelled()) {
                return false;
            }
            this.state = 4;
            if (bl && (thread = this.runner) != null) {
                thread.interrupt();
            }
            this.runner = null;
            this.notifyAll();
        }
        this.done();
        return true;
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        this.waitFor();
        return this.getResult();
    }

    public synchronized Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitFor(timeUnit.toNanos(l));
        return this.getResult();
    }

    protected void done() {
    }

    protected void set(Object object) {
        this.setCompleted(object);
    }

    protected void setException(Throwable throwable) {
        this.setFailed(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.set(this.callable.call());
            return;
        }
        catch (Throwable throwable) {
            this.setException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean runAndReset() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return false;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.callable.call();
            FutureTask futureTask2 = this;
            synchronized (futureTask2) {
                this.runner = null;
                if (this.state == 1) {
                    this.state = 0;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return false;
        }
    }

    private final boolean ranOrCancelled() {
        boolean bl = false;
        if ((this.state & 6) != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setCompleted(Object object) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.result = object;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setFailed(Throwable throwable) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.exception = throwable;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private final void waitFor() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
    }

    private final void waitFor(long l) throws InterruptedException, TimeoutException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isDone()) {
            return;
        }
        long l2 = Utils.nanoTime() + l;
        while (l > 0L) {
            TimeUnit.NANOSECONDS.timedWait(this, l);
            if (this.isDone()) {
                return;
            }
            l = l2 - Utils.nanoTime();
        }
        throw new TimeoutException();
    }

    private final Object getResult() throws ExecutionException {
        if (this.state == 4) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
    }

    public FutureTask(Runnable runnable, Object object) {
        this(Executors.callable(runnable, object));
    }
}

