/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.concurrent.AbstractExecutorService;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.Callable;
import com.tridium.util.backport.concurrent.ExecutionException;
import com.tridium.util.backport.concurrent.ExecutorService;
import com.tridium.util.backport.concurrent.Future;
import com.tridium.util.backport.concurrent.LinkedBlockingQueue;
import com.tridium.util.backport.concurrent.ScheduledExecutorService;
import com.tridium.util.backport.concurrent.ScheduledFuture;
import com.tridium.util.backport.concurrent.ScheduledThreadPoolExecutor;
import com.tridium.util.backport.concurrent.SynchronousQueue;
import com.tridium.util.backport.concurrent.ThreadFactory;
import com.tridium.util.backport.concurrent.ThreadPoolExecutor;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.TimeoutException;
import com.tridium.util.backport.concurrent.atomic.AtomicInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;

public class Executors {
    public static ExecutorService newFixedThreadPool(int n) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newFixedThreadPool(int n, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n) {
        return new ScheduledThreadPoolExecutor(n);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(n, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(executorService);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            throw new NullPointerException();
        }
        return new DelegatedScheduledExecutorService(scheduledExecutorService);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static Callable callable(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(runnable, object);
    }

    public static Callable callable(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(runnable, null);
    }

    public static Callable callable(final PrivilegedAction privilegedAction) {
        if (privilegedAction == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public final Object call() {
                return privilegedAction.run();
            }
        };
    }

    public static Callable callable(final PrivilegedExceptionAction privilegedExceptionAction) {
        if (privilegedExceptionAction == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public final Object call() throws Exception {
                return privilegedExceptionAction.run();
            }
        };
    }

    public static Callable privilegedCallable(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable(callable);
    }

    public static Callable privilegedCallableUsingCurrentClassLoader(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader(callable);
    }

    private Executors() {
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        protected void finalize() {
            super.shutdown();
        }

        FinalizableDelegatedExecutorService(ExecutorService executorService) {
            super(executorService);
        }
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        public ScheduledFuture schedule(Runnable runnable, long l, TimeUnit timeUnit) {
            return this.e.schedule(runnable, l, timeUnit);
        }

        public ScheduledFuture schedule(Callable callable, long l, TimeUnit timeUnit) {
            return this.e.schedule(callable, l, timeUnit);
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            return this.e.scheduleAtFixedRate(runnable, l, l2, timeUnit);
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            return this.e.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
        }

        DelegatedScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.e = scheduledExecutorService;
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        public void execute(Runnable runnable) {
            this.e.execute(runnable);
        }

        public void shutdown() {
            this.e.shutdown();
        }

        public List shutdownNow() {
            return this.e.shutdownNow();
        }

        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.awaitTermination(l, timeUnit);
        }

        public Future submit(Runnable runnable) {
            return this.e.submit(runnable);
        }

        public Future submit(Callable callable) {
            return this.e.submit(callable);
        }

        public Future submit(Runnable runnable, Object object) {
            return this.e.submit(runnable, object);
        }

        public List invokeAll(Collection collection) throws InterruptedException {
            return this.e.invokeAll(collection);
        }

        public List invokeAll(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.invokeAll(collection, l, timeUnit);
        }

        public Object invokeAny(Collection collection) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(collection);
        }

        public Object invokeAny(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(collection, l, timeUnit);
        }

        DelegatedExecutorService(ExecutorService executorService) {
            this.e = executorService;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber;
        final String namePrefix;

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }

        private final /* synthetic */ void this() {
            this.threadNumber = new AtomicInteger(1);
        }

        DefaultThreadFactory() {
            this.this();
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext acc = AccessController.getContext();

        public Thread newThread(final Runnable runnable) {
            return super.newThread(new Runnable(){

                public final void run() {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public final Object run() {
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.this.ccl);
                            runnable.run();
                            return null;
                        }
                    }, PrivilegedThreadFactory.this.acc);
                }
            });
        }

        PrivilegedThreadFactory() {
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        public final Object call() {
            this.task.run();
            return this.result;
        }

        RunnableAdapter(Runnable runnable, Object object) {
            this.task = runnable;
            this.result = object;
        }
    }

    static final class PrivilegedCallable
    implements Callable {
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        public final Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    try {
                        PrivilegedCallable.this.result = PrivilegedCallable.this.task.call();
                    }
                    catch (Exception exception) {
                        PrivilegedCallable.this.exception = exception;
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static final /* synthetic */ Exception access$0(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.exception;
        }

        static final /* synthetic */ Object access$3(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.result;
        }

        PrivilegedCallable(Callable callable) {
            this.task = callable;
            this.acc = AccessController.getContext();
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader
    implements Callable {
        private final ClassLoader ccl;
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        public final Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * Exception decompiling
                 */
                public final Object run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 93->96)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static final /* synthetic */ Exception access$0(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.exception;
        }

        static final /* synthetic */ void access$1(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, Exception exception) {
            privilegedCallableUsingCurrentClassLoader.exception = exception;
        }

        static final /* synthetic */ ClassLoader access$2(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.ccl;
        }

        static final /* synthetic */ Callable access$3(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.task;
        }

        static final /* synthetic */ Object access$4(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.result;
        }

        static final /* synthetic */ void access$5(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, Object object) {
            privilegedCallableUsingCurrentClassLoader.result = object;
        }

        PrivilegedCallableUsingCurrentClassLoader(Callable callable) {
            this.task = callable;
            this.ccl = Thread.currentThread().getContextClassLoader();
            this.acc = AccessController.getContext();
            this.acc.checkPermission(new RuntimePermission("getContextClassLoader"));
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
    }
}

