/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.AbstractCollection;
import com.tridium.util.backport.AbstractMap;
import com.tridium.util.backport.AbstractSet;
import com.tridium.util.backport.concurrent.ConcurrentMap;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set keySet;
    transient Set entrySet;
    transient Collection values;

    private static final int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public boolean isEmpty() {
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < segmentArray.length) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            nArray[n2] = segmentArray[n2].modCount;
            n += nArray[n2];
            ++n2;
        }
        if (n != 0) {
            n2 = 0;
            while (n2 < segmentArray.length) {
                if (segmentArray[n2].count != 0 || nArray[n2] != segmentArray[n2].modCount) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        int n = 0;
        while (n < 2) {
            l2 = 0L;
            l = 0L;
            int n2 = 0;
            int n3 = 0;
            while (n3 < segmentArray.length) {
                l += (long)segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n2 += nArray[n3];
                ++n3;
            }
            if (n2 != 0) {
                n3 = 0;
                while (n3 < segmentArray.length) {
                    l2 += (long)segmentArray[n3].count;
                    if (nArray[n3] != segmentArray[n3].modCount) {
                        l2 = -1;
                        break;
                    }
                    ++n3;
                }
            }
            if (l2 == l) break;
            ++n;
        }
        if (l2 != l) {
            l = 0L;
            n = 0;
            while (n < segmentArray.length) {
                segmentArray[n].lock();
                ++n;
            }
            n = 0;
            while (n < segmentArray.length) {
                l += (long)segmentArray[n].count;
                ++n;
            }
            n = 0;
            while (n < segmentArray.length) {
                segmentArray[n].unlock();
                ++n;
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public Object get(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).get(object, n);
    }

    public boolean containsKey(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(Object var1_1) {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.segments;
        var3_3 = new int[var2_2.length];
        var4_4 = false;
        while (true) {
            block19: {
                if (var4_4 >= 2 != 0) break;
                var5_5 = false;
                var6_7 = 0;
                var7_10 = 0;
                while (true) {
                    if (var7_10 >= var2_2.length) {
                        var7_10 = 1;
                        if (var6_7 != 0) {
                            var8_11 = 0;
                            break;
                        }
                        break block19;
                    }
                    var8_11 = var2_2[var7_10].count;
                    var3_3[var7_10] = var2_2[var7_10].modCount;
                    var6_7 += var3_3[var7_10];
                    if (var2_2[var7_10].containsValue(var1_1)) {
                        return true;
                    }
                    ++var7_10;
                }
                while (var8_11 < var2_2.length) {
                    var9_12 = var2_2[var8_11].count;
                    if (var3_3[var8_11] != var2_2[var8_11].modCount) {
                        var7_10 = 0;
                        break;
                    }
                    ++var8_11;
                }
            }
            if (var7_10 != 0) {
                return false;
            }
            var4_4 += 1;
        }
        var4_4 = false;
        while (true) {
            if (var4_4 >= var2_2.length) {
                var4_4 = false;
                ** try [egrp 0[TRYBLOCK] [0 : 184->220)] { 
lbl42:
                // 1 sources

                break;
            }
            var2_2[var4_4].lock();
            var4_4 += 1;
        }
        {
            var9_12 = 0;
            while (var9_12 < var2_2.length) {
                block20: {
                    if (!var2_2[var9_12].containsValue(var1_1)) break block20;
                    var4_4 = true;
                    ** GOTO lbl-1000
                }
                ++var9_12;
            }
            ** GOTO lbl-1000
        }
lbl55:
        // 1 sources

        catch (Throwable var5_6) {
            var6_8 = null;
            var8_11 = 0;
        }
        while (true) {
            if (var8_11 >= var2_2.length) {
                throw var5_6;
            }
            var2_2[var8_11].unlock();
            ++var8_11;
        }
lbl-1000:
        // 2 sources

        {
            var6_9 = null;
            var8_11 = 0;
        }
        while (true) {
            if (var8_11 >= var2_2.length) {
                return var4_4;
            }
            var2_2[var8_11].unlock();
            ++var8_11;
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).put(object, n, object2, false);
    }

    public Object putIfAbsent(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).put(object, n, object2, true);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).remove(object, n, null);
    }

    public boolean remove(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        int n = ConcurrentHashMap.hash(object.hashCode());
        boolean bl = false;
        if (this.segmentFor(n).remove(object, n, object2) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean replace(Object object, Object object2, Object object3) {
        if (object2 == null || object3 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).replace(object, n, object2, object3);
    }

    public Object replace(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).replace(object, n, object2);
    }

    public void clear() {
        int n = 0;
        while (n < this.segments.length) {
            this.segments[n].clear();
            ++n;
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (true) {
            Object var5_4;
            if (n >= this.segments.length) {
                objectOutputStream.writeObject(null);
                objectOutputStream.writeObject(null);
                return;
            }
            Segment segment = this.segments[n];
            segment.lock();
            try {
                HashEntry[] hashEntryArray = segment.table;
                int n2 = 0;
                block4: while (n2 < hashEntryArray.length) {
                    HashEntry hashEntry = hashEntryArray[n2];
                    while (true) {
                        if (hashEntry == null) {
                            ++n2;
                            continue block4;
                        }
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                segment.unlock();
                throw throwable;
            }
            {
                var5_4 = null;
            }
            segment.unlock();
            ++n;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this.segments.length) {
            this.segments[n].setTable(new HashEntry[1]);
            ++n;
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    public ConcurrentHashMap(int n, float f, int n2) {
        int n3;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n4 = 0;
        int n5 = 1;
        while (n5 < n2) {
            ++n4;
            n5 <<= 1;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n5 - 1;
        this.segments = Segment.newArray(n5);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n3 = n / n5) * n5 < n) {
            ++n3;
        }
        int n6 = 1;
        while (n6 < n3) {
            n6 <<= 1;
        }
        int n7 = 0;
        while (n7 < this.segments.length) {
            this.segments[n7] = new Segment(n6, f);
            ++n7;
        }
    }

    public ConcurrentHashMap(int n, float f) {
        this(n, f, 16);
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        static final Segment[] newArray(int n) {
            return new Segment[n];
        }

        final void setTable(HashEntry[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        final HashEntry getFirst(int n) {
            HashEntry[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object readValueUnderLock(HashEntry hashEntry) {
            Object object;
            this.lock();
            try {
                object = hashEntry.value;
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object;
        }

        final Object get(Object object, int n) {
            if (this.count != 0) {
                HashEntry hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        Object object2 = hashEntry.value;
                        if (object2 != null) {
                            return object2;
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        final boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        final boolean containsValue(Object object) {
            if (this.count != 0) {
                HashEntry[] hashEntryArray = this.table;
                int n = hashEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HashEntry hashEntry = hashEntryArray[n2];
                    while (hashEntry != null) {
                        Object object2 = hashEntry.value;
                        if (object2 == null) {
                            object2 = this.readValueUnderLock(hashEntry);
                        }
                        if (object.equals(object2)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                    ++n2;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean replace(Object object, int n, Object object2, Object object3) {
            boolean bl;
            this.lock();
            try {
                HashEntry hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && object.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl2 = false;
                if (hashEntry != null && object2.equals(hashEntry.value)) {
                    bl2 = true;
                    hashEntry.value = object3;
                }
                bl = bl2;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object replace(Object object, int n, Object object2) {
            Object object3;
            this.lock();
            try {
                HashEntry hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && object.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                Object object4 = null;
                if (hashEntry != null) {
                    object4 = hashEntry.value;
                    hashEntry.value = object2;
                }
                object3 = object4;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object put(Object object, int n, Object object2, boolean bl) {
            Object object3;
            this.lock();
            try {
                Object object4;
                HashEntry hashEntry;
                int n2 = this.count;
                if (n2++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && object.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    object4 = hashEntry2.value;
                    if (!bl) {
                        hashEntry2.value = object2;
                    }
                } else {
                    object4 = null;
                    ++this.modCount;
                    hashEntryArray[n3] = new HashEntry(object, n, hashEntry, object2);
                    this.count = n2;
                }
                object3 = object4;
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object3;
        }

        final void rehash() {
            HashEntry[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return;
            }
            HashEntry[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            int n3 = 0;
            while (n3 < n) {
                HashEntry hashEntry = hashEntryArray[n3];
                if (hashEntry != null) {
                    HashEntry hashEntry2 = hashEntry.next;
                    int n4 = hashEntry.hash & n2;
                    if (hashEntry2 == null) {
                        hashEntryArray2[n4] = hashEntry;
                    } else {
                        int n5;
                        HashEntry hashEntry3 = hashEntry;
                        int n6 = n4;
                        HashEntry hashEntry4 = hashEntry2;
                        while (hashEntry4 != null) {
                            n5 = hashEntry4.hash & n2;
                            if (n5 != n6) {
                                n6 = n5;
                                hashEntry3 = hashEntry4;
                            }
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray2[n6] = hashEntry3;
                        hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry3) {
                            n5 = hashEntry4.hash & n2;
                            HashEntry hashEntry5 = hashEntryArray2[n5];
                            hashEntryArray2[n5] = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry5, hashEntry4.value);
                            hashEntry4 = hashEntry4.next;
                        }
                    }
                }
                ++n3;
            }
            this.table = hashEntryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object remove(Object object, int n, Object object2) {
            Object object3;
            this.lock();
            try {
                HashEntry hashEntry;
                int n2 = this.count - 1;
                HashEntry[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && object.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                Object object4 = null;
                if (hashEntry2 != null) {
                    Object object5 = hashEntry2.value;
                    if (object2 == null || object2.equals(object5)) {
                        object4 = object5;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            hashEntry3 = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry3, hashEntry4.value);
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n3] = hashEntry3;
                        this.count = n2;
                    }
                }
                object3 = object4;
                Object var5_14 = null;
            }
            catch (Throwable throwable) {
                Object var5_15 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object3;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void clear() {
            if (this.count == 0) return;
            this.lock();
            try {
                HashEntry[] hashEntryArray = this.table;
                int n = 0;
                while (true) {
                    block4: {
                        if (n < hashEntryArray.length) break block4;
                        ++this.modCount;
                        this.count = 0;
                        break;
                    }
                    hashEntryArray[n] = null;
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.unlock();
                throw throwable;
            }
            {
                Object var2_5 = null;
            }
            this.unlock();
        }

        Segment(int n, float f) {
            this.loadFactor = f;
            this.setTable(HashEntry.newArray(n));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class KeySet
    extends AbstractSet {
        public final Iterator iterator() {
            return new KeyIterator();
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        public final boolean remove(Object object) {
            boolean bl = false;
            if (ConcurrentHashMap.this.remove(object) != null) {
                bl = true;
            }
            return bl;
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        KeySet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class Values
    extends AbstractCollection {
        public final Iterator iterator() {
            return new ValueIterator();
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        Values() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class EntrySet
    extends AbstractSet {
        public final Iterator iterator() {
            return new EntryIterator();
        }

        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentHashMap.this.get(entry.getKey());
            boolean bl = false;
            if (object2 != null && object2.equals(entry.getValue())) {
                bl = true;
            }
            return bl;
        }

        public final boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        EntrySet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        public final Object next() {
            return super.nextEntry().key;
        }

        public final Object nextElement() {
            return super.nextEntry().key;
        }

        KeyIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        public final Object next() {
            return super.nextEntry().value;
        }

        public final Object nextElement() {
            return super.nextEntry().value;
        }

        ValueIterator() {
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry next;

        static final HashEntry[] newArray(int n) {
            return new HashEntry[n];
        }

        HashEntry(Object object, int n, HashEntry hashEntry, Object object2) {
            this.key = object;
            this.hash = n;
            this.next = hashEntry;
            this.value = object2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator {
        public final Object next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key, hashEntry.value);
        }

        EntryIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry {
        public final Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = super.setValue(object);
            ConcurrentHashMap.this.put(this.getKey(), object);
            return object2;
        }

        WriteThroughEntry(Object object, Object object2) {
            super(object, object2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        /*
         * Unable to fully structure code
         */
        final void advance() {
            if (this.nextEntry == null || (this.nextEntry = this.nextEntry.next) == null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
lbl5:
                // 2 sources

                ** while (this.nextTableIndex >= 0)
            }
lbl6:
            // 3 sources

            while (this.nextSegmentIndex >= 0) {
                var1_1 = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (var1_1.count == 0) continue;
                this.currentTable = var1_1.table;
                var2_2 = this.currentTable.length - 1;
                while (var2_2 >= 0) {
                    this.nextEntry = this.currentTable[var2_2];
                    if (this.nextEntry != null) {
                        this.nextTableIndex = var2_2 - 1;
                        return;
                    }
                    --var2_2;
                }
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextEntry != null) {
                bl = true;
            }
            return bl;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }
    }
}

