/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.AbstractQueue;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    private final Object[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int n) {
        int n2 = 0;
        if (++n != this.items.length) {
            n2 = n;
        }
        return n2;
    }

    private final void insert(Object object) {
        this.items[this.putIndex] = object;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private final Object extract() {
        Object[] objectArray = this.items;
        Object object = objectArray[this.takeIndex];
        objectArray[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return object;
    }

    void removeAt(int n) {
        Object[] objectArray = this.items;
        if (n == this.takeIndex) {
            objectArray[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                objectArray[n] = objectArray[n2];
                n = n2;
            }
            objectArray[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    public boolean add(Object object) {
        return super.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object) {
        ReentrantLock reentrantLock;
        block4: {
            if (object == null) {
                throw new NullPointerException();
            }
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                if (this.count != this.items.length) break block4;
                boolean bl = false;
                Object var4_5 = null;
                reentrantLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        this.insert(object);
        boolean bl = true;
        Object var4_6 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (this.count == objectArray.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
            this.insert(object);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            reentrantLock.unlock();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean offer(Object var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var5_4 = var4_3.toNanos(var2_2);
        var7_5 = this.lock;
        var7_5.lockInterruptibly();
        try {
            var11_6 = Utils.nanoTime() + var5_4;
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.count == this.items.length) ** break block8
                this.insert(var1_1);
                var10_7 = true;
                var9_9 = null;
                var7_5.unlock();
                return var10_7;
            }
        }
        catch (Throwable var8_13) {
            var9_11 = null;
            var7_5.unlock();
            throw var8_13;
        }
        {
            block9: {
                if (var5_4 > 0L) break block9;
                var10_8 = false;
                var9_10 = null;
                var7_5.unlock();
                return var10_8;
            }
            try {
                this.notFull.await(var5_4, TimeUnit.NANOSECONDS);
                var5_4 = var11_6 - Utils.nanoTime();
                continue;
            }
            catch (InterruptedException var13_12) {
                this.notFull.signal();
                throw var13_12;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object object;
        ReentrantLock reentrantLock;
        block3: {
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                if (this.count != 0) break block3;
                Object var4_2 = null;
                Object var3_4 = null;
                reentrantLock.unlock();
                return var4_2;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        Object object2 = object = this.extract();
        Object var3_5 = null;
        reentrantLock.unlock();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            Object object;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            Object object2 = object = this.extract();
            Object var3_5 = null;
            reentrantLock.unlock();
            return object2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        var6_4.lockInterruptibly();
        try {
            var10_5 = Utils.nanoTime() + var4_3;
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.count == 0) ** break block7
                var9_8 = var12_6 = this.extract();
                var8_10 = null;
                var6_4.unlock();
                return var9_8;
            }
        }
        catch (Throwable var7_13) {
            var8_12 = null;
            var6_4.unlock();
            throw var7_13;
        }
        {
            block8: {
                if (var4_3 > 0L) break block8;
                var9_9 = null;
                var8_11 = null;
                var6_4.unlock();
                return var9_9;
            }
            try {
                this.notEmpty.await(var4_3, TimeUnit.NANOSECONDS);
                var4_3 = var10_5 - Utils.nanoTime();
                continue;
            }
            catch (InterruptedException var12_7) {
                this.notEmpty.signal();
                throw var12_7;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object object = this.count == 0 ? null : this.items[this.takeIndex];
            Object var3_3 = null;
            reentrantLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            Object var3_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.items.length - this.count;
            Object var3_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (true) {
                if (n2++ >= this.count) {
                    boolean bl2 = false;
                    Object var5_8 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                if (object.equals(objectArray[n])) {
                    this.removeAt(n);
                    bl = true;
                    break;
                }
                n = this.inc(n);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (true) {
                if (n2++ >= this.count) {
                    bl = false;
                    break;
                }
                if (object.equals(objectArray[n])) {
                    boolean bl2 = true;
                    Object var5_8 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                n = this.inc(n);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2 = new Object[this.count];
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray2[n++] = objectArray[n2];
                n2 = this.inc(n2);
            }
            Object[] objectArray3 = objectArray2;
            Object var4_7 = null;
            reentrantLock.unlock();
            return objectArray3;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray[n++] = objectArray2[n2];
                n2 = this.inc(n2);
            }
            if (objectArray.length > this.count) {
                objectArray[this.count] = null;
            }
            Object[] objectArray3 = objectArray;
            Object var5_7 = null;
            reentrantLock.unlock();
            return objectArray3;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            String string = super.toString();
            Object var3_3 = null;
            reentrantLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = this.count;
            while (true) {
                block4: {
                    if (n2-- > 0) break block4;
                    this.count = 0;
                    this.putIndex = 0;
                    this.takeIndex = 0;
                    this.notFull.signalAll();
                    break;
                }
                objectArray[n] = null;
                n = this.inc(n);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        {
            Object var4_7 = null;
            reentrantLock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            int n3 = this.count;
            while (n2 < n3) {
                collection.add(objectArray[n]);
                objectArray[n] = null;
                n = this.inc(n);
                ++n2;
            }
            if (n2 > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n4 = n2;
            Object var5_8 = null;
            reentrantLock.unlock();
            return n4;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.takeIndex;
            int n3 = 0;
            int n4 = this.count;
            int n5 = n < this.count ? n : this.count;
            while (n3 < n5) {
                collection.add(objectArray[n2]);
                objectArray[n2] = null;
                n2 = this.inc(n2);
                ++n3;
            }
            if (n3 > 0) {
                this.count -= n3;
                this.takeIndex = n2;
                this.notFull.signalAll();
            }
            int n6 = n3;
            Object var6_10 = null;
            reentrantLock.unlock();
            return n6;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr itr = new Itr();
            Object var3_3 = null;
            reentrantLock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public ArrayBlockingQueue(int n) {
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingQueue(int n, boolean bl, Collection collection) {
        this(n, bl);
        if (n < collection.size()) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private int nextIndex;
        private Object nextItem;
        private int lastRet = -1;

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextIndex >= 0) {
                bl = true;
            }
            return bl;
        }

        private final void checkNext() {
            if (this.nextIndex == ArrayBlockingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object object = this.nextItem;
                this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex);
                this.checkNext();
                Object object2 = object;
                Object var3_4 = null;
                reentrantLock.unlock();
                return object2;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                int n = this.lastRet;
                if (n == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int n2 = ArrayBlockingQueue.this.takeIndex;
                ArrayBlockingQueue.this.removeAt(n);
                this.nextIndex = n == n2 ? ArrayBlockingQueue.this.takeIndex : n;
                this.checkNext();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var3_6 = null;
                reentrantLock.unlock();
                return;
            }
        }

        Itr() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingQueue.this.items[ArrayBlockingQueue.this.takeIndex];
            }
        }
    }
}

