/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.DataRecoveryWriteQueue;
import com.tridium.platDataRecovery.block.FreeDataRecoveryBlock;
import com.tridium.platDataRecovery.block.PendingDataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInactiveException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreFullException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreUnavailableException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.DataRecoveryTooLargeException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBlob;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryBlockUpdateManager
extends BDataRecoveryBlockManager {
    public static final Type TYPE;
    private HashMap sourceIdDataRecoveryKeyToSeekIndex;
    private RandomAccessFile randomAccessFile;
    private DataRecoveryWriteQueue dataRecoveryQueue;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$block$BDataRecoveryBlockUpdateManager;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void openActiveFile(String string) throws DataRecoveryException {
        boolean bl = log.isTraceOn();
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("Data recovery directories are not initialized");
        }
        if (this.activeFileOpen) {
            if (bl) {
                log.trace("Data recovery active file already open");
            }
            if (this.file.getName().equals(string)) {
                return;
            }
            this.closeActiveFile();
        }
        if (bl) {
            log.trace("Opening active data recovery store with filename: " + string);
        }
        Object object = activeDirectoryMonitor;
        synchronized (object) {
            boolean bl2;
            block16: {
                this.file = new File(activeDirectory, string);
                bl2 = false;
                if (this.file.exists()) break block16;
                try {
                    this.file.createNewFile();
                    bl2 = true;
                }
                catch (IOException iOException) {
                    log.error("Error creating active data recovery file with name: " + string, (Throwable)iOException);
                    throw new DataRecoveryException("Error creating active data recovery file with name: " + string, (Throwable)iOException);
                }
            }
            try {
                this.randomAccessFile = new RandomAccessFile(this.file, "rw");
                this.activeFileOpen = true;
                if (!bl2) {
                    if (bl) {
                        log.trace("Active data recovery file already existed at: " + this.file.getCanonicalPath() + ", reading contents.");
                    }
                    this.readFromActive();
                } else {
                    if (bl) {
                        log.trace("Formatting new active data recovery file at: " + this.file.getCanonicalPath());
                    }
                    this.formatActiveFile();
                }
                this.dataRecoveryQueue = new DataRecoveryWriteQueue(this.randomAccessFile);
                this.dataRecoveryQueue.clear();
            }
            catch (Exception exception) {
                log.error("Error creating/reading active data recovery file: " + this.file.getName(), (Throwable)exception);
                throw new DataRecoveryException("Error creating/reading active data recovery file: " + this.file.getName(), (Throwable)exception);
            }
            return;
        }
    }

    public final void closeActiveFile() throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        if (log.isTraceOn()) {
            log.trace("Closing data recovery active file: " + this.file.getName());
        }
        try {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
            this.activeFileOpen = false;
            if (BDataRecoveryService.chunkFSPresent) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file, false);
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Exception exception) {}
            } else if (!this.file.delete()) {
                log.error("Could not delete active data recovery file: " + this.file.getName() + ", truncating instead");
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file, false);
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Exception exception) {}
            }
            this.file = null;
        }
        catch (IOException iOException) {
            log.error("Error closing active data recovery file: " + this.file.getName(), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void formatActiveFile() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            block11: {
                block10: {
                    if (this.blocks != null) break block10;
                    this.blocks = new ArrayList();
                    break block11;
                }
                this.blocks.clear();
            }
            this.clearHashMap();
            FreeDataRecoveryBlock freeDataRecoveryBlock = new FreeDataRecoveryBlock(this.getMaxCapacity(), true);
            this.blocks.add(freeDataRecoveryBlock);
            try {
                this.randomAccessFile.setLength(this.getMaxCapacity());
                this.writeToActive();
            }
            catch (Exception exception) {
                log.error("Error formatting data recovery database: ", (Throwable)exception);
            }
            Object object2 = this.sizeMonitor;
            synchronized (object2) {
                long l;
                this.setUsedSpace(freeDataRecoveryBlock.getUsedSpace());
                this.setOverheadSpace(freeDataRecoveryBlock.getOverheadSpace());
                this.setFreeSpace(freeDataRecoveryBlock.getFreeSpace());
                if (this.isSubscribed() && (l = System.currentTimeMillis()) - this.lastMillisFired > 5000L) {
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = l;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void writeToActive() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            try {
                long l = 0L;
                if (debug) {
                    l = Clock.ticks();
                }
                this.randomAccessFile.seek(0L);
                DataRecoveryBlock dataRecoveryBlock = null;
                Iterator iterator = this.blocks.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (debug && l != 0L) {
                            System.out.println("BDataRecoveryBlockManager::writeToActive() took: " + (Clock.ticks() - l) + " ms");
                        }
                        break;
                    }
                    dataRecoveryBlock = (DataRecoveryBlock)iterator.next();
                    dataRecoveryBlock.write(this.randomAccessFile);
                }
            }
            catch (Exception exception) {
                log.error("Error writing blocks: ", (Throwable)exception);
                throw exception;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void readFromActive() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            BBlob bBlob = null;
            this.clearHashMap();
            try {
                long l = 0L;
                if (debug) {
                    l = Clock.ticks();
                }
                this.randomAccessFile.seek(0L);
                if (this.blocks != null) {
                    this.blocks.clear();
                } else {
                    this.blocks = new ArrayList();
                }
                DataRecoveryBlock.maxReadSize = this.randomAccessFile.length();
                while (true) {
                    if (this.randomAccessFile.getFilePointer() >= this.randomAccessFile.length()) {
                        if (debug && l != 0L) {
                            System.out.println("BDataRecoveryBlockManager::readFromActive() took: " + (Clock.ticks() - l) + " ms");
                        }
                        break;
                    }
                    if (debug) {
                        System.out.println("RandomAccessFile.getFilePointer(): " + this.randomAccessFile.getFilePointer());
                        System.out.println("RandomAccessFile.length(): " + this.randomAccessFile.length());
                    }
                    DataRecoveryBlock dataRecoveryBlock = DataRecoveryBlock.read(this.randomAccessFile);
                    this.blocks.add(dataRecoveryBlock);
                    if (dataRecoveryBlock.getBlockState() != 1) continue;
                    bBlob = BDataRecoveryBlockManager.createCombinedKey(dataRecoveryBlock.getSpaceIdentifier(), dataRecoveryBlock.getKeyInSourceSpaceCopy());
                    this.sourceIdDataRecoveryKeyToSeekIndex.put(bBlob, new BlockSeekOffsetEntry((int)this.randomAccessFile.getFilePointer() - dataRecoveryBlock.getTotalSize(), this.blocks.size() - 1));
                }
            }
            catch (Exception exception) {
                log.error("Error reading blocks: ", (Throwable)exception);
                throw exception;
            }
            this.recalculateSpace();
            return;
        }
    }

    private final void clearHashMap() {
        if (this.sourceIdDataRecoveryKeyToSeekIndex == null) {
            this.sourceIdDataRecoveryKeyToSeekIndex = new HashMap();
        } else {
            this.sourceIdDataRecoveryKeyToSeekIndex.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int setPendingToFree(int n) {
        Object object = this.blocksMonitor;
        synchronized (object) {
            int n2 = Math.min(n + 1, this.blocks.size());
            ListIterator listIterator = this.blocks.listIterator(n2);
            DataRecoveryBlock dataRecoveryBlock = null;
            do {
                if (!listIterator.hasPrevious()) {
                    return -1;
                }
                --n2;
            } while (!((dataRecoveryBlock = (DataRecoveryBlock)listIterator.previous()) instanceof PendingDataRecoveryBlock));
            if (log.isTraceOn()) {
                log.trace("Replacing a pending block with free at index: " + n2);
            }
            this.blocks.set(n2, new FreeDataRecoveryBlock(dataRecoveryBlock.getTotalSize(), true));
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int setPendingToUsed(int n) {
        Object object = this.blocksMonitor;
        synchronized (object) {
            int n2 = Math.min(n + 1, this.blocks.size());
            ListIterator listIterator = this.blocks.listIterator(n2);
            DataRecoveryBlock dataRecoveryBlock = null;
            do {
                if (!listIterator.hasPrevious()) {
                    return -1;
                }
                --n2;
            } while (!((dataRecoveryBlock = (DataRecoveryBlock)listIterator.previous()) instanceof PendingDataRecoveryBlock));
            if (log.isTraceOn()) {
                log.trace("Replacing a pending block with used at index: " + n2);
            }
            this.blocks.set(n2, PendingDataRecoveryBlock.createUsed((PendingDataRecoveryBlock)dataRecoveryBlock));
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void reindexKeyToSeekOffset(BBlob bBlob) throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            BlockSeekOffsetEntry blockSeekOffsetEntry;
            long l;
            block11: {
                block10: {
                    l = 0L;
                    if (log.isTraceOn()) {
                        l = Clock.ticks();
                    }
                    blockSeekOffsetEntry = null;
                    if (bBlob == null) break block10;
                    blockSeekOffsetEntry = (BlockSeekOffsetEntry)this.sourceIdDataRecoveryKeyToSeekIndex.get(bBlob);
                    if (blockSeekOffsetEntry == null) {
                        blockSeekOffsetEntry = new BlockSeekOffsetEntry(0L, 0);
                        this.clearHashMap();
                    }
                    break block11;
                }
                blockSeekOffsetEntry = new BlockSeekOffsetEntry(0L, 0);
                this.clearHashMap();
            }
            if (log.isTraceOn()) {
                log.trace("Resynchronizing index/seek to combined keys starting from index: " + blockSeekOffsetEntry.getArrayOffset());
            }
            long l2 = blockSeekOffsetEntry.getSeekPosition();
            int n = blockSeekOffsetEntry.getArrayOffset();
            ListIterator listIterator = this.blocks.listIterator(n);
            DataRecoveryBlock dataRecoveryBlock = null;
            BBlob bBlob2 = null;
            while (listIterator.hasNext()) {
                dataRecoveryBlock = (DataRecoveryBlock)listIterator.next();
                if (dataRecoveryBlock.getBlockState() == 1) {
                    bBlob2 = BDataRecoveryBlockManager.createCombinedKey(dataRecoveryBlock.getSpaceIdentifier(), dataRecoveryBlock.getKeyInSourceSpaceCopy());
                    this.sourceIdDataRecoveryKeyToSeekIndex.put(bBlob2, new BlockSeekOffsetEntry(l2, n));
                }
                l2 += (long)dataRecoveryBlock.getTotalSize();
                ++n;
            }
            if (log.isTraceOn()) {
                log.trace("Resync took: " + (Clock.ticks() - l) + " ms");
                log.trace("Finished resynchronization of index/seek to combined keys starting from index: " + blockSeekOffsetEntry.getArrayOffset());
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public final boolean updateData(byte var1_1, byte[] var2_2, byte[] var3_3) throws DataRecoveryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [18 : 94->1484)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean appendData(byte by, byte[] byArray, byte[] byArray2) throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        int n = byArray2.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize + byArray.length;
        if (n > this.getMaxCapacity()) {
            throw new DataRecoveryTooLargeException(byArray2.length, this.getMaxCapacity(), "Cannot store data with length of " + byArray2.length);
        }
        BBlob bBlob = BDataRecoveryBlockManager.createCombinedKey(by, byArray);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        Object object = this.blocksMonitor;
        synchronized (object) {
            BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus = this.getCurrentManagerStatus();
            if (bDataRecoveryBlockManagerStatus != BDataRecoveryBlockManagerStatus.active && bDataRecoveryBlockManagerStatus != BDataRecoveryBlockManagerStatus.reserved) {
                throw new DataRecoveryBlockInactiveException("The current block is not active, append can not be accomplished at this time");
            }
            if (n > this.getFreeSpace()) {
                if (log.isTraceOn()) {
                    log.trace("Size of used block exceeds free space, forcing flush of block");
                }
                throw new DataRecoveryStoreFullException();
            }
            boolean bl4 = this.dataRecoveryQueue.areWritesPending() ^ true;
            DataRecoveryBlock dataRecoveryBlock = null;
            long l = this.blocks.size() == 0 ? 0L : (long)this.getMaxCapacity();
            int n3 = 0;
            if (this.blocks.size() != 0) {
                n3 = this.blocks.size() - 1;
            }
            int n4 = n3;
            ListIterator listIterator = this.blocks.listIterator(this.blocks.size());
            FreeDataRecoveryBlock freeDataRecoveryBlock = null;
            int n5 = 0;
            boolean bl5 = false;
            while (listIterator.hasPrevious() && !bl3) {
                block49: {
                    block47: {
                        UsedDataRecoveryBlock usedDataRecoveryBlock;
                        block48: {
                            dataRecoveryBlock = (DataRecoveryBlock)listIterator.previous();
                            if (dataRecoveryBlock.getBlockState() != 0) break block48;
                            if (dataRecoveryBlock.getFreeSpace() == n) {
                                freeDataRecoveryBlock = null;
                                n5 = 0;
                                bl3 = true;
                                usedDataRecoveryBlock = null;
                                try {
                                    usedDataRecoveryBlock = new UsedDataRecoveryBlock(by, byArray.length, byArray, byArray2.length, byArray2);
                                    long l2 = l - (long)usedDataRecoveryBlock.getTotalSize();
                                    if (l2 < 0L) {
                                        throw new BajaRuntimeException("Target seek offset for block was negative: " + l2);
                                    }
                                    this.dataRecoveryQueue.add(usedDataRecoveryBlock, l2);
                                    if (bl4) {
                                        this.dataRecoveryQueue.commit();
                                    }
                                    this.blocks.set(n4, usedDataRecoveryBlock);
                                    this.sourceIdDataRecoveryKeyToSeekIndex.put(bBlob, new BlockSeekOffsetEntry(l2, n4));
                                    Object object2 = this.sizeMonitor;
                                    synchronized (object2) {
                                        long l3;
                                        this.setFreeSpace(this.getFreeSpace() - dataRecoveryBlock.getFreeSpace());
                                        this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock.getUsedSpace());
                                        this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock.getOverheadSpace());
                                        if (this.isSubscribed() && (l3 = System.currentTimeMillis()) - this.lastMillisFired > 5000L) {
                                            this.fireSizesUpdated(null);
                                            this.lastMillisFired = l3;
                                        }
                                        // MONITOREXIT @DISABLED, blocks:[17, 1, 34, 2, 7, 8] lbl66 : MonitorExitStatement: MONITOREXIT : var26_28
                                        bl = true;
                                    }
                                }
                                catch (Exception exception) {
                                    log.error("Append data: error replacing same size free block with used block, aborting: ", (Throwable)exception);
                                    bl = false;
                                }
                                break;
                            }
                            if (dataRecoveryBlock.getFreeSpace() > n) {
                                if (dataRecoveryBlock.getFreeSpace() - n - DataRecoveryBlock.freeBlockHeaderSize > 0) {
                                    freeDataRecoveryBlock = null;
                                    n5 = 0;
                                    bl3 = true;
                                    try {
                                        long l4 = l - (long)dataRecoveryBlock.getTotalSize();
                                        long l5 = l4 + (long)n;
                                        if (l4 < 0L) {
                                            throw new BajaRuntimeException("Target used seek offset for block was negative: " + l4);
                                        }
                                        if (l5 < 0L) {
                                            throw new BajaRuntimeException("Target free seek offset for block was negative: " + l5);
                                        }
                                        UsedDataRecoveryBlock usedDataRecoveryBlock2 = new UsedDataRecoveryBlock(by, byArray.length, byArray, byArray2.length, byArray2);
                                        FreeDataRecoveryBlock freeDataRecoveryBlock2 = new FreeDataRecoveryBlock(dataRecoveryBlock.getTotalSize() - usedDataRecoveryBlock2.getTotalSize(), true);
                                        this.dataRecoveryQueue.add(freeDataRecoveryBlock2, l5);
                                        this.blocks.set(n4, new FreeDataRecoveryBlock(usedDataRecoveryBlock2.getTotalSize(), true));
                                        this.blocks.add(n4 + 1, freeDataRecoveryBlock2);
                                        this.dataRecoveryQueue.add(usedDataRecoveryBlock2, l4);
                                        this.blocks.set(n4, usedDataRecoveryBlock2);
                                        this.sourceIdDataRecoveryKeyToSeekIndex.put(bBlob, new BlockSeekOffsetEntry(l4, n4));
                                        if (bl4) {
                                            this.dataRecoveryQueue.commit();
                                        }
                                        boolean bl6 = true;
                                        if (n4 == this.blocks.size() - 2 && ((DataRecoveryBlock)this.blocks.get(n4 + 1)).getBlockState() == 0) {
                                            bl6 = false;
                                        }
                                        if (bl6) {
                                            this.reindexKeyToSeekOffset(bBlob);
                                        }
                                        bl = true;
                                        Object object3 = this.sizeMonitor;
                                        synchronized (object3) {
                                            long l6;
                                            this.setFreeSpace(this.getFreeSpace() - usedDataRecoveryBlock2.getTotalSize());
                                            this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock2.getUsedSpace());
                                            this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock2.getOverheadSpace());
                                            if (this.isSubscribed() && (l6 = System.currentTimeMillis()) - this.lastMillisFired > 5000L) {
                                                this.fireSizesUpdated(null);
                                                this.lastMillisFired = l6;
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        log.error("Append data: error adding used block in free block split, aborting: ", (Throwable)exception);
                                        bl = false;
                                    }
                                    break;
                                }
                                bl5 = true;
                            } else {
                                bl5 = true;
                            }
                            if (bl5) {
                                if (freeDataRecoveryBlock == null) {
                                    freeDataRecoveryBlock = new FreeDataRecoveryBlock(dataRecoveryBlock.getTotalSize(), true);
                                    ++n5;
                                } else {
                                    try {
                                        freeDataRecoveryBlock.coalesce(dataRecoveryBlock);
                                        ++n5;
                                    }
                                    catch (Exception exception) {
                                        log.error("Error coalescing free blocks at index: " + n4, (Throwable)exception);
                                        freeDataRecoveryBlock = null;
                                        n5 = 0;
                                    }
                                }
                                bl5 = false;
                            }
                            break block49;
                        }
                        if (freeDataRecoveryBlock != null && n5 > 1) {
                            try {
                                this.dataRecoveryQueue.add(freeDataRecoveryBlock, l);
                                int n6 = 0;
                                while (true) {
                                    if (n6 >= n5) {
                                        this.blocks.add(n4 + 1, freeDataRecoveryBlock);
                                        n2 = freeDataRecoveryBlock.getTotalSize();
                                        usedDataRecoveryBlock = BDataRecoveryBlockUpdateManager.createCombinedKey(dataRecoveryBlock.sourceSpace, dataRecoveryBlock.keyInSourceSpace);
                                        this.reindexKeyToSeekOffset((BBlob)usedDataRecoveryBlock);
                                        if (n >= n2) break;
                                        bl2 = true;
                                        listIterator = this.blocks.listIterator(n4 + 2);
                                        break block47;
                                    }
                                    this.blocks.remove(n4 + 1);
                                    ++n6;
                                }
                                listIterator = this.blocks.listIterator(n4);
                            }
                            catch (Exception exception) {
                                log.error("Error writing coalesced free blocks at index: " + n4, (Throwable)exception);
                            }
                        } else if (freeDataRecoveryBlock != null) {
                            // empty if block
                        }
                    }
                    freeDataRecoveryBlock = null;
                    n5 = 0;
                }
                if (bl2) {
                    bl2 = false;
                    l += (long)n2;
                    ++n4;
                    continue;
                }
                l -= (long)dataRecoveryBlock.getTotalSize();
                --n4;
            }
            if (!bl3) {
                throw new DataRecoveryStoreFullException();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void dump(PrintStream printStream) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            block7: {
                block6: {
                    super.dump(printStream);
                    BBlob bBlob = null;
                    byte by = 0;
                    byte[] byArray = null;
                    BlockSeekOffsetEntry blockSeekOffsetEntry = null;
                    Set set = null;
                    Iterator iterator = null;
                    if (this.sourceIdDataRecoveryKeyToSeekIndex.isEmpty()) break block6;
                    printStream.println("Key To Offset/Index Hash Map Contents:");
                    printStream.println("{");
                    set = this.sourceIdDataRecoveryKeyToSeekIndex.keySet();
                    iterator = set.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            printStream.println("}");
                            break block7;
                        }
                        bBlob = (BBlob)iterator.next();
                        blockSeekOffsetEntry = (BlockSeekOffsetEntry)this.sourceIdDataRecoveryKeyToSeekIndex.get(bBlob);
                        byArray = BDataRecoveryBlockManager.getRecoveryKeyFromCombinedKey(bBlob);
                        by = BDataRecoveryBlockManager.getSourceFromCombinedKey(bBlob);
                        printStream.println("  Source ID: " + by + ", Key In Source: " + TextUtil.bytesToHexString((byte[])byArray) + " --> Array Index: " + blockSeekOffsetEntry.getArrayOffset() + " Seek Offset: " + blockSeekOffsetEntry.getSeekPosition());
                    }
                }
                printStream.println("No Offset Keys");
            }
            printStream.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void visualDump(PrintStream printStream) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            block7: {
                block6: {
                    super.visualDump(printStream);
                    BBlob bBlob = null;
                    byte by = 0;
                    byte[] byArray = null;
                    BlockSeekOffsetEntry blockSeekOffsetEntry = null;
                    Set set = null;
                    Iterator iterator = null;
                    if (this.sourceIdDataRecoveryKeyToSeekIndex.isEmpty()) break block6;
                    printStream.println("Key To Offset/Index Hash Map Contents:");
                    printStream.println("{");
                    set = this.sourceIdDataRecoveryKeyToSeekIndex.keySet();
                    iterator = set.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            printStream.println("}");
                            break block7;
                        }
                        bBlob = (BBlob)iterator.next();
                        blockSeekOffsetEntry = (BlockSeekOffsetEntry)this.sourceIdDataRecoveryKeyToSeekIndex.get(bBlob);
                        byArray = BDataRecoveryBlockManager.getRecoveryKeyFromCombinedKey(bBlob);
                        by = BDataRecoveryBlockManager.getSourceFromCombinedKey(bBlob);
                        printStream.println("  Source ID: " + by + ", Key In Source: " + TextUtil.bytesToHexString((byte[])byArray) + " --> Array Index: " + blockSeekOffsetEntry.getArrayOffset() + " Seek Offset: " + blockSeekOffsetEntry.getSeekPosition());
                    }
                }
                printStream.println("No Offset Keys");
            }
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sourceIdDataRecoveryKeyToSeekIndex = new HashMap();
        this.randomAccessFile = null;
        this.dataRecoveryQueue = null;
    }

    public BDataRecoveryBlockUpdateManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockUpdateManager;
        if (clazz == null) {
            clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockUpdateManager = BDataRecoveryBlockUpdateManager.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockUpdateManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class BlockSeekOffsetEntry {
        long seekPosition;
        int arrayOffset;

        public final long getSeekPosition() {
            return this.seekPosition;
        }

        public final int getArrayOffset() {
            return this.arrayOffset;
        }

        private final /* synthetic */ void this() {
            this.seekPosition = 0L;
            this.arrayOffset = 0;
        }

        public BlockSeekOffsetEntry(long l, int n) {
            this.this();
            if (l < 0L) {
                throw new BajaRuntimeException("Can not create a seek/offset entry with negative seekPosition: " + l);
            }
            if (n < 0) {
                throw new BajaRuntimeException("Can not create a seek/offset entry with negative arrayOffset: " + n);
            }
            this.seekPosition = l;
            this.arrayOffset = n;
        }
    }
}

