/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platgprs;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platgprs.BGprsHostSettings;
import com.tridium.platgprs.BGprsRuntimeData;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class GprsUtil {
    private static final Log log = Log.getLog((String)"platGprs.util");
    public static final Lexicon gprsLexicon;
    private static final String configXmlFile;
    private static final String gprsRuntimeData;
    private static final String gprsResourceManager;
    private static final FilePath configXmlFilePath;
    private static final FilePath gprsRuntimeDataPath;
    private static final FilePath gprsResourceManagerPath;
    static /* synthetic */ Class class$com$tridium$platgprs$BGprsHostSettings;

    public static final void loadConfigFromSession(BGprsHostSettings bGprsHostSettings, BDaemonSession bDaemonSession) {
        BIFile bIFile = bDaemonSession.getFileSpace().findFile(configXmlFilePath);
        GprsUtil.loadConfig(bGprsHostSettings, bIFile);
    }

    public static final void loadConfigLocal(BGprsHostSettings bGprsHostSettings) {
        BIFile bIFile = (BIFile)BOrd.make((String)"file:!daemon/gprs/gprs.xml").resolve().get();
        GprsUtil.loadConfig(bGprsHostSettings, bIFile);
    }

    public static final void loadRuntimeFromSession(BGprsRuntimeData bGprsRuntimeData, BDaemonSession bDaemonSession) {
        BIFile bIFile = bDaemonSession.getFileSpace().findFile(gprsRuntimeDataPath);
        BIFile bIFile2 = bDaemonSession.getFileSpace().findFile(gprsResourceManagerPath);
        GprsUtil.loadRuntime(bGprsRuntimeData, bIFile, bIFile2);
    }

    public static final void loadRuntimeLocal(BGprsRuntimeData bGprsRuntimeData) {
        try {
            BIFile bIFile = (BIFile)BOrd.make((String)"file:/dev/gprs/data").resolve().get();
            BIFile bIFile2 = (BIFile)BOrd.make((String)"file:/dev/gprs/manager").resolve().get();
            GprsUtil.loadRuntime(bGprsRuntimeData, bIFile, bIFile2);
        }
        catch (UnresolvedException unresolvedException) {
            bGprsRuntimeData.setPropertiesFault();
        }
    }

    private static final void loadRuntime(BGprsRuntimeData bGprsRuntimeData, BIFile bIFile, BIFile bIFile2) {
        Object object;
        int n;
        Object object2;
        if (bIFile == null || bIFile2 == null) {
            bGprsRuntimeData.setPropertiesFault();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object2 = bIFile.getInputStream();
            while ((n = ((InputStream)object2).read()) != -1) {
                stringBuffer.append((char)n);
            }
            ((InputStream)object2).close();
        }
        catch (Exception exception) {
            log.error("Error loading GPRS runtime data, returning provided GPRS runtime values", (Throwable)exception);
            return;
        }
        object2 = new StringTokenizer(stringBuffer.toString(), " ");
        if (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            try {
                bGprsRuntimeData.getRssi().setValueValue((BValue)BDouble.make((double)Double.parseDouble(((String)object).substring(5))));
                bGprsRuntimeData.getRssi().setStatusFault(false);
            }
            catch (NumberFormatException numberFormatException) {
                bGprsRuntimeData.getRssi().setStatusFault(true);
            }
            if (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (((String)object).startsWith("roam=")) {
                    BStatusValue bStatusValue = bGprsRuntimeData.getRoam();
                    boolean bl = false;
                    if (((String)object).charAt(5) == 'T') {
                        bl = true;
                    }
                    bStatusValue.setValueValue((BValue)BBoolean.make((boolean)bl));
                    bGprsRuntimeData.getRoam().setStatusFault(false);
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (((String)object).startsWith("pppautocon=")) {
                        BStatusValue bStatusValue = bGprsRuntimeData.getOnDemandPppEnabled();
                        boolean bl = false;
                        if (((String)object).charAt(11) == 'T') {
                            bl = true;
                        }
                        bStatusValue.setValueValue((BValue)BBoolean.make((boolean)bl));
                        bGprsRuntimeData.getOnDemandPppEnabled().setStatusFault(false);
                    }
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        if (((String)object).startsWith("ip=")) {
                            bGprsRuntimeData.getIp().setValueValue((BValue)BString.make((String)((String)object).substring(3)));
                            bGprsRuntimeData.getIp().setStatusFault(false);
                        }
                        if (((StringTokenizer)object2).hasMoreTokens()) {
                            object = ((StringTokenizer)object2).nextToken();
                            if (((String)object).startsWith("imsi=")) {
                                bGprsRuntimeData.getImsi().setValueValue((BValue)BString.make((String)((String)object).substring(5)));
                                bGprsRuntimeData.getImsi().setStatusFault(false);
                            }
                            if (((StringTokenizer)object2).hasMoreTokens()) {
                                object = ((StringTokenizer)object2).nextToken();
                                if (((String)object).startsWith("imei=")) {
                                    bGprsRuntimeData.getImei().setValueValue((BValue)BString.make((String)((String)object).substring(5)));
                                    bGprsRuntimeData.getImei().setStatusFault(false);
                                }
                                if (((StringTokenizer)object2).hasMoreTokens() && ((String)(object = ((StringTokenizer)object2).nextToken())).startsWith("sim=")) {
                                    bGprsRuntimeData.getSim().setValueValue((BValue)BString.make((String)((String)object).substring(4)));
                                    bGprsRuntimeData.getSim().setStatusFault(false);
                                }
                            }
                        }
                    }
                }
            }
        }
        bGprsRuntimeData.setData(stringBuffer.toString());
        n = 0;
        stringBuffer = new StringBuffer();
        try {
            object = bIFile2.getInputStream();
            while ((n = ((InputStream)object).read()) != -1) {
                stringBuffer.append((char)n);
            }
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            log.error("Error loading GPRS runtime data, returning provided GPRS runtime values", (Throwable)exception);
            return;
        }
        bGprsRuntimeData.setManagerStatus(stringBuffer.toString());
    }

    private static final void loadConfig(BGprsHostSettings bGprsHostSettings, BIFile bIFile) {
        if (bIFile == null) {
            return;
        }
        try {
            XElem xElem;
            XElem xElem2;
            byte[] byArray = bIFile.read();
            String string = new String(byArray);
            XElem xElem3 = XParser.make((String)string).parse();
            XElem xElem4 = xElem3.elem("modem");
            if (xElem4 != null) {
                bGprsHostSettings.setGprsModemEnabled(xElem4.getb("enableGprsModem", false));
                bGprsHostSettings.setPreferredBaudRate(xElem4.geti("preferredBaudRate", 115200));
                bGprsHostSettings.setDebugLevel(xElem4.geti("debugLevel", 1));
                bGprsHostSettings.setRun(xElem4.getb("run", true));
                bGprsHostSettings.setCycleTime(BRelTime.makeSeconds((int)xElem4.geti("cycleTime", 60)));
                bGprsHostSettings.setMaxScriptFailureTime(BRelTime.makeSeconds((int)xElem4.geti("maxScriptFailureTime", 60)));
            }
            if ((xElem2 = xElem3.elem("provider")) != null) {
                bGprsHostSettings.setAllowPppConnections(xElem2.getb("allowPppConnections", true));
                bGprsHostSettings.setUsePppAutoconnect(xElem2.getb("usePppAutoconnect", false));
                bGprsHostSettings.setDebugPpp(xElem2.getb("debugPpp", false));
                bGprsHostSettings.setSwitchDefaultGateway(xElem2.getb("switchDefaultGateway", true));
                bGprsHostSettings.setAccessPointName(xElem2.get("apn", ""));
                bGprsHostSettings.setUserName(xElem2.get("userName", ""));
                xElem = null;
                String string2 = xElem2.get("password", null);
                xElem = string2 == null ? BPassword.DEFAULT : BPassword.make((String)string2);
                bGprsHostSettings.setPassword((BPassword)xElem);
                bGprsHostSettings.setSgAuth(xElem2.geti("sgauth", 1));
                bGprsHostSettings.setMinDisconnectTime(BRelTime.makeSeconds((int)xElem2.geti("minDisconnectTime", 180)));
                bGprsHostSettings.setMaxConnectTime(BRelTime.makeSeconds((int)xElem2.geti("maxConnectTime", 1800)));
                bGprsHostSettings.setMaxPppActiveTime(BRelTime.makeMinutes((int)xElem2.geti("maxPppActiveTime", 0)));
                bGprsHostSettings.setMaxLcpFailures(xElem2.geti("maxLcpFailures", 10));
            }
            if ((xElem = xElem3.elem("sms")) != null) {
                bGprsHostSettings.setSmsServerCenter(xElem.get("serviceCenter", ""));
                bGprsHostSettings.setAutoDeleteReadSms(xElem.getb("autoDeleteReadSms", true));
                bGprsHostSettings.setRemoteCommandsEnabled(xElem.getb("remoteCommandsEnabled", true));
            }
        }
        catch (Exception exception) {
            log.error("Error loading GPRS runtime data, returning provided GPRS host settings", (Throwable)exception);
            return;
        }
    }

    public static final void saveToSession(BGprsHostSettings bGprsHostSettings, BDaemonSession bDaemonSession) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
            XElem xElem = GprsUtil.createConfigXml(bGprsHostSettings);
            xElem.write(xWriter);
            xWriter.flush();
            xWriter.close();
            DaemonSessionTaskListener daemonSessionTaskListener = null;
            ICancelHint iCancelHint = null;
            FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)bDaemonSession.getFileSpace());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            fileTransferMessage.addElement((FileTransferMessageElement)new ByteArrayFileTransferElement(configXmlFilePath, byArray, (BDaemonFileSpace)bDaemonSession.getFileSpace()));
            DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)fileTransferMessage, iCancelHint, daemonSessionTaskListener);
        }
        catch (Exception exception) {
            log.error("Error saving GPRS host settings to daemon session", (Throwable)exception);
        }
    }

    public static final void saveLocal(BGprsHostSettings bGprsHostSettings) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(configXmlFile);
            XWriter xWriter = new XWriter((OutputStream)fileOutputStream);
            XElem xElem = GprsUtil.createConfigXml(bGprsHostSettings);
            xElem.write(xWriter);
            xWriter.flush();
            xWriter.close();
        }
        catch (Exception exception) {
            log.error("Error saving GPRS host settings to localhost", (Throwable)exception);
        }
    }

    public static final XElem createConfigXml(BGprsHostSettings bGprsHostSettings) {
        XElem xElem = new XElem("gprs");
        XElem xElem2 = new XElem("modem");
        XElem xElem3 = new XElem("provider");
        XElem xElem4 = new XElem("sms");
        xElem.addContent((XContent)xElem2);
        xElem.addContent((XContent)xElem3);
        xElem.addContent((XContent)xElem4);
        xElem2.addAttr("enableGprsModem", String.valueOf(bGprsHostSettings.getGprsModemEnabled()));
        xElem2.addAttr("preferredBaudRate", String.valueOf(bGprsHostSettings.getPreferredBaudRate()));
        xElem2.addAttr("debugLevel", String.valueOf(bGprsHostSettings.getDebugLevel()));
        xElem2.addAttr("run", String.valueOf(bGprsHostSettings.getRun()));
        xElem2.addAttr("cycleTime", String.valueOf(bGprsHostSettings.getCycleTime().getSeconds()));
        xElem2.addAttr("maxScriptFailureTime", String.valueOf(bGprsHostSettings.getMaxScriptFailureTime().getSeconds()));
        xElem3.addAttr("allowPppConnections", String.valueOf(bGprsHostSettings.getAllowPppConnections()));
        xElem3.addAttr("usePppAutoconnect", String.valueOf(bGprsHostSettings.getUsePppAutoconnect()));
        xElem3.addAttr("debugPpp", String.valueOf(bGprsHostSettings.getDebugPpp()));
        xElem3.addAttr("switchDefaultGateway", String.valueOf(bGprsHostSettings.getSwitchDefaultGateway()));
        xElem3.addAttr("apn", bGprsHostSettings.getAccessPointName());
        xElem3.addAttr("userName", bGprsHostSettings.getUserName());
        xElem3.addAttr("password", bGprsHostSettings.getPassword().getValue());
        xElem3.addAttr("sgauth", String.valueOf(bGprsHostSettings.getSgAuth()));
        xElem3.addAttr("minDisconnectTime", String.valueOf(bGprsHostSettings.getMinDisconnectTime().getSeconds()));
        xElem3.addAttr("maxConnectTime", String.valueOf(bGprsHostSettings.getMaxConnectTime().getSeconds()));
        xElem3.addAttr("maxPppActiveTime", String.valueOf(bGprsHostSettings.getMaxPppActiveTime().getMinutes()));
        xElem3.addAttr("maxLcpFailures", String.valueOf(bGprsHostSettings.getMaxLcpFailures()));
        xElem4.addAttr("serviceCenter", bGprsHostSettings.getSmsServerCenter());
        xElem4.addAttr("autoDeleteReadSms", String.valueOf(bGprsHostSettings.getAutoDeleteReadSms()));
        xElem4.addAttr("remoteCommandsEnabled", String.valueOf(bGprsHostSettings.getRemoteCommandsEnabled()));
        return xElem;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platgprs$BGprsHostSettings;
        if (clazz == null) {
            clazz = class$com$tridium$platgprs$BGprsHostSettings = GprsUtil.class("[Lcom.tridium.platgprs.BGprsHostSettings;", false);
        }
        gprsLexicon = Sys.getModuleForClass((Class)clazz).getLexicon();
        configXmlFile = new String("/niagara/daemon/gprs/gprs.xml");
        gprsRuntimeData = new String("/dev/gprs/data");
        gprsResourceManager = new String("/dev/gprs/manager");
        configXmlFilePath = new FilePath(configXmlFile);
        gprsRuntimeDataPath = new FilePath(gprsRuntimeData);
        gprsResourceManagerPath = new FilePath(gprsResourceManager);
    }
}

