/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.discover;

import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ak255.identify.BAk255ReadParams;
import com.tridium.ak255.identify.BAk255WriteParams;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BDdfPointDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDiscoveryObject;
import com.tridium.ddf.identify.BDdfIdParams;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255PointDiscoveryLeaf
extends BDdfPointDiscoveryLeaf
implements BIDdfDiscoveryObject {
    public static final Property readParameters = BAk255PointDiscoveryLeaf.newProperty((int)0, (BValue)new BAk255ReadParams(), (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Property writeParameters = BAk255PointDiscoveryLeaf.newProperty((int)0, (BValue)new BAk255WriteParams(), (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Type TYPE;
    private static TypeInfo[] BOOLEAN_READ;
    private static TypeInfo[] BOOLEAN_READ_WRITE;
    private static TypeInfo[] NUMERIC_READ;
    private static TypeInfo[] NUMERIC_READ_WRITE;
    static /* synthetic */ Class class$com$tridium$ak255$discover$BAk255PointDiscoveryLeaf;

    public BDdfIdParams getReadParameters() {
        return (BDdfIdParams)this.get(readParameters);
    }

    public void setReadParameters(BDdfIdParams bDdfIdParams) {
        this.set(readParameters, (BValue)bDdfIdParams, null);
    }

    public BDdfIdParams getWriteParameters() {
        return (BDdfIdParams)this.get(writeParameters);
    }

    public void setWriteParameters(BDdfIdParams bDdfIdParams) {
        this.set(writeParameters, (BValue)bDdfIdParams, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDiscoveryName() {
        String string = ((BAk255ReadParams)this.getReadParameters()).getIoName();
        if (string == null || string.length() == 0) {
            return "Point";
        }
        return string;
    }

    public TypeInfo[] getValidDatabaseTypes() {
        String string = ((BAk255ReadParams)this.getReadParameters()).getIoType();
        if (string.equals("input")) {
            return BOOLEAN_READ;
        }
        if (string.equals("relay")) {
            return BOOLEAN_READ_WRITE;
        }
        if (string.equals("sensor")) {
            return NUMERIC_READ;
        }
        return NUMERIC_READ_WRITE;
    }

    public void decodeInfo(XElem xElem) {
        BAk255ReadParams bAk255ReadParams = (BAk255ReadParams)this.getReadParameters();
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("name")) {
                bAk255ReadParams.setIoName(ParseUtil.getXlmStringContent(xElemArray[n], ""));
            } else if (xElemArray[n].name().equals("addr")) {
                bAk255ReadParams.setIoAddr(ParseUtil.getXlmStringContent(xElemArray[n], ""));
            } else if (xElemArray[n].name().equals("node")) {
                bAk255ReadParams.setIoNodeAddr(ParseUtil.getXlmIntContent(xElemArray[n], 0));
            } else if (xElemArray[n].name().equals("mod")) {
                bAk255ReadParams.setIoModuleAddr(ParseUtil.getXlmIntContent(xElemArray[n], 0));
            } else if (xElemArray[n].name().equals("point")) {
                bAk255ReadParams.setIoPointAddr(ParseUtil.getXlmIntContent(xElemArray[n], 0));
            } else if (xElemArray[n].name().equals("units")) {
                bAk255ReadParams.setIoUnits(ParseUtil.getXlmStringContent(xElemArray[n], ""));
                try {
                    bAk255ReadParams.setIoUnitsEnum(BUnitsTypeEnum.getUnit(bAk255ReadParams.getIoUnits()));
                }
                catch (Exception exception) {
                    bAk255ReadParams.setIoUnitsEnum(BUnitsTypeEnum.noUnits);
                }
            }
            ++n;
        }
        BAk255WriteParams bAk255WriteParams = (BAk255WriteParams)this.getWriteParameters();
        bAk255WriteParams.setIoNodeAddr(bAk255ReadParams.getIoNodeAddr());
        bAk255WriteParams.setIoModuleAddr(bAk255ReadParams.getIoModuleAddr());
        bAk255WriteParams.setIoPointAddr(bAk255ReadParams.getIoPointAddr());
    }

    public BFacets getDiscoveryPointFacets() {
        try {
            BAk255ReadParams bAk255ReadParams = (BAk255ReadParams)this.getReadParameters();
            int n = bAk255ReadParams.getIoUnitsEnum().getOrdinal();
            return BFacets.makeNumeric((BUnit)BUnitsTypeEnum.getNigaraUnit(n), (int)2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(Context context) {
        BAk255ReadParams bAk255ReadParams = (BAk255ReadParams)this.getReadParameters();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ioType = ");
        stringBuffer.append(bAk255ReadParams.getIoType());
        stringBuffer.append("\r\nioName = ");
        stringBuffer.append(bAk255ReadParams.getIoName());
        stringBuffer.append("\r\nioAddr = ");
        stringBuffer.append(bAk255ReadParams.getIoAddr());
        stringBuffer.append("\r\nioNodeAddr = ");
        stringBuffer.append(bAk255ReadParams.getIoNodeAddr());
        stringBuffer.append("\r\nioModuleAddr = ");
        stringBuffer.append(bAk255ReadParams.getIoModuleAddr());
        stringBuffer.append("\r\nioPointAddr = ");
        stringBuffer.append(bAk255ReadParams.getIoPointAddr());
        stringBuffer.append("\r\nioUnits = ");
        stringBuffer.append(bAk255ReadParams.getIoUnits());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ak255$discover$BAk255PointDiscoveryLeaf;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$discover$BAk255PointDiscoveryLeaf = BAk255PointDiscoveryLeaf.class("[Lcom.tridium.ak255.discover.BAk255PointDiscoveryLeaf;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        BOOLEAN_READ = new TypeInfo[]{BBooleanPoint.TYPE.getTypeInfo()};
        BOOLEAN_READ_WRITE = new TypeInfo[]{BBooleanPoint.TYPE.getTypeInfo(), BBooleanWritable.TYPE.getTypeInfo()};
        NUMERIC_READ = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo()};
        NUMERIC_READ_WRITE = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo(), BNumericWritable.TYPE.getTypeInfo()};
    }
}

