/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadSuctionCircuitRequest;
import com.tridium.ak255.comm.req.BAk255WriteSuctionCircuitRequest;
import com.tridium.ak255.components.BAk255CircuitDefrost;
import com.tridium.ak255.components.BAk255SensorValue;
import com.tridium.ak255.components.BManDefrostParameter;
import com.tridium.ak255.components.BStatusPollableComponent;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255SuctionCircuit
extends BStatusPollableComponent {
    public static final Property writeStatus = BAk255SuctionCircuit.newProperty((int)3, (String)"", null);
    public static final Property rackId = BAk255SuctionCircuit.newProperty((int)1, (int)0, null);
    public static final Property suctionId = BAk255SuctionCircuit.newProperty((int)1, (int)0, null);
    public static final Property circuitId = BAk255SuctionCircuit.newProperty((int)1, (int)0, null);
    public static final Property circuitName = BAk255SuctionCircuit.newProperty((int)1, (String)"", null);
    public static final Property circuitStatus = BAk255SuctionCircuit.newProperty((int)1, (String)"", null);
    public static final Property temperatureTarget = BAk255SuctionCircuit.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property targetUnits = BAk255SuctionCircuit.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property temperatureRange = BAk255SuctionCircuit.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property rangeUnits = BAk255SuctionCircuit.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property defrost = BAk255SuctionCircuit.newProperty((int)1, (BValue)new BAk255CircuitDefrost(), null);
    public static final Property sensorCount = BAk255SuctionCircuit.newProperty((int)1, (int)0, null);
    public static final Action modifyTemperatureTarget = BAk255SuctionCircuit.newAction((int)16, (BValue)BFloat.make((float)0.0f), null);
    public static final Action modifyTemperatureRange = BAk255SuctionCircuit.newAction((int)16, (BValue)BFloat.make((float)0.0f), null);
    public static final Action manualDefrost = BAk255SuctionCircuit.newAction((int)16, (BValue)new BManDefrostParameter(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255SuctionCircuit;

    public String getWriteStatus() {
        return this.getString(writeStatus);
    }

    public void setWriteStatus(String string) {
        this.setString(writeStatus, string, null);
    }

    public int getRackId() {
        return this.getInt(rackId);
    }

    public void setRackId(int n) {
        this.setInt(rackId, n, null);
    }

    public int getSuctionId() {
        return this.getInt(suctionId);
    }

    public void setSuctionId(int n) {
        this.setInt(suctionId, n, null);
    }

    public int getCircuitId() {
        return this.getInt(circuitId);
    }

    public void setCircuitId(int n) {
        this.setInt(circuitId, n, null);
    }

    public String getCircuitName() {
        return this.getString(circuitName);
    }

    public void setCircuitName(String string) {
        this.setString(circuitName, string, null);
    }

    public String getCircuitStatus() {
        return this.getString(circuitStatus);
    }

    public void setCircuitStatus(String string) {
        this.setString(circuitStatus, string, null);
    }

    public BStatusNumeric getTemperatureTarget() {
        return (BStatusNumeric)this.get(temperatureTarget);
    }

    public void setTemperatureTarget(BStatusNumeric bStatusNumeric) {
        this.set(temperatureTarget, (BValue)bStatusNumeric, null);
    }

    public BUnit getTargetUnits() {
        return (BUnit)this.get(targetUnits);
    }

    public void setTargetUnits(BUnit bUnit) {
        this.set(targetUnits, (BValue)bUnit, null);
    }

    public BStatusNumeric getTemperatureRange() {
        return (BStatusNumeric)this.get(temperatureRange);
    }

    public void setTemperatureRange(BStatusNumeric bStatusNumeric) {
        this.set(temperatureRange, (BValue)bStatusNumeric, null);
    }

    public BUnit getRangeUnits() {
        return (BUnit)this.get(rangeUnits);
    }

    public void setRangeUnits(BUnit bUnit) {
        this.set(rangeUnits, (BValue)bUnit, null);
    }

    public BAk255CircuitDefrost getDefrost() {
        return (BAk255CircuitDefrost)this.get(defrost);
    }

    public void setDefrost(BAk255CircuitDefrost bAk255CircuitDefrost) {
        this.set(defrost, (BValue)bAk255CircuitDefrost, null);
    }

    public int getSensorCount() {
        return this.getInt(sensorCount);
    }

    public void setSensorCount(int n) {
        this.setInt(sensorCount, n, null);
    }

    public void modifyTemperatureTarget(BFloat bFloat) {
        this.invoke(modifyTemperatureTarget, (BValue)bFloat, null);
    }

    public void modifyTemperatureRange(BFloat bFloat) {
        this.invoke(modifyTemperatureRange, (BValue)bFloat, null);
    }

    public void manualDefrost(BManDefrostParameter bManDefrostParameter) {
        this.invoke(manualDefrost, (BValue)bManDefrostParameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)temperatureTarget)) {
            return BFacets.makeNumeric((BUnit)this.getTargetUnits(), (int)2);
        }
        if (slot.equals((Object)temperatureRange)) {
            return BFacets.makeNumeric((BUnit)this.getRangeUnits(), (int)2);
        }
        return super.getSlotFacets(slot);
    }

    public String getDisplayName(Slot slot, Context context) {
        BValue bValue;
        if (slot.isDynamic() && (bValue = this.get(slot.asProperty())) instanceof BAk255SensorValue) {
            this.lease(1);
            BAk255SensorValue bAk255SensorValue = (BAk255SensorValue)this.get(slot.asProperty());
            if (!bAk255SensorValue.getSensorName().equals("")) {
                return bAk255SensorValue.getSensorName();
            }
        }
        return super.getDisplayName(slot, context);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)modifyTemperatureTarget)) {
            return BFloat.make((float)((float)this.getTemperatureTarget().getValue()));
        }
        if (action.equals((Object)modifyTemperatureRange)) {
            return BFloat.make((float)((float)this.getTemperatureRange().getValue()));
        }
        return super.getActionParameterDefault(action);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BAk255Network bAk255Network = this.getNetwork();
        if (bAk255Network != null && (action.equals((Object)modifyTemperatureTarget) || action.equals((Object)modifyTemperatureRange) || action.equals((Object)manualDefrost))) {
            return bAk255Network.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doModifyTemperatureTarget(BFloat bFloat) {
        this.doModifyCircuit("temp_target", bFloat.toString());
    }

    public void doModifyTemperatureRange(BFloat bFloat) {
        this.doModifyCircuit("temp_range", bFloat.toString());
    }

    public void doModifyCircuit(String string, String string2) {
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                BAk255WriteSuctionCircuitRequest bAk255WriteSuctionCircuitRequest = new BAk255WriteSuctionCircuitRequest(bAk255Device, this, string, string2.toString());
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteSuctionCircuitRequest);
            }
            this.doPoll();
        }
    }

    public void doModifyDefrost(String string) {
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                BAk255WriteSuctionCircuitRequest bAk255WriteSuctionCircuitRequest = new BAk255WriteSuctionCircuitRequest(bAk255Device, this, "defrosts", string);
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteSuctionCircuitRequest);
            }
            this.doPoll();
        }
    }

    public void doManualDefrost(BManDefrostParameter bManDefrostParameter) {
        System.out.println("doManualDefrost with: " + (Object)((Object)bManDefrostParameter));
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                String string = bManDefrostParameter.toXmlString();
                BAk255WriteSuctionCircuitRequest bAk255WriteSuctionCircuitRequest = new BAk255WriteSuctionCircuitRequest(bAk255Device, this, string, "");
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteSuctionCircuitRequest);
            }
            this.doPoll();
        }
    }

    public void doPoll() {
        BAk255Network bAk255Network;
        BAk255ReadSuctionCircuitRequest bAk255ReadSuctionCircuitRequest = new BAk255ReadSuctionCircuitRequest(this);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadSuctionCircuitRequest);
        }
    }

    public void decodeXElem(XElem xElem) {
        this.decodeReplyError(xElem);
        this.setLastUpdate(BAbsTime.now());
        int n = xElem.geti("error", 0);
        if (n != 0) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(xElem.content(0).toString());
        } else {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        }
        XElem[] xElemArray = xElem.elems();
        int n2 = 0;
        while (n2 < xElemArray.length) {
            BUnit bUnit;
            BAk255SensorValue bAk255SensorValue;
            String string;
            int n3;
            if (xElemArray[n2].name().equals("name")) {
                this.setCircuitName(xElemArray[n2].content(0).toString());
            } else if (xElemArray[n2].name().equals("status")) {
                this.setCircuitStatus(xElemArray[n2].content(0).toString());
            } else if (xElemArray[n2].name().equals("values")) {
                int n4 = xElemArray[n2].geti("count", 0);
                this.setSensorCount(n4);
                if (n4 > 0) {
                    XElem[] xElemArray2 = xElemArray[n2].elems();
                    n3 = 0;
                    while (n3 < xElemArray2.length) {
                        if (xElemArray2[n3].name().equals("value")) {
                            string = "sensor" + (n3 + 1);
                            bAk255SensorValue = (BAk255SensorValue)this.get(string);
                            if (bAk255SensorValue == null) {
                                bAk255SensorValue = (BAk255SensorValue)this.get(this.add(string, (BValue)new BAk255SensorValue()));
                            }
                            bAk255SensorValue.setSensorName(xElemArray2[n3].get("name", ""));
                            bUnit = BUnitsTypeEnum.getNigaraUnit(xElemArray2[n3].get("units_index", "0"));
                            bAk255SensorValue.setValueUnits(bUnit);
                            double d = Double.parseDouble(xElemArray2[n3].text(0).toString());
                            bAk255SensorValue.setValue(new BStatusNumeric(d));
                            bAk255SensorValue.setSensorNumber(n3 + 1);
                        }
                        ++n3;
                    }
                }
            } else if (xElemArray[n2].name().equals("temp_target")) {
                this.getTemperatureTarget().setValue(Double.parseDouble(xElemArray[n2].text(0).toString()));
                this.setTargetUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n2].geti("units_index", 0)));
            } else if (xElemArray[n2].name().equals("temp_range")) {
                this.getTemperatureRange().setValue(Double.parseDouble(xElemArray[n2].text(0).toString()));
                this.setRangeUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n2].get("units_index", "0")));
            } else if (xElemArray[n2].name().equals("defrosts")) {
                this.getDefrost().decode(xElemArray[n2]);
            } else if (xElemArray[n2].name().equals("alarms")) {
                XElem[] xElemArray3 = xElemArray[n2].elems();
                int n5 = 0;
                while (n5 < xElemArray3.length) {
                    if (xElemArray3[n5].name().equals("alarm") && (n3 = xElemArray3[n5].geti("sensor_num", -1)) > 0) {
                        string = "sensor" + n3;
                        bAk255SensorValue = (BAk255SensorValue)this.get(string);
                        if (bAk255SensorValue == null) {
                            System.out.println("*** " + string + " not found");
                            break;
                        }
                        bUnit = xElemArray3[n5].elem("almhi_limit");
                        if (bUnit != null) {
                            bAk255SensorValue.getAlarmHiLimit().decodeLimit((XElem)bUnit);
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmHiLimit, false);
                        } else {
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmHiLimit, true);
                        }
                        bUnit = xElemArray3[n5].elem("almhi_dur");
                        if (bUnit != null) {
                            bAk255SensorValue.getAlarmHiLimit().decodeDuration((XElem)bUnit);
                        }
                        if ((bUnit = xElemArray3[n5].elem("almlo_limit")) != null) {
                            bAk255SensorValue.getAlarmLoLimit().decodeLimit((XElem)bUnit);
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmLoLimit, false);
                        } else {
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmLoLimit, true);
                        }
                        bUnit = xElemArray3[n5].elem("almlo_dur");
                        if (bUnit != null) {
                            bAk255SensorValue.getAlarmLoLimit().decodeDuration((XElem)bUnit);
                        }
                        if ((bUnit = xElemArray3[n5].elem("almhi_limit_dual")) != null) {
                            bAk255SensorValue.getAlarmHiLimit2().decodeLimit((XElem)bUnit);
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmHiLimit2, false);
                        } else {
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmHiLimit2, true);
                        }
                        bUnit = xElemArray3[n5].elem("almhi_dur_dual");
                        if (bUnit != null) {
                            bAk255SensorValue.getAlarmHiLimit2().decodeDuration((XElem)bUnit);
                        }
                        if ((bUnit = xElemArray3[n5].elem("almlo_limit_dual")) != null) {
                            bAk255SensorValue.getAlarmLoLimit2().decodeLimit((XElem)bUnit);
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmLoLimit2, false);
                        } else {
                            this.setHiddenFlag(bAk255SensorValue, BAk255SensorValue.alarmLoLimit2, true);
                        }
                        bUnit = xElemArray3[n5].elem("almlo_dur_dual");
                        if (bUnit != null) {
                            bAk255SensorValue.getAlarmLoLimit2().decodeDuration((XElem)bUnit);
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
    }

    private final void setHiddenFlag(BComponent bComponent, Property property, boolean bl) {
        int n = bComponent.getFlags((Slot)property);
        if (bl) {
            bComponent.setFlags((Slot)property, n | 4);
        } else {
            bComponent.setFlags((Slot)property, n & 0xFFFFFFFB);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAk255SuctionCircuit() {
    }

    public BAk255SuctionCircuit(int n) {
        this.setCircuitId(n);
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255SuctionCircuit;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255SuctionCircuit = BAk255SuctionCircuit.class("[Lcom.tridium.ak255.components.BAk255SuctionCircuit;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

