/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255WriteHvacSetbackScheduleRequest;
import com.tridium.ak255.comm.req.BAk255WriteLightingZoneRequest;
import com.tridium.ak255.comm.req.BAk255WriteRequest;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.components.BAk255HvacNightSetback;
import com.tridium.ak255.components.BAk255LightingZone;
import com.tridium.ak255.components.BHolidayBits;
import com.tridium.ak255.enums.BScheduleTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255ScheduleEntry
extends BComponent {
    public static BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)false), (String)"showTimeZone", (BIDataValue)BBoolean.make((boolean)false));
    public static BFacets REL_TIME_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)false), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)1439), (String)"min", (BIDataValue)BRelTime.makeMinutes((int)-1439));
    public static final Property scheduleIndex = BAk255ScheduleEntry.newProperty((int)5, (int)0, null);
    public static final Property scheduleType = BAk255ScheduleEntry.newProperty((int)1, (BValue)BScheduleTypeEnum.standard, null);
    public static final Property onTime = BAk255ScheduleEntry.newProperty((int)1, (BValue)BTime.make((int)0, (int)0, (int)0), (BFacets)TIME_FACETS);
    public static final Property offTime = BAk255ScheduleEntry.newProperty((int)1, (BValue)BTime.make((int)0, (int)0, (int)0), (BFacets)TIME_FACETS);
    public static final Property relOnTime = BAk255ScheduleEntry.newProperty((int)5, (BValue)BRelTime.make((long)0L), (BFacets)REL_TIME_FACETS);
    public static final Property relOffTime = BAk255ScheduleEntry.newProperty((int)5, (BValue)BRelTime.make((long)0L), (BFacets)REL_TIME_FACETS);
    public static final Property weekDays = BAk255ScheduleEntry.newProperty((int)1, (BValue)BDaysOfWeekBits.ALL, null);
    public static final Property holidays = BAk255ScheduleEntry.newProperty((int)1, (BValue)BHolidayBits.ALL, null);
    public static final Property isOrphan = BAk255ScheduleEntry.newProperty((int)6, (boolean)false, null);
    public static final Action modify = BAk255ScheduleEntry.newAction((int)16, (BValue)new BComponent(), null);
    public static final Type TYPE;
    int index;
    String strType;
    String strOnTime;
    String strOffTime;
    String strWeekdays;
    String strHolidays;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255ScheduleEntry;

    public int getScheduleIndex() {
        return this.getInt(scheduleIndex);
    }

    public void setScheduleIndex(int n) {
        this.setInt(scheduleIndex, n, null);
    }

    public BScheduleTypeEnum getScheduleType() {
        return (BScheduleTypeEnum)this.get(scheduleType);
    }

    public void setScheduleType(BScheduleTypeEnum bScheduleTypeEnum) {
        this.set(scheduleType, (BValue)bScheduleTypeEnum, null);
    }

    public BTime getOnTime() {
        return (BTime)this.get(onTime);
    }

    public void setOnTime(BTime bTime) {
        this.set(onTime, (BValue)bTime, null);
    }

    public BTime getOffTime() {
        return (BTime)this.get(offTime);
    }

    public void setOffTime(BTime bTime) {
        this.set(offTime, (BValue)bTime, null);
    }

    public BRelTime getRelOnTime() {
        return (BRelTime)this.get(relOnTime);
    }

    public void setRelOnTime(BRelTime bRelTime) {
        this.set(relOnTime, (BValue)bRelTime, null);
    }

    public BRelTime getRelOffTime() {
        return (BRelTime)this.get(relOffTime);
    }

    public void setRelOffTime(BRelTime bRelTime) {
        this.set(relOffTime, (BValue)bRelTime, null);
    }

    public BDaysOfWeekBits getWeekDays() {
        return (BDaysOfWeekBits)this.get(weekDays);
    }

    public void setWeekDays(BDaysOfWeekBits bDaysOfWeekBits) {
        this.set(weekDays, (BValue)bDaysOfWeekBits, null);
    }

    public BHolidayBits getHolidays() {
        return (BHolidayBits)this.get(holidays);
    }

    public void setHolidays(BHolidayBits bHolidayBits) {
        this.set(holidays, (BValue)bHolidayBits, null);
    }

    public boolean getIsOrphan() {
        return this.getBoolean(isOrphan);
    }

    public void setIsOrphan(boolean bl) {
        this.setBoolean(isOrphan, bl, null);
    }

    public void modify(BComponent bComponent) {
        this.invoke(modify, (BValue)bComponent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)modify)) {
            BAk255ScheduleEntry bAk255ScheduleEntry = (BAk255ScheduleEntry)this.newCopy();
            bAk255ScheduleEntry.setFlags((Slot)offTime, bAk255ScheduleEntry.getFlags((Slot)offTime) & 0xFFFFFFFE);
            bAk255ScheduleEntry.setFlags((Slot)onTime, bAk255ScheduleEntry.getFlags((Slot)onTime) & 0xFFFFFFFE);
            bAk255ScheduleEntry.setFlags((Slot)relOnTime, bAk255ScheduleEntry.getFlags((Slot)relOnTime) & 0xFFFFFFFE);
            bAk255ScheduleEntry.setFlags((Slot)relOffTime, bAk255ScheduleEntry.getFlags((Slot)relOffTime) & 0xFFFFFFFE);
            bAk255ScheduleEntry.setFlags((Slot)weekDays, bAk255ScheduleEntry.getFlags((Slot)weekDays) & 0xFFFFFFFE);
            bAk255ScheduleEntry.setFlags((Slot)holidays, bAk255ScheduleEntry.getFlags((Slot)holidays) & 0xFFFFFFFE);
            return bAk255ScheduleEntry;
        }
        return super.getActionParameterDefault(action);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BAk255Network bAk255Network;
        BAk255Device bAk255Device;
        if (action.equals((Object)modify) && (bAk255Device = this.getDevice()) != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            return bAk255Network.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public BAk255Device getDevice() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BAk255Device) {
                return (BAk255Device)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void doModify(BComponent bComponent) {
        System.out.println("doModify with: " + bComponent);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            BAk255WriteRequest bAk255WriteRequest = null;
            if (this.getParent() instanceof BAk255HvacNightSetback) {
                bAk255WriteRequest = new BAk255WriteHvacSetbackScheduleRequest(bAk255Device, this, (BAk255ScheduleEntry)bComponent);
            } else if (this.getParent() instanceof BAk255LightingZone) {
                bAk255WriteRequest = new BAk255WriteLightingZoneRequest(bAk255Device, (BAk255LightingZone)this.getParent(), (BAk255ScheduleEntry)bComponent, false);
            }
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteRequest);
            }
        }
    }

    public static String getSetbackOnString(BAk255ScheduleEntry bAk255ScheduleEntry) {
        if (bAk255ScheduleEntry.getScheduleType().getOrdinal() == 0) {
            return Integer.toString(BAk255ScheduleEntry.getBcdTime(bAk255ScheduleEntry.getOnTime()));
        }
        return Integer.toString(BAk255ScheduleEntry.getBcdRelTime(bAk255ScheduleEntry.getRelOnTime()));
    }

    public static String getSetbackOffString(BAk255ScheduleEntry bAk255ScheduleEntry) {
        if (bAk255ScheduleEntry.getScheduleType().getOrdinal() == 0) {
            return Integer.toString(BAk255ScheduleEntry.getBcdTime(bAk255ScheduleEntry.getOffTime()));
        }
        return Integer.toString(BAk255ScheduleEntry.getBcdRelTime(bAk255ScheduleEntry.getRelOffTime()));
    }

    public static String getSetbackWeekdayString(BAk255ScheduleEntry bAk255ScheduleEntry) {
        return ParseUtil.encodeDaysOfWeek(bAk255ScheduleEntry.getWeekDays());
    }

    public static String getSetbackHolidayString(BAk255ScheduleEntry bAk255ScheduleEntry) {
        return ParseUtil.encodeHolidays(bAk255ScheduleEntry.getHolidays());
    }

    private static final int getBcdRelTime(BRelTime bRelTime) {
        int n = bRelTime.getMinutes();
        int n2 = n / 60;
        int n3 = n2 * 100;
        return n3 += (n -= n2 * 60);
    }

    private static final int getBcdTime(BTime bTime) {
        int n = bTime.getMinute();
        int n2 = bTime.getHour();
        int n3 = n2 * 100;
        return n3 += n;
    }

    public void decodeXElem(XElem[] xElemArray) {
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].text(0).toString();
            String string2 = xElemArray[n].name();
            if (string2.equals("type")) {
                this.strType = string;
            } else if (string2.equals("on_time")) {
                this.strOnTime = string;
            } else if (string2.equals("off_time")) {
                this.strOffTime = string;
            } else if (string2.equals("weekdays")) {
                this.strWeekdays = string;
            } else if (string2.equals("holidays")) {
                this.strHolidays = string;
            }
            ++n;
        }
        this.updateProperties();
    }

    public void parseLightingSchedule(XElem xElem) {
        this.index = xElem.geti("index", 0);
        this.strType = xElem.get("type", "Standard");
        this.strOnTime = ParseUtil.getStringElemValue(xElem, "on", "12:00AM");
        this.strOffTime = ParseUtil.getStringElemValue(xElem, "off", "12:00AM");
        this.strWeekdays = ParseUtil.getStringElemValue(xElem, "days", "       ");
        this.strHolidays = ParseUtil.getStringElemValue(xElem, "holidays", "        ");
        this.updateProperties();
    }

    public void parseSetbackSchedule(XElem xElem) {
        this.index = xElem.geti("index", 0);
        this.strType = xElem.get("type", "Standard");
        this.strOnTime = xElem.get("start", "12:00AM");
        this.strOffTime = xElem.get("stop", "12:00AM");
        this.strWeekdays = xElem.get("days", "       ");
        this.strHolidays = xElem.get("holidays", "        ");
        this.updateProperties();
    }

    public void updatePropertyFlags() {
        if (this.getScheduleType().getOrdinal() == 0) {
            this.setFlags((Slot)relOnTime, this.getFlags((Slot)relOnTime) | 4);
            this.setFlags((Slot)relOffTime, this.getFlags((Slot)relOffTime) | 4);
            this.setFlags((Slot)onTime, this.getFlags((Slot)onTime) & 0xFFFFFFFB);
            this.setFlags((Slot)offTime, this.getFlags((Slot)offTime) & 0xFFFFFFFB);
        } else {
            this.setFlags((Slot)onTime, this.getFlags((Slot)onTime) | 4);
            this.setFlags((Slot)offTime, this.getFlags((Slot)offTime) | 4);
            this.setFlags((Slot)relOnTime, this.getFlags((Slot)relOnTime) & 0xFFFFFFFB);
            this.setFlags((Slot)relOffTime, this.getFlags((Slot)relOffTime) & 0xFFFFFFFB);
        }
    }

    private final void updateProperties() {
        this.setScheduleIndex(this.index);
        this.setScheduleType(BScheduleTypeEnum.make(this.strType.toLowerCase()));
        this.setWeekDays(ParseUtil.parseDaysOfWeek(this.strWeekdays));
        this.setHolidays(ParseUtil.parseHolidayBits(this.strHolidays));
        if (this.getScheduleType().getOrdinal() == 0) {
            this.setFlags((Slot)relOnTime, this.getFlags((Slot)relOnTime) | 4);
            this.setFlags((Slot)relOffTime, this.getFlags((Slot)relOffTime) | 4);
            this.setFlags((Slot)onTime, this.getFlags((Slot)onTime) & 0xFFFFFFFB);
            this.setFlags((Slot)offTime, this.getFlags((Slot)offTime) & 0xFFFFFFFB);
            this.setOnTime(ParseUtil.parseTime(this.strOnTime));
            this.setOffTime(ParseUtil.parseTime(this.strOffTime));
            this.setRelOnTime(BRelTime.make((long)0L));
            this.setRelOffTime(BRelTime.make((long)0L));
        } else {
            this.setFlags((Slot)onTime, this.getFlags((Slot)onTime) | 4);
            this.setFlags((Slot)offTime, this.getFlags((Slot)offTime) | 4);
            this.setFlags((Slot)relOnTime, this.getFlags((Slot)relOnTime) & 0xFFFFFFFB);
            this.setFlags((Slot)relOffTime, this.getFlags((Slot)relOffTime) & 0xFFFFFFFB);
            this.setRelOnTime(ParseUtil.parseRelTime(this.strOnTime));
            this.setRelOffTime(ParseUtil.parseRelTime(this.strOffTime));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.index = 0;
        this.strType = "";
        this.strOnTime = "";
        this.strOffTime = "";
        this.strWeekdays = "";
        this.strHolidays = "";
    }

    public BAk255ScheduleEntry() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255ScheduleEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255ScheduleEntry = BAk255ScheduleEntry.class("[Lcom.tridium.ak255.components.BAk255ScheduleEntry;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

