/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadHvacUnitRequest;
import com.tridium.ak255.components.BAk255DehumidStages;
import com.tridium.ak255.components.BAk255HvacStage;
import com.tridium.ak255.components.BStatusComponent;
import com.tridium.ak255.components.BStatusPollableComponent;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255HvacUnit
extends BStatusPollableComponent {
    public static final Property unitIndex = BAk255HvacUnit.newProperty((int)1, (int)0, null);
    public static final Property unitName = BAk255HvacUnit.newProperty((int)1, (String)"", null);
    public static final Property currentStatus = BAk255HvacUnit.newProperty((int)1, (String)"", null);
    public static final Property currentValue = BAk255HvacUnit.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property valueUnits = BAk255HvacUnit.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property coolingStages = BAk255HvacUnit.newProperty((int)0, (BValue)new BStatusComponent(), null);
    public static final Property heatingStages = BAk255HvacUnit.newProperty((int)0, (BValue)new BStatusComponent(), null);
    public static final Property heatReclaims = BAk255HvacUnit.newProperty((int)0, (BValue)new BStatusComponent(), null);
    public static final Type TYPE;
    public static final String COOLING_STAGES = "cooling_stages";
    public static final String AUX_HEATS = "aux_heats";
    public static final String HEAT_RECLAIMS = "heat_reclaims";
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255HvacUnit;

    public int getUnitIndex() {
        return this.getInt(unitIndex);
    }

    public void setUnitIndex(int n) {
        this.setInt(unitIndex, n, null);
    }

    public String getUnitName() {
        return this.getString(unitName);
    }

    public void setUnitName(String string) {
        this.setString(unitName, string, null);
    }

    public String getCurrentStatus() {
        return this.getString(currentStatus);
    }

    public void setCurrentStatus(String string) {
        this.setString(currentStatus, string, null);
    }

    public BStatusNumeric getCurrentValue() {
        return (BStatusNumeric)this.get(currentValue);
    }

    public void setCurrentValue(BStatusNumeric bStatusNumeric) {
        this.set(currentValue, (BValue)bStatusNumeric, null);
    }

    public BUnit getValueUnits() {
        return (BUnit)this.get(valueUnits);
    }

    public void setValueUnits(BUnit bUnit) {
        this.set(valueUnits, (BValue)bUnit, null);
    }

    public BStatusComponent getCoolingStages() {
        return (BStatusComponent)this.get(coolingStages);
    }

    public void setCoolingStages(BStatusComponent bStatusComponent) {
        this.set(coolingStages, (BValue)bStatusComponent, null);
    }

    public BStatusComponent getHeatingStages() {
        return (BStatusComponent)this.get(heatingStages);
    }

    public void setHeatingStages(BStatusComponent bStatusComponent) {
        this.set(heatingStages, (BValue)bStatusComponent, null);
    }

    public BStatusComponent getHeatReclaims() {
        return (BStatusComponent)this.get(heatReclaims);
    }

    public void setHeatReclaims(BStatusComponent bStatusComponent) {
        this.set(heatReclaims, (BValue)bStatusComponent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)currentValue)) {
            return BFacets.makeNumeric((BUnit)this.getValueUnits(), (int)2);
        }
        return super.getSlotFacets(slot);
    }

    public void doPoll() {
        BAk255Network bAk255Network;
        BAk255ReadHvacUnitRequest bAk255ReadHvacUnitRequest = new BAk255ReadHvacUnitRequest(this);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadHvacUnitRequest);
        }
    }

    public BAk255Device getDevice() {
        return (BAk255Device)this.getParent().getParent();
    }

    public void decodeXElem(XElem xElem) {
        this.decodeReplyError(xElem);
        this.setLastUpdate(BAbsTime.now());
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("name")) {
                this.setUnitName(xElemArray[n].content(0).toString());
            } else if (xElemArray[n].name().equals("status")) {
                this.setCurrentStatus(xElemArray[n].content(0).toString());
            } else if (xElemArray[n].name().equals("value")) {
                this.getCurrentValue().setValue(Double.parseDouble(xElemArray[n].text(0).toString()));
                this.setValueUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("units")) {
                if (this.getValueUnits().equivalent((Object)BUnit.NULL)) {
                    if (xElemArray[n].content(0).toString().equals("-F")) {
                        this.setValueUnits(BUnitsTypeEnum.getNigaraUnit(3));
                    } else {
                        this.setValueUnits(BUnitsTypeEnum.getNigaraUnit(4));
                    }
                }
            } else if (xElemArray[n].name().equals(COOLING_STAGES)) {
                BAk255HvacStage.parseStages(this.getCoolingStages(), xElemArray[n], "coolingStage");
            } else if (xElemArray[n].name().equals(AUX_HEATS)) {
                BAk255HvacStage.parseStages(this.getHeatingStages(), xElemArray[n], "auxHeat");
            } else if (xElemArray[n].name().equals(HEAT_RECLAIMS)) {
                BAk255HvacStage.parseStages(this.getHeatReclaims(), xElemArray[n], "heatReclaim");
            } else if (xElemArray[n].name().equals("dehumid_type")) {
                BAk255DehumidStages.parseData(this, xElemArray[n]);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAk255HvacUnit() {
    }

    public BAk255HvacUnit(int n) {
        this.setUnitIndex(n);
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255HvacUnit;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255HvacUnit = BAk255HvacUnit.class("[Lcom.tridium.ak255.components.BAk255HvacUnit;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

