/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.components;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadCondenserRequest;
import com.tridium.ak255.comm.req.BAk255WriteCondenserRequest;
import com.tridium.ak255.components.BAk255AlarmLimit;
import com.tridium.ak255.components.BAk255CondenserStages;
import com.tridium.ak255.components.BAk255SubDevice;
import com.tridium.ak255.components.BIAlarmLimitParent;
import com.tridium.ak255.components.BStatusComponent;
import com.tridium.ak255.components.BStatusPollableComponent;
import com.tridium.ak255.enums.BCondenserAlmActionEnum;
import com.tridium.ak255.enums.BCondenserAlmDurEnum;
import com.tridium.ak255.enums.BCondenserControlMethodEnum;
import com.tridium.ak255.enums.BCondenserControlSensorTypeEnum;
import com.tridium.ak255.enums.BCondenserControlTypeEnum;
import com.tridium.ak255.enums.BCondenserFansTypeEnum;
import com.tridium.ak255.enums.BCondenserTypeEnum;
import com.tridium.ak255.enums.BUnitsTypeEnum;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255Condenser
extends BStatusPollableComponent
implements BIAlarmLimitParent {
    public static final Property writeStatus = BAk255Condenser.newProperty((int)3, (String)"", null);
    public static final Property rackId = BAk255Condenser.newProperty((int)1, (int)0, null);
    public static final Property condenserName = BAk255Condenser.newProperty((int)1, (String)"", null);
    public static final Property value = BAk255Condenser.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property valueUnits = BAk255Condenser.newProperty((int)5, (BValue)BUnit.NULL, null);
    public static final Property condenserType = BAk255Condenser.newProperty((int)1, (BValue)BCondenserTypeEnum.none, null);
    public static final Property fanType = BAk255Condenser.newProperty((int)1, (BValue)BCondenserFansTypeEnum.singleFan, null);
    public static final Property numFans = BAk255Condenser.newProperty((int)1, (int)0, null);
    public static final Property controlSensor = BAk255Condenser.newProperty((int)1, (BValue)BCondenserControlSensorTypeEnum.droplegTemp, null);
    public static final Property controlType = BAk255Condenser.newProperty((int)1, (BValue)BCondenserControlTypeEnum.neutralZone, null);
    public static final Property controlMethod = BAk255Condenser.newProperty((int)1, (BValue)BCondenserControlMethodEnum.cutInOut, null);
    public static final Property alarmHiLimit = BAk255Condenser.newProperty((int)1, (BValue)new BAk255AlarmLimit(), null);
    public static final Property alarmLoLimit = BAk255Condenser.newProperty((int)1, (BValue)new BAk255AlarmLimit(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255Condenser;

    public String getWriteStatus() {
        return this.getString(writeStatus);
    }

    public void setWriteStatus(String string) {
        this.setString(writeStatus, string, null);
    }

    public int getRackId() {
        return this.getInt(rackId);
    }

    public void setRackId(int n) {
        this.setInt(rackId, n, null);
    }

    public String getCondenserName() {
        return this.getString(condenserName);
    }

    public void setCondenserName(String string) {
        this.setString(condenserName, string, null);
    }

    public BStatusNumeric getValue() {
        return (BStatusNumeric)this.get(value);
    }

    public void setValue(BStatusNumeric bStatusNumeric) {
        this.set(value, (BValue)bStatusNumeric, null);
    }

    public BUnit getValueUnits() {
        return (BUnit)this.get(valueUnits);
    }

    public void setValueUnits(BUnit bUnit) {
        this.set(valueUnits, (BValue)bUnit, null);
    }

    public BCondenserTypeEnum getCondenserType() {
        return (BCondenserTypeEnum)this.get(condenserType);
    }

    public void setCondenserType(BCondenserTypeEnum bCondenserTypeEnum) {
        this.set(condenserType, (BValue)bCondenserTypeEnum, null);
    }

    public BCondenserFansTypeEnum getFanType() {
        return (BCondenserFansTypeEnum)this.get(fanType);
    }

    public void setFanType(BCondenserFansTypeEnum bCondenserFansTypeEnum) {
        this.set(fanType, (BValue)bCondenserFansTypeEnum, null);
    }

    public int getNumFans() {
        return this.getInt(numFans);
    }

    public void setNumFans(int n) {
        this.setInt(numFans, n, null);
    }

    public BCondenserControlSensorTypeEnum getControlSensor() {
        return (BCondenserControlSensorTypeEnum)this.get(controlSensor);
    }

    public void setControlSensor(BCondenserControlSensorTypeEnum bCondenserControlSensorTypeEnum) {
        this.set(controlSensor, (BValue)bCondenserControlSensorTypeEnum, null);
    }

    public BCondenserControlTypeEnum getControlType() {
        return (BCondenserControlTypeEnum)this.get(controlType);
    }

    public void setControlType(BCondenserControlTypeEnum bCondenserControlTypeEnum) {
        this.set(controlType, (BValue)bCondenserControlTypeEnum, null);
    }

    public BCondenserControlMethodEnum getControlMethod() {
        return (BCondenserControlMethodEnum)this.get(controlMethod);
    }

    public void setControlMethod(BCondenserControlMethodEnum bCondenserControlMethodEnum) {
        this.set(controlMethod, (BValue)bCondenserControlMethodEnum, null);
    }

    public BAk255AlarmLimit getAlarmHiLimit() {
        return (BAk255AlarmLimit)this.get(alarmHiLimit);
    }

    public void setAlarmHiLimit(BAk255AlarmLimit bAk255AlarmLimit) {
        this.set(alarmHiLimit, (BValue)bAk255AlarmLimit, null);
    }

    public BAk255AlarmLimit getAlarmLoLimit() {
        return (BAk255AlarmLimit)this.get(alarmLoLimit);
    }

    public void setAlarmLoLimit(BAk255AlarmLimit bAk255AlarmLimit) {
        this.set(alarmLoLimit, (BValue)bAk255AlarmLimit, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)value)) {
            return BFacets.makeNumeric((BUnit)this.getValueUnits(), (int)2);
        }
        return super.getSlotFacets(slot);
    }

    public void doModifyAlarmLimit(Slot slot, Action action, BValue bValue) {
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null) {
            String string = null;
            if (slot.equals((Object)alarmHiLimit)) {
                if (action.equals((Object)BAk255AlarmLimit.modifyLimit)) {
                    string = "almhi_limit";
                } else if (action.equals((Object)BAk255AlarmLimit.modifyDuration)) {
                    string = "almhi_dur";
                }
            } else if (slot.equals((Object)alarmLoLimit)) {
                if (action.equals((Object)BAk255AlarmLimit.modifyLimit)) {
                    string = "almlo_limit";
                } else if (action.equals((Object)BAk255AlarmLimit.modifyDuration)) {
                    string = "almlo_dur";
                }
            }
            BAk255Network bAk255Network = (BAk255Network)bAk255Device.getNetwork();
            if (bAk255Network != null) {
                BAk255WriteCondenserRequest bAk255WriteCondenserRequest = new BAk255WriteCondenserRequest(bAk255Device, this, string, bValue);
                DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255WriteCondenserRequest);
            }
            this.doPoll();
        }
    }

    public void doPoll() {
        BAk255Network bAk255Network;
        this.setRackId(((BAk255SubDevice)this.getParent()).getRackId());
        BAk255ReadCondenserRequest bAk255ReadCondenserRequest = new BAk255ReadCondenserRequest(this);
        BAk255Device bAk255Device = this.getDevice();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadCondenserRequest);
        }
    }

    public void decodeXElem(XElem xElem) {
        this.decodeReplyError(xElem);
        this.setLastUpdate(BAbsTime.now());
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            if (xElemArray[n].name().equals("name")) {
                this.setCondenserName(xElemArray[n].content(0).toString());
            } else if (xElemArray[n].name().equals("value")) {
                this.getValue().setValue(Double.parseDouble(xElemArray[n].text(0).toString()));
                this.setValueUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("cond_type")) {
                this.setCondenserType(BCondenserTypeEnum.make(xElemArray[n].geti("index", 0)));
            } else if (xElemArray[n].name().equals("fans")) {
                this.setFanType(BCondenserFansTypeEnum.make(xElemArray[n].geti("index", 0)));
                this.setNumFans(xElemArray[n].geti("numFans", 1));
            } else if (xElemArray[n].name().equals("control_sensor")) {
                this.setControlSensor(BCondenserControlSensorTypeEnum.make(xElemArray[n].geti("index", 0)));
            } else if (xElemArray[n].name().equals("control_type")) {
                this.setControlType(BCondenserControlTypeEnum.make(xElemArray[n].geti("index", 1)));
            } else if (xElemArray[n].name().equals("control_method")) {
                this.setControlMethod(BCondenserControlMethodEnum.make(xElemArray[n].geti("type_index", 1)));
                if (this.getControlMethod().getOrdinal() == 1) {
                    XElem[] xElemArray2 = xElemArray[n].elems();
                    int n2 = 0;
                    while (n2 < xElemArray2.length) {
                        if (xElemArray2[n2].name().equals("stage_cutin")) {
                            this.updateCutInOut(xElemArray2[n2], "CutinStages");
                        }
                        if (xElemArray2[n2].name().equals("stage_cutout")) {
                            this.updateCutInOut(xElemArray2[n2], "CutoutStages");
                        }
                        ++n2;
                    }
                }
            } else if (xElemArray[n].name().equals("almhi_limit")) {
                this.getAlarmHiLimit().setAction(BCondenserAlmActionEnum.make(xElemArray[n].geti("action_index", 1)));
                this.getAlarmHiLimit().setRoutingAction(xElemArray[n].geti("routingAction", 0));
                this.getAlarmHiLimit().setValue(Float.parseFloat(xElemArray[n].text(0).toString()));
                this.getAlarmHiLimit().setUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almhi_dur")) {
                this.getAlarmHiLimit().setDuration(Integer.parseInt(xElemArray[n].text(0).toString()));
                this.getAlarmHiLimit().setDurationUnits(BCondenserAlmDurEnum.make(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almlo_limit")) {
                this.getAlarmLoLimit().setAction(BCondenserAlmActionEnum.make(xElemArray[n].geti("action_index", 1)));
                this.getAlarmLoLimit().setRoutingAction(xElemArray[n].geti("routingAction", 0));
                this.getAlarmLoLimit().setValue(Float.parseFloat(xElemArray[n].text(0).toString()));
                this.getAlarmLoLimit().setUnits(BUnitsTypeEnum.getNigaraUnit(xElemArray[n].geti("units_index", 0)));
            } else if (xElemArray[n].name().equals("almlo_dur")) {
                this.getAlarmLoLimit().setDuration(Integer.parseInt(xElemArray[n].text(0).toString()));
                this.getAlarmLoLimit().setDurationUnits(BCondenserAlmDurEnum.make(xElemArray[n].geti("units_index", 0)));
            }
            ++n;
        }
    }

    private final void updateCutInOut(XElem xElem, String string) {
        Property property;
        BAk255CondenserStages bAk255CondenserStages = null;
        try {
            bAk255CondenserStages = (BAk255CondenserStages)this.get(string);
        }
        catch (Exception exception) {}
        if (bAk255CondenserStages == null) {
            property = this.add(string, (BValue)new BAk255CondenserStages());
            bAk255CondenserStages = (BAk255CondenserStages)this.get(property);
        }
        property = xElem.elems();
        int n = 0;
        while (n < ((Property)property).length) {
            if (property[n].name().equals("stage")) {
                this.updateStage(bAk255CondenserStages, (XElem)property[n]);
            }
            ++n;
        }
    }

    private final void updateStage(BStatusComponent bStatusComponent, XElem xElem) {
        double d = Double.parseDouble(xElem.text(0).toString());
        BUnit bUnit = BUnitsTypeEnum.getNigaraUnit(xElem.geti("units_index", 0));
        int n = xElem.geti("num", 0);
        BStatusNumeric bStatusNumeric = null;
        try {
            bStatusNumeric = (BStatusNumeric)bStatusComponent.get("stage" + n);
        }
        catch (Exception exception) {}
        if (bStatusNumeric == null) {
            Property property = bStatusComponent.add("stage" + n, (BValue)new BStatusNumeric(d), 1, BFacets.makeNumeric((BUnit)bUnit, (int)1), null);
            bStatusNumeric = (BStatusNumeric)this.get(property);
        } else {
            bStatusNumeric.setValue(d);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAk255Condenser() {
    }

    public BAk255Condenser(int n) {
        this.setRackId(n);
    }

    static {
        Class clazz = class$com$tridium$ak255$components$BAk255Condenser;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255Condenser = BAk255Condenser.class("[Lcom.tridium.ak255.components.BAk255Condenser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

