/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.comm;

import com.tridium.ak255.comm.BAk255AlarmService;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import javax.baja.sys.BString;
import javax.baja.util.ByteArrayUtil;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ak255TcpIpSession {
    private BAk255AlarmService almService;
    private boolean done;
    public Socket socket;
    private InputStream inStream;
    private OutputStream outStream;
    private ReceiveDriver rcvDriver;
    private Thread rcvThread;
    private int sessionId;

    public boolean start() {
        try {
            this.socket.setSoTimeout(this.almService.getSocketTimeoutInMillis());
            this.inStream = this.socket.getInputStream();
            this.outStream = this.socket.getOutputStream();
            this.done = false;
        }
        catch (Exception exception) {
            this.done = true;
            String string = "HillRom Unable to get Socket input or output stream to client ";
            this.almService.getLog().error(string, (Throwable)exception);
            throw new RuntimeException(string);
        }
        this.rcvDriver = new ReceiveDriver(this);
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "ModTcpSlave:RcvSess");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        return true;
    }

    public synchronized void stop() {
        try {
            this.done = true;
            if (this.rcvDriver != null) {
                this.rcvThread.interrupt();
            }
            this.rcvDriver = null;
        }
        catch (Exception exception) {
            this.almService.getLog().error("Ak255TcpIpSession.stop() rcvThread.interrupt() caught exception", (Throwable)exception);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        this.inStream = null;
        this.outStream = null;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public synchronized void sendMessage(String string) {
        try {
            this.almService.getLog().trace(string);
            this.output(string);
        }
        catch (Exception exception) {
            this.almService.getLog().error("Ak255TcpIpSession.sendMessage() caught exception ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void output(String string) {
        StringBuffer stringBuffer = new StringBuffer("Ak255TcpIpSession.output(); outStream==nul = ");
        boolean bl = false;
        if (this.outStream == null) {
            bl = true;
        }
        System.out.println(stringBuffer.append(bl).toString());
        if (this.outStream == null) {
            return;
        }
        OutputStream outputStream = this.outStream;
        synchronized (outputStream) {
            try {
                this.almService.getLog().trace("msg  sent: " + string);
                this.outStream.write(string.getBytes());
                this.outStream.flush();
            }
            catch (Exception exception) {
                this.almService.getLog().error("Exception in Ak255TcpIpSession", (Throwable)exception);
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.done = true;
        this.sessionId = -1;
    }

    public Ak255TcpIpSession(Socket socket, BAk255AlarmService bAk255AlarmService) {
        this.this();
        this.socket = socket;
        this.almService = bAk255AlarmService;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReceiveDriver
    implements Runnable {
        Ak255TcpIpSession tcpSession;

        public void run() {
            XParser xParser = null;
            XElem xElem = null;
            while (!Ak255TcpIpSession.this.done) {
                block9: {
                    try {
                        String string;
                        xParser = XParser.make((InputStream)Ak255TcpIpSession.this.inStream);
                        xElem = xParser.parse(false);
                        if (!xElem.name().equals("alarm")) break block9;
                        Ak255TcpIpSession.this.almService.getLog().trace("alarm received");
                        XElem[] xElemArray = xElem.elems();
                        HashMap<String, BString> hashMap = new HashMap<String, BString>();
                        int n = 0;
                        while (n < xElemArray.length) {
                            string = null;
                            try {
                                string = xElemArray[n].content(0).toString();
                            }
                            catch (Exception exception) {}
                            if (string != null) {
                                hashMap.put(xElemArray[n].name(), BString.make((String)string));
                            }
                            ++n;
                        }
                        System.out.println(hashMap);
                        Ak255TcpIpSession.this.almService.getAlarmSourceInfo().addAlarm(hashMap);
                        BString bString = (BString)hashMap.get("ref");
                        string = "<ack ref=\"" + bString.getString() + "\"/>";
                        Ak255TcpIpSession.this.almService.getLog().trace("ackMsg = " + string);
                        Ak255TcpIpSession.this.output(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        try {
                            Ak255TcpIpSession.this.socket.close();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        Ak255TcpIpSession.this.almService.getServer().closeConnection(Ak255TcpIpSession.this.sessionId);
                        break;
                    }
                }
                if (xElem != null) continue;
            }
        }

        private final void messageComplete(byte[] byArray, int n) {
            if (Ak255TcpIpSession.this.almService.getLog().isTraceOn()) {
                System.out.println("**** HillRom Received Bytes: ****");
                ByteArrayUtil.hexDump((byte[])byArray);
                System.out.println("****************************************");
            }
        }

        private final /* synthetic */ void this() {
            this.tcpSession = null;
        }

        ReceiveDriver(Ak255TcpIpSession ak255TcpIpSession2) {
            this.this();
            this.tcpSession = ak255TcpIpSession2;
        }
    }
}

