/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255.comm;

import com.tridium.ak255.comm.Ak255TcpIpSession;
import com.tridium.ak255.comm.BAk255AlarmService;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ak255TcpIpServer
implements Runnable {
    private int port;
    private boolean isAlive;
    private Thread thread;
    private ServerSocket serverSocket;
    private BAk255AlarmService host;
    private Ak255TcpIpSession[] sessions;

    public void start() {
        System.out.println("Ak255TcpIpServer.start()");
        this.host.setCurrentConnections(0);
        if (this.thread != null) {
            throw new IllegalStateException("Server already running");
        }
        this.port = this.host.getAlarmTcpIpPort();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "Ak255:AlrmServer");
        this.thread.start();
    }

    public void stop() {
        this.host.setCurrentConnections(0);
        if (this.thread == null) {
            return;
        }
        this.isAlive = false;
        this.thread.interrupt();
        this.stopSessions();
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
        this.thread = null;
        this.serverSocket = null;
    }

    public void run() {
        this.openPort();
        this.acceptSessions();
    }

    private final void openPort() {
        while (this.isAlive) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.getLog().trace("new serverSocket on port: " + this.port);
                return;
            }
            catch (IOException iOException) {
                this.getLog().error("Cannot open server port [" + this.port + "] ", (Throwable)iOException);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private final void acceptSessions() {
        while (this.isAlive) {
            try {
                if (this.getNumberSessions() < this.sessions.length) {
                    this.getLog().trace("waiting for socket connection......");
                    Socket socket = this.serverSocket.accept();
                    this.getLog().trace("HillRomTcpServer acceptSession with: " + socket);
                    Ak255TcpIpSession ak255TcpIpSession = new Ak255TcpIpSession(socket, this.host);
                    int n = this.addSession(ak255TcpIpSession, socket);
                    if (n < 0) {
                        this.getLog().error("*** ModbusTcpServer.addSession() returned -1 for some reason.  Should never get here!!!!");
                        continue;
                    }
                    ak255TcpIpSession.setSessionId(n);
                    ak255TcpIpSession.start();
                    this.host.setCurrentConnections(this.getNumberSessions());
                    continue;
                }
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                if (!this.isAlive) continue;
                throwable.printStackTrace();
            }
        }
    }

    public void closeConnection(int n) {
        this.getLog().trace("closeConnection with sessionId: " + n);
        this.removeSession(n);
        this.host.setCurrentConnections(this.getNumberSessions());
    }

    private final int addSession(Ak255TcpIpSession ak255TcpIpSession, Socket socket) {
        this.getLog().trace("ModbusTcpServer.addSession with: " + socket);
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] == null) {
                this.getLog().trace("    found slot at: " + n);
                this.sessions[n] = ak255TcpIpSession;
                return n;
            }
            ++n;
        }
        return -1;
    }

    private final void removeSession(int n) {
        this.sessions[n] = null;
    }

    private final int getNumberSessions() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.sessions.length) {
            if (this.sessions[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private final void stopSessions() {
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] != null) {
                this.sessions[n].stop();
                this.sessions[n] = null;
            }
            ++n;
        }
    }

    public void tcpServerDump() {
        System.out.println(" tcpSessions:");
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] != null) {
                System.out.println("   " + this.sessions[n].socket);
            }
            ++n;
        }
        System.out.println("***** Node.dump()end *****");
    }

    public void removeOldSessions(int n) {
        Ak255TcpIpSession[] ak255TcpIpSessionArray = new Ak255TcpIpSession[n];
        int n2 = 0;
        while (n2 < this.sessions.length) {
            if (this.sessions[n2] != null) {
                if (n2 < ak255TcpIpSessionArray.length) {
                    ak255TcpIpSessionArray[n2] = this.sessions[n2];
                } else {
                    this.sessions[n2].stop();
                    this.sessions[n2] = null;
                }
            }
            ++n2;
        }
        this.sessions = ak255TcpIpSessionArray;
    }

    public boolean isStarted() {
        return this.isAlive;
    }

    public void sendMessage(String string) {
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] != null) {
                this.sessions[n].sendMessage(string);
                return;
            }
            ++n;
        }
        System.out.println("****** session not found !!!!!!!!!!");
    }

    public Log getLog() {
        return this.host.getLog();
    }

    private final /* synthetic */ void this() {
        this.isAlive = false;
    }

    public Ak255TcpIpServer(BAk255AlarmService bAk255AlarmService) {
        this.this();
        this.host = bAk255AlarmService;
        this.sessions = new Ak255TcpIpSession[bAk255AlarmService.getMaxConnections()];
    }
}

