/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ak255;

import com.tridium.ak255.BAk255Device;
import com.tridium.ak255.BAk255Network;
import com.tridium.ak255.comm.req.BAk255ReadAlarmDetailRequest;
import com.tridium.ak255.comm.req.BAk255ReadAlarmSummaryRequest;
import com.tridium.ak255.comm.rsp.ParseUtil;
import com.tridium.ak255.components.BAk255AlarmDetail;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import javax.baja.driver.BDeviceExt;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAk255AlarmDeviceExt
extends BDeviceExt {
    public static final Property readInProcess = BAk255AlarmDeviceExt.newProperty((int)6, (boolean)false, null);
    public static final Property showAcked = BAk255AlarmDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property showCleared = BAk255AlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action readAlarms = BAk255AlarmDeviceExt.newAction((int)16, null);
    public static final Type TYPE;
    public static Log alarmLog;
    private static final BIcon icon;
    private long[] activeRefs;
    private long[] ackedRefs;
    private long[] clearedRefs;
    private boolean alreadyHasAlarms;
    static /* synthetic */ Class class$com$tridium$ak255$BAk255AlarmDeviceExt;
    static /* synthetic */ Class class$com$tridium$ak255$components$BAk255AlarmDetail;

    public boolean getReadInProcess() {
        return this.getBoolean(readInProcess);
    }

    public void setReadInProcess(boolean bl) {
        this.setBoolean(readInProcess, bl, null);
    }

    public boolean getShowAcked() {
        return this.getBoolean(showAcked);
    }

    public void setShowAcked(boolean bl) {
        this.setBoolean(showAcked, bl, null);
    }

    public boolean getShowCleared() {
        return this.getBoolean(showCleared);
    }

    public void setShowCleared(boolean bl) {
        this.setBoolean(showCleared, bl, null);
    }

    public void readAlarms() {
        this.invoke(readAlarms, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BAk255Network getAk255Network() {
        return (BAk255Network)this.getNetwork();
    }

    public final BAk255Device getAk255Device() {
        BAk255Device bAk255Device = null;
        if (bAk255Device == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BAk255Device) {
                    bAk255Device = (BAk255Device)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return bAk255Device;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)readAlarms)) {
            BStatus bStatus = this.getAk255Device().getStatus();
            if (this.isRunning() && !bStatus.isDisabled() && !bStatus.isDown()) {
                return this.getAk255Device().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public Type getDeviceType() {
        return BAk255Device.TYPE;
    }

    public Type getDeviceFolderType() {
        return null;
    }

    public void doReadAlarms() {
        BAk255Network bAk255Network;
        this.getAk255Device().doReadDateTime();
        this.setReadInProcess(true);
        Class clazz = class$com$tridium$ak255$components$BAk255AlarmDetail;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$components$BAk255AlarmDetail = BAk255AlarmDeviceExt.class("[Lcom.tridium.ak255.components.BAk255AlarmDetail;", false);
        }
        BAk255AlarmDetail[] bAk255AlarmDetailArray = (BAk255AlarmDetail[])this.getChildren(clazz);
        boolean bl = false;
        if (bAk255AlarmDetailArray.length > 0) {
            bl = true;
        }
        this.alreadyHasAlarms = bl;
        int n = 0;
        while (n < bAk255AlarmDetailArray.length) {
            bAk255AlarmDetailArray[n].setIsOrphaned(true);
            ++n;
        }
        BAk255ReadAlarmSummaryRequest bAk255ReadAlarmSummaryRequest = new BAk255ReadAlarmSummaryRequest(this);
        BAk255Device bAk255Device = this.getAk255Device();
        if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadAlarmSummaryRequest);
        }
        this.doReadAlarmDetail();
        Class clazz2 = class$com$tridium$ak255$components$BAk255AlarmDetail;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$ak255$components$BAk255AlarmDetail = BAk255AlarmDeviceExt.class("[Lcom.tridium.ak255.components.BAk255AlarmDetail;", false);
        }
        bAk255AlarmDetailArray = (BAk255AlarmDetail[])this.getChildren(clazz2);
        int n2 = 0;
        while (n2 < bAk255AlarmDetailArray.length) {
            if (bAk255AlarmDetailArray[n2].getIsOrphaned()) {
                this.remove((BComplex)bAk255AlarmDetailArray[n2]);
            }
            ++n2;
        }
        this.setReadInProcess(false);
    }

    public void doReadAlarmDetail() {
        this.doReadAlarmDetail("active", this.activeRefs);
        if (this.getShowAcked()) {
            this.doReadAlarmDetail("acked", this.ackedRefs);
        }
        if (this.getShowCleared()) {
            this.doReadAlarmDetail("cleared", this.clearedRefs);
        }
    }

    public void doReadAlarmDetail(String string, long[] lArray) {
        int n = 0;
        while (n < lArray.length) {
            if (lArray[n] > 0L) {
                BAk255Network bAk255Network;
                BAk255ReadAlarmDetailRequest bAk255ReadAlarmDetailRequest = new BAk255ReadAlarmDetailRequest(this, string, lArray[n]);
                BAk255Device bAk255Device = this.getAk255Device();
                if (bAk255Device != null && (bAk255Network = (BAk255Network)bAk255Device.getNetwork()) != null) {
                    DdfRequestUtil.communicateSync((BIDdfCommunicator)bAk255Device.getDdfCommunicator(), (BIDdfRequest)bAk255ReadAlarmDetailRequest);
                }
            }
            ++n;
        }
    }

    public void decodeAlarmDetail(XElem xElem) {
        if (alarmLog.isTraceOn()) {
            alarmLog.trace(this.getDevice().getDisplayName(null) + ": Alarm Detail");
            xElem.dump();
        }
        if (this.decodeReplyError(xElem)) {
            return;
        }
        XElem xElem2 = xElem.elem("ref");
        if (xElem2 == null) {
            return;
        }
        long l = -1;
        try {
            l = Long.parseLong(xElem2.content(0).toString());
        }
        catch (Exception exception) {}
        if (l < 0L) {
            return;
        }
        String string = "alm_" + l;
        if (this.get(string) == null) {
            BAk255AlarmDetail bAk255AlarmDetail = new BAk255AlarmDetail();
            bAk255AlarmDetail.decodeAlarm(xElem, this);
            if (bAk255AlarmDetail.isActive() && !bAk255AlarmDetail.isAcked() || !bAk255AlarmDetail.isCleared() && bAk255AlarmDetail.isAcked() && this.getShowAcked() || bAk255AlarmDetail.isCleared() && this.getShowCleared()) {
                Property property = this.add(string, (BValue)bAk255AlarmDetail, 2);
                if (this.alreadyHasAlarms) {
                    this.reorderToTop(property);
                }
            }
        } else {
            BAk255AlarmDetail bAk255AlarmDetail = (BAk255AlarmDetail)this.get(string);
            bAk255AlarmDetail.decodeAlarm(xElem, this);
            if (bAk255AlarmDetail.isCleared() && !this.getShowCleared() || bAk255AlarmDetail.isAcked() && !this.getShowAcked()) {
                this.remove((BComplex)bAk255AlarmDetail);
            }
        }
    }

    public void decodeAlarmSummary(XElem xElem) {
        if (alarmLog.isTraceOn()) {
            alarmLog.trace(this.getDevice().getDisplayName(null) + ": Alarm Summary\n");
            xElem.dump();
        }
        this.decodeReplyError(xElem);
        XElem xElem2 = xElem.elem("total");
        int n = 0;
        if (xElem2 != null) {
            n = ParseUtil.parseInteger(xElem2.text(0).toString());
        }
        if ((xElem2 = xElem.elem("active")) != null) {
            this.activeRefs = this.decodeReferences(xElem2);
        }
        if ((xElem2 = xElem.elem("acked")) != null) {
            this.ackedRefs = this.decodeReferences(xElem2);
        }
        if ((xElem2 = xElem.elem("cleared")) != null) {
            this.clearedRefs = this.decodeReferences(xElem2);
        }
    }

    private final long[] decodeReferences(XElem xElem) {
        XElem[] xElemArray = xElem.elems();
        long[] lArray = new long[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].text(0).toString();
            if (xElemArray[n].name().equals("ref")) {
                try {
                    lArray[n] = Long.parseLong(string);
                }
                catch (Exception exception) {
                    lArray[n] = -1;
                }
            }
            ++n;
        }
        return lArray;
    }

    public boolean decodeReplyError(XElem xElem) {
        int n = xElem.geti("error", 0);
        if (n != 0) {
            alarmLog.trace("reply error: " + n);
            return true;
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alreadyHasAlarms = false;
    }

    public BAk255AlarmDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ak255$BAk255AlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$ak255$BAk255AlarmDeviceExt = BAk255AlarmDeviceExt.class("[Lcom.tridium.ak255.BAk255AlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        alarmLog = Log.getLog((String)"ak255.alarm");
        icon = BIcon.std((String)"alarm/alarmClassExtension.png");
    }
}

