/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bajascript.util;

import com.tridium.box.json.BoxWriter;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.RegistryEncoderVisitor;
import com.tridium.box.typenode.TypeNodeBuilder;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.EnumType;
import java.io.File;
import java.io.FileOutputStream;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import org.json.JSONObject;

public final class CommonTypeLibGenerator {
    public static final void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            throw new Exception("Could not generate Common Types File. Please specify a file!");
        }
        CommonTypeLibGenerator.generateCommonTypeLib(stringArray[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void generateCommonTypeLib(String string) throws Exception {
        File file;
        ComplexType complexType;
        TypeNodeBuilder.TypeNode[] typeNodeArray;
        System.out.println("*** Generating Common Types File *** ");
        int n = 0;
        while (true) {
            if (n >= CommonTypes.commonTypes.length) break;
            typeNodeArray = Sys.getType((String)CommonTypes.commonTypes[n]);
            if (typeNodeArray instanceof ComplexType ? (complexType = (ComplexType)typeNodeArray).getFrozenSlots().length > 0 : typeNodeArray instanceof EnumType && !typeNodeArray.equals(BFrozenEnum.TYPE)) {
                throw new Exception("Invalid Common Type: " + typeNodeArray);
            }
            ++n;
        }
        System.out.println("Common Types File: " + string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Copyright 2013, Tridium, Inc. All Rights Reserved\n");
        stringBuffer.append("(function(){");
        stringBuffer.append("'use strict';");
        stringBuffer.append("baja.$ctypes='");
        typeNodeArray = TypeNodeBuilder.make().get(CommonTypes.commonTypes);
        complexType = new BoxWriter();
        RegistryEncoderVisitor registryEncoderVisitor = new RegistryEncoderVisitor((BoxWriter)complexType, null, null, false, true);
        complexType.object();
        int n2 = 0;
        while (true) {
            if (n2 >= typeNodeArray.length) {
                complexType.endObject();
                System.out.println("*** Generating compact JSON ***");
                String string2 = JSONObject.quote((String)complexType.toString());
                string2 = string2.substring(1, string2.length() - 1);
                stringBuffer.append(string2);
                stringBuffer.append("';}());");
                file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                if (file.createNewFile()) break;
                throw new Exception("Unable to create file: " + string);
            }
            typeNodeArray[n2].visit((TypeNodeVisitor)registryEncoderVisitor);
            ++n2;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        try {}
        catch (Exception exception) {}
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        System.out.println("*** Finished Generating Common Types File " + string + " *** ");
        System.exit(0);
    }

    private CommonTypeLibGenerator() {
    }
}

