/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.backup;

import com.tridium.backup.BBackupChannel;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BLocalDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.KeyRingFactory;
import com.tridium.nre.security.SimpleKeyRingTranscoderInputStream;
import com.tridium.nre.util.BogTranscoderInputStream;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.RemotePlatformStation;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.sys.Nre;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.io.ValueDocDecoder;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ILambda;
import javax.baja.platform.PlatformDaemon;
import javax.baja.platform.RemoteStation;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.PatternFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBackupService
extends BAbstractService {
    public static final Property excludeFiles = BBackupService.newProperty((int)0, (String)"*.hdb;*.adb;*.lock;*backup*;console.*;config.bog.b*;config_backup*", null);
    public static final Property excludeDirectories = BBackupService.newProperty((int)0, (BValue)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:^history"), BOrd.make((String)"file:^alarm")}), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    public static final Property offlineExcludeFiles = BBackupService.newProperty((int)0, (String)"*.lock;*backup*;console.*;config.bog.b*;config_backup*", null);
    public static final Property offlineExcludeDirectories = BBackupService.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    public static Log log;
    private static final BOrdList DEFAULT_PLATFORM_BACKUP;
    private static final BOrdList DEFAULT_SECURITY_BACKUP;
    public static final ICanceler NULL_CANCELER;
    private static final File WORKBENCH_SEC_DIR;
    private static final File SYSTEM_SEC_DIR;
    private static final String WORKSTATION_HOST_MODEL = "Workstation";
    private DateFormat logDateFormat;
    static /* synthetic */ Class class$javax$baja$backup$BBackupService;
    static /* synthetic */ Class class$javax$baja$backup$BBackupService$FileTuple;
    static /* synthetic */ Class class$javax$baja$file$BIFile;
    static /* synthetic */ Class class$com$tridium$install$BDependency;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$com$tridium$install$installable$BModuleInstallable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public String getExcludeFiles() {
        return this.getString(excludeFiles);
    }

    public void setExcludeFiles(String string) {
        this.setString(excludeFiles, string, null);
    }

    public BOrdList getExcludeDirectories() {
        return (BOrdList)this.get(excludeDirectories);
    }

    public void setExcludeDirectories(BOrdList bOrdList) {
        this.set(excludeDirectories, (BValue)bOrdList, null);
    }

    public String getOfflineExcludeFiles() {
        return this.getString(offlineExcludeFiles);
    }

    public void setOfflineExcludeFiles(String string) {
        this.setString(offlineExcludeFiles, string, null);
    }

    public BOrdList getOfflineExcludeDirectories() {
        return (BOrdList)this.get(offlineExcludeDirectories);
    }

    public void setOfflineExcludeDirectories(BOrdList bOrdList) {
        this.set(offlineExcludeDirectories, (BValue)bOrdList, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        BFoxChannelRegistry.getPrototype().add("backup", (BValue)new BBackupChannel());
        try {
            Sys.getService((Type)BIDataRecoveryService.TYPE);
            BOrd[] bOrdArray = this.getExcludeDirectories().toArray();
            BOrd bOrd = BOrd.make((String)"file:^dataRecovery");
            boolean bl = true;
            int n = 0;
            while (n < bOrdArray.length) {
                if (bOrdArray[n].equals((Object)bOrd)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.setExcludeDirectories(BOrdList.add((BOrdList)this.getExcludeDirectories(), (BOrd)bOrd));
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
    }

    public BIFile[] listStationBackupFiles() throws Exception {
        Class clazz = class$javax$baja$backup$BBackupService$FileTuple;
        if (clazz == null) {
            clazz = class$javax$baja$backup$BBackupService$FileTuple = BBackupService.class("[Ljavax.baja.backup.BBackupService$FileTuple;", false);
        }
        Array array = new Array(clazz);
        this.findStationBackupFiles((BIFile)BFileSystem.INSTANCE.getStationHome(), Sys.getStation().getStationName(), array, null);
        Class clazz2 = class$javax$baja$file$BIFile;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$file$BIFile = BBackupService.class("[Ljavax.baja.file.BIFile;", false);
        }
        return (BIFile[])array.apply(clazz2, new ILambda(){

            public final Object eval(Object object) {
                return ((FileTuple)object).file;
            }
        }).trim();
    }

    public void restoreFiles(BIFile bIFile) throws Exception {
        this.restoreFiles(bIFile, false, true, 1500L);
    }

    public void restoreFiles(BIFile bIFile, boolean bl, boolean bl2) throws Exception {
        this.restoreFiles(bIFile, bl, bl2, 1500L);
    }

    public void restoreFiles(BIFile bIFile, boolean bl, boolean bl2, long l) throws Exception {
        log.message("Restoring from backup file " + bIFile.getFilePath().getBody());
        RestoreOp restoreOp = new RestoreOp(bIFile, bl, bl2, l);
        if (!restoreOp.ignoreDependencies) {
            this.verifyDependencies(restoreOp);
        }
        log.warning("Shutting down the station for file restore.  Please do not kill or reboot while the restore is in progress.");
        log.warning("The station will be restarted automatically once the restore completes.");
        new Thread(restoreOp).start();
    }

    private final void doRestore(RestoreOp restoreOp) {
        String string = restoreOp.stationName;
        Runtime.getRuntime().addShutdownHook(new RestoreThread(restoreOp));
        try {
            BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
            NiagaraPlatformDaemon niagaraPlatformDaemon = NiagaraPlatformDaemon.make((BDaemonSession)bDaemonSession, (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
            RemoteStation[] remoteStationArray = niagaraPlatformDaemon.getStationManager().getAllStations();
            int n = 0;
            while (n < remoteStationArray.length) {
                if (remoteStationArray[n].getName().equals(string)) {
                    RemotePlatformStation remotePlatformStation = (RemotePlatformStation)remoteStationArray[n];
                    BStationSurrogate bStationSurrogate = BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)string);
                    bStationSurrogate.stopStation(null, null);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not commit platform changes.");
            exception.printStackTrace();
        }
    }

    private final void verifyDependencies(RestoreOp restoreOp) throws Exception {
        log.message("Verifying backup file dependencies");
        BDependency[] bDependencyArray = restoreOp.manifest().getDependencies();
        Class clazz = class$com$tridium$install$BDependency;
        if (clazz == null) {
            clazz = class$com$tridium$install$BDependency = BBackupService.class("[Lcom.tridium.install.BDependency;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bDependencyArray.length) {
            if (!restoreOp.daemonPlatform().meets(bDependencyArray[n])) {
                array.add((Object)bDependencyArray[n]);
            }
            ++n;
        }
        if (array.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < array.size()) {
                stringBuffer.append(' ').append(array.get(n2).toString());
                ++n2;
            }
            throw new LocalizableRuntimeException("backup", "restore.error.unmetDeps", new Object[]{stringBuffer});
        }
    }

    private final void restoreFiles(RestoreOp restoreOp) throws Exception {
        OutputStream outputStream;
        ZipEntry zipEntry;
        Object object;
        String string = null;
        boolean bl = false;
        restoreOp.consoleMessage("Cleaning original station folder:" + restoreOp.stationName);
        try {
            object = new FilePath("!stations/" + restoreOp.stationName);
            BFileSystem.INSTANCE.delete((FilePath)object);
        }
        catch (Exception exception) {
            restoreOp.consoleError("Cleaning original station folder failed", exception);
            bl = true;
        }
        restoreOp.consoleMessage("Restoring files");
        object = restoreOp.zipFile.entries();
        while (object.hasMoreElements()) {
            zipEntry = (ZipEntry)object.nextElement();
            if (zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            try {
                BIFile bIFile = BFileSystem.INSTANCE.makeFile(this.getPathForEntry(zipEntry.getName(), restoreOp));
                restoreOp.consoleMessage("Copying " + bIFile.getFilePath().getBody());
                InputStream inputStream = restoreOp.zipFile.getInputStream(zipEntry);
                outputStream = bIFile.getOutputStream();
                FileUtil.pipe((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.close();
                if (!bIFile.getFilePath().getName().equals("config.bog") || !bIFile.getFilePath().getParent().getParent().getBody().equals("!stations") && !bIFile.getFilePath().getParent().getParent().getBody().equals("/niagara/stations")) continue;
                string = bIFile.getFilePath().getParent().getName();
            }
            catch (Exception exception) {
                restoreOp.consoleError("File copy failed", exception);
                bl = true;
            }
        }
        try {
            if (string != null && restoreOp.stationName != null && !string.equals(restoreOp.stationName)) {
                restoreOp.consoleMessage("stationName is changing from " + restoreOp.stationName + " to " + string);
                object = LocalSessionUtil.getLocalSession();
                zipEntry = BStationSurrogate.make((BDaemonSession)object, (String)restoreOp.stationName);
                boolean bl2 = zipEntry.getIsAutoStart();
                boolean bl3 = zipEntry.getIsAutoRestart();
                object.sendMessage((DaemonMessage)new UpdateStationMessage());
                outputStream = BStationSurrogate.make((BDaemonSession)object, (String)string);
                object.sendMessage((DaemonMessage)new UpdateStationMessage(string, false, bl2, bl3, true));
                if (Nre.getHostModel().equals(WORKSTATION_HOST_MODEL)) {
                    outputStream.startStationAsync();
                }
                object.sendMessage((DaemonMessage)new UpdateStationMessage(restoreOp.stationName, true, false, false, true));
                restoreOp.newStationName = string;
            } else if (restoreOp.stationName != null && string != null && string.equals(restoreOp.stationName)) {
                restoreOp.consoleMessage("stationName is still " + restoreOp.stationName);
            } else {
                restoreOp.consoleMessage("unable to determine station name difference; oldName = '" + restoreOp.stationName + "', newName = '" + string + '\'');
            }
        }
        catch (Exception exception) {
            restoreOp.consoleError("Station Name Analysis Failed", exception);
            bl = true;
        }
        if (bl) {
            restoreOp.consoleWarning("Restore completed with errors");
        } else {
            restoreOp.consoleMessage("Restore completed successfully");
        }
    }

    private final FilePath getPathForEntry(String string, RestoreOp restoreOp) throws Exception {
        if (restoreOp.manifest().useAbsoluteElementPaths()) {
            return new FilePath("/" + string);
        }
        return new FilePath("!" + string);
    }

    private final void restartStation(RestoreOp restoreOp) throws Exception {
        if (restoreOp.isRestartEnabled) {
            restoreOp.consoleMessage("Requesting station restart from niagarad");
            restoreOp.stationSurrogate().restartStationAsync(true);
        } else {
            restoreOp.consoleMessage("Requesting reboot from niagarad");
            restoreOp.daemonPlatform().getDaemonSession().sendForceRebootRequest();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zip(BJob bJob, OutputStream outputStream, boolean bl) throws Exception {
        try {
            this.zip(outputStream, bl, new BackupOp(bJob, BBackupService.makeCanceler(bJob), (BDaemonPlatform)BLocalDaemonPlatform.getInstance()));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (!bl) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (!bl) return;
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zip(BJob bJob, PlatformDaemon platformDaemon, OutputStream outputStream, boolean bl) throws Exception {
        try {
            this.zip(outputStream, bl, new BackupOp(bJob, BBackupService.makeCanceler(bJob), (BDaemonPlatform)((NiagaraPlatformDaemon)platformDaemon).getDaemonPlatform(null)));
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (!bl) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (!bl) return;
        outputStream.close();
    }

    public void zip(JobLog jobLog, PlatformDaemon platformDaemon, OutputStream outputStream, boolean bl) throws Exception {
        this.zip(jobLog, NULL_CANCELER, platformDaemon, outputStream, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zip(JobLog jobLog, ICanceler iCanceler, PlatformDaemon platformDaemon, OutputStream outputStream, boolean bl) throws Exception {
        try {
            this.zip(outputStream, bl, new BackupOp(jobLog, iCanceler, (BDaemonPlatform)((NiagaraPlatformDaemon)platformDaemon).getDaemonPlatform(null)));
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (!bl) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (!bl) return;
        outputStream.close();
    }

    private final void zip(OutputStream outputStream, boolean bl, BackupOp backupOp) throws Exception {
        long l = Clock.millis();
        log.message("Backup starting...");
        if (backupOp.log() != null) {
            backupOp.log().message("Backup starting...");
        }
        backupOp.zip = new ZipOutputStream(outputStream);
        backupOp.platform().checkSession();
        backupOp.checkCanceled();
        this.processManifest(backupOp);
        this.findPlatformBackupFiles(backupOp);
        if (backupOp.offline()) {
            this.findRemoteStationFiles(backupOp);
        } else {
            this.findStationBackupFiles((BIFile)BFileSystem.INSTANCE.getStationHome(), Sys.getStation().getStationName(), backupOp.files(), backupOp);
        }
        this.addFilesToDist(backupOp);
        if (backupOp.log() != null) {
            backupOp.log().start("Adding distribution manifest");
        }
        backupOp.zip.putNextEntry(new ZipEntry("META-INF/dist.xml"));
        backupOp.manifest().write((OutputStream)backupOp.zip);
        if (backupOp.log() != null) {
            backupOp.log().endSuccess();
        }
        backupOp.zip.finish();
        if (bl) {
            backupOp.zip.flush();
            backupOp.zip.close();
        }
        if (backupOp.log() != null) {
            backupOp.log().success("Backup successful");
        }
        if (backupOp.job() != null) {
            backupOp.job().setProgress(100);
        }
        long l2 = Clock.millis();
        log.message("Finished backup, " + backupOp.totalFilesCreated() + " files [" + (l2 - l) + "ms]");
    }

    /*
     * Unable to fully structure code
     */
    private final void processManifest(BackupOp var1_1) throws Exception {
        block16: {
            var1_1.manifest().setInstallableName("backupdist");
            var1_1.manifest().setInstallableVersion(new BVersion("Tridium", "0"));
            var1_1.manifest().setBuildDate(BAbsTime.now());
            var1_1.manifest().setBuildHost(Sys.getLocalHost().getHostName());
            if (!var1_1.platform().getAllowStationRestart()) {
                var1_1.manifest().setRebootRequired(true);
            }
            var1_1.manifest().setNoRunningApp(true);
            var1_1.manifest().setUpdateModuleContent(var1_1.moduleContent());
            var1_1.manifest().setTargetOs(var1_1.platform().getOsPart());
            var1_1.manifest().setHostId(var1_1.platform().getHostId());
            var2_2 = var1_1.platform().getOsTimeZone();
            if (!var2_2.isNull()) {
                var1_1.manifest().setNewOsTimeZone(var2_2);
            }
            var1_1.manifest().addDir(var1_1.manifest().getEntryPath(new FilePath("!stations")), true);
            var1_1.manifest().addDir(var1_1.manifest().getEntryPath(new FilePath("!lexicon")), true);
            if (var1_1.offline()) {
                var1_1.manifest().setDescription("Offline backup of host \"" + var1_1.platform().getHostName() + '\"');
            } else {
                var1_1.manifest().setDescription("Online backup of station \"" + Sys.getStation().getStationName() + "\" on \"" + Sys.getLocalHost().getHostName() + '\"');
            }
            if (!var1_1.platform().getNiagaraR2Enabled()) {
                var3_3 = var1_1.fileSpace().findFile(new FilePath("!lib/platform.bog"));
                if (var3_3 != null) {
                    var1_1.manifest().setPlatformBog(var3_3, false);
                }
            } else {
                var1_1.manifest().setIsStandalone(true);
            }
            if (var1_1.offline()) {
                var1_1.manifest().setDaemonTcpIpSettings(var1_1.session());
            } else {
                var1_1.manifest().setStationTcpIpSettings();
            }
            var1_1.manifest().addDependency(this.getExactDependency((BPart)var1_1.platform().getOsPart()));
            var1_1.manifest().addDependency(this.getExactDependency((BPart)var1_1.platform().getArchPart()));
            var3_3 = var1_1.platform().getNrePart();
            if (var3_3.isNull()) {
                throw new LocalizableRuntimeException("backup", "backup.error.badNRE", new Object[]{var3_3.getPartName()});
            }
            var1_1.manifest().addDependency(this.getExactDependency((BPart)var3_3));
            var4_4 = var1_1.platform().getVmPart();
            if (!var4_4.isNull() && !var4_4.getUnspecified()) {
                var1_1.manifest().addDependency(this.getExactDependency((BPart)var1_1.platform().getVmPart()));
            }
            var5_5 = var1_1.platform().getOtherParts().getProperties();
            if (true) ** GOTO lbl44
            do {
                var6_6 = (BPart)var5_5.get();
                var1_1.manifest().addDependency(new BDependency(var6_6.getPartName(), BVersion.makeZero(), var6_6.getType().getTypeSpec()));
lbl44:
                // 2 sources

                if ((v0 = BBackupService.class$com$tridium$install$part$BPart) != null) continue;
                v0 = BBackupService.class("[Lcom.tridium.install.part.BPart;", false);
            } while (var5_5.next(v0));
            if (var1_1.brandId() != null) {
                var1_1.manifest().addDependency(this.getExactDependency((BPart)var1_1.platform().getBrandPart()));
            }
            if (var1_1.platform().getNiagaraR2Enabled()) break block16;
            if (var1_1.log() != null) {
                var1_1.log().start("Analyzing modules");
            }
            var5_5 = var1_1.platform().getModuleList();
            var1_1.checkCanceled();
            var5_5.init();
            var1_1.checkCanceled();
            var6_6 = var5_5.getModules().getProperties();
            if (true) ** GOTO lbl61
            do {
                var7_7 = (BModuleInstallable)var6_6.get();
                var1_1.manifest().addDependency(this.getExactDependency((BPart)var7_7.getModulePart()));
lbl61:
                // 2 sources

                if ((v1 = BBackupService.class$com$tridium$install$installable$BModuleInstallable) != null) continue;
                v1 = BBackupService.class("[Lcom.tridium.install.installable.BModuleInstallable;", false);
            } while (var6_6.next(v1));
        }
        if (var1_1.log() != null) {
            var1_1.log().endSuccess();
        }
    }

    private final BDependency getExactDependency(BPart bPart) {
        return new BDependency(bPart.getPartName(), bPart.getVersion(), BVersionRelation.exact, bPart.getType().getTypeSpec());
    }

    private final void findStationBackupFiles(BIFile bIFile, String string, Array array, BackupOp backupOp) throws Exception {
        BOrdList bOrdList;
        String string2;
        if (backupOp != null && backupOp.offline()) {
            string2 = this.getOfflineExcludeFiles();
            bOrdList = this.getOfflineExcludeDirectories();
        } else {
            string2 = this.getExcludeFiles();
            bOrdList = this.getExcludeDirectories();
        }
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)string2, (String)";");
        BOrd[] bOrdArray = bOrdList.toArray();
        TreeSet<FilePath> treeSet = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
        int n = 0;
        while (n < bOrdArray.length) {
            treeSet.add(this.getStationFilePath(bOrdArray[n]));
            ++n;
        }
        this.listBackupFiles(bIFile, string, patternFilterArray, treeSet, array);
    }

    private final void findRemoteStationFiles(BackupOp backupOp) throws Exception {
        BDirectory bDirectory = (BDirectory)backupOp.fileSpace().findFile(new FilePath("!stations"));
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                BDirectory bDirectory2;
                BBogFile bBogFile;
                if (bIFileArray[n] instanceof BDirectory && (bBogFile = (BBogFile)(bDirectory2 = (BDirectory)bIFileArray[n]).getNavChild("config.bog")) != null) {
                    BBackupService bBackupService = null;
                    try {
                        BComponent bComponent = (BComponent)new ValueDocDecoder((BIFile)bBogFile).decodeDocument();
                        bBackupService = this.findUnmountedBackupService(bComponent);
                    }
                    catch (Exception exception) {}
                    if (bBackupService == null) {
                        bBackupService = new BBackupService();
                    }
                    bBackupService.findStationBackupFiles((BIFile)bDirectory2, bDirectory2.getFileName(), backupOp.files(), backupOp);
                }
                ++n;
            }
        }
    }

    private final void findPlatformBackupFiles(BackupOp backupOp) throws Exception {
        String string = backupOp.offline() ? this.getOfflineExcludeFiles() : this.getExcludeFiles();
        string = string + ";platform.bog;.data";
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)string, (String)";");
        TreeSet<FilePath> treeSet = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
        treeSet.add(new FilePath("!security"));
        treeSet.add(new FilePath("!workbench/security"));
        treeSet.add(new FilePath("!stations"));
        BOrdList bOrdList = backupOp.platformBackupOrds();
        if (backupOp.fileSpace().findFile(this.getPlatformFilePath(BOrd.make((String)"file:!niagaraR2"), backupOp)) != null) {
            bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)BOrd.make((String)"file:!niagaraR2"));
        }
        BOrd[] bOrdArray = bOrdList.toArray();
        int n = 0;
        while (n < bOrdArray.length) {
            BIFile bIFile = backupOp.fileSpace().findFile(this.getPlatformFilePath(bOrdArray[n], backupOp));
            this.listBackupFiles(bIFile, null, patternFilterArray, treeSet, backupOp.files());
            if (bIFile instanceof BDirectory) {
                if (bIFile.getFileName().equals("licenses")) {
                    backupOp.manifest().addDir(backupOp.manifest().getEntryPath(bIFile.getFilePath()), 0, false);
                } else {
                    backupOp.manifest().addDir(backupOp.manifest().getEntryPath(bIFile.getFilePath()), -1, true);
                }
            }
            ++n;
        }
        BOrd[] bOrdArray2 = DEFAULT_SECURITY_BACKUP.toArray();
        int n2 = 0;
        while (n2 < bOrdArray2.length) {
            BIFile bIFile = backupOp.fileSpace().findFile(this.getPlatformFilePath(bOrdArray2[n2], backupOp));
            if (bIFile != null) {
                this.listBackupFiles(bIFile, null, new PatternFilter[0], new TreeSet(FilePathComparator.INSTANCE), backupOp.files());
                if (bIFile.getFileName().indexOf("ssl.tks") >= 0) {
                    backupOp.manifest().addFile(backupOp.manifest().getEntryPath(bIFile.getFilePath()), 0);
                } else {
                    backupOp.manifest().addFile(backupOp.manifest().getEntryPath(bIFile.getFilePath()), 1);
                }
            }
            ++n2;
        }
    }

    private final void listBackupFiles(BIFile bIFile, String string, PatternFilter[] patternFilterArray, Set set, Array array) throws Exception {
        if (bIFile == null) {
            return;
        }
        if (!bIFile.isDirectory()) {
            String string2 = bIFile.getFileName();
            int n = 0;
            while (n < patternFilterArray.length) {
                if (patternFilterArray[n].accept(string2)) {
                    return;
                }
                ++n;
            }
            array.add((Object)new FileTuple(string, bIFile));
            return;
        }
        if (set.contains(bIFile.getFilePath())) {
            return;
        }
        BIDirectory bIDirectory = (BIDirectory)bIFile;
        BIFile[] bIFileArray = bIDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            this.listBackupFiles(bIFileArray[n], string, patternFilterArray, set, array);
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BBackupService findUnmountedBackupService(BComponent var1_1) {
        if (var1_1 instanceof BBackupService) {
            return (BBackupService)var1_1;
        }
        var2_2 = var1_1.getProperties();
        v0 = BBackupService.class$javax$baja$backup$BBackupService;
        if (v0 == null) {
            v0 = BBackupService.class$javax$baja$backup$BBackupService = BBackupService.class("[Ljavax.baja.backup.BBackupService;", false);
        }
        if (var2_2.next(v0)) {
            return (BBackupService)var2_2.get();
        }
        var2_2 = var1_1.getProperties();
        if (true) ** GOTO lbl14
        do {
            if ((var3_3 = this.findUnmountedBackupService((BComponent)var2_2.get())) != null) {
                return var3_3;
            }
lbl14:
            // 3 sources

            if ((v1 = BBackupService.class$javax$baja$sys$BComponent) != null) continue;
            v1 = BBackupService.class("[Ljavax.baja.sys.BComponent;", false);
        } while (var2_2.next(v1));
        return null;
    }

    private final void addFilesToDist(BackupOp backupOp) throws Exception {
        FileTuple[] fileTupleArray = (FileTuple[])backupOp.files().trim();
        int n = 0;
        while (n < fileTupleArray.length) {
            Object object;
            Serializable serializable;
            backupOp.checkCanceled();
            BIFile bIFile = fileTupleArray[n].file;
            InputStream inputStream = bIFile.getInputStream();
            if (bIFile.getFileName().equals(".kr") && !backupOp.offline()) {
                serializable = ((BLocalFileStore)bIFile.getStore()).getLocalFile();
                object = null;
                if (((File)serializable).getParentFile().equals(WORKBENCH_SEC_DIR)) {
                    object = KeyRingFactory.getInstance((File)WORKBENCH_SEC_DIR, (String)".kr", (String)".wbkm").getKeyRing();
                } else if (((File)serializable).getParentFile().equals(SYSTEM_SEC_DIR)) {
                    object = KeyRingFactory.getInstance((File)SYSTEM_SEC_DIR, (String)".kr", (String)".km").getKeyRing();
                }
                inputStream = new SimpleKeyRingTranscoderInputStream((KeyRing)object, inputStream);
            }
            if (bIFile.getFileName().endsWith(".bog") && !backupOp.offline()) {
                serializable = ((BLocalFileStore)bIFile.getStore()).getLocalFile();
                inputStream = new BogTranscoderInputStream(Nre.getSecurityInfoProvider().getKeyRing(), inputStream);
            }
            if (bIFile.getFileName().equals("daemon.properties")) {
                serializable = new Properties();
                ((Properties)serializable).load(inputStream);
                if (((Properties)serializable).containsKey("_password")) {
                    ((Properties)serializable).remove("user");
                    ((Properties)serializable).remove("_password");
                }
                object = new ByteArrayOutputStream();
                ((Properties)serializable).store((OutputStream)object, "Do not modify the contents of this file");
                ((OutputStream)object).flush();
                ((ByteArrayOutputStream)object).close();
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
            serializable = bIFile.getFilePath();
            object = backupOp.manifest().getEntryPath((FilePath)serializable, fileTupleArray[n].stationName);
            if (backupOp.log() != null) {
                backupOp.log().start("Writing : " + (String)object);
            }
            ZipEntry zipEntry = new ZipEntry((String)object);
            zipEntry.setTime(bIFile.getLastModified().getMillis());
            backupOp.zip.putNextEntry(zipEntry);
            FileUtil.pipe((InputStream)inputStream, (OutputStream)backupOp.zip);
            backupOp.zip.closeEntry();
            inputStream.close();
            backupOp.notifyFileCreated();
            if (backupOp.log() != null) {
                backupOp.log().endSuccess();
            }
            ++n;
        }
    }

    private final FilePath getPlatformFilePath(BOrd bOrd, BackupOp backupOp) throws Exception {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = ordQueryArray.length - 1;
        while (n >= 0) {
            if (ordQueryArray[n] instanceof FilePath) {
                FilePath filePath = (FilePath)ordQueryArray[n];
                if (filePath.isStationHomeAbsolute()) {
                    throw new IllegalStateException(filePath.getBody() + " cannot be station home absolute");
                }
                if (backupOp == null) {
                    return filePath;
                }
                return backupOp.manifest().getNormalFilePath(filePath);
            }
            --n;
        }
        return null;
    }

    private final FilePath getStationFilePath(BOrd bOrd) throws Exception {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = ordQueryArray.length - 1;
        while (n >= 0) {
            if (ordQueryArray[n] instanceof FilePath) {
                FilePath filePath = (FilePath)ordQueryArray[n];
                if (!filePath.isStationHomeAbsolute()) {
                    throw new IllegalStateException(filePath.getBody() + " cannot be station home absolute");
                }
                return filePath;
            }
            --n;
        }
        return null;
    }

    public static ICanceler makeCanceler(BJob bJob) {
        return bJob == null ? NULL_CANCELER : new JobCanceler(bJob);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        BIFile[] bIFileArray = this.listStationBackupFiles();
        spyWriter.w((Object)("<hr><b>List Station Backup Files [" + bIFileArray.length + "]</b>"));
        spyWriter.w((Object)"<pre>");
        int n = 0;
        while (n < bIFileArray.length) {
            spyWriter.w((Object)"  ").w((Object)bIFileArray[n].getOrdInSpace()).nl();
            ++n;
        }
        spyWriter.w((Object)"</pre>");
    }

    static final /* synthetic */ void access$0(BBackupService bBackupService, RestoreOp restoreOp) throws Exception {
        bBackupService.restoreFiles(restoreOp);
    }

    static final /* synthetic */ void access$1(BBackupService bBackupService, RestoreOp restoreOp) throws Exception {
        bBackupService.restartStation(restoreOp);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.logDateFormat = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    }

    public BBackupService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$backup$BBackupService;
        if (clazz == null) {
            clazz = class$javax$baja$backup$BBackupService = BBackupService.class("[Ljavax.baja.backup.BBackupService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std((String)"backup.png");
        log = Log.getLog((String)"backup");
        DEFAULT_PLATFORM_BACKUP = BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:!certificates"), BOrd.make((String)"file:!daemon"), BOrd.make((String)"file:!lexicon"), BOrd.make((String)"file:!lib"), BOrd.make((String)"file:!licenses"), BOrd.make((String)"file:!platform"), BOrd.make((String)"file:!users"), BOrd.make((String)"file:!workbench"), BOrd.make((String)"file:!sedona"), BOrd.make((String)"file:!fips")});
        DEFAULT_SECURITY_BACKUP = BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:!security/ssl.tks"), BOrd.make((String)"file:!security/keystore.jceks"), BOrd.make((String)"file:!security/cacerts.jceks"), BOrd.make((String)"file:!security/exemptions.tes"), BOrd.make((String)"file:!security/.km"), BOrd.make((String)"file:!security/.kr"), BOrd.make((String)"file:!workbench/security/keystore.jceks"), BOrd.make((String)"file:!workbench/security/cacerts.jceks"), BOrd.make((String)"file:!workbench/security/exemptions.tes"), BOrd.make((String)"file:!workbench/security/.km"), BOrd.make((String)"file:!workbench/security/.kr")});
        NULL_CANCELER = new ICanceler(){

            public final boolean isCanceled() {
                return false;
            }
        };
        WORKBENCH_SEC_DIR = new File(System.getProperty("baja.home") + "/workbench/security/");
        SYSTEM_SEC_DIR = new File(System.getProperty("baja.home") + "/security/");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RestoreOp
    implements Runnable {
        private DistributionManifest manifest;
        public ZipFile zipFile;
        public boolean ignoreDependencies;
        public boolean deleteFile;
        public BIFile backupFile;
        private long shutdownDelay;
        private String stationName;
        public boolean isRestartEnabled;
        private String newStationName;

        public void run() {
            try {
                Thread.sleep(this.shutdownDelay);
            }
            catch (InterruptedException interruptedException) {}
            BBackupService.this.doRestore(this);
        }

        public DistributionManifest manifest() throws Exception {
            if (this.manifest == null) {
                ZipEntry zipEntry = this.zipFile.getEntry("META-INF/dist.xml");
                if (zipEntry == null) {
                    zipEntry = this.zipFile.getEntry("meta-inf/dist.xml");
                }
                if (zipEntry == null) {
                    throw new LocalizableRuntimeException("backup", "restore.error.noManifest");
                }
                this.manifest = DistributionManifest.make((InputStream)this.zipFile.getInputStream(zipEntry));
                if (!"backupdist".equals(this.manifest.getInstallableName())) {
                    throw new LocalizableRuntimeException("backup", "restore.error.invalidName");
                }
            }
            return this.manifest;
        }

        public BDaemonPlatform daemonPlatform() throws Exception {
            BLocalDaemonPlatform bLocalDaemonPlatform = BLocalDaemonPlatform.getInstance();
            if (bLocalDaemonPlatform == null) {
                throw new LocalizableRuntimeException("backup", "restore.error.noDaemonSession");
            }
            bLocalDaemonPlatform.checkSession();
            return bLocalDaemonPlatform;
        }

        public BStationSurrogate stationSurrogate() throws Exception {
            if (this.newStationName == null) {
                return BStationSurrogate.make((BDaemonSession)this.daemonPlatform().getDaemonSession(), (String)this.stationName);
            }
            return BStationSurrogate.make((BDaemonSession)this.daemonPlatform().getDaemonSession(), (String)this.newStationName);
        }

        public void consoleError(String string) {
            this.consoleError(string, null);
        }

        public void consoleError(String string, Exception exception) {
            this.consoleLog(3, string, exception);
        }

        public void consoleWarning(String string) {
            this.consoleLog(2, string, null);
        }

        public void consoleMessage(String string) {
            this.consoleLog(1, string, null);
        }

        public void consoleLog(int n, String string, Exception exception) {
            switch (n) {
                case 3: {
                    System.out.print("ERROR [");
                    break;
                }
                case 2: {
                    System.out.print("WARNING [");
                    break;
                }
                case 1: {
                    System.out.print("MESSAGE [");
                    break;
                }
            }
            System.out.print(BBackupService.this.logDateFormat.format(new Date()));
            System.out.print("][backup] ");
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }

        static /* synthetic */ String access$1(RestoreOp restoreOp) {
            return restoreOp.newStationName;
        }

        private final /* synthetic */ void this() {
            this.manifest = null;
        }

        public RestoreOp(BIFile bIFile, boolean bl, boolean bl2, long l) throws Exception {
            this.this();
            this.backupFile = bIFile;
            this.ignoreDependencies = bl;
            this.deleteFile = bl2;
            this.shutdownDelay = l;
            if (Sys.getStation() != null) {
                this.stationName = Sys.getStation().getStationName();
            }
            if (!(bIFile.getStore() instanceof BLocalFileStore)) {
                throw new LocalizableRuntimeException("backup", "restore.error.backupNotLocal");
            }
            this.zipFile = new ZipFile(((BLocalFileStore)bIFile.getStore()).getLocalFile());
            this.manifest();
            this.daemonPlatform();
            if (this.stationSurrogate() == null) {
                throw new LocalizableRuntimeException("backup", "restore.error.noSurrogate");
            }
            this.isRestartEnabled = this.stationSurrogate().isRestartEnabled();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RestoreThread
    extends Thread {
        private RestoreOp op;

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 147->151)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public RestoreThread(RestoreOp restoreOp) {
            this.op = restoreOp;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BackupOp {
        private DistributionManifest manifest;
        private BJob job;
        private JobLog log;
        private BDaemonPlatform platform;
        private String stationName;
        private BFileSpace fileSpace;
        private int totalFilesCreated;
        private Array files;
        private ICanceler canceler;
        public ZipOutputStream zip;

        public String brandId() throws Exception {
            if (this.platform == null) {
                return null;
            }
            BBrandPart bBrandPart = this.platform.getBrandPart();
            return bBrandPart.isNull() ? null : bBrandPart.getPartName();
        }

        public BModuleContent moduleContent() throws Exception {
            return this.platform() == null ? null : this.platform().getModuleContent();
        }

        public BDaemonSession session() {
            return this.platform() == null ? null : this.platform().getDaemonSession();
        }

        public BFileSpace fileSpace() {
            if (this.fileSpace == null) {
                if (this.platform() == null) {
                    return null;
                }
                this.fileSpace = this.platform() instanceof BRemoteDaemonPlatform ? new BCachedDaemonFileSpace(this.session(), true, false, false) : BFileSystem.INSTANCE;
            }
            return this.fileSpace;
        }

        public BJob job() {
            return this.job;
        }

        public JobLog log() {
            if (this.log == null && this.job != null) {
                this.log = this.job.log();
            }
            return this.log;
        }

        public BDaemonPlatform platform() {
            return this.platform;
        }

        public void checkCanceled() {
            if (this.canceler.isCanceled()) {
                throw new JobCancelException();
            }
            if (this.job != null) {
                this.job.heartbeat();
            }
        }

        public BOrdList platformBackupOrds() {
            Property property = BBackupService.this.getProperty("platformBackupFiles");
            return property == null ? DEFAULT_PLATFORM_BACKUP : (BOrdList)BBackupService.this.get(property);
        }

        public int totalFilesCreated() {
            return this.totalFilesCreated;
        }

        public void notifyFileCreated() {
            ++this.totalFilesCreated;
            if (this.job != null) {
                this.job.setProgress(10 + 90 * this.totalFilesCreated / this.files.size());
            }
        }

        public DistributionManifest manifest() {
            return this.manifest;
        }

        public Array files() {
            return this.files;
        }

        public boolean offline() {
            return this.platform() instanceof BRemoteDaemonPlatform;
        }

        private final /* synthetic */ void this() {
            this.job = null;
            this.log = null;
            this.stationName = null;
            this.fileSpace = null;
            this.totalFilesCreated = 0;
            Class clazz = class$javax$baja$backup$BBackupService$FileTuple;
            if (clazz == null) {
                clazz = class$javax$baja$backup$BBackupService$FileTuple = BBackupService.class("[Ljavax.baja.backup.BBackupService$FileTuple;", false);
            }
            this.files = new Array(clazz);
            this.zip = null;
        }

        public BackupOp(BJob bJob, BDaemonPlatform bDaemonPlatform) {
            this(bJob, BBackupService.makeCanceler(bJob), bDaemonPlatform);
        }

        public BackupOp(BJob bJob, ICanceler iCanceler, BDaemonPlatform bDaemonPlatform) {
            this.this();
            this.job = bJob;
            this.canceler = iCanceler == null ? NULL_CANCELER : iCanceler;
            this.platform = bDaemonPlatform;
            if (bDaemonPlatform == null) {
                throw new IllegalStateException("platform is unavailable");
            }
            this.manifest = DistributionManifest.make();
        }

        public BackupOp(JobLog jobLog, ICanceler iCanceler, BDaemonPlatform bDaemonPlatform) {
            this.this();
            this.canceler = iCanceler == null ? NULL_CANCELER : iCanceler;
            this.log = jobLog;
            this.platform = bDaemonPlatform;
            if (bDaemonPlatform == null) {
                throw new IllegalStateException("platform is unavailable");
            }
            this.manifest = DistributionManifest.make();
        }
    }

    private static class FileTuple {
        public BIFile file;
        public String stationName;

        public FileTuple(String string, BIFile bIFile) {
            this.file = bIFile;
            this.stationName = string;
        }
    }

    public static class JobCanceler
    implements ICanceler {
        private BJob job;

        public boolean isCanceled() {
            return !this.job.isAlive();
        }

        public JobCanceler(BJob bJob) {
            this.job = bJob;
        }
    }

    public static interface ICanceler {
        public boolean isCanceled();
    }
}

