/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import com.tridium.workbench.user.BUserMgrTable;
import com.tridium.workbench.user.BUserPasswordFE;
import javax.baja.security.BPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BUserManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$user$BUserManager == null ? (class$com$tridium$workbench$user$BUserManager = BUserManager.class$("com.tridium.workbench.user.BUserManager")) : class$com$tridium$workbench$user$BUserManager));
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$user$BUserManager == null ? (class$com$tridium$workbench$user$BUserManager = BUserManager.class$("com.tridium.workbench.user.BUserManager")) : class$com$tridium$workbench$user$BUserManager));
    static final String lexNever = lex.getText("never");
    static final String lexExpired = lex.getText("expired");
    MgrColumn colName = new UserNameColumn();
    MgrColumn colFullName = new UserProp(BUser.fullName, 1);
    MgrColumn colEnabled = new UserProp(BUser.enabled, 1);
    MgrColumn colExpiration = new ExpirationColumn();
    MgrColumn colLockOut = new UserProp(BUser.lockOut, 2);
    MgrColumn colPermissions = new PermissionsColumn(3);
    MgrColumn colLanguage = new UserProp(BUser.language, 1);
    MgrColumn colNetworkUser = new UserProp(BUser.networkUser, 1);
    MgrColumn colPrototype = new UserProp(BUser.prototypeName, 1);
    MgrColumn colPassword = new UserProp(BUser.password, 3);
    MgrColumn colEmail = new UserProp(BUser.email, 1);
    MgrColumn colFacets = new UserProp(BUser.facets, 3);
    MgrColumn colNavFile = new UserProp(BUser.navFile, 3);
    MgrColumn colCellPhoneNumber = new UserProp(BUser.cellPhoneNumber, 3);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colFullName, this.colEnabled, this.colExpiration, this.colLockOut, this.colPermissions, this.colNetworkUser, this.colPrototype, this.colLanguage, this.colPassword, this.colEmail, this.colCellPhoneNumber, this.colFacets, this.colNavFile};
    BUserService service;
    static /* synthetic */ Class class$com$tridium$workbench$user$BUserManager;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.service = (BUserService)bObject;
        super.doLoadValue(bObject, context);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    void validate(MgrEditRow mgrEditRow) throws Exception {
        BUser bUser = (BUser)mgrEditRow.getTarget();
        BPassword bPassword = (BPassword)mgrEditRow.getCell(this.colPassword);
        if (this.service != null) {
            this.service.checkPassword(bPassword.getValue());
        }
        if (bPassword.getPasswordEncoder().isReversible()) {
            BUserPasswordFE.checkPasswordHistory(bUser, bPassword, this.service);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PermissionsColumn
    extends UserProp {
        PermissionsColumn(int n) {
            super(BUser.permissions, n);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BWbFieldEditor bWbFieldEditor;
            BValue bValue = mgrEditRowArray[0].getCell(n);
            BFacets bFacets = mgrEditRowArray.length == 1 && this.props.length == 1 ? mgrEditRowArray[0].getTarget().getSlotFacets((Slot)this.props[0]) : this.props[this.props.length - 1].getFacets();
            Context context = mgrEditRowArray[0].getManager().getCurrentContext();
            if (!bFacets.isNull()) {
                context = new BasicContext(context, bFacets);
            }
            if ((bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, (Context)context)) instanceof BStringFE) {
                bWbFieldEditor = new BStringMgrColFE(n);
            }
            if (bWbEditor != null && bWbEditor.getClass() == bWbFieldEditor.getClass()) {
                bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            }
            boolean bl = true;
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                bl &= !"admin".equals(((BUser)mgrEditRowArray[i].getTarget()).getUsername());
            }
            bWbFieldEditor.setEnabled(bl);
            bWbFieldEditor.loadValue((BObject)bValue, context);
            return bWbFieldEditor;
        }
    }

    class ExpirationColumn
    extends UserProp {
        ExpirationColumn() {
            super(BUser.expiration, 1);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BWbEditor bWbEditor2 = super.toEditor(mgrEditRowArray, n, bWbEditor);
            boolean bl = true;
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                bl &= !"admin".equals(((BUser)mgrEditRowArray[i].getTarget()).getUsername());
            }
            if (bWbEditor2 != null) {
                bWbEditor2.setEnabled(bl);
            }
            return bWbEditor2;
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            BAbsTime bAbsTime = (BAbsTime)object2;
            if (bAbsTime.isNull()) {
                return lexNever;
            }
            if (BUser.isExpired((BAbsTime)bAbsTime)) {
                return lexExpired;
            }
            return bAbsTime.toDateString(context);
        }
    }

    class UserNameColumn
    extends MgrColumn.Name {
        UserNameColumn() {
        }

        public Object get(Object object) {
            String string = (String)super.get(object);
            if (string.equals("Admin")) {
                return BString.make((String)"admin");
            }
            if (string.equals("Guest")) {
                return BString.make((String)"guest");
            }
            return string;
        }
    }

    static class UserProp
    extends MgrColumn.Prop {
        public UserProp(Property property, int n) {
            super(property, n);
        }

        public Property getProperty() {
            return this.prop;
        }
    }

    class Edit
    extends MgrEdit {
        Edit(BAbstractManager bAbstractManager, String string) {
            super(bAbstractManager, string);
        }

        public void validate(MgrEditRow[] mgrEditRowArray) throws Exception {
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                BUserManager.this.validate(mgrEditRowArray[i]);
            }
        }

        public boolean isReadonly(MgrEditRow[] mgrEditRowArray, MgrColumn mgrColumn) {
            boolean bl = super.isReadonly(mgrEditRowArray, mgrColumn);
            if (!bl) {
                BString bString;
                Property property;
                BUser bUser = null;
                Property property2 = property = mgrColumn instanceof UserProp ? ((UserProp)mgrColumn).getProperty() : null;
                if (property != null || mgrColumn instanceof MgrColumn.MixIn) {
                    try {
                        Context context = this.getManager().getCurrentContext();
                        BString bString2 = bString = context != null ? (BString)context.getFacet("username") : null;
                        if (bString != null) {
                            bUser = BUserManager.this.service.getUser(bString.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < mgrEditRowArray.length; ++i) {
                    Object object;
                    bString = (BUser)mgrEditRowArray[i].getTarget();
                    BComponent bComponent = (BComponent)bString.getParent();
                    Property property3 = bString.getPropertyInParent();
                    if (bComponent != null && property3 != null && !property3.isFrozen() && Flags.isReadonly((BComplex)bComponent, (Slot)property3)) {
                        bl = true;
                        break;
                    }
                    if (bUser != null && property != null) {
                        try {
                            bUser.checkWrite((BComponent)bString, (Slot)property);
                            continue;
                        }
                        catch (PermissionException permissionException) {
                            bl = true;
                            break;
                        }
                    }
                    if (property != null) {
                        bl = Flags.isReadonly((BComplex)bString, (Slot)property);
                        continue;
                    }
                    if (bUser == null || !(mgrColumn instanceof MgrColumn.MixIn) || !((object = ((MgrColumn.MixIn)mgrColumn).get((Object)bString)) instanceof BComplex) || (property3 = ((BComplex)object).getPropertyInParent()) == null) continue;
                    try {
                        bUser.checkWrite((BComponent)bString, (Slot)property3);
                        continue;
                    }
                    catch (PermissionException permissionException) {
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }
    }

    class Controller
    extends MgrController {
        Controller(BUserManager bUserManager2) {
            super((BAbstractManager)bUserManager2);
        }

        public MgrEdit makeEdit(String string) {
            return new Edit(this.getManager(), string);
        }
    }

    class Model
    extends MgrModel {
        Model(BUserManager bUserManager2) {
            super((BAbstractManager)bUserManager2);
        }

        protected BMgrTable makeTable() {
            return new BUserMgrTable(this);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BUserManager.this.cols, BUser.TYPE);
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BUser.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((BComponent)new BUser())};
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) {
            BUser bUser = (BUser)BUserManager.this.service.getUserPrototypes().getDefaultPrototype().newCopy();
            return bUser;
        }
    }
}

