/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.ui.util.ValidatingTextController;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BTlsEnum;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUserService;

public class NewStationWizard
extends WizardModel {
    static UiLexicon lex = new UiLexicon(class$com$tridium$workbench$tools$NewStationWizard == null ? (class$com$tridium$workbench$tools$NewStationWizard = NewStationWizard.class$("com.tridium.workbench.tools.NewStationWizard")) : class$com$tridium$workbench$tools$NewStationWizard);
    static BImage banner = BImage.make((String)"module://icons/x32/newDatabase.png");
    BNiagaraWbShell shell;
    String stationDirBase;
    int currentStep = 0;
    BWidget step0;
    BWidget step1;
    BTextField stationName;
    BTextField stationDir;
    BRadioButton supervisor;
    BRadioButton jace;
    BPasswordFE adminPass0;
    BPasswordFE adminPass1;
    BTextField foxPort;
    BTextField httpPort;
    BCheckBox openStationBog;
    BCheckBox securePorts;
    BLabel foxPortLabel;
    BLabel httpPortLabel;
    static /* synthetic */ Class class$com$tridium$workbench$tools$NewStationWizard;

    public static void kickIt(BNiagaraWbShell bNiagaraWbShell) {
        NewStationWizard newStationWizard = new NewStationWizard(bNiagaraWbShell);
        BWizard.open((BWidget)bNiagaraWbShell, (WizardModel)newStationWizard);
    }

    public NewStationWizard(BNiagaraWbShell bNiagaraWbShell) {
        this.shell = bNiagaraWbShell;
        this.stationDirBase = Sys.getBajaHome() + File.separator + "stations" + File.separator;
        this.buildStep0();
        this.buildStep1();
    }

    private void buildStep0() {
        this.stationName = new BTextField("", 20);
        this.stationName.setModel((TextModel)new StationNameModel());
        this.stationName.setController((TextController)new StationNameController());
        this.stationDir = new BTextField(this.stationDirBase, 50, false);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("newStation.stationName")));
        bGridPane.add(null, (BValue)this.stationName);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("newStation.stationDir")));
        bGridPane.add(null, (BValue)this.stationDir);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(banner, this.getTitle()));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0));
        this.step0 = bEdgePane;
    }

    private void buildStep1() {
        this.adminPass0 = new BPasswordFE();
        this.adminPass1 = new BPasswordFE();
        this.openStationBog = new BCheckBox(lex.getText("newStation.openStationBog"), true);
        this.securePorts = new BCheckBox((ToggleCommand)new SecureToggleCommand((BWidget)this.shell, lex.getText("newStation.securePorts")));
        this.adminPass0.setHidePasswordLength(false);
        this.adminPass1.setHidePasswordLength(false);
        this.adminPass0.loadValue((BObject)BPassword.make((String)""));
        this.adminPass1.loadValue((BObject)BPassword.make((String)""));
        this.foxPort = new BTextField("4911", 6);
        this.httpPort = System.getProperty("os.name").equalsIgnoreCase("linux") ? new BTextField("8443", 6) : new BTextField("443", 6);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.fill);
        bGridPane.setStretchColumn(0);
        BGridPane bGridPane2 = new BGridPane(3);
        bGridPane2.setColumnGap(10.0);
        bGridPane2.add(null, (BValue)new BLabel("   "));
        this.foxPortLabel = new BLabel(BImage.make((String)lex.getText("newStation.foxsPort.icon")), lex.getText("newStation.foxsPort"));
        bGridPane2.add(null, (BValue)this.foxPortLabel);
        bGridPane2.add(null, (BValue)this.foxPort);
        bGridPane2.add(null, (BValue)new BLabel("   "));
        this.httpPortLabel = new BLabel(BImage.make((String)lex.getText("newStation.httpsPort.icon")), lex.getText("newStation.httpsPort"));
        bGridPane2.add(null, (BValue)this.httpPortLabel);
        bGridPane2.add(null, (BValue)this.httpPort);
        bGridPane.add(null, (BValue)this.securePorts);
        bGridPane.add(null, (BValue)bGridPane2);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, BBorder.none);
        bBorderPane.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.setHalign(BHalign.fill);
        bGridPane3.setStretchColumn(0);
        bGridPane3.setValign(BValign.top);
        bGridPane3.add(null, (BValue)new BLabel(lex.getText("newStation.adminPassword")));
        bGridPane3.add(null, (BValue)this.adminPass0);
        bGridPane3.add(null, (BValue)new BLabel(lex.getText("newStation.adminPasswordConfirm")));
        bGridPane3.add(null, (BValue)this.adminPass1);
        bGridPane3.add(null, (BValue)bBorderPane);
        bGridPane3.add(null, (BValue)new BBorderPane((BWidget)this.openStationBog, 10.0, 0.0, 10.0, 0.0));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(banner, this.getTitle()));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane3, 10.0, 10.0, 10.0, 10.0));
        this.step1 = bEdgePane;
    }

    public String getTitle() {
        return lex.getText("newStation.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(380.0, 260.0);
    }

    public void init() {
        this.updateTo0();
    }

    public void back() {
        switch (this.currentStep) {
            case 1: {
                this.updateTo0();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.updateTo1();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() {
        BPassword bPassword;
        BPassword bPassword2;
        try {
            bPassword2 = (BPassword)this.adminPass0.saveValue();
            bPassword = (BPassword)this.adminPass1.saveValue();
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot build new station", (Throwable)throwable);
            return true;
        }
        if (!bPassword2.getValue().equals(bPassword.getValue())) {
            BDialog.error((BWidget)this.getWizard(), (Object)lex.getText("newStation.adminPasswordMismatch"));
            return false;
        }
        try {
            String string = bPassword2.getValue();
            BPasswordStrength.DEFAULT.isPasswordValid(string);
            if (bPassword2.getValue().equalsIgnoreCase(this.stationName.getText())) {
                throw new LocalizableException("baja", "user.strongPassword.matchStation");
            }
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this.getWizard(), (Object)exception.getMessage());
            return false;
        }
        this.shell.enterBusy();
        try {
            this.doit();
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot build new station", (Throwable)throwable);
        }
        finally {
            this.shell.exitBusy();
        }
        return true;
    }

    private void updateTo0() {
        String string = this.stationName.getText();
        int n = SlotPath.isValidName((String)string) && string.length() <= 32 ? 2 : 0;
        this.update(this.step0, n);
        this.getWizard().setNextAsDefault();
        this.stationName.requestFocus();
        this.currentStep = 0;
    }

    private void updateTo1() {
        int n;
        File file = new File(this.stationDirBase + File.separator + this.stationName.getText() + File.separator + "config.bog");
        if (file.exists() && (n = BDialog.open((BWidget)this.shell, (String)BDialog.TITLE_CONFIRM, (Object)lex.getText("newStation.overwrite", new Object[]{file}), (int)6, (BImage)BDialog.WARNING_ICON)) != 4) {
            return;
        }
        this.update(this.step1, 5);
        this.adminPass0.requestFocus();
        this.currentStep = 1;
    }

    private void doit() throws Exception {
        BPassword bPassword = (BPassword)this.adminPass0.saveValue();
        String string = bPassword.getValue();
        String string2 = this.stationName.getText();
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        int n = Integer.parseInt(this.foxPort.getText());
        int n2 = Integer.parseInt(this.httpPort.getText());
        if (n < 0 || 65535 < n) {
            throw new Exception("invalid fox(s) port: " + n + ", please select 0-65535");
        }
        if (n2 < 0 || 65535 < n2) {
            throw new Exception("invalid http(s) port: " + n2 + ", please select 0-65535");
        }
        if (n2 == n) {
            throw new Exception("http(s) port and fox(s) port can not be the same");
        }
        BComponent bComponent = this.newInstance("baja:UserService");
        BComponent bComponent2 = this.newInstance("baja:CategoryService");
        BComponent bComponent3 = this.newInstance("baja:JobService");
        BComponent bComponent4 = this.newInstance("alarm:AlarmService");
        BComponent bComponent5 = this.newInstance("history:HistoryService");
        BComponent bComponent6 = this.newInstance("history:AuditHistoryService");
        BComponent bComponent7 = this.newInstance("history:LogHistoryService");
        BComponent bComponent8 = this.newInstance("program:ProgramService");
        BComponent bComponent9 = this.newInstance("backup:BackupService");
        BComponent bComponent10 = this.newInstance("web:WebService");
        BComponent bComponent11 = this.newInstance("niagaraDriver:NiagaraNetwork");
        BComponent bComponent12 = bComponent11.get("foxService").asComponent();
        if (this.securePorts.isSelected()) {
            bComponent10.set("httpEnabled", (BValue)BBoolean.FALSE);
            bComponent10.set("httpsEnabled", (BValue)BBoolean.TRUE);
            bComponent10.set("httpsOnly", (BValue)BBoolean.TRUE);
            bComponent10.set("tlsMinProtocol", (BValue)BTlsEnum.DEFAULT);
            bComponent12.set("foxEnabled", (BValue)BBoolean.FALSE);
            bComponent12.set("foxsEnabled", (BValue)BBoolean.TRUE);
            bComponent12.set("foxsOnly", (BValue)BBoolean.TRUE);
            bComponent12.set("tlsMinProtocol", (BValue)BTlsEnum.DEFAULT);
        } else {
            bComponent10.set("httpEnabled", (BValue)BBoolean.TRUE);
            bComponent10.set("httpsEnabled", (BValue)BBoolean.FALSE);
            bComponent10.set("httpsOnly", (BValue)BBoolean.FALSE);
            bComponent10.set("tlsMinProtocol", (BValue)BTlsEnum.DEFAULT);
            bComponent12.set("foxEnabled", (BValue)BBoolean.TRUE);
            bComponent12.set("foxsEnabled", (BValue)BBoolean.FALSE);
            bComponent12.set("foxsOnly", (BValue)BBoolean.FALSE);
            bComponent12.set("tlsMinProtocol", (BValue)BTlsEnum.DEFAULT);
        }
        BComponent bComponent13 = this.newInstance("driver:DriverContainer");
        BComponent bComponent14 = this.newInstance("baja:ServiceContainer");
        BComponent bComponent15 = this.newInstance("app:AppContainer");
        BStation bStation = new BStation();
        bStation.setCategoryMask(BCategoryMask.make((String)"1"), null);
        bStation.setStationName(string2);
        bStation.add("Services", (BValue)bComponent14);
        bComponent14.add("UserService", (BValue)bComponent);
        bComponent14.add("CategoryService", (BValue)bComponent2);
        bComponent14.add("JobService", (BValue)bComponent3);
        bComponent14.add("AlarmService", (BValue)bComponent4);
        bComponent14.add("HistoryService", (BValue)bComponent5);
        bComponent14.add("AuditHistory", (BValue)bComponent6);
        bComponent14.add("LogHistory", (BValue)bComponent7);
        bComponent14.add("ProgramService", (BValue)bComponent8);
        bComponent14.add("BackupService", (BValue)bComponent9);
        bComponent14.add("WebService", (BValue)bComponent10);
        bStation.add("Drivers", (BValue)bComponent13);
        bComponent13.add("NiagaraNetwork", (BValue)bComponent11);
        bStation.add("Apps", (BValue)bComponent15);
        BCategory bCategory = new BCategory();
        BCategory bCategory2 = new BCategory();
        bComponent2.add("User", (BValue)bCategory);
        bComponent2.add("Admin", (BValue)bCategory2);
        bCategory.setIndex(1);
        bCategory2.setIndex(2);
        bComponent.setCategoryMask(BCategoryMask.make((int[])new int[]{2}), null);
        bComponent2.setCategoryMask(BCategoryMask.make((int[])new int[]{2}), null);
        bComponent8.setCategoryMask(BCategoryMask.make((int[])new int[]{2}), null);
        BCategoryMask bCategoryMask = BCategoryMask.make((int[])new int[]{bCategory2.getIndex()});
        BCategoryMask bCategoryMask2 = BCategoryMask.make((int[])new int[]{bCategory2.getIndex(), bCategory.getIndex()});
        BOrdToCategoryMap bOrdToCategoryMap = BOrdToCategoryMap.make((BOrd[])new BOrd[]{BOrd.make((String)"file:^"), BOrd.make((String)"file:^nav"), BOrd.make((String)"file:^px")}, (BCategoryMask[])new BCategoryMask[]{bCategoryMask, bCategoryMask2, bCategoryMask2});
        bComponent2.set("ordMap", (BValue)bOrdToCategoryMap);
        bComponent.setFlags((Slot)BUserService.requireStrongPasswords, Integer.MIN_VALUE | bComponent.getFlags((Slot)BUserService.requireStrongPasswords));
        bComponent.get("admin").asComplex().set("password", (BValue)BPassword.make((String)string, (String)"pbkdf2hmacsha256/text"));
        bComponent.get("guest").asComplex().set("password", (BValue)BPassword.make((String)"", (String)"pbkdf2hmacsha256/text"));
        if (this.securePorts.isSelected()) {
            bComponent11.get("foxService").asComplex().set("foxsPort", (BValue)BInteger.make((int)n));
            bComponent10.set("httpsPort", (BValue)BInteger.make((int)n2));
        } else {
            bComponent11.get("foxService").asComplex().set("port", (BValue)BInteger.make((int)n));
            bComponent10.set("httpPort", (BValue)BInteger.make((int)n2));
        }
        BIFile bIFile = bFileSystem.makeFile(new FilePath("!stations/" + string2 + "/config.bog"), null);
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(bIFile.getOutputStream());
        valueDocEncoder.setZipped(true);
        valueDocEncoder.encodeDocument((BValue)bStation);
        valueDocEncoder.close();
        if (this.openStationBog.isSelected()) {
            BOrd bOrd = BOrd.make((String)("local:|file:!stations/" + string2 + "/config.bog|bog:|slot:/"));
            this.shell.hyperlink(bOrd);
            this.shell.syncTree();
        }
    }

    private BComponent newInstance(String string) throws Exception {
        return (BComponent)Sys.getType((String)string).getInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SecureToggleCommand
    extends ToggleCommand {
        public SecureToggleCommand(BWidget bWidget, String string) {
            super(bWidget, string);
            this.setSelected(true);
        }

        public CommandArtifact doInvoke() throws Exception {
            if (this.isSelected()) {
                NewStationWizard.this.foxPortLabel.setText(lex.getText("newStation.foxsPort"));
                NewStationWizard.this.foxPortLabel.setImage(BImage.make((String)lex.getText("newStation.foxsPort.icon")));
                NewStationWizard.this.httpPortLabel.setText(lex.getText("newStation.httpsPort"));
                NewStationWizard.this.httpPortLabel.setImage(BImage.make((String)lex.getText("newStation.httpsPort.icon")));
                NewStationWizard.this.foxPort.setText("4911");
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    NewStationWizard.this.httpPort.setText("8443");
                } else {
                    NewStationWizard.this.httpPort.setText("443");
                }
            } else {
                NewStationWizard.this.foxPortLabel.setText(lex.getText("newStation.foxPort"));
                NewStationWizard.this.foxPortLabel.setImage(BImage.make((String)lex.getText("newStation.foxPort.icon")));
                NewStationWizard.this.httpPortLabel.setText(lex.getText("newStation.httpPort"));
                NewStationWizard.this.httpPortLabel.setImage(BImage.make((String)lex.getText("newStation.httpPort.icon")));
                NewStationWizard.this.foxPort.setText("1911");
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    NewStationWizard.this.httpPort.setText("8080");
                } else {
                    NewStationWizard.this.httpPort.setText("80");
                }
            }
            return null;
        }
    }

    class StationNameController
    extends ValidatingTextController {
        StationNameController() {
        }

        protected boolean valid(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return string.length() <= 32 && SlotPath.isValidName((String)string);
        }
    }

    class StationNameModel
    extends TextModel {
        StationNameModel() {
        }

        protected void textModified() {
            String string = NewStationWizard.this.stationName.getText();
            if (NewStationWizard.this.getWizard() != null) {
                NewStationWizard.this.getWizard().setNextEnabled(SlotPath.isValidName((String)string) && string.length() <= 32);
            }
            NewStationWizard.this.stationDir.setText(NewStationWizard.this.stationDirBase + string);
        }
    }
}

